/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalEntryType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * JournalData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class JournalData {
  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private JournalEntryType entryType;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private UUID fromAccount;

  public static final String SERIALIZED_NAME_TO_ACCOUNT = "to_account";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT)
  private UUID toAccount;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public JournalData() {
  }

  public JournalData entryType(JournalEntryType entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * Get entryType
   * @return entryType
  **/
  @javax.annotation.Nonnull
  public JournalEntryType getEntryType() {
    return entryType;
  }

  public void setEntryType(JournalEntryType entryType) {
    this.entryType = entryType;
  }


  public JournalData fromAccount(UUID fromAccount) {
    this.fromAccount = fromAccount;
    return this;
  }

   /**
   * Get fromAccount
   * @return fromAccount
  **/
  @javax.annotation.Nonnull
  public UUID getFromAccount() {
    return fromAccount;
  }

  public void setFromAccount(UUID fromAccount) {
    this.fromAccount = fromAccount;
  }


  public JournalData toAccount(UUID toAccount) {
    this.toAccount = toAccount;
    return this;
  }

   /**
   * Get toAccount
   * @return toAccount
  **/
  @javax.annotation.Nonnull
  public UUID getToAccount() {
    return toAccount;
  }

  public void setToAccount(UUID toAccount) {
    this.toAccount = toAccount;
  }


  public JournalData amount(BigDecimal amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Required for JNLC. The dollar amount to move. It has to be a positive value. 
   * @return amount
  **/
  @javax.annotation.Nullable
  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public JournalData symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Required for JNLS. 
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public JournalData qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Required for JNLS. The number of shares to move. It has to be a positive value. 
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JournalData journalData = (JournalData) o;
    return Objects.equals(this.entryType, journalData.entryType) &&
        Objects.equals(this.fromAccount, journalData.fromAccount) &&
        Objects.equals(this.toAccount, journalData.toAccount) &&
        Objects.equals(this.amount, journalData.amount) &&
        Objects.equals(this.symbol, journalData.symbol) &&
        Objects.equals(this.qty, journalData.qty);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entryType, fromAccount, toAccount, amount, symbol, qty);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JournalData {\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    toAccount: ").append(toIndentedString(toAccount)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("entry_type");
    openapiFields.add("from_account");
    openapiFields.add("to_account");
    openapiFields.add("amount");
    openapiFields.add("symbol");
    openapiFields.add("qty");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("entry_type");
    openapiRequiredFields.add("from_account");
    openapiRequiredFields.add("to_account");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!JournalData.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in JournalData is not found in the empty JSON string", JournalData.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!JournalData.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JournalData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : JournalData.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the required field `entry_type`
      JournalEntryType.validateJsonElement(jsonObj.get("entry_type"));
      if (!jsonObj.get("from_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from_account").toString()));
      }
      if (!jsonObj.get("to_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to_account").toString()));
      }
      if ((jsonObj.get("amount") != null && !jsonObj.get("amount").isJsonNull()) && !jsonObj.get("amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("amount").toString()));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!JournalData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'JournalData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<JournalData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(JournalData.class));

       return (TypeAdapter<T>) new TypeAdapter<JournalData>() {
           @Override
           public void write(JsonWriter out, JournalData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public JournalData read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of JournalData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of JournalData
  * @throws IOException if the JSON string is invalid with respect to JournalData
  */
  public static JournalData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, JournalData.class);
  }

 /**
  * Convert an instance of JournalData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

