/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * JNLS
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class JNLS {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_TO_ACCOUNT = "to_account";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT)
  private String toAccount;

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private String entryType;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private String price;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private JournalStatus status;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private String fromAccount;

  public static final String SERIALIZED_NAME_SETTLE_DATE = "settle_date";
  @SerializedName(SERIALIZED_NAME_SETTLE_DATE)
  private String settleDate;

  public static final String SERIALIZED_NAME_SYSTEM_DATE = "system_date";
  @SerializedName(SERIALIZED_NAME_SYSTEM_DATE)
  private String systemDate;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public JNLS() {
  }

  public JNLS id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The journal ID
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public JNLS toAccount(String toAccount) {
    this.toAccount = toAccount;
    return this;
  }

   /**
   * The account ID that received the journal - account_status must equal to ACTIVE
   * @return toAccount
  **/
  @javax.annotation.Nullable
  public String getToAccount() {
    return toAccount;
  }

  public void setToAccount(String toAccount) {
    this.toAccount = toAccount;
  }


  public JNLS entryType(String entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * JNLS
   * @return entryType
  **/
  @javax.annotation.Nullable
  public String getEntryType() {
    return entryType;
  }

  public void setEntryType(String entryType) {
    this.entryType = entryType;
  }


  public JNLS symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol of the security journaled
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public JNLS qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * The quantity of the securities journaled
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public JNLS price(String price) {
    this.price = price;
    return this;
  }

   /**
   * The price of the security journaled
   * @return price
  **/
  @javax.annotation.Nullable
  public String getPrice() {
    return price;
  }

  public void setPrice(String price) {
    this.price = price;
  }


  public JNLS status(JournalStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  public JournalStatus getStatus() {
    return status;
  }

  public void setStatus(JournalStatus status) {
    this.status = status;
  }


  public JNLS fromAccount(String fromAccount) {
    this.fromAccount = fromAccount;
    return this;
  }

   /**
   * The account ID that initiates the journal - account_status must equal to ACTIVE or CLOSE
   * @return fromAccount
  **/
  @javax.annotation.Nullable
  public String getFromAccount() {
    return fromAccount;
  }

  public void setFromAccount(String fromAccount) {
    this.fromAccount = fromAccount;
  }


  public JNLS settleDate(String settleDate) {
    this.settleDate = settleDate;
    return this;
  }

   /**
   * Date string in “%Y-%m-%d” format
   * @return settleDate
  **/
  @javax.annotation.Nullable
  public String getSettleDate() {
    return settleDate;
  }

  public void setSettleDate(String settleDate) {
    this.settleDate = settleDate;
  }


  public JNLS systemDate(String systemDate) {
    this.systemDate = systemDate;
    return this;
  }

   /**
   * Date string in “%Y-%m-%d” format
   * @return systemDate
  **/
  @javax.annotation.Nullable
  public String getSystemDate() {
    return systemDate;
  }

  public void setSystemDate(String systemDate) {
    this.systemDate = systemDate;
  }


  public JNLS description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public JNLS currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Currency denomination of the journal. USD by default.
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JNLS JNLS = (JNLS) o;
    return Objects.equals(this.id, JNLS.id) &&
        Objects.equals(this.toAccount, JNLS.toAccount) &&
        Objects.equals(this.entryType, JNLS.entryType) &&
        Objects.equals(this.symbol, JNLS.symbol) &&
        Objects.equals(this.qty, JNLS.qty) &&
        Objects.equals(this.price, JNLS.price) &&
        Objects.equals(this.status, JNLS.status) &&
        Objects.equals(this.fromAccount, JNLS.fromAccount) &&
        Objects.equals(this.settleDate, JNLS.settleDate) &&
        Objects.equals(this.systemDate, JNLS.systemDate) &&
        Objects.equals(this.description, JNLS.description) &&
        Objects.equals(this.currency, JNLS.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, toAccount, entryType, symbol, qty, price, status, fromAccount, settleDate, systemDate, description, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JNLS {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    toAccount: ").append(toIndentedString(toAccount)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    settleDate: ").append(toIndentedString(settleDate)).append("\n");
    sb.append("    systemDate: ").append(toIndentedString(systemDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("to_account");
    openapiFields.add("entry_type");
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("price");
    openapiFields.add("status");
    openapiFields.add("from_account");
    openapiFields.add("settle_date");
    openapiFields.add("system_date");
    openapiFields.add("description");
    openapiFields.add("currency");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!JNLS.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in JNLS is not found in the empty JSON string", JNLS.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!JNLS.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JNLS` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("to_account") != null && !jsonObj.get("to_account").isJsonNull()) && !jsonObj.get("to_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to_account").toString()));
      }
      if ((jsonObj.get("entry_type") != null && !jsonObj.get("entry_type").isJsonNull()) && !jsonObj.get("entry_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `entry_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entry_type").toString()));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("price") != null && !jsonObj.get("price").isJsonNull()) && !jsonObj.get("price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        JournalStatus.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("from_account") != null && !jsonObj.get("from_account").isJsonNull()) && !jsonObj.get("from_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from_account").toString()));
      }
      if ((jsonObj.get("settle_date") != null && !jsonObj.get("settle_date").isJsonNull()) && !jsonObj.get("settle_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `settle_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("settle_date").toString()));
      }
      if ((jsonObj.get("system_date") != null && !jsonObj.get("system_date").isJsonNull()) && !jsonObj.get("system_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `system_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("system_date").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!JNLS.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'JNLS' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<JNLS> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(JNLS.class));

       return (TypeAdapter<T>) new TypeAdapter<JNLS>() {
           @Override
           public void write(JsonWriter out, JNLS value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public JNLS read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of JNLS given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of JNLS
  * @throws IOException if the JSON string is invalid with respect to JNLS
  */
  public static JNLS fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, JNLS.class);
  }

 /**
  * Convert an instance of JNLS to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

