/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Journal information specific to cash transfers. This field is required for &#x60;Journal&#x60;s with an &#x60;entry_type&#x60; of &#x60;jnlc&#x60; (cash transfers), but will be null for those with &#x60;jnls&#x60; (securities transfers).
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class JNLC {
  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
  @SerializedName(SERIALIZED_NAME_NET_AMOUNT)
  private BigDecimal netAmount;

  public static final String SERIALIZED_NAME_TRANSMITTER_NAME = "transmitter_name";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_NAME)
  private String transmitterName;

  public static final String SERIALIZED_NAME_TRANSMITTER_ACCOUNT_NUMBER = "transmitter_account_number";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_ACCOUNT_NUMBER)
  private String transmitterAccountNumber;

  public static final String SERIALIZED_NAME_TRANSMITTER_ADDRESS = "transmitter_address";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_ADDRESS)
  private String transmitterAddress;

  public static final String SERIALIZED_NAME_TRANSMITTER_FINANCIAL_INSTITUTION = "transmitter_financial_institution";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_FINANCIAL_INSTITUTION)
  private String transmitterFinancialInstitution;

  public static final String SERIALIZED_NAME_TRANSMITTER_TIMESTAMP = "transmitter_timestamp";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_TIMESTAMP)
  private OffsetDateTime transmitterTimestamp;

  public JNLC() {
  }

  public JNLC description(String description) {
    this.description = description;
    return this;
  }

   /**
   * ID the amount goes to. Only valid for JNLC journals. Null for JNLS.
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public JNLC netAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.
   * @return netAmount
  **/
  @javax.annotation.Nonnull
  public BigDecimal getNetAmount() {
    return netAmount;
  }

  public void setNetAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
  }


  public JNLC transmitterName(String transmitterName) {
    this.transmitterName = transmitterName;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS. Max 255 characters.
   * @return transmitterName
  **/
  @javax.annotation.Nullable
  public String getTransmitterName() {
    return transmitterName;
  }

  public void setTransmitterName(String transmitterName) {
    this.transmitterName = transmitterName;
  }


  public JNLC transmitterAccountNumber(String transmitterAccountNumber) {
    this.transmitterAccountNumber = transmitterAccountNumber;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.max 255 characters
   * @return transmitterAccountNumber
  **/
  @javax.annotation.Nullable
  public String getTransmitterAccountNumber() {
    return transmitterAccountNumber;
  }

  public void setTransmitterAccountNumber(String transmitterAccountNumber) {
    this.transmitterAccountNumber = transmitterAccountNumber;
  }


  public JNLC transmitterAddress(String transmitterAddress) {
    this.transmitterAddress = transmitterAddress;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.max 255 characters
   * @return transmitterAddress
  **/
  @javax.annotation.Nullable
  public String getTransmitterAddress() {
    return transmitterAddress;
  }

  public void setTransmitterAddress(String transmitterAddress) {
    this.transmitterAddress = transmitterAddress;
  }


  public JNLC transmitterFinancialInstitution(String transmitterFinancialInstitution) {
    this.transmitterFinancialInstitution = transmitterFinancialInstitution;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.max 255 characters
   * @return transmitterFinancialInstitution
  **/
  @javax.annotation.Nullable
  public String getTransmitterFinancialInstitution() {
    return transmitterFinancialInstitution;
  }

  public void setTransmitterFinancialInstitution(String transmitterFinancialInstitution) {
    this.transmitterFinancialInstitution = transmitterFinancialInstitution;
  }


  public JNLC transmitterTimestamp(OffsetDateTime transmitterTimestamp) {
    this.transmitterTimestamp = transmitterTimestamp;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.
   * @return transmitterTimestamp
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getTransmitterTimestamp() {
    return transmitterTimestamp;
  }

  public void setTransmitterTimestamp(OffsetDateTime transmitterTimestamp) {
    this.transmitterTimestamp = transmitterTimestamp;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JNLC JNLC = (JNLC) o;
    return Objects.equals(this.description, JNLC.description) &&
        Objects.equals(this.netAmount, JNLC.netAmount) &&
        Objects.equals(this.transmitterName, JNLC.transmitterName) &&
        Objects.equals(this.transmitterAccountNumber, JNLC.transmitterAccountNumber) &&
        Objects.equals(this.transmitterAddress, JNLC.transmitterAddress) &&
        Objects.equals(this.transmitterFinancialInstitution, JNLC.transmitterFinancialInstitution) &&
        Objects.equals(this.transmitterTimestamp, JNLC.transmitterTimestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, netAmount, transmitterName, transmitterAccountNumber, transmitterAddress, transmitterFinancialInstitution, transmitterTimestamp);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JNLC {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    transmitterName: ").append(toIndentedString(transmitterName)).append("\n");
    sb.append("    transmitterAccountNumber: ").append(toIndentedString(transmitterAccountNumber)).append("\n");
    sb.append("    transmitterAddress: ").append(toIndentedString(transmitterAddress)).append("\n");
    sb.append("    transmitterFinancialInstitution: ").append(toIndentedString(transmitterFinancialInstitution)).append("\n");
    sb.append("    transmitterTimestamp: ").append(toIndentedString(transmitterTimestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("description");
    openapiFields.add("net_amount");
    openapiFields.add("transmitter_name");
    openapiFields.add("transmitter_account_number");
    openapiFields.add("transmitter_address");
    openapiFields.add("transmitter_financial_institution");
    openapiFields.add("transmitter_timestamp");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("net_amount");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!JNLC.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in JNLC is not found in the empty JSON string", JNLC.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!JNLC.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JNLC` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : JNLC.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (!jsonObj.get("net_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_amount").toString()));
      }
      if ((jsonObj.get("transmitter_name") != null && !jsonObj.get("transmitter_name").isJsonNull()) && !jsonObj.get("transmitter_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_name").toString()));
      }
      if ((jsonObj.get("transmitter_account_number") != null && !jsonObj.get("transmitter_account_number").isJsonNull()) && !jsonObj.get("transmitter_account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_account_number").toString()));
      }
      if ((jsonObj.get("transmitter_address") != null && !jsonObj.get("transmitter_address").isJsonNull()) && !jsonObj.get("transmitter_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_address").toString()));
      }
      if ((jsonObj.get("transmitter_financial_institution") != null && !jsonObj.get("transmitter_financial_institution").isJsonNull()) && !jsonObj.get("transmitter_financial_institution").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_financial_institution` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_financial_institution").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!JNLC.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'JNLC' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<JNLC> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(JNLC.class));

       return (TypeAdapter<T>) new TypeAdapter<JNLC>() {
           @Override
           public void write(JsonWriter out, JNLC value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public JNLC read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of JNLC given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of JNLC
  * @throws IOException if the JSON string is invalid with respect to JNLC
  */
  public static JNLC fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, JNLC.class);
  }

 /**
  * Convert an instance of JNLC to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

