/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * JIT Securities reports are made available through the API and can be accessed within the hour after 11:30 PM EST on the trade date (T+0). The reports communicate transaction-level details as well as overall settlement amounts, transfer direction, and payment timing.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class JITReport {
  public static final String SERIALIZED_NAME_DETAIL = "detail";
  @SerializedName(SERIALIZED_NAME_DETAIL)
  private String detail;

  public static final String SERIALIZED_NAME_NET_SUMMARY = "net_summary";
  @SerializedName(SERIALIZED_NAME_NET_SUMMARY)
  private String netSummary;

  public static final String SERIALIZED_NAME_NET_PAYMENT = "net_payment";
  @SerializedName(SERIALIZED_NAME_NET_PAYMENT)
  private String netPayment;

  public static final String SERIALIZED_NAME_NET_PAYMENT_FINAL = "net_payment_final";
  @SerializedName(SERIALIZED_NAME_NET_PAYMENT_FINAL)
  private String netPaymentFinal;

  public JITReport() {
  }

  public JITReport detail(String detail) {
    this.detail = detail;
    return this;
  }

   /**
   * Contains all activities that impact cash throughout the trading session including executed trades, trading fees, and corporate actions that involve cash allocations.  content-type &#x3D; application/csv
   * @return detail
  **/
  @javax.annotation.Nullable
  public String getDetail() {
    return detail;
  }

  public void setDetail(String detail) {
    this.detail = detail;
  }


  public JITReport netSummary(String netSummary) {
    this.netSummary = netSummary;
    return this;
  }

   /**
   * Consists of three columns and a single row, which lists the net money movement to or from Alpaca for T0, T1, and T2.  content-type &#x3D; application/csv
   * @return netSummary
  **/
  @javax.annotation.Nullable
  public String getNetSummary() {
    return netSummary;
  }

  public void setNetSummary(String netSummary) {
    this.netSummary = netSummary;
  }


  public JITReport netPayment(String netPayment) {
    this.netPayment = netPayment;
    return this;
  }

   /**
   * Highlights the net amount due to Alpaca by settlement or to the partner on the date of settlement in a formalized invoice format.  content-type &#x3D; application/pdf
   * @return netPayment
  **/
  @javax.annotation.Nullable
  public String getNetPayment() {
    return netPayment;
  }

  public void setNetPayment(String netPayment) {
    this.netPayment = netPayment;
  }


  public JITReport netPaymentFinal(String netPaymentFinal) {
    this.netPaymentFinal = netPaymentFinal;
    return this;
  }

   /**
   * Includes additional information to account for T+0 and T+1 settling activity to clarify settlement journaling reconciliation. This report is generated after trading session close on T+1.  content-type &#x3D; application/pdf
   * @return netPaymentFinal
  **/
  @javax.annotation.Nullable
  public String getNetPaymentFinal() {
    return netPaymentFinal;
  }

  public void setNetPaymentFinal(String netPaymentFinal) {
    this.netPaymentFinal = netPaymentFinal;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JITReport jiTReport = (JITReport) o;
    return Objects.equals(this.detail, jiTReport.detail) &&
        Objects.equals(this.netSummary, jiTReport.netSummary) &&
        Objects.equals(this.netPayment, jiTReport.netPayment) &&
        Objects.equals(this.netPaymentFinal, jiTReport.netPaymentFinal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(detail, netSummary, netPayment, netPaymentFinal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JITReport {\n");
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    sb.append("    netSummary: ").append(toIndentedString(netSummary)).append("\n");
    sb.append("    netPayment: ").append(toIndentedString(netPayment)).append("\n");
    sb.append("    netPaymentFinal: ").append(toIndentedString(netPaymentFinal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("detail");
    openapiFields.add("net_summary");
    openapiFields.add("net_payment");
    openapiFields.add("net_payment_final");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!JITReport.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in JITReport is not found in the empty JSON string", JITReport.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!JITReport.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `JITReport` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("detail") != null && !jsonObj.get("detail").isJsonNull()) && !jsonObj.get("detail").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `detail` to be a primitive type in the JSON string but got `%s`", jsonObj.get("detail").toString()));
      }
      if ((jsonObj.get("net_summary") != null && !jsonObj.get("net_summary").isJsonNull()) && !jsonObj.get("net_summary").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_summary").toString()));
      }
      if ((jsonObj.get("net_payment") != null && !jsonObj.get("net_payment").isJsonNull()) && !jsonObj.get("net_payment").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_payment` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_payment").toString()));
      }
      if ((jsonObj.get("net_payment_final") != null && !jsonObj.get("net_payment_final").isJsonNull()) && !jsonObj.get("net_payment_final").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_payment_final` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_payment_final").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!JITReport.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'JITReport' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<JITReport> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(JITReport.class));

       return (TypeAdapter<T>) new TypeAdapter<JITReport>() {
           @Override
           public void write(JsonWriter out, JITReport value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public JITReport read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of JITReport given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of JITReport
  * @throws IOException if the JSON string is invalid with respect to JITReport
  */
  public static JITReport fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, JITReport.class);
  }

 /**
  * Convert an instance of JITReport to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

