/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.TaxIdType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Identity is the model to provide account owner’s identity information. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Identity {
  public static final String SERIALIZED_NAME_GIVEN_NAME = "given_name";
  @SerializedName(SERIALIZED_NAME_GIVEN_NAME)
  private String givenName;

  public static final String SERIALIZED_NAME_FAMILY_NAME = "family_name";
  @SerializedName(SERIALIZED_NAME_FAMILY_NAME)
  private String familyName;

  public static final String SERIALIZED_NAME_MIDDLE_NAME = "middle_name";
  @SerializedName(SERIALIZED_NAME_MIDDLE_NAME)
  private String middleName;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_TAX_ID = "tax_id";
  @SerializedName(SERIALIZED_NAME_TAX_ID)
  private String taxId;

  public static final String SERIALIZED_NAME_TAX_ID_TYPE = "tax_id_type";
  @SerializedName(SERIALIZED_NAME_TAX_ID_TYPE)
  private TaxIdType taxIdType;

  public static final String SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP = "country_of_citizenship";
  @SerializedName(SERIALIZED_NAME_COUNTRY_OF_CITIZENSHIP)
  private String countryOfCitizenship;

  public static final String SERIALIZED_NAME_COUNTRY_OF_BIRTH = "country_of_birth";
  @SerializedName(SERIALIZED_NAME_COUNTRY_OF_BIRTH)
  private String countryOfBirth;

  public static final String SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE = "country_of_tax_residence";
  @SerializedName(SERIALIZED_NAME_COUNTRY_OF_TAX_RESIDENCE)
  private String countryOfTaxResidence;

  /**
   * Gets or Sets fundingSource
   */
  @JsonAdapter(FundingSourceEnum.Adapter.class)
  public enum FundingSourceEnum {
    EMPLOYMENT_INCOME("employment_income"),
    
    INVESTMENTS("investments"),
    
    INHERITANCE("inheritance"),
    
    BUSINESS_INCOME("business_income"),
    
    SAVINGS("savings"),
    
    FAMILY("family");

    private String value;

    FundingSourceEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FundingSourceEnum fromValue(String value) {
      for (FundingSourceEnum b : FundingSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<FundingSourceEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FundingSourceEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FundingSourceEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FundingSourceEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      FundingSourceEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_FUNDING_SOURCE = "funding_source";
  @SerializedName(SERIALIZED_NAME_FUNDING_SOURCE)
  private List<FundingSourceEnum> fundingSource = new ArrayList<>();

  /**
   * The user&#39;s ability to quickly and easily convert to cash all or a portion of the investments in this account without experiencing significant loss in value. 
   */
  @JsonAdapter(LiquidityNeedsEnum.Adapter.class)
  public enum LiquidityNeedsEnum {
    VERY_IMPORTANT("very_important"),
    
    IMPORTANT("important"),
    
    SOMEWHAT_IMPORTANT("somewhat_important"),
    
    DOES_NOT_MATTER("does_not_matter");

    private String value;

    LiquidityNeedsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LiquidityNeedsEnum fromValue(String value) {
      for (LiquidityNeedsEnum b : LiquidityNeedsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<LiquidityNeedsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LiquidityNeedsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LiquidityNeedsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return LiquidityNeedsEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      LiquidityNeedsEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_LIQUIDITY_NEEDS = "liquidity_needs";
  @SerializedName(SERIALIZED_NAME_LIQUIDITY_NEEDS)
  private LiquidityNeedsEnum liquidityNeeds;

  /**
   * The user&#39;s level of expertise and familiarity with investing in US Equities. 
   */
  @JsonAdapter(InvestmentExperienceWithStocksEnum.Adapter.class)
  public enum InvestmentExperienceWithStocksEnum {
    NONE("none"),
    
    _1_TO_5_YEARS("1_to_5_years"),
    
    OVER_5_YEARS("over_5_years");

    private String value;

    InvestmentExperienceWithStocksEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InvestmentExperienceWithStocksEnum fromValue(String value) {
      for (InvestmentExperienceWithStocksEnum b : InvestmentExperienceWithStocksEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<InvestmentExperienceWithStocksEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InvestmentExperienceWithStocksEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InvestmentExperienceWithStocksEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InvestmentExperienceWithStocksEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      InvestmentExperienceWithStocksEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS = "investment_experience_with_stocks";
  @SerializedName(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_STOCKS)
  private InvestmentExperienceWithStocksEnum investmentExperienceWithStocks;

  /**
   * The user&#39;s level of expertise and familiarity with investing in Options. 
   */
  @JsonAdapter(InvestmentExperienceWithOptionsEnum.Adapter.class)
  public enum InvestmentExperienceWithOptionsEnum {
    NONE("none"),
    
    _1_TO_5_YEARS("1_to_5_years"),
    
    OVER_5_YEARS("over_5_years");

    private String value;

    InvestmentExperienceWithOptionsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InvestmentExperienceWithOptionsEnum fromValue(String value) {
      for (InvestmentExperienceWithOptionsEnum b : InvestmentExperienceWithOptionsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<InvestmentExperienceWithOptionsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InvestmentExperienceWithOptionsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InvestmentExperienceWithOptionsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InvestmentExperienceWithOptionsEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      InvestmentExperienceWithOptionsEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS = "investment_experience_with_options";
  @SerializedName(SERIALIZED_NAME_INVESTMENT_EXPERIENCE_WITH_OPTIONS)
  private InvestmentExperienceWithOptionsEnum investmentExperienceWithOptions;

  /**
   * The user&#39;s investment risk tolerance. 
   */
  @JsonAdapter(RiskToleranceEnum.Adapter.class)
  public enum RiskToleranceEnum {
    CONSERVATIVE("conservative"),
    
    MODERATE("moderate"),
    
    SIGNIFICANT_RISK("significant_risk");

    private String value;

    RiskToleranceEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RiskToleranceEnum fromValue(String value) {
      for (RiskToleranceEnum b : RiskToleranceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<RiskToleranceEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RiskToleranceEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RiskToleranceEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RiskToleranceEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      RiskToleranceEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_RISK_TOLERANCE = "risk_tolerance";
  @SerializedName(SERIALIZED_NAME_RISK_TOLERANCE)
  private RiskToleranceEnum riskTolerance;

  /**
   * The user&#39;s investment objective. 
   */
  @JsonAdapter(InvestmentObjectiveEnum.Adapter.class)
  public enum InvestmentObjectiveEnum {
    GENERATE_INCOME("generate_income"),
    
    PARTIALLY_FUND_RETIREMENT("partially_fund_retirement"),
    
    WHOLLY_FUND_RETIREMENT("wholly_fund_retirement"),
    
    STEADILY_ACCUMULATE_WEALTH("steadily_accumulate_wealth"),
    
    PRESERVE_WEALTH("preserve_wealth"),
    
    PAY_FOR_LARGE_PURCHASE("pay_for_large_purchase"),
    
    MARKET_SPECULATION("market_speculation");

    private String value;

    InvestmentObjectiveEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InvestmentObjectiveEnum fromValue(String value) {
      for (InvestmentObjectiveEnum b : InvestmentObjectiveEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<InvestmentObjectiveEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InvestmentObjectiveEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InvestmentObjectiveEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InvestmentObjectiveEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      InvestmentObjectiveEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_INVESTMENT_OBJECTIVE = "investment_objective";
  @SerializedName(SERIALIZED_NAME_INVESTMENT_OBJECTIVE)
  private InvestmentObjectiveEnum investmentObjective;

  /**
   * The expected period of time the user plan to invest to achieve his/her financial goal(s) 
   */
  @JsonAdapter(InvestmentTimeHorizonEnum.Adapter.class)
  public enum InvestmentTimeHorizonEnum {
    LESS_THAN_1_YEAR("less_than_1_year"),
    
    _1_TO_2_YEARS("1_to_2_years"),
    
    _3_TO_5_YEARS("3_to_5_years"),
    
    _6_TO_10_YEARS("6_to_10_years"),
    
    MORE_THAN_10_YEARS("more_than_10_years");

    private String value;

    InvestmentTimeHorizonEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InvestmentTimeHorizonEnum fromValue(String value) {
      for (InvestmentTimeHorizonEnum b : InvestmentTimeHorizonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<InvestmentTimeHorizonEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InvestmentTimeHorizonEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InvestmentTimeHorizonEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InvestmentTimeHorizonEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      InvestmentTimeHorizonEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_INVESTMENT_TIME_HORIZON = "investment_time_horizon";
  @SerializedName(SERIALIZED_NAME_INVESTMENT_TIME_HORIZON)
  private InvestmentTimeHorizonEnum investmentTimeHorizon;

  public static final String SERIALIZED_NAME_ANNUAL_INCOME_MIN = "annual_income_min";
  @SerializedName(SERIALIZED_NAME_ANNUAL_INCOME_MIN)
  private BigDecimal annualIncomeMin;

  public static final String SERIALIZED_NAME_ANNUAL_INCOME_MAX = "annual_income_max";
  @SerializedName(SERIALIZED_NAME_ANNUAL_INCOME_MAX)
  private BigDecimal annualIncomeMax;

  public static final String SERIALIZED_NAME_LIQUID_NET_WORTH_MIN = "liquid_net_worth_min";
  @SerializedName(SERIALIZED_NAME_LIQUID_NET_WORTH_MIN)
  private BigDecimal liquidNetWorthMin;

  public static final String SERIALIZED_NAME_LIQUID_NET_WORTH_MAX = "liquid_net_worth_max";
  @SerializedName(SERIALIZED_NAME_LIQUID_NET_WORTH_MAX)
  private BigDecimal liquidNetWorthMax;

  public static final String SERIALIZED_NAME_TOTAL_NET_WORTH_MIN = "total_net_worth_min";
  @SerializedName(SERIALIZED_NAME_TOTAL_NET_WORTH_MIN)
  private BigDecimal totalNetWorthMin;

  public static final String SERIALIZED_NAME_TOTAL_NET_WORTH_MAX = "total_net_worth_max";
  @SerializedName(SERIALIZED_NAME_TOTAL_NET_WORTH_MAX)
  private BigDecimal totalNetWorthMax;

  public static final String SERIALIZED_NAME_VISA_TYPE = "visa_type";
  @SerializedName(SERIALIZED_NAME_VISA_TYPE)
  private String visaType;

  public static final String SERIALIZED_NAME_VISA_EXPIRATION_DATE = "visa_expiration_date";
  @SerializedName(SERIALIZED_NAME_VISA_EXPIRATION_DATE)
  private LocalDate visaExpirationDate;

  public static final String SERIALIZED_NAME_DATE_OF_DEPARTURE_FROM_USA = "date_of_departure_from_usa";
  @SerializedName(SERIALIZED_NAME_DATE_OF_DEPARTURE_FROM_USA)
  private LocalDate dateOfDepartureFromUsa;

  public static final String SERIALIZED_NAME_PERMANENT_RESIDENT = "permanent_resident";
  @SerializedName(SERIALIZED_NAME_PERMANENT_RESIDENT)
  private Boolean permanentResident;

  public static final String SERIALIZED_NAME_EXTRA = "extra";
  @SerializedName(SERIALIZED_NAME_EXTRA)
  private Object extra;

  public Identity() {
  }

  public Identity givenName(String givenName) {
    this.givenName = givenName;
    return this;
  }

   /**
   * The first/given name of the user.
   * @return givenName
  **/
  @javax.annotation.Nonnull
  public String getGivenName() {
    return givenName;
  }

  public void setGivenName(String givenName) {
    this.givenName = givenName;
  }


  public Identity familyName(String familyName) {
    this.familyName = familyName;
    return this;
  }

   /**
   * The last name (surname) of the user.
   * @return familyName
  **/
  @javax.annotation.Nonnull
  public String getFamilyName() {
    return familyName;
  }

  public void setFamilyName(String familyName) {
    this.familyName = familyName;
  }


  public Identity middleName(String middleName) {
    this.middleName = middleName;
    return this;
  }

   /**
   * The middle name of the user.
   * @return middleName
  **/
  @javax.annotation.Nullable
  public String getMiddleName() {
    return middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }


  public Identity dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The date of birth in \&quot;YYYY-MM-DD\&quot; format.
   * @return dateOfBirth
  **/
  @javax.annotation.Nonnull
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public Identity taxId(String taxId) {
    this.taxId = taxId;
    return this;
  }

   /**
   * Required if tax_id_type is set.
   * @return taxId
  **/
  @javax.annotation.Nullable
  public String getTaxId() {
    return taxId;
  }

  public void setTaxId(String taxId) {
    this.taxId = taxId;
  }


  public Identity taxIdType(TaxIdType taxIdType) {
    this.taxIdType = taxIdType;
    return this;
  }

   /**
   * Get taxIdType
   * @return taxIdType
  **/
  @javax.annotation.Nonnull
  public TaxIdType getTaxIdType() {
    return taxIdType;
  }

  public void setTaxIdType(TaxIdType taxIdType) {
    this.taxIdType = taxIdType;
  }


  public Identity countryOfCitizenship(String countryOfCitizenship) {
    this.countryOfCitizenship = countryOfCitizenship;
    return this;
  }

   /**
   * [ISO 3166-1 alpha-3](https://www.iso.org/iso-3166-country-codes.html). 
   * @return countryOfCitizenship
  **/
  @javax.annotation.Nullable
  public String getCountryOfCitizenship() {
    return countryOfCitizenship;
  }

  public void setCountryOfCitizenship(String countryOfCitizenship) {
    this.countryOfCitizenship = countryOfCitizenship;
  }


  public Identity countryOfBirth(String countryOfBirth) {
    this.countryOfBirth = countryOfBirth;
    return this;
  }

   /**
   * [ISO 3166-1 alpha-3](https://www.iso.org/iso-3166-country-codes.html). 
   * @return countryOfBirth
  **/
  @javax.annotation.Nullable
  public String getCountryOfBirth() {
    return countryOfBirth;
  }

  public void setCountryOfBirth(String countryOfBirth) {
    this.countryOfBirth = countryOfBirth;
  }


  public Identity countryOfTaxResidence(String countryOfTaxResidence) {
    this.countryOfTaxResidence = countryOfTaxResidence;
    return this;
  }

   /**
   * [ISO 3166-1 alpha-3](https://www.iso.org/iso-3166-country-codes.html). 
   * @return countryOfTaxResidence
  **/
  @javax.annotation.Nonnull
  public String getCountryOfTaxResidence() {
    return countryOfTaxResidence;
  }

  public void setCountryOfTaxResidence(String countryOfTaxResidence) {
    this.countryOfTaxResidence = countryOfTaxResidence;
  }


  public Identity fundingSource(List<FundingSourceEnum> fundingSource) {
    this.fundingSource = fundingSource;
    return this;
  }

  public Identity addFundingSourceItem(FundingSourceEnum fundingSourceItem) {
    if (this.fundingSource == null) {
      this.fundingSource = new ArrayList<>();
    }
    this.fundingSource.add(fundingSourceItem);
    return this;
  }

   /**
   * Can be one or more of the following: &#x60;employment_income&#x60;, &#x60;investments&#x60;, &#x60;inheritance&#x60;, &#x60;business_income&#x60;, &#x60;savings&#x60;, &#x60;family&#x60;.
   * @return fundingSource
  **/
  @javax.annotation.Nonnull
  public List<FundingSourceEnum> getFundingSource() {
    return fundingSource;
  }

  public void setFundingSource(List<FundingSourceEnum> fundingSource) {
    this.fundingSource = fundingSource;
  }


  public Identity liquidityNeeds(LiquidityNeedsEnum liquidityNeeds) {
    this.liquidityNeeds = liquidityNeeds;
    return this;
  }

   /**
   * The user&#39;s ability to quickly and easily convert to cash all or a portion of the investments in this account without experiencing significant loss in value. 
   * @return liquidityNeeds
  **/
  @javax.annotation.Nullable
  public LiquidityNeedsEnum getLiquidityNeeds() {
    return liquidityNeeds;
  }

  public void setLiquidityNeeds(LiquidityNeedsEnum liquidityNeeds) {
    this.liquidityNeeds = liquidityNeeds;
  }


  public Identity investmentExperienceWithStocks(InvestmentExperienceWithStocksEnum investmentExperienceWithStocks) {
    this.investmentExperienceWithStocks = investmentExperienceWithStocks;
    return this;
  }

   /**
   * The user&#39;s level of expertise and familiarity with investing in US Equities. 
   * @return investmentExperienceWithStocks
  **/
  @javax.annotation.Nullable
  public InvestmentExperienceWithStocksEnum getInvestmentExperienceWithStocks() {
    return investmentExperienceWithStocks;
  }

  public void setInvestmentExperienceWithStocks(InvestmentExperienceWithStocksEnum investmentExperienceWithStocks) {
    this.investmentExperienceWithStocks = investmentExperienceWithStocks;
  }


  public Identity investmentExperienceWithOptions(InvestmentExperienceWithOptionsEnum investmentExperienceWithOptions) {
    this.investmentExperienceWithOptions = investmentExperienceWithOptions;
    return this;
  }

   /**
   * The user&#39;s level of expertise and familiarity with investing in Options. 
   * @return investmentExperienceWithOptions
  **/
  @javax.annotation.Nullable
  public InvestmentExperienceWithOptionsEnum getInvestmentExperienceWithOptions() {
    return investmentExperienceWithOptions;
  }

  public void setInvestmentExperienceWithOptions(InvestmentExperienceWithOptionsEnum investmentExperienceWithOptions) {
    this.investmentExperienceWithOptions = investmentExperienceWithOptions;
  }


  public Identity riskTolerance(RiskToleranceEnum riskTolerance) {
    this.riskTolerance = riskTolerance;
    return this;
  }

   /**
   * The user&#39;s investment risk tolerance. 
   * @return riskTolerance
  **/
  @javax.annotation.Nullable
  public RiskToleranceEnum getRiskTolerance() {
    return riskTolerance;
  }

  public void setRiskTolerance(RiskToleranceEnum riskTolerance) {
    this.riskTolerance = riskTolerance;
  }


  public Identity investmentObjective(InvestmentObjectiveEnum investmentObjective) {
    this.investmentObjective = investmentObjective;
    return this;
  }

   /**
   * The user&#39;s investment objective. 
   * @return investmentObjective
  **/
  @javax.annotation.Nullable
  public InvestmentObjectiveEnum getInvestmentObjective() {
    return investmentObjective;
  }

  public void setInvestmentObjective(InvestmentObjectiveEnum investmentObjective) {
    this.investmentObjective = investmentObjective;
  }


  public Identity investmentTimeHorizon(InvestmentTimeHorizonEnum investmentTimeHorizon) {
    this.investmentTimeHorizon = investmentTimeHorizon;
    return this;
  }

   /**
   * The expected period of time the user plan to invest to achieve his/her financial goal(s) 
   * @return investmentTimeHorizon
  **/
  @javax.annotation.Nullable
  public InvestmentTimeHorizonEnum getInvestmentTimeHorizon() {
    return investmentTimeHorizon;
  }

  public void setInvestmentTimeHorizon(InvestmentTimeHorizonEnum investmentTimeHorizon) {
    this.investmentTimeHorizon = investmentTimeHorizon;
  }


  public Identity annualIncomeMin(BigDecimal annualIncomeMin) {
    this.annualIncomeMin = annualIncomeMin;
    return this;
  }

   /**
   * The lower bound of the user&#39;s annual income.
   * @return annualIncomeMin
  **/
  @javax.annotation.Nullable
  public BigDecimal getAnnualIncomeMin() {
    return annualIncomeMin;
  }

  public void setAnnualIncomeMin(BigDecimal annualIncomeMin) {
    this.annualIncomeMin = annualIncomeMin;
  }


  public Identity annualIncomeMax(BigDecimal annualIncomeMax) {
    this.annualIncomeMax = annualIncomeMax;
    return this;
  }

   /**
   * The upper bound of the user&#39;s annual income.
   * @return annualIncomeMax
  **/
  @javax.annotation.Nullable
  public BigDecimal getAnnualIncomeMax() {
    return annualIncomeMax;
  }

  public void setAnnualIncomeMax(BigDecimal annualIncomeMax) {
    this.annualIncomeMax = annualIncomeMax;
  }


  public Identity liquidNetWorthMin(BigDecimal liquidNetWorthMin) {
    this.liquidNetWorthMin = liquidNetWorthMin;
    return this;
  }

   /**
   * The lower bound of the user&#39;s liquid net worth.
   * @return liquidNetWorthMin
  **/
  @javax.annotation.Nullable
  public BigDecimal getLiquidNetWorthMin() {
    return liquidNetWorthMin;
  }

  public void setLiquidNetWorthMin(BigDecimal liquidNetWorthMin) {
    this.liquidNetWorthMin = liquidNetWorthMin;
  }


  public Identity liquidNetWorthMax(BigDecimal liquidNetWorthMax) {
    this.liquidNetWorthMax = liquidNetWorthMax;
    return this;
  }

   /**
   * The upper bound of the user&#39;s liquid net worth.
   * @return liquidNetWorthMax
  **/
  @javax.annotation.Nullable
  public BigDecimal getLiquidNetWorthMax() {
    return liquidNetWorthMax;
  }

  public void setLiquidNetWorthMax(BigDecimal liquidNetWorthMax) {
    this.liquidNetWorthMax = liquidNetWorthMax;
  }


  public Identity totalNetWorthMin(BigDecimal totalNetWorthMin) {
    this.totalNetWorthMin = totalNetWorthMin;
    return this;
  }

   /**
   * The lower bound of the user&#39;s total net worth.
   * @return totalNetWorthMin
  **/
  @javax.annotation.Nullable
  public BigDecimal getTotalNetWorthMin() {
    return totalNetWorthMin;
  }

  public void setTotalNetWorthMin(BigDecimal totalNetWorthMin) {
    this.totalNetWorthMin = totalNetWorthMin;
  }


  public Identity totalNetWorthMax(BigDecimal totalNetWorthMax) {
    this.totalNetWorthMax = totalNetWorthMax;
    return this;
  }

   /**
   * The upper bound of the user&#39;s total net worth.
   * @return totalNetWorthMax
  **/
  @javax.annotation.Nullable
  public BigDecimal getTotalNetWorthMax() {
    return totalNetWorthMax;
  }

  public void setTotalNetWorthMax(BigDecimal totalNetWorthMax) {
    this.totalNetWorthMax = totalNetWorthMax;
  }


  public Identity visaType(String visaType) {
    this.visaType = visaType;
    return this;
  }

   /**
   * Only used to collect visa types for users residing in the USA.
   * @return visaType
  **/
  @javax.annotation.Nullable
  public String getVisaType() {
    return visaType;
  }

  public void setVisaType(String visaType) {
    this.visaType = visaType;
  }


  public Identity visaExpirationDate(LocalDate visaExpirationDate) {
    this.visaExpirationDate = visaExpirationDate;
    return this;
  }

   /**
   * Required if &#x60;visa_type&#x60; is set.
   * @return visaExpirationDate
  **/
  @javax.annotation.Nullable
  public LocalDate getVisaExpirationDate() {
    return visaExpirationDate;
  }

  public void setVisaExpirationDate(LocalDate visaExpirationDate) {
    this.visaExpirationDate = visaExpirationDate;
  }


  public Identity dateOfDepartureFromUsa(LocalDate dateOfDepartureFromUsa) {
    this.dateOfDepartureFromUsa = dateOfDepartureFromUsa;
    return this;
  }

   /**
   * Required if &#x60;visa_type&#x60; &#x3D; B1 or B2
   * @return dateOfDepartureFromUsa
  **/
  @javax.annotation.Nullable
  public LocalDate getDateOfDepartureFromUsa() {
    return dateOfDepartureFromUsa;
  }

  public void setDateOfDepartureFromUsa(LocalDate dateOfDepartureFromUsa) {
    this.dateOfDepartureFromUsa = dateOfDepartureFromUsa;
  }


  public Identity permanentResident(Boolean permanentResident) {
    this.permanentResident = permanentResident;
    return this;
  }

   /**
   * Only used to collect permanent residence status in the USA.
   * @return permanentResident
  **/
  @javax.annotation.Nullable
  public Boolean getPermanentResident() {
    return permanentResident;
  }

  public void setPermanentResident(Boolean permanentResident) {
    this.permanentResident = permanentResident;
  }


  public Identity extra(Object extra) {
    this.extra = extra;
    return this;
  }

   /**
   * Any additional information used for KYC purposes 
   * @return extra
  **/
  @javax.annotation.Nullable
  public Object getExtra() {
    return extra;
  }

  public void setExtra(Object extra) {
    this.extra = extra;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Identity identity = (Identity) o;
    return Objects.equals(this.givenName, identity.givenName) &&
        Objects.equals(this.familyName, identity.familyName) &&
        Objects.equals(this.middleName, identity.middleName) &&
        Objects.equals(this.dateOfBirth, identity.dateOfBirth) &&
        Objects.equals(this.taxId, identity.taxId) &&
        Objects.equals(this.taxIdType, identity.taxIdType) &&
        Objects.equals(this.countryOfCitizenship, identity.countryOfCitizenship) &&
        Objects.equals(this.countryOfBirth, identity.countryOfBirth) &&
        Objects.equals(this.countryOfTaxResidence, identity.countryOfTaxResidence) &&
        Objects.equals(this.fundingSource, identity.fundingSource) &&
        Objects.equals(this.liquidityNeeds, identity.liquidityNeeds) &&
        Objects.equals(this.investmentExperienceWithStocks, identity.investmentExperienceWithStocks) &&
        Objects.equals(this.investmentExperienceWithOptions, identity.investmentExperienceWithOptions) &&
        Objects.equals(this.riskTolerance, identity.riskTolerance) &&
        Objects.equals(this.investmentObjective, identity.investmentObjective) &&
        Objects.equals(this.investmentTimeHorizon, identity.investmentTimeHorizon) &&
        Objects.equals(this.annualIncomeMin, identity.annualIncomeMin) &&
        Objects.equals(this.annualIncomeMax, identity.annualIncomeMax) &&
        Objects.equals(this.liquidNetWorthMin, identity.liquidNetWorthMin) &&
        Objects.equals(this.liquidNetWorthMax, identity.liquidNetWorthMax) &&
        Objects.equals(this.totalNetWorthMin, identity.totalNetWorthMin) &&
        Objects.equals(this.totalNetWorthMax, identity.totalNetWorthMax) &&
        Objects.equals(this.visaType, identity.visaType) &&
        Objects.equals(this.visaExpirationDate, identity.visaExpirationDate) &&
        Objects.equals(this.dateOfDepartureFromUsa, identity.dateOfDepartureFromUsa) &&
        Objects.equals(this.permanentResident, identity.permanentResident) &&
        Objects.equals(this.extra, identity.extra);
  }

  @Override
  public int hashCode() {
    return Objects.hash(givenName, familyName, middleName, dateOfBirth, taxId, taxIdType, countryOfCitizenship, countryOfBirth, countryOfTaxResidence, fundingSource, liquidityNeeds, investmentExperienceWithStocks, investmentExperienceWithOptions, riskTolerance, investmentObjective, investmentTimeHorizon, annualIncomeMin, annualIncomeMax, liquidNetWorthMin, liquidNetWorthMax, totalNetWorthMin, totalNetWorthMax, visaType, visaExpirationDate, dateOfDepartureFromUsa, permanentResident, extra);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Identity {\n");
    sb.append("    givenName: ").append(toIndentedString(givenName)).append("\n");
    sb.append("    familyName: ").append(toIndentedString(familyName)).append("\n");
    sb.append("    middleName: ").append(toIndentedString(middleName)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    taxId: ").append(toIndentedString(taxId)).append("\n");
    sb.append("    taxIdType: ").append(toIndentedString(taxIdType)).append("\n");
    sb.append("    countryOfCitizenship: ").append(toIndentedString(countryOfCitizenship)).append("\n");
    sb.append("    countryOfBirth: ").append(toIndentedString(countryOfBirth)).append("\n");
    sb.append("    countryOfTaxResidence: ").append(toIndentedString(countryOfTaxResidence)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    liquidityNeeds: ").append(toIndentedString(liquidityNeeds)).append("\n");
    sb.append("    investmentExperienceWithStocks: ").append(toIndentedString(investmentExperienceWithStocks)).append("\n");
    sb.append("    investmentExperienceWithOptions: ").append(toIndentedString(investmentExperienceWithOptions)).append("\n");
    sb.append("    riskTolerance: ").append(toIndentedString(riskTolerance)).append("\n");
    sb.append("    investmentObjective: ").append(toIndentedString(investmentObjective)).append("\n");
    sb.append("    investmentTimeHorizon: ").append(toIndentedString(investmentTimeHorizon)).append("\n");
    sb.append("    annualIncomeMin: ").append(toIndentedString(annualIncomeMin)).append("\n");
    sb.append("    annualIncomeMax: ").append(toIndentedString(annualIncomeMax)).append("\n");
    sb.append("    liquidNetWorthMin: ").append(toIndentedString(liquidNetWorthMin)).append("\n");
    sb.append("    liquidNetWorthMax: ").append(toIndentedString(liquidNetWorthMax)).append("\n");
    sb.append("    totalNetWorthMin: ").append(toIndentedString(totalNetWorthMin)).append("\n");
    sb.append("    totalNetWorthMax: ").append(toIndentedString(totalNetWorthMax)).append("\n");
    sb.append("    visaType: ").append(toIndentedString(visaType)).append("\n");
    sb.append("    visaExpirationDate: ").append(toIndentedString(visaExpirationDate)).append("\n");
    sb.append("    dateOfDepartureFromUsa: ").append(toIndentedString(dateOfDepartureFromUsa)).append("\n");
    sb.append("    permanentResident: ").append(toIndentedString(permanentResident)).append("\n");
    sb.append("    extra: ").append(toIndentedString(extra)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("given_name");
    openapiFields.add("family_name");
    openapiFields.add("middle_name");
    openapiFields.add("date_of_birth");
    openapiFields.add("tax_id");
    openapiFields.add("tax_id_type");
    openapiFields.add("country_of_citizenship");
    openapiFields.add("country_of_birth");
    openapiFields.add("country_of_tax_residence");
    openapiFields.add("funding_source");
    openapiFields.add("liquidity_needs");
    openapiFields.add("investment_experience_with_stocks");
    openapiFields.add("investment_experience_with_options");
    openapiFields.add("risk_tolerance");
    openapiFields.add("investment_objective");
    openapiFields.add("investment_time_horizon");
    openapiFields.add("annual_income_min");
    openapiFields.add("annual_income_max");
    openapiFields.add("liquid_net_worth_min");
    openapiFields.add("liquid_net_worth_max");
    openapiFields.add("total_net_worth_min");
    openapiFields.add("total_net_worth_max");
    openapiFields.add("visa_type");
    openapiFields.add("visa_expiration_date");
    openapiFields.add("date_of_departure_from_usa");
    openapiFields.add("permanent_resident");
    openapiFields.add("extra");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("given_name");
    openapiRequiredFields.add("family_name");
    openapiRequiredFields.add("date_of_birth");
    openapiRequiredFields.add("tax_id_type");
    openapiRequiredFields.add("country_of_tax_residence");
    openapiRequiredFields.add("funding_source");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Identity.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Identity is not found in the empty JSON string", Identity.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Identity.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Identity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Identity.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("given_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `given_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("given_name").toString()));
      }
      if (!jsonObj.get("family_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `family_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("family_name").toString()));
      }
      if ((jsonObj.get("middle_name") != null && !jsonObj.get("middle_name").isJsonNull()) && !jsonObj.get("middle_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `middle_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("middle_name").toString()));
      }
      if ((jsonObj.get("tax_id") != null && !jsonObj.get("tax_id").isJsonNull()) && !jsonObj.get("tax_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `tax_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("tax_id").toString()));
      }
      // validate the required field `tax_id_type`
      TaxIdType.validateJsonElement(jsonObj.get("tax_id_type"));
      if ((jsonObj.get("country_of_citizenship") != null && !jsonObj.get("country_of_citizenship").isJsonNull()) && !jsonObj.get("country_of_citizenship").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country_of_citizenship` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country_of_citizenship").toString()));
      }
      if ((jsonObj.get("country_of_birth") != null && !jsonObj.get("country_of_birth").isJsonNull()) && !jsonObj.get("country_of_birth").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country_of_birth` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country_of_birth").toString()));
      }
      if (!jsonObj.get("country_of_tax_residence").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country_of_tax_residence` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country_of_tax_residence").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("funding_source") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("funding_source").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `funding_source` to be an array in the JSON string but got `%s`", jsonObj.get("funding_source").toString()));
      }
      if ((jsonObj.get("liquidity_needs") != null && !jsonObj.get("liquidity_needs").isJsonNull()) && !jsonObj.get("liquidity_needs").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `liquidity_needs` to be a primitive type in the JSON string but got `%s`", jsonObj.get("liquidity_needs").toString()));
      }
      // validate the optional field `liquidity_needs`
      if (jsonObj.get("liquidity_needs") != null && !jsonObj.get("liquidity_needs").isJsonNull()) {
        LiquidityNeedsEnum.validateJsonElement(jsonObj.get("liquidity_needs"));
      }
      if ((jsonObj.get("investment_experience_with_stocks") != null && !jsonObj.get("investment_experience_with_stocks").isJsonNull()) && !jsonObj.get("investment_experience_with_stocks").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `investment_experience_with_stocks` to be a primitive type in the JSON string but got `%s`", jsonObj.get("investment_experience_with_stocks").toString()));
      }
      // validate the optional field `investment_experience_with_stocks`
      if (jsonObj.get("investment_experience_with_stocks") != null && !jsonObj.get("investment_experience_with_stocks").isJsonNull()) {
        InvestmentExperienceWithStocksEnum.validateJsonElement(jsonObj.get("investment_experience_with_stocks"));
      }
      if ((jsonObj.get("investment_experience_with_options") != null && !jsonObj.get("investment_experience_with_options").isJsonNull()) && !jsonObj.get("investment_experience_with_options").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `investment_experience_with_options` to be a primitive type in the JSON string but got `%s`", jsonObj.get("investment_experience_with_options").toString()));
      }
      // validate the optional field `investment_experience_with_options`
      if (jsonObj.get("investment_experience_with_options") != null && !jsonObj.get("investment_experience_with_options").isJsonNull()) {
        InvestmentExperienceWithOptionsEnum.validateJsonElement(jsonObj.get("investment_experience_with_options"));
      }
      if ((jsonObj.get("risk_tolerance") != null && !jsonObj.get("risk_tolerance").isJsonNull()) && !jsonObj.get("risk_tolerance").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `risk_tolerance` to be a primitive type in the JSON string but got `%s`", jsonObj.get("risk_tolerance").toString()));
      }
      // validate the optional field `risk_tolerance`
      if (jsonObj.get("risk_tolerance") != null && !jsonObj.get("risk_tolerance").isJsonNull()) {
        RiskToleranceEnum.validateJsonElement(jsonObj.get("risk_tolerance"));
      }
      if ((jsonObj.get("investment_objective") != null && !jsonObj.get("investment_objective").isJsonNull()) && !jsonObj.get("investment_objective").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `investment_objective` to be a primitive type in the JSON string but got `%s`", jsonObj.get("investment_objective").toString()));
      }
      // validate the optional field `investment_objective`
      if (jsonObj.get("investment_objective") != null && !jsonObj.get("investment_objective").isJsonNull()) {
        InvestmentObjectiveEnum.validateJsonElement(jsonObj.get("investment_objective"));
      }
      if ((jsonObj.get("investment_time_horizon") != null && !jsonObj.get("investment_time_horizon").isJsonNull()) && !jsonObj.get("investment_time_horizon").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `investment_time_horizon` to be a primitive type in the JSON string but got `%s`", jsonObj.get("investment_time_horizon").toString()));
      }
      // validate the optional field `investment_time_horizon`
      if (jsonObj.get("investment_time_horizon") != null && !jsonObj.get("investment_time_horizon").isJsonNull()) {
        InvestmentTimeHorizonEnum.validateJsonElement(jsonObj.get("investment_time_horizon"));
      }
      if ((jsonObj.get("visa_type") != null && !jsonObj.get("visa_type").isJsonNull()) && !jsonObj.get("visa_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `visa_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("visa_type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Identity.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Identity' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Identity> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Identity.class));

       return (TypeAdapter<T>) new TypeAdapter<Identity>() {
           @Override
           public void write(JsonWriter out, Identity value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Identity read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Identity given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Identity
  * @throws IOException if the JSON string is invalid with respect to Identity
  */
  public static Identity fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Identity.class);
  }

 /**
  * Convert an instance of Identity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

