/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.Transaction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * GetV1TransfersJitLedgerIdBalances200Response
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class GetV1TransfersJitLedgerIdBalances200Response {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_LEDGER_NO = "ledger_no";
  @SerializedName(SERIALIZED_NAME_LEDGER_NO)
  private String ledgerNo;

  public static final String SERIALIZED_NAME_LEDGER_NAME = "ledger_name";
  @SerializedName(SERIALIZED_NAME_LEDGER_NAME)
  private String ledgerName;

  public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
  @SerializedName(SERIALIZED_NAME_TRANSACTIONS)
  private List<Transaction> transactions;

  public static final String SERIALIZED_NAME_STARTING_BALANCE = "starting_balance";
  @SerializedName(SERIALIZED_NAME_STARTING_BALANCE)
  private BigDecimal startingBalance;

  public static final String SERIALIZED_NAME_ENDING_BALANCE = "ending_balance";
  @SerializedName(SERIALIZED_NAME_ENDING_BALANCE)
  private BigDecimal endingBalance;

  public static final String SERIALIZED_NAME_ACTIVITY_AMOUNT = "activity_amount";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_AMOUNT)
  private BigDecimal activityAmount;

  public GetV1TransfersJitLedgerIdBalances200Response() {
  }

  public GetV1TransfersJitLedgerIdBalances200Response id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The ledger ID
   * @return id
  **/
  @javax.annotation.Nullable
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public GetV1TransfersJitLedgerIdBalances200Response ledgerNo(String ledgerNo) {
    this.ledgerNo = ledgerNo;
    return this;
  }

   /**
   * The ledger account number
   * @return ledgerNo
  **/
  @javax.annotation.Nullable
  public String getLedgerNo() {
    return ledgerNo;
  }

  public void setLedgerNo(String ledgerNo) {
    this.ledgerNo = ledgerNo;
  }


  public GetV1TransfersJitLedgerIdBalances200Response ledgerName(String ledgerName) {
    this.ledgerName = ledgerName;
    return this;
  }

   /**
   * The ledger name
   * @return ledgerName
  **/
  @javax.annotation.Nullable
  public String getLedgerName() {
    return ledgerName;
  }

  public void setLedgerName(String ledgerName) {
    this.ledgerName = ledgerName;
  }


  public GetV1TransfersJitLedgerIdBalances200Response transactions(List<Transaction> transactions) {
    this.transactions = transactions;
    return this;
  }

  public GetV1TransfersJitLedgerIdBalances200Response addTransactionsItem(Transaction transactionsItem) {
    if (this.transactions == null) {
      this.transactions = new ArrayList<>();
    }
    this.transactions.add(transactionsItem);
    return this;
  }

   /**
   * Get transactions
   * @return transactions
  **/
  @javax.annotation.Nullable
  public List<Transaction> getTransactions() {
    return transactions;
  }

  public void setTransactions(List<Transaction> transactions) {
    this.transactions = transactions;
  }


  public GetV1TransfersJitLedgerIdBalances200Response startingBalance(BigDecimal startingBalance) {
    this.startingBalance = startingBalance;
    return this;
  }

   /**
   * Ledger balance at the beginning of the date range
   * @return startingBalance
  **/
  @javax.annotation.Nullable
  public BigDecimal getStartingBalance() {
    return startingBalance;
  }

  public void setStartingBalance(BigDecimal startingBalance) {
    this.startingBalance = startingBalance;
  }


  public GetV1TransfersJitLedgerIdBalances200Response endingBalance(BigDecimal endingBalance) {
    this.endingBalance = endingBalance;
    return this;
  }

   /**
   * Ledger balance at the end of the date range
   * @return endingBalance
  **/
  @javax.annotation.Nullable
  public BigDecimal getEndingBalance() {
    return endingBalance;
  }

  public void setEndingBalance(BigDecimal endingBalance) {
    this.endingBalance = endingBalance;
  }


  public GetV1TransfersJitLedgerIdBalances200Response activityAmount(BigDecimal activityAmount) {
    this.activityAmount = activityAmount;
    return this;
  }

   /**
   * The number of transactions related to the ledger during the specified date range 
   * @return activityAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getActivityAmount() {
    return activityAmount;
  }

  public void setActivityAmount(BigDecimal activityAmount) {
    this.activityAmount = activityAmount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetV1TransfersJitLedgerIdBalances200Response getV1TransfersJitLedgerIdBalances200Response = (GetV1TransfersJitLedgerIdBalances200Response) o;
    return Objects.equals(this.id, getV1TransfersJitLedgerIdBalances200Response.id) &&
        Objects.equals(this.ledgerNo, getV1TransfersJitLedgerIdBalances200Response.ledgerNo) &&
        Objects.equals(this.ledgerName, getV1TransfersJitLedgerIdBalances200Response.ledgerName) &&
        Objects.equals(this.transactions, getV1TransfersJitLedgerIdBalances200Response.transactions) &&
        Objects.equals(this.startingBalance, getV1TransfersJitLedgerIdBalances200Response.startingBalance) &&
        Objects.equals(this.endingBalance, getV1TransfersJitLedgerIdBalances200Response.endingBalance) &&
        Objects.equals(this.activityAmount, getV1TransfersJitLedgerIdBalances200Response.activityAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, ledgerNo, ledgerName, transactions, startingBalance, endingBalance, activityAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetV1TransfersJitLedgerIdBalances200Response {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    ledgerNo: ").append(toIndentedString(ledgerNo)).append("\n");
    sb.append("    ledgerName: ").append(toIndentedString(ledgerName)).append("\n");
    sb.append("    transactions: ").append(toIndentedString(transactions)).append("\n");
    sb.append("    startingBalance: ").append(toIndentedString(startingBalance)).append("\n");
    sb.append("    endingBalance: ").append(toIndentedString(endingBalance)).append("\n");
    sb.append("    activityAmount: ").append(toIndentedString(activityAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("ledger_no");
    openapiFields.add("ledger_name");
    openapiFields.add("transactions");
    openapiFields.add("starting_balance");
    openapiFields.add("ending_balance");
    openapiFields.add("activity_amount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!GetV1TransfersJitLedgerIdBalances200Response.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in GetV1TransfersJitLedgerIdBalances200Response is not found in the empty JSON string", GetV1TransfersJitLedgerIdBalances200Response.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!GetV1TransfersJitLedgerIdBalances200Response.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetV1TransfersJitLedgerIdBalances200Response` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("ledger_no") != null && !jsonObj.get("ledger_no").isJsonNull()) && !jsonObj.get("ledger_no").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ledger_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ledger_no").toString()));
      }
      if ((jsonObj.get("ledger_name") != null && !jsonObj.get("ledger_name").isJsonNull()) && !jsonObj.get("ledger_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ledger_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ledger_name").toString()));
      }
      if (jsonObj.get("transactions") != null && !jsonObj.get("transactions").isJsonNull()) {
        JsonArray jsonArraytransactions = jsonObj.getAsJsonArray("transactions");
        if (jsonArraytransactions != null) {
          // ensure the json data is an array
          if (!jsonObj.get("transactions").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `transactions` to be an array in the JSON string but got `%s`", jsonObj.get("transactions").toString()));
          }

          // validate the optional field `transactions` (array)
          for (int i = 0; i < jsonArraytransactions.size(); i++) {
            Transaction.validateJsonElement(jsonArraytransactions.get(i));
          };
        }
      }
      if ((jsonObj.get("starting_balance") != null && !jsonObj.get("starting_balance").isJsonNull()) && !jsonObj.get("starting_balance").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `starting_balance` to be a primitive type in the JSON string but got `%s`", jsonObj.get("starting_balance").toString()));
      }
      if ((jsonObj.get("ending_balance") != null && !jsonObj.get("ending_balance").isJsonNull()) && !jsonObj.get("ending_balance").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ending_balance` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ending_balance").toString()));
      }
      if ((jsonObj.get("activity_amount") != null && !jsonObj.get("activity_amount").isJsonNull()) && !jsonObj.get("activity_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `activity_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("activity_amount").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GetV1TransfersJitLedgerIdBalances200Response.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GetV1TransfersJitLedgerIdBalances200Response' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GetV1TransfersJitLedgerIdBalances200Response> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GetV1TransfersJitLedgerIdBalances200Response.class));

       return (TypeAdapter<T>) new TypeAdapter<GetV1TransfersJitLedgerIdBalances200Response>() {
           @Override
           public void write(JsonWriter out, GetV1TransfersJitLedgerIdBalances200Response value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GetV1TransfersJitLedgerIdBalances200Response read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GetV1TransfersJitLedgerIdBalances200Response given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GetV1TransfersJitLedgerIdBalances200Response
  * @throws IOException if the JSON string is invalid with respect to GetV1TransfersJitLedgerIdBalances200Response
  */
  public static GetV1TransfersJitLedgerIdBalances200Response fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GetV1TransfersJitLedgerIdBalances200Response.class);
  }

 /**
  * Convert an instance of GetV1TransfersJitLedgerIdBalances200Response to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

