/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderType;
import net.jacobpeterson.alpaca.openapi.broker.model.TimeInForce;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * GetV1TradingAccountsAccountIdOrdersEstimationRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class GetV1TradingAccountsAccountIdOrdersEstimationRequest {
  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private OrderSide side;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private OrderType type;

  public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
  @SerializedName(SERIALIZED_NAME_TIME_IN_FORCE)
  private TimeInForce timeInForce;

  public static final String SERIALIZED_NAME_NOTIONAL = "notional";
  @SerializedName(SERIALIZED_NAME_NOTIONAL)
  private String notional;

  public static final String SERIALIZED_NAME_SWAP_FEE_BPS = "swap_fee_bps";
  @SerializedName(SERIALIZED_NAME_SWAP_FEE_BPS)
  private Integer swapFeeBps;

  public GetV1TradingAccountsAccountIdOrdersEstimationRequest() {
  }

  public GetV1TradingAccountsAccountIdOrdersEstimationRequest symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Get symbol
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public GetV1TradingAccountsAccountIdOrdersEstimationRequest side(OrderSide side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nullable
  public OrderSide getSide() {
    return side;
  }

  public void setSide(OrderSide side) {
    this.side = side;
  }


  public GetV1TradingAccountsAccountIdOrdersEstimationRequest type(OrderType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  public OrderType getType() {
    return type;
  }

  public void setType(OrderType type) {
    this.type = type;
  }


  public GetV1TradingAccountsAccountIdOrdersEstimationRequest timeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
    return this;
  }

   /**
   * Get timeInForce
   * @return timeInForce
  **/
  @javax.annotation.Nullable
  public TimeInForce getTimeInForce() {
    return timeInForce;
  }

  public void setTimeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
  }


  public GetV1TradingAccountsAccountIdOrdersEstimationRequest notional(String notional) {
    this.notional = notional;
    return this;
  }

   /**
   * Get notional
   * @return notional
  **/
  @javax.annotation.Nullable
  public String getNotional() {
    return notional;
  }

  public void setNotional(String notional) {
    this.notional = notional;
  }


  public GetV1TradingAccountsAccountIdOrdersEstimationRequest swapFeeBps(Integer swapFeeBps) {
    this.swapFeeBps = swapFeeBps;
    return this;
  }

   /**
   * Get swapFeeBps
   * @return swapFeeBps
  **/
  @javax.annotation.Nullable
  public Integer getSwapFeeBps() {
    return swapFeeBps;
  }

  public void setSwapFeeBps(Integer swapFeeBps) {
    this.swapFeeBps = swapFeeBps;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest = (GetV1TradingAccountsAccountIdOrdersEstimationRequest) o;
    return Objects.equals(this.symbol, getV1TradingAccountsAccountIdOrdersEstimationRequest.symbol) &&
        Objects.equals(this.side, getV1TradingAccountsAccountIdOrdersEstimationRequest.side) &&
        Objects.equals(this.type, getV1TradingAccountsAccountIdOrdersEstimationRequest.type) &&
        Objects.equals(this.timeInForce, getV1TradingAccountsAccountIdOrdersEstimationRequest.timeInForce) &&
        Objects.equals(this.notional, getV1TradingAccountsAccountIdOrdersEstimationRequest.notional) &&
        Objects.equals(this.swapFeeBps, getV1TradingAccountsAccountIdOrdersEstimationRequest.swapFeeBps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, side, type, timeInForce, notional, swapFeeBps);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetV1TradingAccountsAccountIdOrdersEstimationRequest {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    timeInForce: ").append(toIndentedString(timeInForce)).append("\n");
    sb.append("    notional: ").append(toIndentedString(notional)).append("\n");
    sb.append("    swapFeeBps: ").append(toIndentedString(swapFeeBps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("symbol");
    openapiFields.add("side");
    openapiFields.add("type");
    openapiFields.add("time_in_force");
    openapiFields.add("notional");
    openapiFields.add("swap_fee_bps");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!GetV1TradingAccountsAccountIdOrdersEstimationRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in GetV1TradingAccountsAccountIdOrdersEstimationRequest is not found in the empty JSON string", GetV1TradingAccountsAccountIdOrdersEstimationRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!GetV1TradingAccountsAccountIdOrdersEstimationRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetV1TradingAccountsAccountIdOrdersEstimationRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      // validate the optional field `side`
      if (jsonObj.get("side") != null && !jsonObj.get("side").isJsonNull()) {
        OrderSide.validateJsonElement(jsonObj.get("side"));
      }
      // validate the optional field `type`
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) {
        OrderType.validateJsonElement(jsonObj.get("type"));
      }
      // validate the optional field `time_in_force`
      if (jsonObj.get("time_in_force") != null && !jsonObj.get("time_in_force").isJsonNull()) {
        TimeInForce.validateJsonElement(jsonObj.get("time_in_force"));
      }
      if ((jsonObj.get("notional") != null && !jsonObj.get("notional").isJsonNull()) && !jsonObj.get("notional").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `notional` to be a primitive type in the JSON string but got `%s`", jsonObj.get("notional").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GetV1TradingAccountsAccountIdOrdersEstimationRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GetV1TradingAccountsAccountIdOrdersEstimationRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GetV1TradingAccountsAccountIdOrdersEstimationRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GetV1TradingAccountsAccountIdOrdersEstimationRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<GetV1TradingAccountsAccountIdOrdersEstimationRequest>() {
           @Override
           public void write(JsonWriter out, GetV1TradingAccountsAccountIdOrdersEstimationRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GetV1TradingAccountsAccountIdOrdersEstimationRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GetV1TradingAccountsAccountIdOrdersEstimationRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GetV1TradingAccountsAccountIdOrdersEstimationRequest
  * @throws IOException if the JSON string is invalid with respect to GetV1TradingAccountsAccountIdOrdersEstimationRequest
  */
  public static GetV1TradingAccountsAccountIdOrdersEstimationRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GetV1TradingAccountsAccountIdOrdersEstimationRequest.class);
  }

 /**
  * Convert an instance of GetV1TradingAccountsAccountIdOrdersEstimationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

