/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.UUID;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * GetV1ReportingEodPositionsRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class GetV1ReportingEodPositionsRequest {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private UUID accountId;

  public static final String SERIALIZED_NAME_ASSET = "asset";
  @SerializedName(SERIALIZED_NAME_ASSET)
  private String asset;

  public static final String SERIALIZED_NAME_ASOF = "asof";
  @SerializedName(SERIALIZED_NAME_ASOF)
  private LocalDate asof;

  public static final String SERIALIZED_NAME_PAGE = "page";
  @SerializedName(SERIALIZED_NAME_PAGE)
  private Integer page;

  public static final String SERIALIZED_NAME_LIMIT = "limit";
  @SerializedName(SERIALIZED_NAME_LIMIT)
  private Integer limit;

  public GetV1ReportingEodPositionsRequest() {
  }

  public GetV1ReportingEodPositionsRequest accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Filter the results by account_id (optional).
   * @return accountId
  **/
  @javax.annotation.Nullable
  public UUID getAccountId() {
    return accountId;
  }

  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }


  public GetV1ReportingEodPositionsRequest asset(String asset) {
    this.asset = asset;
    return this;
  }

   /**
   * Filter the results by asset ID or symbol (optional).
   * @return asset
  **/
  @javax.annotation.Nullable
  public String getAsset() {
    return asset;
  }

  public void setAsset(String asset) {
    this.asset = asset;
  }


  public GetV1ReportingEodPositionsRequest asof(LocalDate asof) {
    this.asof = asof;
    return this;
  }

   /**
   * The positions date in &#39;YYYY-MM-DD&#39; format. It&#39;s recommended to provide this parameter when the &#39;page&#39; parameter is specified, to ensure precise data retrieval based on the desired date.
   * @return asof
  **/
  @javax.annotation.Nullable
  public LocalDate getAsof() {
    return asof;
  }

  public void setAsof(LocalDate asof) {
    this.asof = asof;
  }


  public GetV1ReportingEodPositionsRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * The page number (default&#x3D;1). This parameter is used for pagination.
   * @return page
  **/
  @javax.annotation.Nullable
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }


  public GetV1ReportingEodPositionsRequest limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * The number of accounts to display per page (default&#x3D;1000, max&#x3D;10000).
   * @return limit
  **/
  @javax.annotation.Nullable
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetV1ReportingEodPositionsRequest getV1ReportingEodPositionsRequest = (GetV1ReportingEodPositionsRequest) o;
    return Objects.equals(this.accountId, getV1ReportingEodPositionsRequest.accountId) &&
        Objects.equals(this.asset, getV1ReportingEodPositionsRequest.asset) &&
        Objects.equals(this.asof, getV1ReportingEodPositionsRequest.asof) &&
        Objects.equals(this.page, getV1ReportingEodPositionsRequest.page) &&
        Objects.equals(this.limit, getV1ReportingEodPositionsRequest.limit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, asset, asof, page, limit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetV1ReportingEodPositionsRequest {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    asset: ").append(toIndentedString(asset)).append("\n");
    sb.append("    asof: ").append(toIndentedString(asof)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_id");
    openapiFields.add("asset");
    openapiFields.add("asof");
    openapiFields.add("page");
    openapiFields.add("limit");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!GetV1ReportingEodPositionsRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in GetV1ReportingEodPositionsRequest is not found in the empty JSON string", GetV1ReportingEodPositionsRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!GetV1ReportingEodPositionsRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetV1ReportingEodPositionsRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("account_id") != null && !jsonObj.get("account_id").isJsonNull()) && !jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      if ((jsonObj.get("asset") != null && !jsonObj.get("asset").isJsonNull()) && !jsonObj.get("asset").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `asset` to be a primitive type in the JSON string but got `%s`", jsonObj.get("asset").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GetV1ReportingEodPositionsRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GetV1ReportingEodPositionsRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GetV1ReportingEodPositionsRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GetV1ReportingEodPositionsRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<GetV1ReportingEodPositionsRequest>() {
           @Override
           public void write(JsonWriter out, GetV1ReportingEodPositionsRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GetV1ReportingEodPositionsRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GetV1ReportingEodPositionsRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GetV1ReportingEodPositionsRequest
  * @throws IOException if the JSON string is invalid with respect to GetV1ReportingEodPositionsRequest
  */
  public static GetV1ReportingEodPositionsRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GetV1ReportingEodPositionsRequest.class);
  }

 /**
  * Convert an instance of GetV1ReportingEodPositionsRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

