/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jacobpeterson.alpaca.openapi.broker.model.Position;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * GetV1ReportingEodPositions200Response
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class GetV1ReportingEodPositions200Response {
  public static final String SERIALIZED_NAME_ASOF = "asof";
  @SerializedName(SERIALIZED_NAME_ASOF)
  private LocalDate asof;

  public static final String SERIALIZED_NAME_POSITIONS = "positions";
  @SerializedName(SERIALIZED_NAME_POSITIONS)
  private Map<String, List<Position>> positions = new HashMap<>();

  public static final String SERIALIZED_NAME_PAGE = "page";
  @SerializedName(SERIALIZED_NAME_PAGE)
  private Integer page;

  public static final String SERIALIZED_NAME_LIMIT = "limit";
  @SerializedName(SERIALIZED_NAME_LIMIT)
  private Integer limit;

  public GetV1ReportingEodPositions200Response() {
  }

  public GetV1ReportingEodPositions200Response asof(LocalDate asof) {
    this.asof = asof;
    return this;
  }

   /**
   * The date of the snapshot in the &#39;YYYY-MM-DD&#39; format.
   * @return asof
  **/
  @javax.annotation.Nullable
  public LocalDate getAsof() {
    return asof;
  }

  public void setAsof(LocalDate asof) {
    this.asof = asof;
  }


  public GetV1ReportingEodPositions200Response positions(Map<String, List<Position>> positions) {
    this.positions = positions;
    return this;
  }

  public GetV1ReportingEodPositions200Response putPositionsItem(String key, List<Position> positionsItem) {
    if (this.positions == null) {
      this.positions = new HashMap<>();
    }
    this.positions.put(key, positionsItem);
    return this;
  }

   /**
   * A detailed map of account IDs to their respective positions.
   * @return positions
  **/
  @javax.annotation.Nullable
  public Map<String, List<Position>> getPositions() {
    return positions;
  }

  public void setPositions(Map<String, List<Position>> positions) {
    this.positions = positions;
  }


  public GetV1ReportingEodPositions200Response page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * The current page number.
   * @return page
  **/
  @javax.annotation.Nullable
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }


  public GetV1ReportingEodPositions200Response limit(Integer limit) {
    this.limit = limit;
    return this;
  }

   /**
   * The number of accounts per page.
   * @return limit
  **/
  @javax.annotation.Nullable
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetV1ReportingEodPositions200Response getV1ReportingEodPositions200Response = (GetV1ReportingEodPositions200Response) o;
    return Objects.equals(this.asof, getV1ReportingEodPositions200Response.asof) &&
        Objects.equals(this.positions, getV1ReportingEodPositions200Response.positions) &&
        Objects.equals(this.page, getV1ReportingEodPositions200Response.page) &&
        Objects.equals(this.limit, getV1ReportingEodPositions200Response.limit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(asof, positions, page, limit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetV1ReportingEodPositions200Response {\n");
    sb.append("    asof: ").append(toIndentedString(asof)).append("\n");
    sb.append("    positions: ").append(toIndentedString(positions)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("asof");
    openapiFields.add("positions");
    openapiFields.add("page");
    openapiFields.add("limit");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!GetV1ReportingEodPositions200Response.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in GetV1ReportingEodPositions200Response is not found in the empty JSON string", GetV1ReportingEodPositions200Response.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!GetV1ReportingEodPositions200Response.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetV1ReportingEodPositions200Response` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GetV1ReportingEodPositions200Response.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GetV1ReportingEodPositions200Response' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GetV1ReportingEodPositions200Response> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GetV1ReportingEodPositions200Response.class));

       return (TypeAdapter<T>) new TypeAdapter<GetV1ReportingEodPositions200Response>() {
           @Override
           public void write(JsonWriter out, GetV1ReportingEodPositions200Response value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GetV1ReportingEodPositions200Response read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GetV1ReportingEodPositions200Response given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GetV1ReportingEodPositions200Response
  * @throws IOException if the JSON string is invalid with respect to GetV1ReportingEodPositions200Response
  */
  public static GetV1ReportingEodPositions200Response fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GetV1ReportingEodPositions200Response.class);
  }

 /**
  * Convert an instance of GetV1ReportingEodPositions200Response to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

