/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingDetailPaymentType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * FundingWalletRecipientBank
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class FundingWalletRecipientBank {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
  @SerializedName(SERIALIZED_NAME_FIRST_NAME)
  private String firstName;

  public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
  @SerializedName(SERIALIZED_NAME_LAST_NAME)
  private String lastName;

  public static final String SERIALIZED_NAME_COMPANY_NAME = "company_name";
  @SerializedName(SERIALIZED_NAME_COMPANY_NAME)
  private String companyName;

  public static final String SERIALIZED_NAME_PAYMENT_TYPES = "payment_types";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPES)
  private List<FundingDetailPaymentType> paymentTypes;

  public static final String SERIALIZED_NAME_STREET_ADDRESS = "street_address";
  @SerializedName(SERIALIZED_NAME_STREET_ADDRESS)
  private String streetAddress;

  public static final String SERIALIZED_NAME_COUNTRY = "country";
  @SerializedName(SERIALIZED_NAME_COUNTRY)
  private String country;

  public static final String SERIALIZED_NAME_CITY = "city";
  @SerializedName(SERIALIZED_NAME_CITY)
  private String city;

  public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
  @SerializedName(SERIALIZED_NAME_POSTAL_CODE)
  private String postalCode;

  public static final String SERIALIZED_NAME_STATE_OR_PROVINCE = "state_or_province";
  @SerializedName(SERIALIZED_NAME_STATE_OR_PROVINCE)
  private String stateOrProvince;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_ROUTING_CODE_TYPE = "routing_code_type";
  @SerializedName(SERIALIZED_NAME_ROUTING_CODE_TYPE)
  private String routingCodeType;

  public static final String SERIALIZED_NAME_ROUTING_CODE = "routing_code";
  @SerializedName(SERIALIZED_NAME_ROUTING_CODE)
  private String routingCode;

  public static final String SERIALIZED_NAME_BIC_SWIFT = "bic_swift";
  @SerializedName(SERIALIZED_NAME_BIC_SWIFT)
  private String bicSwift;

  public static final String SERIALIZED_NAME_IBAN = "iban";
  @SerializedName(SERIALIZED_NAME_IBAN)
  private String iban;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public FundingWalletRecipientBank() {
  }

  public FundingWalletRecipientBank id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nullable
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public FundingWalletRecipientBank firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @javax.annotation.Nullable
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public FundingWalletRecipientBank lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @javax.annotation.Nullable
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public FundingWalletRecipientBank companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * Get companyName
   * @return companyName
  **/
  @javax.annotation.Nullable
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }


  public FundingWalletRecipientBank paymentTypes(List<FundingDetailPaymentType> paymentTypes) {
    this.paymentTypes = paymentTypes;
    return this;
  }

  public FundingWalletRecipientBank addPaymentTypesItem(FundingDetailPaymentType paymentTypesItem) {
    if (this.paymentTypes == null) {
      this.paymentTypes = new ArrayList<>();
    }
    this.paymentTypes.add(paymentTypesItem);
    return this;
  }

   /**
   * Get paymentTypes
   * @return paymentTypes
  **/
  @javax.annotation.Nullable
  public List<FundingDetailPaymentType> getPaymentTypes() {
    return paymentTypes;
  }

  public void setPaymentTypes(List<FundingDetailPaymentType> paymentTypes) {
    this.paymentTypes = paymentTypes;
  }


  public FundingWalletRecipientBank streetAddress(String streetAddress) {
    this.streetAddress = streetAddress;
    return this;
  }

   /**
   * Get streetAddress
   * @return streetAddress
  **/
  @javax.annotation.Nullable
  public String getStreetAddress() {
    return streetAddress;
  }

  public void setStreetAddress(String streetAddress) {
    this.streetAddress = streetAddress;
  }


  public FundingWalletRecipientBank country(String country) {
    this.country = country;
    return this;
  }

   /**
   * Two-letter ISO country code.
   * @return country
  **/
  @javax.annotation.Nullable
  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }


  public FundingWalletRecipientBank city(String city) {
    this.city = city;
    return this;
  }

   /**
   * City
   * @return city
  **/
  @javax.annotation.Nullable
  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }


  public FundingWalletRecipientBank postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal code
   * @return postalCode
  **/
  @javax.annotation.Nullable
  public String getPostalCode() {
    return postalCode;
  }

  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public FundingWalletRecipientBank stateOrProvince(String stateOrProvince) {
    this.stateOrProvince = stateOrProvince;
    return this;
  }

   /**
   * State or province.
   * @return stateOrProvince
  **/
  @javax.annotation.Nullable
  public String getStateOrProvince() {
    return stateOrProvince;
  }

  public void setStateOrProvince(String stateOrProvince) {
    this.stateOrProvince = stateOrProvince;
  }


  public FundingWalletRecipientBank currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Currency in which money is held in the beneficiary&#39;s bank account. Three-digit currency code.
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public FundingWalletRecipientBank accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * Bank account number.
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public FundingWalletRecipientBank routingCodeType(String routingCodeType) {
    this.routingCodeType = routingCodeType;
    return this;
  }

   /**
   * Local payment routing system.
   * @return routingCodeType
  **/
  @javax.annotation.Nullable
  public String getRoutingCodeType() {
    return routingCodeType;
  }

  public void setRoutingCodeType(String routingCodeType) {
    this.routingCodeType = routingCodeType;
  }


  public FundingWalletRecipientBank routingCode(String routingCode) {
    this.routingCode = routingCode;
    return this;
  }

   /**
   * Value for \&quot;routing_code_type\&quot;.
   * @return routingCode
  **/
  @javax.annotation.Nullable
  public String getRoutingCode() {
    return routingCode;
  }

  public void setRoutingCode(String routingCode) {
    this.routingCode = routingCode;
  }


  public FundingWalletRecipientBank bicSwift(String bicSwift) {
    this.bicSwift = bicSwift;
    return this;
  }

   /**
   * BIC/SWIFT code
   * @return bicSwift
  **/
  @javax.annotation.Nullable
  public String getBicSwift() {
    return bicSwift;
  }

  public void setBicSwift(String bicSwift) {
    this.bicSwift = bicSwift;
  }


  public FundingWalletRecipientBank iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * IBAN code
   * @return iban
  **/
  @javax.annotation.Nullable
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }


  public FundingWalletRecipientBank createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Date the beneficiary record was created.
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public FundingWalletRecipientBank updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Date the beneficiary record was last updated.
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FundingWalletRecipientBank fundingWalletRecipientBank = (FundingWalletRecipientBank) o;
    return Objects.equals(this.id, fundingWalletRecipientBank.id) &&
        Objects.equals(this.firstName, fundingWalletRecipientBank.firstName) &&
        Objects.equals(this.lastName, fundingWalletRecipientBank.lastName) &&
        Objects.equals(this.companyName, fundingWalletRecipientBank.companyName) &&
        Objects.equals(this.paymentTypes, fundingWalletRecipientBank.paymentTypes) &&
        Objects.equals(this.streetAddress, fundingWalletRecipientBank.streetAddress) &&
        Objects.equals(this.country, fundingWalletRecipientBank.country) &&
        Objects.equals(this.city, fundingWalletRecipientBank.city) &&
        Objects.equals(this.postalCode, fundingWalletRecipientBank.postalCode) &&
        Objects.equals(this.stateOrProvince, fundingWalletRecipientBank.stateOrProvince) &&
        Objects.equals(this.currency, fundingWalletRecipientBank.currency) &&
        Objects.equals(this.accountNumber, fundingWalletRecipientBank.accountNumber) &&
        Objects.equals(this.routingCodeType, fundingWalletRecipientBank.routingCodeType) &&
        Objects.equals(this.routingCode, fundingWalletRecipientBank.routingCode) &&
        Objects.equals(this.bicSwift, fundingWalletRecipientBank.bicSwift) &&
        Objects.equals(this.iban, fundingWalletRecipientBank.iban) &&
        Objects.equals(this.createdAt, fundingWalletRecipientBank.createdAt) &&
        Objects.equals(this.updatedAt, fundingWalletRecipientBank.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, firstName, lastName, companyName, paymentTypes, streetAddress, country, city, postalCode, stateOrProvince, currency, accountNumber, routingCodeType, routingCode, bicSwift, iban, createdAt, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FundingWalletRecipientBank {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    paymentTypes: ").append(toIndentedString(paymentTypes)).append("\n");
    sb.append("    streetAddress: ").append(toIndentedString(streetAddress)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    stateOrProvince: ").append(toIndentedString(stateOrProvince)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    routingCodeType: ").append(toIndentedString(routingCodeType)).append("\n");
    sb.append("    routingCode: ").append(toIndentedString(routingCode)).append("\n");
    sb.append("    bicSwift: ").append(toIndentedString(bicSwift)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("first_name");
    openapiFields.add("last_name");
    openapiFields.add("company_name");
    openapiFields.add("payment_types");
    openapiFields.add("street_address");
    openapiFields.add("country");
    openapiFields.add("city");
    openapiFields.add("postal_code");
    openapiFields.add("state_or_province");
    openapiFields.add("currency");
    openapiFields.add("account_number");
    openapiFields.add("routing_code_type");
    openapiFields.add("routing_code");
    openapiFields.add("bic_swift");
    openapiFields.add("iban");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!FundingWalletRecipientBank.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in FundingWalletRecipientBank is not found in the empty JSON string", FundingWalletRecipientBank.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!FundingWalletRecipientBank.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FundingWalletRecipientBank` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("first_name") != null && !jsonObj.get("first_name").isJsonNull()) && !jsonObj.get("first_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `first_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("first_name").toString()));
      }
      if ((jsonObj.get("last_name") != null && !jsonObj.get("last_name").isJsonNull()) && !jsonObj.get("last_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_name").toString()));
      }
      if ((jsonObj.get("company_name") != null && !jsonObj.get("company_name").isJsonNull()) && !jsonObj.get("company_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_name").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("payment_types") != null && !jsonObj.get("payment_types").isJsonNull() && !jsonObj.get("payment_types").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `payment_types` to be an array in the JSON string but got `%s`", jsonObj.get("payment_types").toString()));
      }
      if ((jsonObj.get("street_address") != null && !jsonObj.get("street_address").isJsonNull()) && !jsonObj.get("street_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `street_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("street_address").toString()));
      }
      if ((jsonObj.get("country") != null && !jsonObj.get("country").isJsonNull()) && !jsonObj.get("country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country").toString()));
      }
      if ((jsonObj.get("city") != null && !jsonObj.get("city").isJsonNull()) && !jsonObj.get("city").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get("city").toString()));
      }
      if ((jsonObj.get("postal_code") != null && !jsonObj.get("postal_code").isJsonNull()) && !jsonObj.get("postal_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `postal_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("postal_code").toString()));
      }
      if ((jsonObj.get("state_or_province") != null && !jsonObj.get("state_or_province").isJsonNull()) && !jsonObj.get("state_or_province").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `state_or_province` to be a primitive type in the JSON string but got `%s`", jsonObj.get("state_or_province").toString()));
      }
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if ((jsonObj.get("account_number") != null && !jsonObj.get("account_number").isJsonNull()) && !jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      if ((jsonObj.get("routing_code_type") != null && !jsonObj.get("routing_code_type").isJsonNull()) && !jsonObj.get("routing_code_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `routing_code_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("routing_code_type").toString()));
      }
      if ((jsonObj.get("routing_code") != null && !jsonObj.get("routing_code").isJsonNull()) && !jsonObj.get("routing_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `routing_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("routing_code").toString()));
      }
      if ((jsonObj.get("bic_swift") != null && !jsonObj.get("bic_swift").isJsonNull()) && !jsonObj.get("bic_swift").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bic_swift` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bic_swift").toString()));
      }
      if ((jsonObj.get("iban") != null && !jsonObj.get("iban").isJsonNull()) && !jsonObj.get("iban").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `iban` to be a primitive type in the JSON string but got `%s`", jsonObj.get("iban").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FundingWalletRecipientBank.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FundingWalletRecipientBank' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FundingWalletRecipientBank> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FundingWalletRecipientBank.class));

       return (TypeAdapter<T>) new TypeAdapter<FundingWalletRecipientBank>() {
           @Override
           public void write(JsonWriter out, FundingWalletRecipientBank value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FundingWalletRecipientBank read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FundingWalletRecipientBank given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FundingWalletRecipientBank
  * @throws IOException if the JSON string is invalid with respect to FundingWalletRecipientBank
  */
  public static FundingWalletRecipientBank fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FundingWalletRecipientBank.class);
  }

 /**
  * Convert an instance of FundingWalletRecipientBank to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

