/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.BankInformation;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingDetailPaymentType;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingDetailRoutingCodeType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Gets funding details that can be used to settle and collect funds in each available currency. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class FundingDetail {
  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_ACCOUNT_HOLDER_NAME = "account_holder_name";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_HOLDER_NAME)
  private String accountHolderName;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER_TYPE = "account_number_type";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER_TYPE)
  private String accountNumberType;

  public static final String SERIALIZED_NAME_BANK_INFORMATION = "bank_information";
  @SerializedName(SERIALIZED_NAME_BANK_INFORMATION)
  private BankInformation bankInformation;

  public static final String SERIALIZED_NAME_BANK_NAME = "bank_name";
  @SerializedName(SERIALIZED_NAME_BANK_NAME)
  private String bankName;

  public static final String SERIALIZED_NAME_BANK_ADDRESS = "bank_address";
  @SerializedName(SERIALIZED_NAME_BANK_ADDRESS)
  private String bankAddress;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_ROUTING_CODE_TYPE = "routing_code_type";
  @SerializedName(SERIALIZED_NAME_ROUTING_CODE_TYPE)
  private FundingDetailRoutingCodeType routingCodeType;

  public static final String SERIALIZED_NAME_ROUTING_CODE = "routing_code";
  @SerializedName(SERIALIZED_NAME_ROUTING_CODE)
  private String routingCode;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE = "payment_type";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE)
  private FundingDetailPaymentType paymentType;

  public static final String SERIALIZED_NAME_BANK_COUNTRY = "bank_country";
  @SerializedName(SERIALIZED_NAME_BANK_COUNTRY)
  private String bankCountry;

  public FundingDetail() {
  }

  public FundingDetail accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * Get accountNumber
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public FundingDetail accountHolderName(String accountHolderName) {
    this.accountHolderName = accountHolderName;
    return this;
  }

   /**
   * Get accountHolderName
   * @return accountHolderName
  **/
  @javax.annotation.Nullable
  public String getAccountHolderName() {
    return accountHolderName;
  }

  public void setAccountHolderName(String accountHolderName) {
    this.accountHolderName = accountHolderName;
  }


  public FundingDetail accountNumberType(String accountNumberType) {
    this.accountNumberType = accountNumberType;
    return this;
  }

   /**
   * Get accountNumberType
   * @return accountNumberType
  **/
  @javax.annotation.Nullable
  public String getAccountNumberType() {
    return accountNumberType;
  }

  public void setAccountNumberType(String accountNumberType) {
    this.accountNumberType = accountNumberType;
  }


  public FundingDetail bankInformation(BankInformation bankInformation) {
    this.bankInformation = bankInformation;
    return this;
  }

   /**
   * Get bankInformation
   * @return bankInformation
  **/
  @javax.annotation.Nullable
  public BankInformation getBankInformation() {
    return bankInformation;
  }

  public void setBankInformation(BankInformation bankInformation) {
    this.bankInformation = bankInformation;
  }


  public FundingDetail bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

   /**
   * Get bankName
   * @return bankName
  **/
  @javax.annotation.Nullable
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }


  public FundingDetail bankAddress(String bankAddress) {
    this.bankAddress = bankAddress;
    return this;
  }

   /**
   * Get bankAddress
   * @return bankAddress
  **/
  @javax.annotation.Nullable
  public String getBankAddress() {
    return bankAddress;
  }

  public void setBankAddress(String bankAddress) {
    this.bankAddress = bankAddress;
  }


  public FundingDetail currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public FundingDetail routingCodeType(FundingDetailRoutingCodeType routingCodeType) {
    this.routingCodeType = routingCodeType;
    return this;
  }

   /**
   * Get routingCodeType
   * @return routingCodeType
  **/
  @javax.annotation.Nullable
  public FundingDetailRoutingCodeType getRoutingCodeType() {
    return routingCodeType;
  }

  public void setRoutingCodeType(FundingDetailRoutingCodeType routingCodeType) {
    this.routingCodeType = routingCodeType;
  }


  public FundingDetail routingCode(String routingCode) {
    this.routingCode = routingCode;
    return this;
  }

   /**
   * Get routingCode
   * @return routingCode
  **/
  @javax.annotation.Nullable
  public String getRoutingCode() {
    return routingCode;
  }

  public void setRoutingCode(String routingCode) {
    this.routingCode = routingCode;
  }


  public FundingDetail paymentType(FundingDetailPaymentType paymentType) {
    this.paymentType = paymentType;
    return this;
  }

   /**
   * Get paymentType
   * @return paymentType
  **/
  @javax.annotation.Nullable
  public FundingDetailPaymentType getPaymentType() {
    return paymentType;
  }

  public void setPaymentType(FundingDetailPaymentType paymentType) {
    this.paymentType = paymentType;
  }


  public FundingDetail bankCountry(String bankCountry) {
    this.bankCountry = bankCountry;
    return this;
  }

   /**
   * Get bankCountry
   * @return bankCountry
  **/
  @javax.annotation.Nullable
  public String getBankCountry() {
    return bankCountry;
  }

  public void setBankCountry(String bankCountry) {
    this.bankCountry = bankCountry;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FundingDetail fundingDetail = (FundingDetail) o;
    return Objects.equals(this.accountNumber, fundingDetail.accountNumber) &&
        Objects.equals(this.accountHolderName, fundingDetail.accountHolderName) &&
        Objects.equals(this.accountNumberType, fundingDetail.accountNumberType) &&
        Objects.equals(this.bankInformation, fundingDetail.bankInformation) &&
        Objects.equals(this.bankName, fundingDetail.bankName) &&
        Objects.equals(this.bankAddress, fundingDetail.bankAddress) &&
        Objects.equals(this.currency, fundingDetail.currency) &&
        Objects.equals(this.routingCodeType, fundingDetail.routingCodeType) &&
        Objects.equals(this.routingCode, fundingDetail.routingCode) &&
        Objects.equals(this.paymentType, fundingDetail.paymentType) &&
        Objects.equals(this.bankCountry, fundingDetail.bankCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNumber, accountHolderName, accountNumberType, bankInformation, bankName, bankAddress, currency, routingCodeType, routingCode, paymentType, bankCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FundingDetail {\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    accountHolderName: ").append(toIndentedString(accountHolderName)).append("\n");
    sb.append("    accountNumberType: ").append(toIndentedString(accountNumberType)).append("\n");
    sb.append("    bankInformation: ").append(toIndentedString(bankInformation)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankAddress: ").append(toIndentedString(bankAddress)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    routingCodeType: ").append(toIndentedString(routingCodeType)).append("\n");
    sb.append("    routingCode: ").append(toIndentedString(routingCode)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("    bankCountry: ").append(toIndentedString(bankCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_number");
    openapiFields.add("account_holder_name");
    openapiFields.add("account_number_type");
    openapiFields.add("bank_information");
    openapiFields.add("bank_name");
    openapiFields.add("bank_address");
    openapiFields.add("currency");
    openapiFields.add("routing_code_type");
    openapiFields.add("routing_code");
    openapiFields.add("payment_type");
    openapiFields.add("bank_country");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!FundingDetail.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in FundingDetail is not found in the empty JSON string", FundingDetail.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!FundingDetail.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FundingDetail` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("account_number") != null && !jsonObj.get("account_number").isJsonNull()) && !jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      if ((jsonObj.get("account_holder_name") != null && !jsonObj.get("account_holder_name").isJsonNull()) && !jsonObj.get("account_holder_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_holder_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_holder_name").toString()));
      }
      if ((jsonObj.get("account_number_type") != null && !jsonObj.get("account_number_type").isJsonNull()) && !jsonObj.get("account_number_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number_type").toString()));
      }
      // validate the optional field `bank_information`
      if (jsonObj.get("bank_information") != null && !jsonObj.get("bank_information").isJsonNull()) {
        BankInformation.validateJsonElement(jsonObj.get("bank_information"));
      }
      if ((jsonObj.get("bank_name") != null && !jsonObj.get("bank_name").isJsonNull()) && !jsonObj.get("bank_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_name").toString()));
      }
      if ((jsonObj.get("bank_address") != null && !jsonObj.get("bank_address").isJsonNull()) && !jsonObj.get("bank_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_address").toString()));
      }
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      // validate the optional field `routing_code_type`
      if (jsonObj.get("routing_code_type") != null && !jsonObj.get("routing_code_type").isJsonNull()) {
        FundingDetailRoutingCodeType.validateJsonElement(jsonObj.get("routing_code_type"));
      }
      if ((jsonObj.get("routing_code") != null && !jsonObj.get("routing_code").isJsonNull()) && !jsonObj.get("routing_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `routing_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("routing_code").toString()));
      }
      // validate the optional field `payment_type`
      if (jsonObj.get("payment_type") != null && !jsonObj.get("payment_type").isJsonNull()) {
        FundingDetailPaymentType.validateJsonElement(jsonObj.get("payment_type"));
      }
      if ((jsonObj.get("bank_country") != null && !jsonObj.get("bank_country").isJsonNull()) && !jsonObj.get("bank_country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_country").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!FundingDetail.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'FundingDetail' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<FundingDetail> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(FundingDetail.class));

       return (TypeAdapter<T>) new TypeAdapter<FundingDetail>() {
           @Override
           public void write(JsonWriter out, FundingDetail value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public FundingDetail read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of FundingDetail given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of FundingDetail
  * @throws IOException if the JSON string is invalid with respect to FundingDetail
  */
  public static FundingDetail fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, FundingDetail.class);
  }

 /**
  * Convert an instance of FundingDetail to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

