/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentType;
import net.jacobpeterson.alpaca.openapi.broker.model.W8benDocument;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * If an account has to replace documents after the submission, it has to use the Document model instead of DocumentUploadRequest. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class DocumentUploadRequest {
  public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
  @SerializedName(SERIALIZED_NAME_DOCUMENT_TYPE)
  private DocumentType documentType;

  public static final String SERIALIZED_NAME_DOCUMENT_SUB_TYPE = "document_sub_type";
  @SerializedName(SERIALIZED_NAME_DOCUMENT_SUB_TYPE)
  private String documentSubType;

  public static final String SERIALIZED_NAME_CONTENT = "content";
  @SerializedName(SERIALIZED_NAME_CONTENT)
  private String content;

  public static final String SERIALIZED_NAME_CONTENT_DATA = "content_data";
  @SerializedName(SERIALIZED_NAME_CONTENT_DATA)
  private W8benDocument contentData;

  public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
  @SerializedName(SERIALIZED_NAME_MIME_TYPE)
  private String mimeType;

  public DocumentUploadRequest() {
  }

  public DocumentUploadRequest documentType(DocumentType documentType) {
    this.documentType = documentType;
    return this;
  }

   /**
   * Get documentType
   * @return documentType
  **/
  @javax.annotation.Nonnull
  public DocumentType getDocumentType() {
    return documentType;
  }

  public void setDocumentType(DocumentType documentType) {
    this.documentType = documentType;
  }


  public DocumentUploadRequest documentSubType(String documentSubType) {
    this.documentSubType = documentSubType;
    return this;
  }

   /**
   * The specific type of document, e.g. passport
   * @return documentSubType
  **/
  @javax.annotation.Nullable
  public String getDocumentSubType() {
    return documentSubType;
  }

  public void setDocumentSubType(String documentSubType) {
    this.documentSubType = documentSubType;
  }


  public DocumentUploadRequest content(String content) {
    this.content = content;
    return this;
  }

   /**
   * Base64 string representing the document
   * @return content
  **/
  @javax.annotation.Nonnull
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }


  public DocumentUploadRequest contentData(W8benDocument contentData) {
    this.contentData = contentData;
    return this;
  }

   /**
   * Get contentData
   * @return contentData
  **/
  @javax.annotation.Nullable
  public W8benDocument getContentData() {
    return contentData;
  }

  public void setContentData(W8benDocument contentData) {
    this.contentData = contentData;
  }


  public DocumentUploadRequest mimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

   /**
   * This field is Required if content is specified. ENUM: application/pdf, image/png, or image/jpeg. If document_type is w8ben then application/json is also accepted
   * @return mimeType
  **/
  @javax.annotation.Nullable
  public String getMimeType() {
    return mimeType;
  }

  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentUploadRequest documentUploadRequest = (DocumentUploadRequest) o;
    return Objects.equals(this.documentType, documentUploadRequest.documentType) &&
        Objects.equals(this.documentSubType, documentUploadRequest.documentSubType) &&
        Objects.equals(this.content, documentUploadRequest.content) &&
        Objects.equals(this.contentData, documentUploadRequest.contentData) &&
        Objects.equals(this.mimeType, documentUploadRequest.mimeType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(documentType, documentSubType, content, contentData, mimeType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentUploadRequest {\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    documentSubType: ").append(toIndentedString(documentSubType)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    contentData: ").append(toIndentedString(contentData)).append("\n");
    sb.append("    mimeType: ").append(toIndentedString(mimeType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("document_type");
    openapiFields.add("document_sub_type");
    openapiFields.add("content");
    openapiFields.add("content_data");
    openapiFields.add("mime_type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("document_type");
    openapiRequiredFields.add("content");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!DocumentUploadRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in DocumentUploadRequest is not found in the empty JSON string", DocumentUploadRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!DocumentUploadRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DocumentUploadRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : DocumentUploadRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the required field `document_type`
      DocumentType.validateJsonElement(jsonObj.get("document_type"));
      if ((jsonObj.get("document_sub_type") != null && !jsonObj.get("document_sub_type").isJsonNull()) && !jsonObj.get("document_sub_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `document_sub_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("document_sub_type").toString()));
      }
      if (!jsonObj.get("content").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get("content").toString()));
      }
      // validate the optional field `content_data`
      if (jsonObj.get("content_data") != null && !jsonObj.get("content_data").isJsonNull()) {
        W8benDocument.validateJsonElement(jsonObj.get("content_data"));
      }
      if ((jsonObj.get("mime_type") != null && !jsonObj.get("mime_type").isJsonNull()) && !jsonObj.get("mime_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `mime_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mime_type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DocumentUploadRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DocumentUploadRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DocumentUploadRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DocumentUploadRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<DocumentUploadRequest>() {
           @Override
           public void write(JsonWriter out, DocumentUploadRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DocumentUploadRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DocumentUploadRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DocumentUploadRequest
  * @throws IOException if the JSON string is invalid with respect to DocumentUploadRequest
  */
  public static DocumentUploadRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DocumentUploadRequest.class);
  }

 /**
  * Convert an instance of DocumentUploadRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

