/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.DisclosureContextAnnotation;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Disclosures fields denote if the account owner falls under each category defined by FINRA rule. The client has to ask questions for the end user and the values should reflect their answers. If one of the answers is true (yes), the account goes into ACTION_REQUIRED status. 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Disclosures {
  /**
   * One of the following: &#x60;employed&#x60;, &#x60;unemployed&#x60;, &#x60;retired&#x60;, or &#x60;student&#x60;.
   */
  @JsonAdapter(EmploymentStatusEnum.Adapter.class)
  public enum EmploymentStatusEnum {
    UNEMPLOYED("unemployed"),
    
    EMPLOYED("employed"),
    
    STUDENT("student"),
    
    RETIRED("retired");

    private String value;

    EmploymentStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EmploymentStatusEnum fromValue(String value) {
      for (EmploymentStatusEnum b : EmploymentStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<EmploymentStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EmploymentStatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EmploymentStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EmploymentStatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      EmploymentStatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_EMPLOYMENT_STATUS = "employment_status";
  @SerializedName(SERIALIZED_NAME_EMPLOYMENT_STATUS)
  private EmploymentStatusEnum employmentStatus;

  public static final String SERIALIZED_NAME_EMPLOYER_NAME = "employer_name";
  @SerializedName(SERIALIZED_NAME_EMPLOYER_NAME)
  private String employerName;

  public static final String SERIALIZED_NAME_EMPLOYER_ADDRESS = "employer_address";
  @SerializedName(SERIALIZED_NAME_EMPLOYER_ADDRESS)
  private String employerAddress;

  public static final String SERIALIZED_NAME_EMPLOYMENT_POSITION = "employment_position";
  @SerializedName(SERIALIZED_NAME_EMPLOYMENT_POSITION)
  private String employmentPosition;

  public static final String SERIALIZED_NAME_IS_CONTROL_PERSON = "is_control_person";
  @SerializedName(SERIALIZED_NAME_IS_CONTROL_PERSON)
  private Boolean isControlPerson;

  public static final String SERIALIZED_NAME_IS_AFFILIATED_EXCHANGE_OR_FINRA = "is_affiliated_exchange_or_finra";
  @SerializedName(SERIALIZED_NAME_IS_AFFILIATED_EXCHANGE_OR_FINRA)
  private Boolean isAffiliatedExchangeOrFinra;

  public static final String SERIALIZED_NAME_IS_POLITICALLY_EXPOSED = "is_politically_exposed";
  @SerializedName(SERIALIZED_NAME_IS_POLITICALLY_EXPOSED)
  private Boolean isPoliticallyExposed;

  public static final String SERIALIZED_NAME_IMMEDIATE_FAMILY_EXPOSED = "immediate_family_exposed";
  @SerializedName(SERIALIZED_NAME_IMMEDIATE_FAMILY_EXPOSED)
  private Boolean immediateFamilyExposed;

  public static final String SERIALIZED_NAME_CONTEXT = "context";
  @SerializedName(SERIALIZED_NAME_CONTEXT)
  private List<DisclosureContextAnnotation> context;

  public Disclosures() {
  }

  public Disclosures employmentStatus(EmploymentStatusEnum employmentStatus) {
    this.employmentStatus = employmentStatus;
    return this;
  }

   /**
   * One of the following: &#x60;employed&#x60;, &#x60;unemployed&#x60;, &#x60;retired&#x60;, or &#x60;student&#x60;.
   * @return employmentStatus
  **/
  @javax.annotation.Nullable
  public EmploymentStatusEnum getEmploymentStatus() {
    return employmentStatus;
  }

  public void setEmploymentStatus(EmploymentStatusEnum employmentStatus) {
    this.employmentStatus = employmentStatus;
  }


  public Disclosures employerName(String employerName) {
    this.employerName = employerName;
    return this;
  }

   /**
   * The name of the employer if the user is employed.
   * @return employerName
  **/
  @javax.annotation.Nullable
  public String getEmployerName() {
    return employerName;
  }

  public void setEmployerName(String employerName) {
    this.employerName = employerName;
  }


  public Disclosures employerAddress(String employerAddress) {
    this.employerAddress = employerAddress;
    return this;
  }

   /**
   * The employer&#39;s address if the user is employed.
   * @return employerAddress
  **/
  @javax.annotation.Nullable
  public String getEmployerAddress() {
    return employerAddress;
  }

  public void setEmployerAddress(String employerAddress) {
    this.employerAddress = employerAddress;
  }


  public Disclosures employmentPosition(String employmentPosition) {
    this.employmentPosition = employmentPosition;
    return this;
  }

   /**
   * The user&#39;s position if they are employed.
   * @return employmentPosition
  **/
  @javax.annotation.Nullable
  public String getEmploymentPosition() {
    return employmentPosition;
  }

  public void setEmploymentPosition(String employmentPosition) {
    this.employmentPosition = employmentPosition;
  }


  public Disclosures isControlPerson(Boolean isControlPerson) {
    this.isControlPerson = isControlPerson;
    return this;
  }

   /**
   * Whether user holds a controlling position in a publicly traded company, member of the board of directors or has policy making abilities in a publicly traded company.
   * @return isControlPerson
  **/
  @javax.annotation.Nonnull
  public Boolean getIsControlPerson() {
    return isControlPerson;
  }

  public void setIsControlPerson(Boolean isControlPerson) {
    this.isControlPerson = isControlPerson;
  }


  public Disclosures isAffiliatedExchangeOrFinra(Boolean isAffiliatedExchangeOrFinra) {
    this.isAffiliatedExchangeOrFinra = isAffiliatedExchangeOrFinra;
    return this;
  }

   /**
   * Whether user is affiliated with any exchanges or FINRA.
   * @return isAffiliatedExchangeOrFinra
  **/
  @javax.annotation.Nonnull
  public Boolean getIsAffiliatedExchangeOrFinra() {
    return isAffiliatedExchangeOrFinra;
  }

  public void setIsAffiliatedExchangeOrFinra(Boolean isAffiliatedExchangeOrFinra) {
    this.isAffiliatedExchangeOrFinra = isAffiliatedExchangeOrFinra;
  }


  public Disclosures isPoliticallyExposed(Boolean isPoliticallyExposed) {
    this.isPoliticallyExposed = isPoliticallyExposed;
    return this;
  }

   /**
   * Whether the user is politically exposed.
   * @return isPoliticallyExposed
  **/
  @javax.annotation.Nonnull
  public Boolean getIsPoliticallyExposed() {
    return isPoliticallyExposed;
  }

  public void setIsPoliticallyExposed(Boolean isPoliticallyExposed) {
    this.isPoliticallyExposed = isPoliticallyExposed;
  }


  public Disclosures immediateFamilyExposed(Boolean immediateFamilyExposed) {
    this.immediateFamilyExposed = immediateFamilyExposed;
    return this;
  }

   /**
   * If your user’s immediate family member (sibling, husband/wife, child, parent) is either politically exposed or holds a control position.
   * @return immediateFamilyExposed
  **/
  @javax.annotation.Nonnull
  public Boolean getImmediateFamilyExposed() {
    return immediateFamilyExposed;
  }

  public void setImmediateFamilyExposed(Boolean immediateFamilyExposed) {
    this.immediateFamilyExposed = immediateFamilyExposed;
  }


  public Disclosures context(List<DisclosureContextAnnotation> context) {
    this.context = context;
    return this;
  }

  public Disclosures addContextItem(DisclosureContextAnnotation contextItem) {
    if (this.context == null) {
      this.context = new ArrayList<>();
    }
    this.context.add(contextItem);
    return this;
  }

   /**
   * Array of annotations describing the rational for marking &#x60;is_control_person&#x60;, &#x60;is_affiliated_exchange_or_finra&#x60;, and/or &#x60;immediate_family_exposed&#x60; as true
   * @return context
  **/
  @javax.annotation.Nullable
  public List<DisclosureContextAnnotation> getContext() {
    return context;
  }

  public void setContext(List<DisclosureContextAnnotation> context) {
    this.context = context;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Disclosures disclosures = (Disclosures) o;
    return Objects.equals(this.employmentStatus, disclosures.employmentStatus) &&
        Objects.equals(this.employerName, disclosures.employerName) &&
        Objects.equals(this.employerAddress, disclosures.employerAddress) &&
        Objects.equals(this.employmentPosition, disclosures.employmentPosition) &&
        Objects.equals(this.isControlPerson, disclosures.isControlPerson) &&
        Objects.equals(this.isAffiliatedExchangeOrFinra, disclosures.isAffiliatedExchangeOrFinra) &&
        Objects.equals(this.isPoliticallyExposed, disclosures.isPoliticallyExposed) &&
        Objects.equals(this.immediateFamilyExposed, disclosures.immediateFamilyExposed) &&
        Objects.equals(this.context, disclosures.context);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(employmentStatus, employerName, employerAddress, employmentPosition, isControlPerson, isAffiliatedExchangeOrFinra, isPoliticallyExposed, immediateFamilyExposed, context);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Disclosures {\n");
    sb.append("    employmentStatus: ").append(toIndentedString(employmentStatus)).append("\n");
    sb.append("    employerName: ").append(toIndentedString(employerName)).append("\n");
    sb.append("    employerAddress: ").append(toIndentedString(employerAddress)).append("\n");
    sb.append("    employmentPosition: ").append(toIndentedString(employmentPosition)).append("\n");
    sb.append("    isControlPerson: ").append(toIndentedString(isControlPerson)).append("\n");
    sb.append("    isAffiliatedExchangeOrFinra: ").append(toIndentedString(isAffiliatedExchangeOrFinra)).append("\n");
    sb.append("    isPoliticallyExposed: ").append(toIndentedString(isPoliticallyExposed)).append("\n");
    sb.append("    immediateFamilyExposed: ").append(toIndentedString(immediateFamilyExposed)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("employment_status");
    openapiFields.add("employer_name");
    openapiFields.add("employer_address");
    openapiFields.add("employment_position");
    openapiFields.add("is_control_person");
    openapiFields.add("is_affiliated_exchange_or_finra");
    openapiFields.add("is_politically_exposed");
    openapiFields.add("immediate_family_exposed");
    openapiFields.add("context");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("is_control_person");
    openapiRequiredFields.add("is_affiliated_exchange_or_finra");
    openapiRequiredFields.add("is_politically_exposed");
    openapiRequiredFields.add("immediate_family_exposed");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Disclosures.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Disclosures is not found in the empty JSON string", Disclosures.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Disclosures.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Disclosures` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Disclosures.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("employment_status") != null && !jsonObj.get("employment_status").isJsonNull()) && !jsonObj.get("employment_status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `employment_status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("employment_status").toString()));
      }
      // validate the optional field `employment_status`
      if (jsonObj.get("employment_status") != null && !jsonObj.get("employment_status").isJsonNull()) {
        EmploymentStatusEnum.validateJsonElement(jsonObj.get("employment_status"));
      }
      if ((jsonObj.get("employer_name") != null && !jsonObj.get("employer_name").isJsonNull()) && !jsonObj.get("employer_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `employer_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("employer_name").toString()));
      }
      if ((jsonObj.get("employer_address") != null && !jsonObj.get("employer_address").isJsonNull()) && !jsonObj.get("employer_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `employer_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("employer_address").toString()));
      }
      if ((jsonObj.get("employment_position") != null && !jsonObj.get("employment_position").isJsonNull()) && !jsonObj.get("employment_position").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `employment_position` to be a primitive type in the JSON string but got `%s`", jsonObj.get("employment_position").toString()));
      }
      if (jsonObj.get("context") != null && !jsonObj.get("context").isJsonNull()) {
        JsonArray jsonArraycontext = jsonObj.getAsJsonArray("context");
        if (jsonArraycontext != null) {
          // ensure the json data is an array
          if (!jsonObj.get("context").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `context` to be an array in the JSON string but got `%s`", jsonObj.get("context").toString()));
          }

          // validate the optional field `context` (array)
          for (int i = 0; i < jsonArraycontext.size(); i++) {
            DisclosureContextAnnotation.validateJsonElement(jsonArraycontext.get(i));
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Disclosures.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Disclosures' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Disclosures> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Disclosures.class));

       return (TypeAdapter<T>) new TypeAdapter<Disclosures>() {
           @Override
           public void write(JsonWriter out, Disclosures value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Disclosures read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Disclosures given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Disclosures
  * @throws IOException if the JSON string is invalid with respect to Disclosures
  */
  public static Disclosures fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Disclosures.class);
  }

 /**
  * Convert an instance of Disclosures to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

