/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * DisclosureContextAnnotation
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class DisclosureContextAnnotation {
  /**
   * Specifies the type of disclosure annotation. Valid types are FINRA affiliations, for users affiliated with or employed by a FINRA member firm, a Stock Exchange Member, FINRA, Registered Investment Advisor, or a Municipal Securities Broker/Dealer; Company control relationships, for senior executives, and 10% or greater shareholders, of a publicly traded company; and immediate family members of politically exposed individuals.
   */
  @JsonAdapter(ContextTypeEnum.Adapter.class)
  public enum ContextTypeEnum {
    CONTROLLED_FIRM("CONTROLLED_FIRM"),
    
    IMMEDIATE_FAMILY_EXPOSED("IMMEDIATE_FAMILY_EXPOSED"),
    
    AFFILIATE_FIRM("AFFILIATE_FIRM");

    private String value;

    ContextTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ContextTypeEnum fromValue(String value) {
      for (ContextTypeEnum b : ContextTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ContextTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ContextTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ContextTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ContextTypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      ContextTypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_CONTEXT_TYPE = "context_type";
  @SerializedName(SERIALIZED_NAME_CONTEXT_TYPE)
  private ContextTypeEnum contextType;

  public static final String SERIALIZED_NAME_COMPANY_NAME = "company_name";
  @SerializedName(SERIALIZED_NAME_COMPANY_NAME)
  private String companyName;

  public static final String SERIALIZED_NAME_COMPANY_STREET_ADDRESS = "company_street_address";
  @SerializedName(SERIALIZED_NAME_COMPANY_STREET_ADDRESS)
  private String companyStreetAddress;

  public static final String SERIALIZED_NAME_COMPANY_CITY = "company_city";
  @SerializedName(SERIALIZED_NAME_COMPANY_CITY)
  private String companyCity;

  public static final String SERIALIZED_NAME_COMPANY_STATE = "company_state";
  @SerializedName(SERIALIZED_NAME_COMPANY_STATE)
  private String companyState;

  public static final String SERIALIZED_NAME_COMPANY_COUNTRY = "company_country";
  @SerializedName(SERIALIZED_NAME_COMPANY_COUNTRY)
  private String companyCountry;

  public static final String SERIALIZED_NAME_COMPANY_COMPLIANCE_EMAIL = "company_compliance_email";
  @SerializedName(SERIALIZED_NAME_COMPANY_COMPLIANCE_EMAIL)
  private String companyComplianceEmail;

  public static final String SERIALIZED_NAME_GIVEN_NAME = "given_name";
  @SerializedName(SERIALIZED_NAME_GIVEN_NAME)
  private String givenName;

  public static final String SERIALIZED_NAME_FAMILY_NAME = "family_name";
  @SerializedName(SERIALIZED_NAME_FAMILY_NAME)
  private String familyName;

  public DisclosureContextAnnotation() {
  }

  public DisclosureContextAnnotation contextType(ContextTypeEnum contextType) {
    this.contextType = contextType;
    return this;
  }

   /**
   * Specifies the type of disclosure annotation. Valid types are FINRA affiliations, for users affiliated with or employed by a FINRA member firm, a Stock Exchange Member, FINRA, Registered Investment Advisor, or a Municipal Securities Broker/Dealer; Company control relationships, for senior executives, and 10% or greater shareholders, of a publicly traded company; and immediate family members of politically exposed individuals.
   * @return contextType
  **/
  @javax.annotation.Nonnull
  public ContextTypeEnum getContextType() {
    return contextType;
  }

  public void setContextType(ContextTypeEnum contextType) {
    this.contextType = contextType;
  }


  public DisclosureContextAnnotation companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * Required for FINRA affiliations and controlled firms.
   * @return companyName
  **/
  @javax.annotation.Nullable
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }


  public DisclosureContextAnnotation companyStreetAddress(String companyStreetAddress) {
    this.companyStreetAddress = companyStreetAddress;
    return this;
  }

   /**
   * Required for FINRA affiliations and controlled firms.
   * @return companyStreetAddress
  **/
  @javax.annotation.Nullable
  public String getCompanyStreetAddress() {
    return companyStreetAddress;
  }

  public void setCompanyStreetAddress(String companyStreetAddress) {
    this.companyStreetAddress = companyStreetAddress;
  }


  public DisclosureContextAnnotation companyCity(String companyCity) {
    this.companyCity = companyCity;
    return this;
  }

   /**
   * Required for FINRA affiliations and controlled firms.
   * @return companyCity
  **/
  @javax.annotation.Nullable
  public String getCompanyCity() {
    return companyCity;
  }

  public void setCompanyCity(String companyCity) {
    this.companyCity = companyCity;
  }


  public DisclosureContextAnnotation companyState(String companyState) {
    this.companyState = companyState;
    return this;
  }

   /**
   * Required if and only if &#x60;company_country&#x60; is &#x60;USA&#x60;.
   * @return companyState
  **/
  @javax.annotation.Nullable
  public String getCompanyState() {
    return companyState;
  }

  public void setCompanyState(String companyState) {
    this.companyState = companyState;
  }


  public DisclosureContextAnnotation companyCountry(String companyCountry) {
    this.companyCountry = companyCountry;
    return this;
  }

   /**
   * Required for FINRA affiliations and controlled firms.
   * @return companyCountry
  **/
  @javax.annotation.Nullable
  public String getCompanyCountry() {
    return companyCountry;
  }

  public void setCompanyCountry(String companyCountry) {
    this.companyCountry = companyCountry;
  }


  public DisclosureContextAnnotation companyComplianceEmail(String companyComplianceEmail) {
    this.companyComplianceEmail = companyComplianceEmail;
    return this;
  }

   /**
   * Required for FINRA affiliations and controlled firms.
   * @return companyComplianceEmail
  **/
  @javax.annotation.Nullable
  public String getCompanyComplianceEmail() {
    return companyComplianceEmail;
  }

  public void setCompanyComplianceEmail(String companyComplianceEmail) {
    this.companyComplianceEmail = companyComplianceEmail;
  }


  public DisclosureContextAnnotation givenName(String givenName) {
    this.givenName = givenName;
    return this;
  }

   /**
   * Required for immediate family members of politically exposed persons.
   * @return givenName
  **/
  @javax.annotation.Nullable
  public String getGivenName() {
    return givenName;
  }

  public void setGivenName(String givenName) {
    this.givenName = givenName;
  }


  public DisclosureContextAnnotation familyName(String familyName) {
    this.familyName = familyName;
    return this;
  }

   /**
   * Required for immediate family members of politically exposed persons.
   * @return familyName
  **/
  @javax.annotation.Nullable
  public String getFamilyName() {
    return familyName;
  }

  public void setFamilyName(String familyName) {
    this.familyName = familyName;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DisclosureContextAnnotation disclosureContextAnnotation = (DisclosureContextAnnotation) o;
    return Objects.equals(this.contextType, disclosureContextAnnotation.contextType) &&
        Objects.equals(this.companyName, disclosureContextAnnotation.companyName) &&
        Objects.equals(this.companyStreetAddress, disclosureContextAnnotation.companyStreetAddress) &&
        Objects.equals(this.companyCity, disclosureContextAnnotation.companyCity) &&
        Objects.equals(this.companyState, disclosureContextAnnotation.companyState) &&
        Objects.equals(this.companyCountry, disclosureContextAnnotation.companyCountry) &&
        Objects.equals(this.companyComplianceEmail, disclosureContextAnnotation.companyComplianceEmail) &&
        Objects.equals(this.givenName, disclosureContextAnnotation.givenName) &&
        Objects.equals(this.familyName, disclosureContextAnnotation.familyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contextType, companyName, companyStreetAddress, companyCity, companyState, companyCountry, companyComplianceEmail, givenName, familyName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DisclosureContextAnnotation {\n");
    sb.append("    contextType: ").append(toIndentedString(contextType)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyStreetAddress: ").append(toIndentedString(companyStreetAddress)).append("\n");
    sb.append("    companyCity: ").append(toIndentedString(companyCity)).append("\n");
    sb.append("    companyState: ").append(toIndentedString(companyState)).append("\n");
    sb.append("    companyCountry: ").append(toIndentedString(companyCountry)).append("\n");
    sb.append("    companyComplianceEmail: ").append(toIndentedString(companyComplianceEmail)).append("\n");
    sb.append("    givenName: ").append(toIndentedString(givenName)).append("\n");
    sb.append("    familyName: ").append(toIndentedString(familyName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("context_type");
    openapiFields.add("company_name");
    openapiFields.add("company_street_address");
    openapiFields.add("company_city");
    openapiFields.add("company_state");
    openapiFields.add("company_country");
    openapiFields.add("company_compliance_email");
    openapiFields.add("given_name");
    openapiFields.add("family_name");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("context_type");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!DisclosureContextAnnotation.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in DisclosureContextAnnotation is not found in the empty JSON string", DisclosureContextAnnotation.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!DisclosureContextAnnotation.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DisclosureContextAnnotation` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : DisclosureContextAnnotation.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("context_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `context_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("context_type").toString()));
      }
      // validate the required field `context_type`
      ContextTypeEnum.validateJsonElement(jsonObj.get("context_type"));
      if ((jsonObj.get("company_name") != null && !jsonObj.get("company_name").isJsonNull()) && !jsonObj.get("company_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_name").toString()));
      }
      if ((jsonObj.get("company_street_address") != null && !jsonObj.get("company_street_address").isJsonNull()) && !jsonObj.get("company_street_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_street_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_street_address").toString()));
      }
      if ((jsonObj.get("company_city") != null && !jsonObj.get("company_city").isJsonNull()) && !jsonObj.get("company_city").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_city` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_city").toString()));
      }
      if ((jsonObj.get("company_state") != null && !jsonObj.get("company_state").isJsonNull()) && !jsonObj.get("company_state").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_state` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_state").toString()));
      }
      if ((jsonObj.get("company_country") != null && !jsonObj.get("company_country").isJsonNull()) && !jsonObj.get("company_country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_country").toString()));
      }
      if ((jsonObj.get("company_compliance_email") != null && !jsonObj.get("company_compliance_email").isJsonNull()) && !jsonObj.get("company_compliance_email").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `company_compliance_email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("company_compliance_email").toString()));
      }
      if ((jsonObj.get("given_name") != null && !jsonObj.get("given_name").isJsonNull()) && !jsonObj.get("given_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `given_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("given_name").toString()));
      }
      if ((jsonObj.get("family_name") != null && !jsonObj.get("family_name").isJsonNull()) && !jsonObj.get("family_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `family_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("family_name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DisclosureContextAnnotation.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DisclosureContextAnnotation' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DisclosureContextAnnotation> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DisclosureContextAnnotation.class));

       return (TypeAdapter<T>) new TypeAdapter<DisclosureContextAnnotation>() {
           @Override
           public void write(JsonWriter out, DisclosureContextAnnotation value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DisclosureContextAnnotation read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DisclosureContextAnnotation given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DisclosureContextAnnotation
  * @throws IOException if the JSON string is invalid with respect to DisclosureContextAnnotation
  */
  public static DisclosureContextAnnotation fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DisclosureContextAnnotation.class);
  }

 /**
  * Convert an instance of DisclosureContextAnnotation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

