/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * DailyTradingLimit
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class DailyTradingLimit {
  public static final String SERIALIZED_NAME_DAILY_NET_LIMIT_IN_USE = "daily_net_limit_in_use";
  @SerializedName(SERIALIZED_NAME_DAILY_NET_LIMIT_IN_USE)
  private BigDecimal dailyNetLimitInUse;

  public static final String SERIALIZED_NAME_DAILY_NET_LIMIT = "daily_net_limit";
  @SerializedName(SERIALIZED_NAME_DAILY_NET_LIMIT)
  private BigDecimal dailyNetLimit;

  public DailyTradingLimit() {
  }

  public DailyTradingLimit dailyNetLimitInUse(BigDecimal dailyNetLimitInUse) {
    this.dailyNetLimitInUse = dailyNetLimitInUse;
    return this;
  }

   /**
   * The real time net value of cash inflows (buy trades, etc.) with cash outflows (sell trades, dividends, etc). This will be dynamic throughout the day based on user activity, with executed orders being reset at the start of the next trading day.
   * @return dailyNetLimitInUse
  **/
  @javax.annotation.Nullable
  public BigDecimal getDailyNetLimitInUse() {
    return dailyNetLimitInUse;
  }

  public void setDailyNetLimitInUse(BigDecimal dailyNetLimitInUse) {
    this.dailyNetLimitInUse = dailyNetLimitInUse;
  }


  public DailyTradingLimit dailyNetLimit(BigDecimal dailyNetLimit) {
    this.dailyNetLimit = dailyNetLimit;
    return this;
  }

   /**
   * The net buying limit that can be reached before further cash outflow trading activity is restricted. Please reach out to learn more about how this limit is determined.
   * @return dailyNetLimit
  **/
  @javax.annotation.Nullable
  public BigDecimal getDailyNetLimit() {
    return dailyNetLimit;
  }

  public void setDailyNetLimit(BigDecimal dailyNetLimit) {
    this.dailyNetLimit = dailyNetLimit;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyTradingLimit dailyTradingLimit = (DailyTradingLimit) o;
    return Objects.equals(this.dailyNetLimitInUse, dailyTradingLimit.dailyNetLimitInUse) &&
        Objects.equals(this.dailyNetLimit, dailyTradingLimit.dailyNetLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dailyNetLimitInUse, dailyNetLimit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyTradingLimit {\n");
    sb.append("    dailyNetLimitInUse: ").append(toIndentedString(dailyNetLimitInUse)).append("\n");
    sb.append("    dailyNetLimit: ").append(toIndentedString(dailyNetLimit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("daily_net_limit_in_use");
    openapiFields.add("daily_net_limit");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!DailyTradingLimit.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in DailyTradingLimit is not found in the empty JSON string", DailyTradingLimit.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!DailyTradingLimit.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DailyTradingLimit` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("daily_net_limit_in_use") != null && !jsonObj.get("daily_net_limit_in_use").isJsonNull()) && !jsonObj.get("daily_net_limit_in_use").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `daily_net_limit_in_use` to be a primitive type in the JSON string but got `%s`", jsonObj.get("daily_net_limit_in_use").toString()));
      }
      if ((jsonObj.get("daily_net_limit") != null && !jsonObj.get("daily_net_limit").isJsonNull()) && !jsonObj.get("daily_net_limit").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `daily_net_limit` to be a primitive type in the JSON string but got `%s`", jsonObj.get("daily_net_limit").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DailyTradingLimit.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DailyTradingLimit' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DailyTradingLimit> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DailyTradingLimit.class));

       return (TypeAdapter<T>) new TypeAdapter<DailyTradingLimit>() {
           @Override
           public void write(JsonWriter out, DailyTradingLimit value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DailyTradingLimit read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DailyTradingLimit given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DailyTradingLimit
  * @throws IOException if the JSON string is invalid with respect to DailyTradingLimit
  */
  public static DailyTradingLimit fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DailyTradingLimit.class);
  }

 /**
  * Convert an instance of DailyTradingLimit to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

