/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferDirection;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferTiming;
import net.jacobpeterson.alpaca.openapi.broker.model.TransferType;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * [See main docs here](https://alpaca.markets/docs/api-references/broker-api/funding/transfers/#creating-a-transfer-entity)
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CreateTransferRequest {
  public static final String SERIALIZED_NAME_TRANSFER_TYPE = "transfer_type";
  @SerializedName(SERIALIZED_NAME_TRANSFER_TYPE)
  private TransferType transferType;

  public static final String SERIALIZED_NAME_RELATIONSHIP_ID = "relationship_id";
  @SerializedName(SERIALIZED_NAME_RELATIONSHIP_ID)
  private UUID relationshipId;

  public static final String SERIALIZED_NAME_BANK_ID = "bank_id";
  @SerializedName(SERIALIZED_NAME_BANK_ID)
  private UUID bankId;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_DIRECTION = "direction";
  @SerializedName(SERIALIZED_NAME_DIRECTION)
  private TransferDirection direction;

  public static final String SERIALIZED_NAME_TIMING = "timing";
  @SerializedName(SERIALIZED_NAME_TIMING)
  private TransferTiming timing;

  public static final String SERIALIZED_NAME_ADDITIONAL_INFORMATION = "additional_information";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_INFORMATION)
  private String additionalInformation;

  public static final String SERIALIZED_NAME_FEE_PAYMENT_METHOD = "fee_payment_method";
  @SerializedName(SERIALIZED_NAME_FEE_PAYMENT_METHOD)
  private String feePaymentMethod;

  public CreateTransferRequest() {
  }

  public CreateTransferRequest transferType(TransferType transferType) {
    this.transferType = transferType;
    return this;
  }

   /**
   * Get transferType
   * @return transferType
  **/
  @javax.annotation.Nonnull
  public TransferType getTransferType() {
    return transferType;
  }

  public void setTransferType(TransferType transferType) {
    this.transferType = transferType;
  }


  public CreateTransferRequest relationshipId(UUID relationshipId) {
    this.relationshipId = relationshipId;
    return this;
  }

   /**
   * Required if type &#x3D; &#x60;ach&#x60;  The ach_relationship created for the account_id [here](https://alpaca.markets/docs/api-references/broker-api/funding/ach/#creating-an-ach-relationship)
   * @return relationshipId
  **/
  @javax.annotation.Nullable
  public UUID getRelationshipId() {
    return relationshipId;
  }

  public void setRelationshipId(UUID relationshipId) {
    this.relationshipId = relationshipId;
  }


  public CreateTransferRequest bankId(UUID bankId) {
    this.bankId = bankId;
    return this;
  }

   /**
   * Required if type &#x3D; &#x60;wire&#x60;  The bank_relationship created for the account_id [here](https://alpaca.markets/docs/api-references/broker-api/funding/bank/#creating-a-new-bank-relationship)
   * @return bankId
  **/
  @javax.annotation.Nullable
  public UUID getBankId() {
    return bankId;
  }

  public void setBankId(UUID bankId) {
    this.bankId = bankId;
  }


  public CreateTransferRequest amount(BigDecimal amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Must be &gt; 0.00
   * @return amount
  **/
  @javax.annotation.Nonnull
  public BigDecimal getAmount() {
    return amount;
  }

  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public CreateTransferRequest direction(TransferDirection direction) {
    this.direction = direction;
    return this;
  }

   /**
   * Get direction
   * @return direction
  **/
  @javax.annotation.Nonnull
  public TransferDirection getDirection() {
    return direction;
  }

  public void setDirection(TransferDirection direction) {
    this.direction = direction;
  }


  public CreateTransferRequest timing(TransferTiming timing) {
    this.timing = timing;
    return this;
  }

   /**
   * Get timing
   * @return timing
  **/
  @javax.annotation.Nonnull
  public TransferTiming getTiming() {
    return timing;
  }

  public void setTiming(TransferTiming timing) {
    this.timing = timing;
  }


  public CreateTransferRequest additionalInformation(String additionalInformation) {
    this.additionalInformation = additionalInformation;
    return this;
  }

   /**
   * Additional details for when type &#x3D; &#x60;wire&#x60;
   * @return additionalInformation
  **/
  @javax.annotation.Nullable
  public String getAdditionalInformation() {
    return additionalInformation;
  }

  public void setAdditionalInformation(String additionalInformation) {
    this.additionalInformation = additionalInformation;
  }


  public CreateTransferRequest feePaymentMethod(String feePaymentMethod) {
    this.feePaymentMethod = feePaymentMethod;
    return this;
  }

   /**
   * Only outgoing wire fees are currently supported for automated processing.   **user** The end user will pay any applicable fees **invoice** Any applicable fees will be billed to the client in the following monthly invoice
   * @return feePaymentMethod
  **/
  @javax.annotation.Nullable
  public String getFeePaymentMethod() {
    return feePaymentMethod;
  }

  public void setFeePaymentMethod(String feePaymentMethod) {
    this.feePaymentMethod = feePaymentMethod;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateTransferRequest createTransferRequest = (CreateTransferRequest) o;
    return Objects.equals(this.transferType, createTransferRequest.transferType) &&
        Objects.equals(this.relationshipId, createTransferRequest.relationshipId) &&
        Objects.equals(this.bankId, createTransferRequest.bankId) &&
        Objects.equals(this.amount, createTransferRequest.amount) &&
        Objects.equals(this.direction, createTransferRequest.direction) &&
        Objects.equals(this.timing, createTransferRequest.timing) &&
        Objects.equals(this.additionalInformation, createTransferRequest.additionalInformation) &&
        Objects.equals(this.feePaymentMethod, createTransferRequest.feePaymentMethod);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(transferType, relationshipId, bankId, amount, direction, timing, additionalInformation, feePaymentMethod);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTransferRequest {\n");
    sb.append("    transferType: ").append(toIndentedString(transferType)).append("\n");
    sb.append("    relationshipId: ").append(toIndentedString(relationshipId)).append("\n");
    sb.append("    bankId: ").append(toIndentedString(bankId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    timing: ").append(toIndentedString(timing)).append("\n");
    sb.append("    additionalInformation: ").append(toIndentedString(additionalInformation)).append("\n");
    sb.append("    feePaymentMethod: ").append(toIndentedString(feePaymentMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("transfer_type");
    openapiFields.add("relationship_id");
    openapiFields.add("bank_id");
    openapiFields.add("amount");
    openapiFields.add("direction");
    openapiFields.add("timing");
    openapiFields.add("additional_information");
    openapiFields.add("fee_payment_method");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("transfer_type");
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("direction");
    openapiRequiredFields.add("timing");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CreateTransferRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateTransferRequest is not found in the empty JSON string", CreateTransferRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CreateTransferRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateTransferRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CreateTransferRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the required field `transfer_type`
      TransferType.validateJsonElement(jsonObj.get("transfer_type"));
      if ((jsonObj.get("relationship_id") != null && !jsonObj.get("relationship_id").isJsonNull()) && !jsonObj.get("relationship_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `relationship_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("relationship_id").toString()));
      }
      if ((jsonObj.get("bank_id") != null && !jsonObj.get("bank_id").isJsonNull()) && !jsonObj.get("bank_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_id").toString()));
      }
      if (!jsonObj.get("amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("amount").toString()));
      }
      // validate the required field `direction`
      TransferDirection.validateJsonElement(jsonObj.get("direction"));
      // validate the required field `timing`
      TransferTiming.validateJsonElement(jsonObj.get("timing"));
      if ((jsonObj.get("additional_information") != null && !jsonObj.get("additional_information").isJsonNull()) && !jsonObj.get("additional_information").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `additional_information` to be a primitive type in the JSON string but got `%s`", jsonObj.get("additional_information").toString()));
      }
      if ((jsonObj.get("fee_payment_method") != null && !jsonObj.get("fee_payment_method").isJsonNull()) && !jsonObj.get("fee_payment_method").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fee_payment_method` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fee_payment_method").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateTransferRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateTransferRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateTransferRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateTransferRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateTransferRequest>() {
           @Override
           public void write(JsonWriter out, CreateTransferRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateTransferRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateTransferRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateTransferRequest
  * @throws IOException if the JSON string is invalid with respect to CreateTransferRequest
  */
  public static CreateTransferRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateTransferRequest.class);
  }

 /**
  * Convert an instance of CreateTransferRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

