/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequestStopLoss;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequestTakeProfit;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderClass;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderType;
import net.jacobpeterson.alpaca.openapi.broker.model.TimeInForce;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * CreateOrderRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CreateOrderRequest {
  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public static final String SERIALIZED_NAME_NOTIONAL = "notional";
  @SerializedName(SERIALIZED_NAME_NOTIONAL)
  private BigDecimal notional;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private OrderSide side;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private OrderType type;

  public static final String SERIALIZED_NAME_TIME_IN_FORCE = "time_in_force";
  @SerializedName(SERIALIZED_NAME_TIME_IN_FORCE)
  private TimeInForce timeInForce;

  public static final String SERIALIZED_NAME_LIMIT_PRICE = "limit_price";
  @SerializedName(SERIALIZED_NAME_LIMIT_PRICE)
  private BigDecimal limitPrice;

  public static final String SERIALIZED_NAME_STOP_PRICE = "stop_price";
  @SerializedName(SERIALIZED_NAME_STOP_PRICE)
  private BigDecimal stopPrice;

  public static final String SERIALIZED_NAME_TRAIL_PRICE = "trail_price";
  @SerializedName(SERIALIZED_NAME_TRAIL_PRICE)
  private BigDecimal trailPrice;

  public static final String SERIALIZED_NAME_TRAIL_PERCENT = "trail_percent";
  @SerializedName(SERIALIZED_NAME_TRAIL_PERCENT)
  private BigDecimal trailPercent;

  public static final String SERIALIZED_NAME_EXTENDED_HOURS = "extended_hours";
  @SerializedName(SERIALIZED_NAME_EXTENDED_HOURS)
  private Boolean extendedHours;

  public static final String SERIALIZED_NAME_CLIENT_ORDER_ID = "client_order_id";
  @SerializedName(SERIALIZED_NAME_CLIENT_ORDER_ID)
  private String clientOrderId;

  public static final String SERIALIZED_NAME_ORDER_CLASS = "order_class";
  @SerializedName(SERIALIZED_NAME_ORDER_CLASS)
  private OrderClass orderClass;

  public static final String SERIALIZED_NAME_TAKE_PROFIT = "take_profit";
  @SerializedName(SERIALIZED_NAME_TAKE_PROFIT)
  private CreateOrderRequestTakeProfit takeProfit;

  public static final String SERIALIZED_NAME_STOP_LOSS = "stop_loss";
  @SerializedName(SERIALIZED_NAME_STOP_LOSS)
  private CreateOrderRequestStopLoss stopLoss;

  public static final String SERIALIZED_NAME_COMMISSION = "commission";
  @SerializedName(SERIALIZED_NAME_COMMISSION)
  private BigDecimal commission;

  public static final String SERIALIZED_NAME_COMMISSION_BPS = "commission_bps";
  @SerializedName(SERIALIZED_NAME_COMMISSION_BPS)
  private BigDecimal commissionBps;

  public static final String SERIALIZED_NAME_SOURCE = "source";
  @SerializedName(SERIALIZED_NAME_SOURCE)
  private String source;

  public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
  @SerializedName(SERIALIZED_NAME_INSTRUCTIONS)
  private String instructions;

  public static final String SERIALIZED_NAME_SUBTAG = "subtag";
  @SerializedName(SERIALIZED_NAME_SUBTAG)
  private String subtag;

  public static final String SERIALIZED_NAME_SWAP_FEE_BPS = "swap_fee_bps";
  @SerializedName(SERIALIZED_NAME_SWAP_FEE_BPS)
  private BigDecimal swapFeeBps;

  public CreateOrderRequest() {
  }

  public CreateOrderRequest symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Symbol or asset ID to identify the asset to trade
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public CreateOrderRequest qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Number of shares to trade. Can be fractionable for only market and day order types.
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }


  public CreateOrderRequest notional(BigDecimal notional) {
    this.notional = notional;
    return this;
  }

   /**
   * Dollar amount to trade. Cannot work with qty. Can only work for market order types and time_in_force &#x3D; day.
   * @return notional
  **/
  @javax.annotation.Nullable
  public BigDecimal getNotional() {
    return notional;
  }

  public void setNotional(BigDecimal notional) {
    this.notional = notional;
  }


  public CreateOrderRequest side(OrderSide side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nonnull
  public OrderSide getSide() {
    return side;
  }

  public void setSide(OrderSide side) {
    this.side = side;
  }


  public CreateOrderRequest type(OrderType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nonnull
  public OrderType getType() {
    return type;
  }

  public void setType(OrderType type) {
    this.type = type;
  }


  public CreateOrderRequest timeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
    return this;
  }

   /**
   * Get timeInForce
   * @return timeInForce
  **/
  @javax.annotation.Nonnull
  public TimeInForce getTimeInForce() {
    return timeInForce;
  }

  public void setTimeInForce(TimeInForce timeInForce) {
    this.timeInForce = timeInForce;
  }


  public CreateOrderRequest limitPrice(BigDecimal limitPrice) {
    this.limitPrice = limitPrice;
    return this;
  }

   /**
   * Required if type is limit or stop_limit
   * @return limitPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getLimitPrice() {
    return limitPrice;
  }

  public void setLimitPrice(BigDecimal limitPrice) {
    this.limitPrice = limitPrice;
  }


  public CreateOrderRequest stopPrice(BigDecimal stopPrice) {
    this.stopPrice = stopPrice;
    return this;
  }

   /**
   * Required if type is stop or stop_limit
   * @return stopPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getStopPrice() {
    return stopPrice;
  }

  public void setStopPrice(BigDecimal stopPrice) {
    this.stopPrice = stopPrice;
  }


  public CreateOrderRequest trailPrice(BigDecimal trailPrice) {
    this.trailPrice = trailPrice;
    return this;
  }

   /**
   * If type is trailing_stop, then one of trail_price or trail_percent is required
   * @return trailPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getTrailPrice() {
    return trailPrice;
  }

  public void setTrailPrice(BigDecimal trailPrice) {
    this.trailPrice = trailPrice;
  }


  public CreateOrderRequest trailPercent(BigDecimal trailPercent) {
    this.trailPercent = trailPercent;
    return this;
  }

   /**
   * If type is trailing_stop, then one of trail_price or trail_percent is required
   * @return trailPercent
  **/
  @javax.annotation.Nullable
  public BigDecimal getTrailPercent() {
    return trailPercent;
  }

  public void setTrailPercent(BigDecimal trailPercent) {
    this.trailPercent = trailPercent;
  }


  public CreateOrderRequest extendedHours(Boolean extendedHours) {
    this.extendedHours = extendedHours;
    return this;
  }

   /**
   * Defaults to false. If true, order will be eligible to execute in premarket/afterhours. Only works with type limit and time_in_force &#x3D; day.
   * @return extendedHours
  **/
  @javax.annotation.Nullable
  public Boolean getExtendedHours() {
    return extendedHours;
  }

  public void setExtendedHours(Boolean extendedHours) {
    this.extendedHours = extendedHours;
  }


  public CreateOrderRequest clientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
    return this;
  }

   /**
   * A unique identifier for the order. Automatically generated if not sent. (&lt;&#x3D; 48 characters)
   * @return clientOrderId
  **/
  @javax.annotation.Nullable
  public String getClientOrderId() {
    return clientOrderId;
  }

  public void setClientOrderId(String clientOrderId) {
    this.clientOrderId = clientOrderId;
  }


  public CreateOrderRequest orderClass(OrderClass orderClass) {
    this.orderClass = orderClass;
    return this;
  }

   /**
   * Get orderClass
   * @return orderClass
  **/
  @javax.annotation.Nullable
  public OrderClass getOrderClass() {
    return orderClass;
  }

  public void setOrderClass(OrderClass orderClass) {
    this.orderClass = orderClass;
  }


  public CreateOrderRequest takeProfit(CreateOrderRequestTakeProfit takeProfit) {
    this.takeProfit = takeProfit;
    return this;
  }

   /**
   * Get takeProfit
   * @return takeProfit
  **/
  @javax.annotation.Nullable
  public CreateOrderRequestTakeProfit getTakeProfit() {
    return takeProfit;
  }

  public void setTakeProfit(CreateOrderRequestTakeProfit takeProfit) {
    this.takeProfit = takeProfit;
  }


  public CreateOrderRequest stopLoss(CreateOrderRequestStopLoss stopLoss) {
    this.stopLoss = stopLoss;
    return this;
  }

   /**
   * Get stopLoss
   * @return stopLoss
  **/
  @javax.annotation.Nullable
  public CreateOrderRequestStopLoss getStopLoss() {
    return stopLoss;
  }

  public void setStopLoss(CreateOrderRequestStopLoss stopLoss) {
    this.stopLoss = stopLoss;
  }


  public CreateOrderRequest commission(BigDecimal commission) {
    this.commission = commission;
    return this;
  }

   /**
   * The commission you want to collect from the user.
   * @return commission
  **/
  @javax.annotation.Nullable
  public BigDecimal getCommission() {
    return commission;
  }

  public void setCommission(BigDecimal commission) {
    this.commission = commission;
  }


  public CreateOrderRequest commissionBps(BigDecimal commissionBps) {
    this.commissionBps = commissionBps;
    return this;
  }

   /**
   * The percent commission you want to charge the end user on the order (expressed in bps). Alpaca will convert the order to a notional amount for purposes of calculating commission
   * @return commissionBps
  **/
  @javax.annotation.Nullable
  public BigDecimal getCommissionBps() {
    return commissionBps;
  }

  public void setCommissionBps(BigDecimal commissionBps) {
    this.commissionBps = commissionBps;
  }


  public CreateOrderRequest source(String source) {
    this.source = source;
    return this;
  }

   /**
   * Get source
   * @return source
  **/
  @javax.annotation.Nullable
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }


  public CreateOrderRequest instructions(String instructions) {
    this.instructions = instructions;
    return this;
  }

   /**
   * Get instructions
   * @return instructions
  **/
  @javax.annotation.Nullable
  public String getInstructions() {
    return instructions;
  }

  public void setInstructions(String instructions) {
    this.instructions = instructions;
  }


  public CreateOrderRequest subtag(String subtag) {
    this.subtag = subtag;
    return this;
  }

   /**
   * Get subtag
   * @return subtag
  **/
  @javax.annotation.Nullable
  public String getSubtag() {
    return subtag;
  }

  public void setSubtag(String subtag) {
    this.subtag = subtag;
  }


  public CreateOrderRequest swapFeeBps(BigDecimal swapFeeBps) {
    this.swapFeeBps = swapFeeBps;
    return this;
  }

   /**
   * Get swapFeeBps
   * @return swapFeeBps
  **/
  @javax.annotation.Nullable
  public BigDecimal getSwapFeeBps() {
    return swapFeeBps;
  }

  public void setSwapFeeBps(BigDecimal swapFeeBps) {
    this.swapFeeBps = swapFeeBps;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateOrderRequest createOrderRequest = (CreateOrderRequest) o;
    return Objects.equals(this.symbol, createOrderRequest.symbol) &&
        Objects.equals(this.qty, createOrderRequest.qty) &&
        Objects.equals(this.notional, createOrderRequest.notional) &&
        Objects.equals(this.side, createOrderRequest.side) &&
        Objects.equals(this.type, createOrderRequest.type) &&
        Objects.equals(this.timeInForce, createOrderRequest.timeInForce) &&
        Objects.equals(this.limitPrice, createOrderRequest.limitPrice) &&
        Objects.equals(this.stopPrice, createOrderRequest.stopPrice) &&
        Objects.equals(this.trailPrice, createOrderRequest.trailPrice) &&
        Objects.equals(this.trailPercent, createOrderRequest.trailPercent) &&
        Objects.equals(this.extendedHours, createOrderRequest.extendedHours) &&
        Objects.equals(this.clientOrderId, createOrderRequest.clientOrderId) &&
        Objects.equals(this.orderClass, createOrderRequest.orderClass) &&
        Objects.equals(this.takeProfit, createOrderRequest.takeProfit) &&
        Objects.equals(this.stopLoss, createOrderRequest.stopLoss) &&
        Objects.equals(this.commission, createOrderRequest.commission) &&
        Objects.equals(this.commissionBps, createOrderRequest.commissionBps) &&
        Objects.equals(this.source, createOrderRequest.source) &&
        Objects.equals(this.instructions, createOrderRequest.instructions) &&
        Objects.equals(this.subtag, createOrderRequest.subtag) &&
        Objects.equals(this.swapFeeBps, createOrderRequest.swapFeeBps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, qty, notional, side, type, timeInForce, limitPrice, stopPrice, trailPrice, trailPercent, extendedHours, clientOrderId, orderClass, takeProfit, stopLoss, commission, commissionBps, source, instructions, subtag, swapFeeBps);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderRequest {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    notional: ").append(toIndentedString(notional)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    timeInForce: ").append(toIndentedString(timeInForce)).append("\n");
    sb.append("    limitPrice: ").append(toIndentedString(limitPrice)).append("\n");
    sb.append("    stopPrice: ").append(toIndentedString(stopPrice)).append("\n");
    sb.append("    trailPrice: ").append(toIndentedString(trailPrice)).append("\n");
    sb.append("    trailPercent: ").append(toIndentedString(trailPercent)).append("\n");
    sb.append("    extendedHours: ").append(toIndentedString(extendedHours)).append("\n");
    sb.append("    clientOrderId: ").append(toIndentedString(clientOrderId)).append("\n");
    sb.append("    orderClass: ").append(toIndentedString(orderClass)).append("\n");
    sb.append("    takeProfit: ").append(toIndentedString(takeProfit)).append("\n");
    sb.append("    stopLoss: ").append(toIndentedString(stopLoss)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    commissionBps: ").append(toIndentedString(commissionBps)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
    sb.append("    subtag: ").append(toIndentedString(subtag)).append("\n");
    sb.append("    swapFeeBps: ").append(toIndentedString(swapFeeBps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("notional");
    openapiFields.add("side");
    openapiFields.add("type");
    openapiFields.add("time_in_force");
    openapiFields.add("limit_price");
    openapiFields.add("stop_price");
    openapiFields.add("trail_price");
    openapiFields.add("trail_percent");
    openapiFields.add("extended_hours");
    openapiFields.add("client_order_id");
    openapiFields.add("order_class");
    openapiFields.add("take_profit");
    openapiFields.add("stop_loss");
    openapiFields.add("commission");
    openapiFields.add("commission_bps");
    openapiFields.add("source");
    openapiFields.add("instructions");
    openapiFields.add("subtag");
    openapiFields.add("swap_fee_bps");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("symbol");
    openapiRequiredFields.add("side");
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("time_in_force");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CreateOrderRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateOrderRequest is not found in the empty JSON string", CreateOrderRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CreateOrderRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateOrderRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CreateOrderRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("notional") != null && !jsonObj.get("notional").isJsonNull()) && !jsonObj.get("notional").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `notional` to be a primitive type in the JSON string but got `%s`", jsonObj.get("notional").toString()));
      }
      // validate the required field `side`
      OrderSide.validateJsonElement(jsonObj.get("side"));
      // validate the required field `type`
      OrderType.validateJsonElement(jsonObj.get("type"));
      // validate the required field `time_in_force`
      TimeInForce.validateJsonElement(jsonObj.get("time_in_force"));
      if ((jsonObj.get("limit_price") != null && !jsonObj.get("limit_price").isJsonNull()) && !jsonObj.get("limit_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `limit_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("limit_price").toString()));
      }
      if ((jsonObj.get("stop_price") != null && !jsonObj.get("stop_price").isJsonNull()) && !jsonObj.get("stop_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `stop_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("stop_price").toString()));
      }
      if ((jsonObj.get("trail_price") != null && !jsonObj.get("trail_price").isJsonNull()) && !jsonObj.get("trail_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail_price").toString()));
      }
      if ((jsonObj.get("trail_percent") != null && !jsonObj.get("trail_percent").isJsonNull()) && !jsonObj.get("trail_percent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trail_percent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trail_percent").toString()));
      }
      if ((jsonObj.get("client_order_id") != null && !jsonObj.get("client_order_id").isJsonNull()) && !jsonObj.get("client_order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_order_id").toString()));
      }
      // validate the optional field `order_class`
      if (jsonObj.get("order_class") != null && !jsonObj.get("order_class").isJsonNull()) {
        OrderClass.validateJsonElement(jsonObj.get("order_class"));
      }
      // validate the optional field `take_profit`
      if (jsonObj.get("take_profit") != null && !jsonObj.get("take_profit").isJsonNull()) {
        CreateOrderRequestTakeProfit.validateJsonElement(jsonObj.get("take_profit"));
      }
      // validate the optional field `stop_loss`
      if (jsonObj.get("stop_loss") != null && !jsonObj.get("stop_loss").isJsonNull()) {
        CreateOrderRequestStopLoss.validateJsonElement(jsonObj.get("stop_loss"));
      }
      if ((jsonObj.get("commission") != null && !jsonObj.get("commission").isJsonNull()) && !jsonObj.get("commission").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `commission` to be a primitive type in the JSON string but got `%s`", jsonObj.get("commission").toString()));
      }
      if ((jsonObj.get("commission_bps") != null && !jsonObj.get("commission_bps").isJsonNull()) && !jsonObj.get("commission_bps").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `commission_bps` to be a primitive type in the JSON string but got `%s`", jsonObj.get("commission_bps").toString()));
      }
      if ((jsonObj.get("source") != null && !jsonObj.get("source").isJsonNull()) && !jsonObj.get("source").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `source` to be a primitive type in the JSON string but got `%s`", jsonObj.get("source").toString()));
      }
      if ((jsonObj.get("instructions") != null && !jsonObj.get("instructions").isJsonNull()) && !jsonObj.get("instructions").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `instructions` to be a primitive type in the JSON string but got `%s`", jsonObj.get("instructions").toString()));
      }
      if ((jsonObj.get("subtag") != null && !jsonObj.get("subtag").isJsonNull()) && !jsonObj.get("subtag").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `subtag` to be a primitive type in the JSON string but got `%s`", jsonObj.get("subtag").toString()));
      }
      if ((jsonObj.get("swap_fee_bps") != null && !jsonObj.get("swap_fee_bps").isJsonNull()) && !jsonObj.get("swap_fee_bps").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `swap_fee_bps` to be a primitive type in the JSON string but got `%s`", jsonObj.get("swap_fee_bps").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateOrderRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateOrderRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateOrderRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateOrderRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateOrderRequest>() {
           @Override
           public void write(JsonWriter out, CreateOrderRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateOrderRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateOrderRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateOrderRequest
  * @throws IOException if the JSON string is invalid with respect to CreateOrderRequest
  */
  public static CreateOrderRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateOrderRequest.class);
  }

 /**
  * Convert an instance of CreateOrderRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

