/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalEntryType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Journals API allows you to move cash or securities from one account to another.  This model represents the fields you can specify when creating a Journal  Fixture Rules  - No Fixtures   - anything below limit is executed immediately   - anything above limit is pending until executed at EOD, - With Fixtures   - any status &#x3D; rejected will be rejected EOD   - any status &#x3D; pending will be pending forever
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CreateJournalRequest {
  public static final String SERIALIZED_NAME_TO_ACCOUNT = "to_account";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT)
  private UUID toAccount;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private UUID fromAccount;

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private JournalEntryType entryType;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private String amount;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_TRANSMITTER_NAME = "transmitter_name";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_NAME)
  private String transmitterName;

  public static final String SERIALIZED_NAME_TRANSMITTER_ACCOUNT_NUMBER = "transmitter_account_number";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_ACCOUNT_NUMBER)
  private String transmitterAccountNumber;

  public static final String SERIALIZED_NAME_TRANSMITTER_ADDRESS = "transmitter_address";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_ADDRESS)
  private String transmitterAddress;

  public static final String SERIALIZED_NAME_TRANSMITTER_FINANCIAL_INSTITUTION = "transmitter_financial_institution";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_FINANCIAL_INSTITUTION)
  private String transmitterFinancialInstitution;

  public static final String SERIALIZED_NAME_TRANSMITTER_TIMESTAMP = "transmitter_timestamp";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_TIMESTAMP)
  private OffsetDateTime transmitterTimestamp;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public CreateJournalRequest() {
  }

  public CreateJournalRequest toAccount(UUID toAccount) {
    this.toAccount = toAccount;
    return this;
  }

   /**
   * The account_id you wish to journal to
   * @return toAccount
  **/
  @javax.annotation.Nonnull
  public UUID getToAccount() {
    return toAccount;
  }

  public void setToAccount(UUID toAccount) {
    this.toAccount = toAccount;
  }


  public CreateJournalRequest fromAccount(UUID fromAccount) {
    this.fromAccount = fromAccount;
    return this;
  }

   /**
   * The account_id you wish to journal from
   * @return fromAccount
  **/
  @javax.annotation.Nonnull
  public UUID getFromAccount() {
    return fromAccount;
  }

  public void setFromAccount(UUID fromAccount) {
    this.fromAccount = fromAccount;
  }


  public CreateJournalRequest entryType(JournalEntryType entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * Get entryType
   * @return entryType
  **/
  @javax.annotation.Nonnull
  public JournalEntryType getEntryType() {
    return entryType;
  }

  public void setEntryType(JournalEntryType entryType) {
    this.entryType = entryType;
  }


  public CreateJournalRequest amount(String amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Required if &#x60;entry_type&#x60; &#x3D; &#x60;JNLC&#x60;
   * @return amount
  **/
  @javax.annotation.Nullable
  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }


  public CreateJournalRequest symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Required if &#x60;entry_type&#x60; &#x3D; &#x60;JNLS&#x60;
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public CreateJournalRequest qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Required if &#x60;entry_type&#x60; &#x3D; &#x60;JNLS&#x60;
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public CreateJournalRequest description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Max 1024 characters. Can include fixtures for amounts that are above the transaction limit
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public CreateJournalRequest transmitterName(String transmitterName) {
    this.transmitterName = transmitterName;
    return this;
  }

   /**
   * Max 255 characters. See more details about [Travel Rule](https://alpaca.markets/docs/broker/integration/funding/#travel-rule) in our main documentation.
   * @return transmitterName
  **/
  @javax.annotation.Nullable
  public String getTransmitterName() {
    return transmitterName;
  }

  public void setTransmitterName(String transmitterName) {
    this.transmitterName = transmitterName;
  }


  public CreateJournalRequest transmitterAccountNumber(String transmitterAccountNumber) {
    this.transmitterAccountNumber = transmitterAccountNumber;
    return this;
  }

   /**
   * Max 255 characters. See more details about [Travel Rule](https://alpaca.markets/docs/broker/integration/funding/#travel-rule) in our main documentation.
   * @return transmitterAccountNumber
  **/
  @javax.annotation.Nullable
  public String getTransmitterAccountNumber() {
    return transmitterAccountNumber;
  }

  public void setTransmitterAccountNumber(String transmitterAccountNumber) {
    this.transmitterAccountNumber = transmitterAccountNumber;
  }


  public CreateJournalRequest transmitterAddress(String transmitterAddress) {
    this.transmitterAddress = transmitterAddress;
    return this;
  }

   /**
   * Max 255 characters. See more details about [Travel Rule](https://alpaca.markets/docs/broker/integration/funding/#travel-rule) in our main documentation.
   * @return transmitterAddress
  **/
  @javax.annotation.Nullable
  public String getTransmitterAddress() {
    return transmitterAddress;
  }

  public void setTransmitterAddress(String transmitterAddress) {
    this.transmitterAddress = transmitterAddress;
  }


  public CreateJournalRequest transmitterFinancialInstitution(String transmitterFinancialInstitution) {
    this.transmitterFinancialInstitution = transmitterFinancialInstitution;
    return this;
  }

   /**
   * Max 255 characters. See more details about [Travel Rule](https://alpaca.markets/docs/broker/integration/funding/#travel-rule) in our main documentation.
   * @return transmitterFinancialInstitution
  **/
  @javax.annotation.Nullable
  public String getTransmitterFinancialInstitution() {
    return transmitterFinancialInstitution;
  }

  public void setTransmitterFinancialInstitution(String transmitterFinancialInstitution) {
    this.transmitterFinancialInstitution = transmitterFinancialInstitution;
  }


  public CreateJournalRequest transmitterTimestamp(OffsetDateTime transmitterTimestamp) {
    this.transmitterTimestamp = transmitterTimestamp;
    return this;
  }

   /**
   * RFC 3339 format. See more details about [Travel Rule](https://alpaca.markets/docs/broker/integration/funding/#travel-rule) in our main documentation.
   * @return transmitterTimestamp
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getTransmitterTimestamp() {
    return transmitterTimestamp;
  }

  public void setTransmitterTimestamp(OffsetDateTime transmitterTimestamp) {
    this.transmitterTimestamp = transmitterTimestamp;
  }


  public CreateJournalRequest currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateJournalRequest createJournalRequest = (CreateJournalRequest) o;
    return Objects.equals(this.toAccount, createJournalRequest.toAccount) &&
        Objects.equals(this.fromAccount, createJournalRequest.fromAccount) &&
        Objects.equals(this.entryType, createJournalRequest.entryType) &&
        Objects.equals(this.amount, createJournalRequest.amount) &&
        Objects.equals(this.symbol, createJournalRequest.symbol) &&
        Objects.equals(this.qty, createJournalRequest.qty) &&
        Objects.equals(this.description, createJournalRequest.description) &&
        Objects.equals(this.transmitterName, createJournalRequest.transmitterName) &&
        Objects.equals(this.transmitterAccountNumber, createJournalRequest.transmitterAccountNumber) &&
        Objects.equals(this.transmitterAddress, createJournalRequest.transmitterAddress) &&
        Objects.equals(this.transmitterFinancialInstitution, createJournalRequest.transmitterFinancialInstitution) &&
        Objects.equals(this.transmitterTimestamp, createJournalRequest.transmitterTimestamp) &&
        Objects.equals(this.currency, createJournalRequest.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(toAccount, fromAccount, entryType, amount, symbol, qty, description, transmitterName, transmitterAccountNumber, transmitterAddress, transmitterFinancialInstitution, transmitterTimestamp, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateJournalRequest {\n");
    sb.append("    toAccount: ").append(toIndentedString(toAccount)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    transmitterName: ").append(toIndentedString(transmitterName)).append("\n");
    sb.append("    transmitterAccountNumber: ").append(toIndentedString(transmitterAccountNumber)).append("\n");
    sb.append("    transmitterAddress: ").append(toIndentedString(transmitterAddress)).append("\n");
    sb.append("    transmitterFinancialInstitution: ").append(toIndentedString(transmitterFinancialInstitution)).append("\n");
    sb.append("    transmitterTimestamp: ").append(toIndentedString(transmitterTimestamp)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("to_account");
    openapiFields.add("from_account");
    openapiFields.add("entry_type");
    openapiFields.add("amount");
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("description");
    openapiFields.add("transmitter_name");
    openapiFields.add("transmitter_account_number");
    openapiFields.add("transmitter_address");
    openapiFields.add("transmitter_financial_institution");
    openapiFields.add("transmitter_timestamp");
    openapiFields.add("currency");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("to_account");
    openapiRequiredFields.add("from_account");
    openapiRequiredFields.add("entry_type");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CreateJournalRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateJournalRequest is not found in the empty JSON string", CreateJournalRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CreateJournalRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateJournalRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CreateJournalRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("to_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to_account").toString()));
      }
      if (!jsonObj.get("from_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from_account").toString()));
      }
      // validate the required field `entry_type`
      JournalEntryType.validateJsonElement(jsonObj.get("entry_type"));
      if ((jsonObj.get("amount") != null && !jsonObj.get("amount").isJsonNull()) && !jsonObj.get("amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("amount").toString()));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("transmitter_name") != null && !jsonObj.get("transmitter_name").isJsonNull()) && !jsonObj.get("transmitter_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_name").toString()));
      }
      if ((jsonObj.get("transmitter_account_number") != null && !jsonObj.get("transmitter_account_number").isJsonNull()) && !jsonObj.get("transmitter_account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_account_number").toString()));
      }
      if ((jsonObj.get("transmitter_address") != null && !jsonObj.get("transmitter_address").isJsonNull()) && !jsonObj.get("transmitter_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_address").toString()));
      }
      if ((jsonObj.get("transmitter_financial_institution") != null && !jsonObj.get("transmitter_financial_institution").isJsonNull()) && !jsonObj.get("transmitter_financial_institution").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_financial_institution` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_financial_institution").toString()));
      }
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateJournalRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateJournalRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateJournalRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateJournalRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateJournalRequest>() {
           @Override
           public void write(JsonWriter out, CreateJournalRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateJournalRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateJournalRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateJournalRequest
  * @throws IOException if the JSON string is invalid with respect to CreateJournalRequest
  */
  public static CreateJournalRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateJournalRequest.class);
  }

 /**
  * Convert an instance of CreateJournalRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

