/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.FundingDetailPaymentType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * CreateFundingWalletWithdrawalRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CreateFundingWalletWithdrawalRequest {
  public static final String SERIALIZED_NAME_USD_AMOUNT = "usd_amount";
  @SerializedName(SERIALIZED_NAME_USD_AMOUNT)
  private BigDecimal usdAmount;

  public static final String SERIALIZED_NAME_DESIRED_CURRENCY = "desired_currency";
  @SerializedName(SERIALIZED_NAME_DESIRED_CURRENCY)
  private String desiredCurrency;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE = "payment_type";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE)
  private FundingDetailPaymentType paymentType;

  public CreateFundingWalletWithdrawalRequest() {
  }

  public CreateFundingWalletWithdrawalRequest usdAmount(BigDecimal usdAmount) {
    this.usdAmount = usdAmount;
    return this;
  }

   /**
   * Get usdAmount
   * @return usdAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getUsdAmount() {
    return usdAmount;
  }

  public void setUsdAmount(BigDecimal usdAmount) {
    this.usdAmount = usdAmount;
  }


  public CreateFundingWalletWithdrawalRequest desiredCurrency(String desiredCurrency) {
    this.desiredCurrency = desiredCurrency;
    return this;
  }

   /**
   * Get desiredCurrency
   * @return desiredCurrency
  **/
  @javax.annotation.Nullable
  public String getDesiredCurrency() {
    return desiredCurrency;
  }

  public void setDesiredCurrency(String desiredCurrency) {
    this.desiredCurrency = desiredCurrency;
  }


  public CreateFundingWalletWithdrawalRequest paymentType(FundingDetailPaymentType paymentType) {
    this.paymentType = paymentType;
    return this;
  }

   /**
   * Get paymentType
   * @return paymentType
  **/
  @javax.annotation.Nullable
  public FundingDetailPaymentType getPaymentType() {
    return paymentType;
  }

  public void setPaymentType(FundingDetailPaymentType paymentType) {
    this.paymentType = paymentType;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateFundingWalletWithdrawalRequest createFundingWalletWithdrawalRequest = (CreateFundingWalletWithdrawalRequest) o;
    return Objects.equals(this.usdAmount, createFundingWalletWithdrawalRequest.usdAmount) &&
        Objects.equals(this.desiredCurrency, createFundingWalletWithdrawalRequest.desiredCurrency) &&
        Objects.equals(this.paymentType, createFundingWalletWithdrawalRequest.paymentType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(usdAmount, desiredCurrency, paymentType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateFundingWalletWithdrawalRequest {\n");
    sb.append("    usdAmount: ").append(toIndentedString(usdAmount)).append("\n");
    sb.append("    desiredCurrency: ").append(toIndentedString(desiredCurrency)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("usd_amount");
    openapiFields.add("desired_currency");
    openapiFields.add("payment_type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CreateFundingWalletWithdrawalRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateFundingWalletWithdrawalRequest is not found in the empty JSON string", CreateFundingWalletWithdrawalRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CreateFundingWalletWithdrawalRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateFundingWalletWithdrawalRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("usd_amount") != null && !jsonObj.get("usd_amount").isJsonNull()) && !jsonObj.get("usd_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `usd_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("usd_amount").toString()));
      }
      if ((jsonObj.get("desired_currency") != null && !jsonObj.get("desired_currency").isJsonNull()) && !jsonObj.get("desired_currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `desired_currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("desired_currency").toString()));
      }
      // validate the optional field `payment_type`
      if (jsonObj.get("payment_type") != null && !jsonObj.get("payment_type").isJsonNull()) {
        FundingDetailPaymentType.validateJsonElement(jsonObj.get("payment_type"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateFundingWalletWithdrawalRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateFundingWalletWithdrawalRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateFundingWalletWithdrawalRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateFundingWalletWithdrawalRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateFundingWalletWithdrawalRequest>() {
           @Override
           public void write(JsonWriter out, CreateFundingWalletWithdrawalRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateFundingWalletWithdrawalRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateFundingWalletWithdrawalRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateFundingWalletWithdrawalRequest
  * @throws IOException if the JSON string is invalid with respect to CreateFundingWalletWithdrawalRequest
  */
  public static CreateFundingWalletWithdrawalRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateFundingWalletWithdrawalRequest.class);
  }

 /**
  * Convert an instance of CreateFundingWalletWithdrawalRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

