/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents the fields used in creation of a new ACHRelationship.  You can create an ACHRelationship by passing the required fields here or if you have an account with Plaid you can use our integration with Plaid to create a relationship.  Please see the documentation [here](https://alpaca.markets/docs/api-references/broker-api/funding/ach/#plaid-integration-for-bank-transfers) for more info on using Plaid with Alpaca
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CreateACHRelationshipRequest {
  public static final String SERIALIZED_NAME_ACCOUNT_OWNER_NAME = "account_owner_name";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_OWNER_NAME)
  private String accountOwnerName;

  /**
   * Must be &#x60;CHECKING&#x60; or &#x60;SAVINGS&#x60;
   */
  @JsonAdapter(BankAccountTypeEnum.Adapter.class)
  public enum BankAccountTypeEnum {
    CHECKING("CHECKING"),
    
    SAVINGS("SAVINGS");

    private String value;

    BankAccountTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BankAccountTypeEnum fromValue(String value) {
      for (BankAccountTypeEnum b : BankAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<BankAccountTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BankAccountTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BankAccountTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BankAccountTypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      BankAccountTypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_BANK_ACCOUNT_TYPE = "bank_account_type";
  @SerializedName(SERIALIZED_NAME_BANK_ACCOUNT_TYPE)
  private BankAccountTypeEnum bankAccountType;

  public static final String SERIALIZED_NAME_BANK_ACCOUNT_NUMBER = "bank_account_number";
  @SerializedName(SERIALIZED_NAME_BANK_ACCOUNT_NUMBER)
  private String bankAccountNumber;

  public static final String SERIALIZED_NAME_BANK_ROUTING_NUMBER = "bank_routing_number";
  @SerializedName(SERIALIZED_NAME_BANK_ROUTING_NUMBER)
  private String bankRoutingNumber;

  public static final String SERIALIZED_NAME_NICKNAME = "nickname";
  @SerializedName(SERIALIZED_NAME_NICKNAME)
  private String nickname;

  public static final String SERIALIZED_NAME_PROCESSOR_TOKEN = "processor_token";
  @SerializedName(SERIALIZED_NAME_PROCESSOR_TOKEN)
  private String processorToken;

  public static final String SERIALIZED_NAME_INSTANT = "instant";
  @SerializedName(SERIALIZED_NAME_INSTANT)
  private Boolean instant;

  public CreateACHRelationshipRequest() {
  }

  public CreateACHRelationshipRequest accountOwnerName(String accountOwnerName) {
    this.accountOwnerName = accountOwnerName;
    return this;
  }

   /**
   * Get accountOwnerName
   * @return accountOwnerName
  **/
  @javax.annotation.Nonnull
  public String getAccountOwnerName() {
    return accountOwnerName;
  }

  public void setAccountOwnerName(String accountOwnerName) {
    this.accountOwnerName = accountOwnerName;
  }


  public CreateACHRelationshipRequest bankAccountType(BankAccountTypeEnum bankAccountType) {
    this.bankAccountType = bankAccountType;
    return this;
  }

   /**
   * Must be &#x60;CHECKING&#x60; or &#x60;SAVINGS&#x60;
   * @return bankAccountType
  **/
  @javax.annotation.Nonnull
  public BankAccountTypeEnum getBankAccountType() {
    return bankAccountType;
  }

  public void setBankAccountType(BankAccountTypeEnum bankAccountType) {
    this.bankAccountType = bankAccountType;
  }


  public CreateACHRelationshipRequest bankAccountNumber(String bankAccountNumber) {
    this.bankAccountNumber = bankAccountNumber;
    return this;
  }

   /**
   * In sandbox, this still must be a valid format
   * @return bankAccountNumber
  **/
  @javax.annotation.Nonnull
  public String getBankAccountNumber() {
    return bankAccountNumber;
  }

  public void setBankAccountNumber(String bankAccountNumber) {
    this.bankAccountNumber = bankAccountNumber;
  }


  public CreateACHRelationshipRequest bankRoutingNumber(String bankRoutingNumber) {
    this.bankRoutingNumber = bankRoutingNumber;
    return this;
  }

   /**
   * In sandbox, this still must be a valid format
   * @return bankRoutingNumber
  **/
  @javax.annotation.Nonnull
  public String getBankRoutingNumber() {
    return bankRoutingNumber;
  }

  public void setBankRoutingNumber(String bankRoutingNumber) {
    this.bankRoutingNumber = bankRoutingNumber;
  }


  public CreateACHRelationshipRequest nickname(String nickname) {
    this.nickname = nickname;
    return this;
  }

   /**
   * Get nickname
   * @return nickname
  **/
  @javax.annotation.Nullable
  public String getNickname() {
    return nickname;
  }

  public void setNickname(String nickname) {
    this.nickname = nickname;
  }


  public CreateACHRelationshipRequest processorToken(String processorToken) {
    this.processorToken = processorToken;
    return this;
  }

   /**
   * If using Plaid, you can specify a Plaid processor token here 
   * @return processorToken
  **/
  @javax.annotation.Nullable
  public String getProcessorToken() {
    return processorToken;
  }

  public void setProcessorToken(String processorToken) {
    this.processorToken = processorToken;
  }


  public CreateACHRelationshipRequest instant(Boolean instant) {
    this.instant = instant;
    return this;
  }

   /**
   * Get instant
   * @return instant
  **/
  @javax.annotation.Nullable
  public Boolean getInstant() {
    return instant;
  }

  public void setInstant(Boolean instant) {
    this.instant = instant;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateACHRelationshipRequest createACHRelationshipRequest = (CreateACHRelationshipRequest) o;
    return Objects.equals(this.accountOwnerName, createACHRelationshipRequest.accountOwnerName) &&
        Objects.equals(this.bankAccountType, createACHRelationshipRequest.bankAccountType) &&
        Objects.equals(this.bankAccountNumber, createACHRelationshipRequest.bankAccountNumber) &&
        Objects.equals(this.bankRoutingNumber, createACHRelationshipRequest.bankRoutingNumber) &&
        Objects.equals(this.nickname, createACHRelationshipRequest.nickname) &&
        Objects.equals(this.processorToken, createACHRelationshipRequest.processorToken) &&
        Objects.equals(this.instant, createACHRelationshipRequest.instant);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountOwnerName, bankAccountType, bankAccountNumber, bankRoutingNumber, nickname, processorToken, instant);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateACHRelationshipRequest {\n");
    sb.append("    accountOwnerName: ").append(toIndentedString(accountOwnerName)).append("\n");
    sb.append("    bankAccountType: ").append(toIndentedString(bankAccountType)).append("\n");
    sb.append("    bankAccountNumber: ").append(toIndentedString(bankAccountNumber)).append("\n");
    sb.append("    bankRoutingNumber: ").append(toIndentedString(bankRoutingNumber)).append("\n");
    sb.append("    nickname: ").append(toIndentedString(nickname)).append("\n");
    sb.append("    processorToken: ").append(toIndentedString(processorToken)).append("\n");
    sb.append("    instant: ").append(toIndentedString(instant)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_owner_name");
    openapiFields.add("bank_account_type");
    openapiFields.add("bank_account_number");
    openapiFields.add("bank_routing_number");
    openapiFields.add("nickname");
    openapiFields.add("processor_token");
    openapiFields.add("instant");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("account_owner_name");
    openapiRequiredFields.add("bank_account_type");
    openapiRequiredFields.add("bank_account_number");
    openapiRequiredFields.add("bank_routing_number");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CreateACHRelationshipRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CreateACHRelationshipRequest is not found in the empty JSON string", CreateACHRelationshipRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CreateACHRelationshipRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateACHRelationshipRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CreateACHRelationshipRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("account_owner_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_owner_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_owner_name").toString()));
      }
      if (!jsonObj.get("bank_account_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_account_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_account_type").toString()));
      }
      // validate the required field `bank_account_type`
      BankAccountTypeEnum.validateJsonElement(jsonObj.get("bank_account_type"));
      if (!jsonObj.get("bank_account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_account_number").toString()));
      }
      if (!jsonObj.get("bank_routing_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bank_routing_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bank_routing_number").toString()));
      }
      if ((jsonObj.get("nickname") != null && !jsonObj.get("nickname").isJsonNull()) && !jsonObj.get("nickname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `nickname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nickname").toString()));
      }
      if ((jsonObj.get("processor_token") != null && !jsonObj.get("processor_token").isJsonNull()) && !jsonObj.get("processor_token").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `processor_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get("processor_token").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CreateACHRelationshipRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CreateACHRelationshipRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CreateACHRelationshipRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CreateACHRelationshipRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<CreateACHRelationshipRequest>() {
           @Override
           public void write(JsonWriter out, CreateACHRelationshipRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CreateACHRelationshipRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CreateACHRelationshipRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CreateACHRelationshipRequest
  * @throws IOException if the JSON string is invalid with respect to CreateACHRelationshipRequest
  */
  public static CreateACHRelationshipRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CreateACHRelationshipRequest.class);
  }

 /**
  * Convert an instance of CreateACHRelationshipRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

