/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents the info for a country.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CountryInfo {
  public static final String SERIALIZED_NAME_FULL_NAME = "full_name";
  @SerializedName(SERIALIZED_NAME_FULL_NAME)
  private String fullName;

  /**
   * crypto risk rating of the country
   */
  @JsonAdapter(CryptoRiskRatingEnum.Adapter.class)
  public enum CryptoRiskRatingEnum {
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high"),
    
    PROHIBITED("prohibited");

    private String value;

    CryptoRiskRatingEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CryptoRiskRatingEnum fromValue(String value) {
      for (CryptoRiskRatingEnum b : CryptoRiskRatingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<CryptoRiskRatingEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CryptoRiskRatingEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CryptoRiskRatingEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CryptoRiskRatingEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      CryptoRiskRatingEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_CRYPTO_RISK_RATING = "crypto_risk_rating";
  @SerializedName(SERIALIZED_NAME_CRYPTO_RISK_RATING)
  private CryptoRiskRatingEnum cryptoRiskRating;

  /**
   * the securities risk rating of the country
   */
  @JsonAdapter(SecuritiesRiskRatingEnum.Adapter.class)
  public enum SecuritiesRiskRatingEnum {
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high"),
    
    PROHIBITED("prohibited");

    private String value;

    SecuritiesRiskRatingEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SecuritiesRiskRatingEnum fromValue(String value) {
      for (SecuritiesRiskRatingEnum b : SecuritiesRiskRatingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<SecuritiesRiskRatingEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SecuritiesRiskRatingEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SecuritiesRiskRatingEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return SecuritiesRiskRatingEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      SecuritiesRiskRatingEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_SECURITIES_RISK_RATING = "securities_risk_rating";
  @SerializedName(SERIALIZED_NAME_SECURITIES_RISK_RATING)
  private SecuritiesRiskRatingEnum securitiesRiskRating;

  public static final String SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES = "crypto_supported_states";
  @SerializedName(SERIALIZED_NAME_CRYPTO_SUPPORTED_STATES)
  private List<String> cryptoSupportedStates;

  public CountryInfo() {
  }

  public CountryInfo fullName(String fullName) {
    this.fullName = fullName;
    return this;
  }

   /**
   * The full name of the country definded by ISO 3166-1
   * @return fullName
  **/
  @javax.annotation.Nonnull
  public String getFullName() {
    return fullName;
  }

  public void setFullName(String fullName) {
    this.fullName = fullName;
  }


  public CountryInfo cryptoRiskRating(CryptoRiskRatingEnum cryptoRiskRating) {
    this.cryptoRiskRating = cryptoRiskRating;
    return this;
  }

   /**
   * crypto risk rating of the country
   * @return cryptoRiskRating
  **/
  @javax.annotation.Nonnull
  public CryptoRiskRatingEnum getCryptoRiskRating() {
    return cryptoRiskRating;
  }

  public void setCryptoRiskRating(CryptoRiskRatingEnum cryptoRiskRating) {
    this.cryptoRiskRating = cryptoRiskRating;
  }


  public CountryInfo securitiesRiskRating(SecuritiesRiskRatingEnum securitiesRiskRating) {
    this.securitiesRiskRating = securitiesRiskRating;
    return this;
  }

   /**
   * the securities risk rating of the country
   * @return securitiesRiskRating
  **/
  @javax.annotation.Nonnull
  public SecuritiesRiskRatingEnum getSecuritiesRiskRating() {
    return securitiesRiskRating;
  }

  public void setSecuritiesRiskRating(SecuritiesRiskRatingEnum securitiesRiskRating) {
    this.securitiesRiskRating = securitiesRiskRating;
  }


  public CountryInfo cryptoSupportedStates(List<String> cryptoSupportedStates) {
    this.cryptoSupportedStates = cryptoSupportedStates;
    return this;
  }

  public CountryInfo addCryptoSupportedStatesItem(String cryptoSupportedStatesItem) {
    if (this.cryptoSupportedStates == null) {
      this.cryptoSupportedStates = new ArrayList<>();
    }
    this.cryptoSupportedStates.add(cryptoSupportedStatesItem);
    return this;
  }

   /**
   * states where Alpaca supports crypto trading
   * @return cryptoSupportedStates
  **/
  @javax.annotation.Nullable
  public List<String> getCryptoSupportedStates() {
    return cryptoSupportedStates;
  }

  public void setCryptoSupportedStates(List<String> cryptoSupportedStates) {
    this.cryptoSupportedStates = cryptoSupportedStates;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CountryInfo countryInfo = (CountryInfo) o;
    return Objects.equals(this.fullName, countryInfo.fullName) &&
        Objects.equals(this.cryptoRiskRating, countryInfo.cryptoRiskRating) &&
        Objects.equals(this.securitiesRiskRating, countryInfo.securitiesRiskRating) &&
        Objects.equals(this.cryptoSupportedStates, countryInfo.cryptoSupportedStates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fullName, cryptoRiskRating, securitiesRiskRating, cryptoSupportedStates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CountryInfo {\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    cryptoRiskRating: ").append(toIndentedString(cryptoRiskRating)).append("\n");
    sb.append("    securitiesRiskRating: ").append(toIndentedString(securitiesRiskRating)).append("\n");
    sb.append("    cryptoSupportedStates: ").append(toIndentedString(cryptoSupportedStates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("full_name");
    openapiFields.add("crypto_risk_rating");
    openapiFields.add("securities_risk_rating");
    openapiFields.add("crypto_supported_states");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("full_name");
    openapiRequiredFields.add("crypto_risk_rating");
    openapiRequiredFields.add("securities_risk_rating");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CountryInfo.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CountryInfo is not found in the empty JSON string", CountryInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CountryInfo.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CountryInfo` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CountryInfo.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("full_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `full_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("full_name").toString()));
      }
      if (!jsonObj.get("crypto_risk_rating").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `crypto_risk_rating` to be a primitive type in the JSON string but got `%s`", jsonObj.get("crypto_risk_rating").toString()));
      }
      // validate the required field `crypto_risk_rating`
      CryptoRiskRatingEnum.validateJsonElement(jsonObj.get("crypto_risk_rating"));
      if (!jsonObj.get("securities_risk_rating").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `securities_risk_rating` to be a primitive type in the JSON string but got `%s`", jsonObj.get("securities_risk_rating").toString()));
      }
      // validate the required field `securities_risk_rating`
      SecuritiesRiskRatingEnum.validateJsonElement(jsonObj.get("securities_risk_rating"));
      // ensure the optional json data is an array if present
      if (jsonObj.get("crypto_supported_states") != null && !jsonObj.get("crypto_supported_states").isJsonNull() && !jsonObj.get("crypto_supported_states").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `crypto_supported_states` to be an array in the JSON string but got `%s`", jsonObj.get("crypto_supported_states").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CountryInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CountryInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CountryInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CountryInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<CountryInfo>() {
           @Override
           public void write(JsonWriter out, CountryInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CountryInfo read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CountryInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CountryInfo
  * @throws IOException if the JSON string is invalid with respect to CountryInfo
  */
  public static CountryInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CountryInfo.class);
  }

 /**
  * Convert an instance of CountryInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

