/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents the current market time and open/close events.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Clock {
  public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
  @SerializedName(SERIALIZED_NAME_TIMESTAMP)
  private OffsetDateTime timestamp;

  public static final String SERIALIZED_NAME_IS_OPEN = "is_open";
  @SerializedName(SERIALIZED_NAME_IS_OPEN)
  private Boolean isOpen;

  public static final String SERIALIZED_NAME_NEXT_OPEN = "next_open";
  @SerializedName(SERIALIZED_NAME_NEXT_OPEN)
  private OffsetDateTime nextOpen;

  public static final String SERIALIZED_NAME_NEXT_CLOSE = "next_close";
  @SerializedName(SERIALIZED_NAME_NEXT_CLOSE)
  private OffsetDateTime nextClose;

  public Clock() {
  }

  public Clock timestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Current timestamp
   * @return timestamp
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = timestamp;
  }


  public Clock isOpen(Boolean isOpen) {
    this.isOpen = isOpen;
    return this;
  }

   /**
   * Whether the market is open or not
   * @return isOpen
  **/
  @javax.annotation.Nonnull
  public Boolean getIsOpen() {
    return isOpen;
  }

  public void setIsOpen(Boolean isOpen) {
    this.isOpen = isOpen;
  }


  public Clock nextOpen(OffsetDateTime nextOpen) {
    this.nextOpen = nextOpen;
    return this;
  }

   /**
   * Next market open timestamp - inclusive of timestamp
   * @return nextOpen
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getNextOpen() {
    return nextOpen;
  }

  public void setNextOpen(OffsetDateTime nextOpen) {
    this.nextOpen = nextOpen;
  }


  public Clock nextClose(OffsetDateTime nextClose) {
    this.nextClose = nextClose;
    return this;
  }

   /**
   * Next market close timestamp - inclusive of timestamp
   * @return nextClose
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getNextClose() {
    return nextClose;
  }

  public void setNextClose(OffsetDateTime nextClose) {
    this.nextClose = nextClose;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Clock clock = (Clock) o;
    return Objects.equals(this.timestamp, clock.timestamp) &&
        Objects.equals(this.isOpen, clock.isOpen) &&
        Objects.equals(this.nextOpen, clock.nextOpen) &&
        Objects.equals(this.nextClose, clock.nextClose);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timestamp, isOpen, nextOpen, nextClose);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Clock {\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    isOpen: ").append(toIndentedString(isOpen)).append("\n");
    sb.append("    nextOpen: ").append(toIndentedString(nextOpen)).append("\n");
    sb.append("    nextClose: ").append(toIndentedString(nextClose)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("timestamp");
    openapiFields.add("is_open");
    openapiFields.add("next_open");
    openapiFields.add("next_close");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("timestamp");
    openapiRequiredFields.add("is_open");
    openapiRequiredFields.add("next_open");
    openapiRequiredFields.add("next_close");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Clock.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Clock is not found in the empty JSON string", Clock.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Clock.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Clock` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Clock.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Clock.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Clock' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Clock> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Clock.class));

       return (TypeAdapter<T>) new TypeAdapter<Clock>() {
           @Override
           public void write(JsonWriter out, Clock value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Clock read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Clock given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Clock
  * @throws IOException if the JSON string is invalid with respect to Clock
  */
  public static Clock fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Clock.class);
  }

 /**
  * Convert an instance of Clock to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

