/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * The calendar API serves the full list of market days from 1970 to 2029. It can also be queried by specifying a start and/or end time to narrow down the results. In addition to the dates, the response also contains the specific open and close times for the market days, taking into account early closures.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Calendar {
  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_OPEN = "open";
  @SerializedName(SERIALIZED_NAME_OPEN)
  private String open;

  public static final String SERIALIZED_NAME_CLOSE = "close";
  @SerializedName(SERIALIZED_NAME_CLOSE)
  private String close;

  public static final String SERIALIZED_NAME_SESSION_OPEN = "session_open";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_SESSION_OPEN)
  private String sessionOpen;

  public static final String SERIALIZED_NAME_SESSION_CLOSE = "session_close";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_SESSION_CLOSE)
  private String sessionClose;

  public static final String SERIALIZED_NAME_SETTLEMENT_DATE = "settlement_date";
  @SerializedName(SERIALIZED_NAME_SETTLEMENT_DATE)
  private String settlementDate;

  public Calendar() {
  }

  public Calendar date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * Date string in YYYY-MM-DD format
   * @return date
  **/
  @javax.annotation.Nonnull
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }


  public Calendar open(String open) {
    this.open = open;
    return this;
  }

   /**
   * The time the market opens at on this date in HH:MM format
   * @return open
  **/
  @javax.annotation.Nonnull
  public String getOpen() {
    return open;
  }

  public void setOpen(String open) {
    this.open = open;
  }


  public Calendar close(String close) {
    this.close = close;
    return this;
  }

   /**
   * The time the market closes at on this date in HH:MM format
   * @return close
  **/
  @javax.annotation.Nonnull
  public String getClose() {
    return close;
  }

  public void setClose(String close) {
    this.close = close;
  }


  @Deprecated
  public Calendar sessionOpen(String sessionOpen) {
    this.sessionOpen = sessionOpen;
    return this;
  }

   /**
   * this field has been deprecated please ignore
   * @return sessionOpen
   * @deprecated
  **/
  @Deprecated
  @javax.annotation.Nullable
  public String getSessionOpen() {
    return sessionOpen;
  }

  @Deprecated
  public void setSessionOpen(String sessionOpen) {
    this.sessionOpen = sessionOpen;
  }


  @Deprecated
  public Calendar sessionClose(String sessionClose) {
    this.sessionClose = sessionClose;
    return this;
  }

   /**
   * this field has been deprecated please ignore
   * @return sessionClose
   * @deprecated
  **/
  @Deprecated
  @javax.annotation.Nullable
  public String getSessionClose() {
    return sessionClose;
  }

  @Deprecated
  public void setSessionClose(String sessionClose) {
    this.sessionClose = sessionClose;
  }


  public Calendar settlementDate(String settlementDate) {
    this.settlementDate = settlementDate;
    return this;
  }

   /**
   * Date string in “%Y-%m-%d” format. representing the settlement date for the trade date
   * @return settlementDate
  **/
  @javax.annotation.Nullable
  public String getSettlementDate() {
    return settlementDate;
  }

  public void setSettlementDate(String settlementDate) {
    this.settlementDate = settlementDate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Calendar calendar = (Calendar) o;
    return Objects.equals(this.date, calendar.date) &&
        Objects.equals(this.open, calendar.open) &&
        Objects.equals(this.close, calendar.close) &&
        Objects.equals(this.sessionOpen, calendar.sessionOpen) &&
        Objects.equals(this.sessionClose, calendar.sessionClose) &&
        Objects.equals(this.settlementDate, calendar.settlementDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, open, close, sessionOpen, sessionClose, settlementDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Calendar {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    open: ").append(toIndentedString(open)).append("\n");
    sb.append("    close: ").append(toIndentedString(close)).append("\n");
    sb.append("    sessionOpen: ").append(toIndentedString(sessionOpen)).append("\n");
    sb.append("    sessionClose: ").append(toIndentedString(sessionClose)).append("\n");
    sb.append("    settlementDate: ").append(toIndentedString(settlementDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("date");
    openapiFields.add("open");
    openapiFields.add("close");
    openapiFields.add("session_open");
    openapiFields.add("session_close");
    openapiFields.add("settlement_date");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("date");
    openapiRequiredFields.add("open");
    openapiRequiredFields.add("close");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Calendar.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Calendar is not found in the empty JSON string", Calendar.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Calendar.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Calendar` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Calendar.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("open").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `open` to be a primitive type in the JSON string but got `%s`", jsonObj.get("open").toString()));
      }
      if (!jsonObj.get("close").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `close` to be a primitive type in the JSON string but got `%s`", jsonObj.get("close").toString()));
      }
      if ((jsonObj.get("session_open") != null && !jsonObj.get("session_open").isJsonNull()) && !jsonObj.get("session_open").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `session_open` to be a primitive type in the JSON string but got `%s`", jsonObj.get("session_open").toString()));
      }
      if ((jsonObj.get("session_close") != null && !jsonObj.get("session_close").isJsonNull()) && !jsonObj.get("session_close").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `session_close` to be a primitive type in the JSON string but got `%s`", jsonObj.get("session_close").toString()));
      }
      if ((jsonObj.get("settlement_date") != null && !jsonObj.get("settlement_date").isJsonNull()) && !jsonObj.get("settlement_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `settlement_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("settlement_date").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Calendar.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Calendar' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Calendar> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Calendar.class));

       return (TypeAdapter<T>) new TypeAdapter<Calendar>() {
           @Override
           public void write(JsonWriter out, Calendar value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Calendar read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Calendar given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Calendar
  * @throws IOException if the JSON string is invalid with respect to Calendar
  */
  public static Calendar fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Calendar.class);
  }

 /**
  * Convert an instance of Calendar to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

