/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents Know Your Customer (KYC) info for a CIPInfo
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CIPKYC {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_RISK_SCORE = "risk_score";
  @SerializedName(SERIALIZED_NAME_RISK_SCORE)
  private String riskScore;

  public static final String SERIALIZED_NAME_RISK_LEVEL = "risk_level";
  @SerializedName(SERIALIZED_NAME_RISK_LEVEL)
  private String riskLevel;

  public static final String SERIALIZED_NAME_RISK_CATEGORIES = "risk_categories";
  @SerializedName(SERIALIZED_NAME_RISK_CATEGORIES)
  private List<String> riskCategories;

  public static final String SERIALIZED_NAME_APPLICANT_NAME = "applicant_name";
  @SerializedName(SERIALIZED_NAME_APPLICANT_NAME)
  private String applicantName;

  public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
  @SerializedName(SERIALIZED_NAME_EMAIL_ADDRESS)
  private String emailAddress;

  public static final String SERIALIZED_NAME_NATIONALITY = "nationality";
  @SerializedName(SERIALIZED_NAME_NATIONALITY)
  private String nationality;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_ADDRESS = "address";
  @SerializedName(SERIALIZED_NAME_ADDRESS)
  private String address;

  public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
  @SerializedName(SERIALIZED_NAME_POSTAL_CODE)
  private String postalCode;

  public static final String SERIALIZED_NAME_COUNTRY_OF_RESIDENCY = "country_of_residency";
  @SerializedName(SERIALIZED_NAME_COUNTRY_OF_RESIDENCY)
  private String countryOfResidency;

  public static final String SERIALIZED_NAME_KYC_COMPLETED_AT = "kyc_completed_at";
  @SerializedName(SERIALIZED_NAME_KYC_COMPLETED_AT)
  private OffsetDateTime kycCompletedAt;

  public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
  @SerializedName(SERIALIZED_NAME_IP_ADDRESS)
  private String ipAddress;

  public static final String SERIALIZED_NAME_CHECK_INITIATED_AT = "check_initiated_at";
  @SerializedName(SERIALIZED_NAME_CHECK_INITIATED_AT)
  private OffsetDateTime checkInitiatedAt;

  public static final String SERIALIZED_NAME_CHECK_COMPLETED_AT = "check_completed_at";
  @SerializedName(SERIALIZED_NAME_CHECK_COMPLETED_AT)
  private OffsetDateTime checkCompletedAt;

  public static final String SERIALIZED_NAME_APPROVAL_STATUS = "approval_status";
  @SerializedName(SERIALIZED_NAME_APPROVAL_STATUS)
  private String approvalStatus;

  public static final String SERIALIZED_NAME_APPROVED_BY = "approved_by";
  @SerializedName(SERIALIZED_NAME_APPROVED_BY)
  private String approvedBy;

  public static final String SERIALIZED_NAME_APPROVED_AT = "approved_at";
  @SerializedName(SERIALIZED_NAME_APPROVED_AT)
  private OffsetDateTime approvedAt;

  public static final String SERIALIZED_NAME_APPROVED_REASON = "approved_reason";
  @SerializedName(SERIALIZED_NAME_APPROVED_REASON)
  private String approvedReason;

  public CIPKYC() {
  }

  public CIPKYC id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Your internal ID of check
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public CIPKYC riskScore(String riskScore) {
    this.riskScore = riskScore;
    return this;
  }

   /**
   * Overall risk score returned by KYC provider or assessed
   * @return riskScore
  **/
  @javax.annotation.Nullable
  public String getRiskScore() {
    return riskScore;
  }

  public void setRiskScore(String riskScore) {
    this.riskScore = riskScore;
  }


  public CIPKYC riskLevel(String riskLevel) {
    this.riskLevel = riskLevel;
    return this;
  }

   /**
   * Overall risk level returned by KYC provider or assessed
   * @return riskLevel
  **/
  @javax.annotation.Nullable
  public String getRiskLevel() {
    return riskLevel;
  }

  public void setRiskLevel(String riskLevel) {
    this.riskLevel = riskLevel;
  }


  public CIPKYC riskCategories(List<String> riskCategories) {
    this.riskCategories = riskCategories;
    return this;
  }

  public CIPKYC addRiskCategoriesItem(String riskCategoriesItem) {
    if (this.riskCategories == null) {
      this.riskCategories = new ArrayList<>();
    }
    this.riskCategories.add(riskCategoriesItem);
    return this;
  }

   /**
   * The list of risk categories returned by the KYC provider or assessed
   * @return riskCategories
  **/
  @javax.annotation.Nullable
  public List<String> getRiskCategories() {
    return riskCategories;
  }

  public void setRiskCategories(List<String> riskCategories) {
    this.riskCategories = riskCategories;
  }


  public CIPKYC applicantName(String applicantName) {
    this.applicantName = applicantName;
    return this;
  }

   /**
   * Given and family name of applicant
   * @return applicantName
  **/
  @javax.annotation.Nullable
  public String getApplicantName() {
    return applicantName;
  }

  public void setApplicantName(String applicantName) {
    this.applicantName = applicantName;
  }


  public CIPKYC emailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

   /**
   * email address of applicant
   * @return emailAddress
  **/
  @javax.annotation.Nullable
  public String getEmailAddress() {
    return emailAddress;
  }

  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }


  public CIPKYC nationality(String nationality) {
    this.nationality = nationality;
    return this;
  }

   /**
   * nationality of applicant
   * @return nationality
  **/
  @javax.annotation.Nullable
  public String getNationality() {
    return nationality;
  }

  public void setNationality(String nationality) {
    this.nationality = nationality;
  }


  public CIPKYC dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * DOB of applicant
   * @return dateOfBirth
  **/
  @javax.annotation.Nullable
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public CIPKYC address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Concatenated street address, city, state and country of applicant
   * @return address
  **/
  @javax.annotation.Nullable
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }


  public CIPKYC postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

   /**
   * postal code for &#x60;address&#x60; field
   * @return postalCode
  **/
  @javax.annotation.Nullable
  public String getPostalCode() {
    return postalCode;
  }

  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public CIPKYC countryOfResidency(String countryOfResidency) {
    this.countryOfResidency = countryOfResidency;
    return this;
  }

   /**
   * country for &#x60;address&#x60; field
   * @return countryOfResidency
  **/
  @javax.annotation.Nullable
  public String getCountryOfResidency() {
    return countryOfResidency;
  }

  public void setCountryOfResidency(String countryOfResidency) {
    this.countryOfResidency = countryOfResidency;
  }


  public CIPKYC kycCompletedAt(OffsetDateTime kycCompletedAt) {
    this.kycCompletedAt = kycCompletedAt;
    return this;
  }

   /**
   * Datetime that KYC check was completed at
   * @return kycCompletedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getKycCompletedAt() {
    return kycCompletedAt;
  }

  public void setKycCompletedAt(OffsetDateTime kycCompletedAt) {
    this.kycCompletedAt = kycCompletedAt;
  }


  public CIPKYC ipAddress(String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * IP address of applicant at time of KYC check
   * @return ipAddress
  **/
  @javax.annotation.Nullable
  public String getIpAddress() {
    return ipAddress;
  }

  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public CIPKYC checkInitiatedAt(OffsetDateTime checkInitiatedAt) {
    this.checkInitiatedAt = checkInitiatedAt;
    return this;
  }

   /**
   * start datetime of KYC check
   * @return checkInitiatedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCheckInitiatedAt() {
    return checkInitiatedAt;
  }

  public void setCheckInitiatedAt(OffsetDateTime checkInitiatedAt) {
    this.checkInitiatedAt = checkInitiatedAt;
  }


  public CIPKYC checkCompletedAt(OffsetDateTime checkCompletedAt) {
    this.checkCompletedAt = checkCompletedAt;
    return this;
  }

   /**
   * completion datetime of KYC check
   * @return checkCompletedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCheckCompletedAt() {
    return checkCompletedAt;
  }

  public void setCheckCompletedAt(OffsetDateTime checkCompletedAt) {
    this.checkCompletedAt = checkCompletedAt;
  }


  public CIPKYC approvalStatus(String approvalStatus) {
    this.approvalStatus = approvalStatus;
    return this;
  }

   /**
   * Approval status of KYC check
   * @return approvalStatus
  **/
  @javax.annotation.Nullable
  public String getApprovalStatus() {
    return approvalStatus;
  }

  public void setApprovalStatus(String approvalStatus) {
    this.approvalStatus = approvalStatus;
  }


  public CIPKYC approvedBy(String approvedBy) {
    this.approvedBy = approvedBy;
    return this;
  }

   /**
   * Identifier of who approved KYC check
   * @return approvedBy
  **/
  @javax.annotation.Nullable
  public String getApprovedBy() {
    return approvedBy;
  }

  public void setApprovedBy(String approvedBy) {
    this.approvedBy = approvedBy;
  }


  public CIPKYC approvedAt(OffsetDateTime approvedAt) {
    this.approvedAt = approvedAt;
    return this;
  }

   /**
   * Reason for approving this KYC check
   * @return approvedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getApprovedAt() {
    return approvedAt;
  }

  public void setApprovedAt(OffsetDateTime approvedAt) {
    this.approvedAt = approvedAt;
  }


  public CIPKYC approvedReason(String approvedReason) {
    this.approvedReason = approvedReason;
    return this;
  }

   /**
   * Datetime that this KYC check was approved
   * @return approvedReason
  **/
  @javax.annotation.Nullable
  public String getApprovedReason() {
    return approvedReason;
  }

  public void setApprovedReason(String approvedReason) {
    this.approvedReason = approvedReason;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CIPKYC CIPKYC = (CIPKYC) o;
    return Objects.equals(this.id, CIPKYC.id) &&
        Objects.equals(this.riskScore, CIPKYC.riskScore) &&
        Objects.equals(this.riskLevel, CIPKYC.riskLevel) &&
        Objects.equals(this.riskCategories, CIPKYC.riskCategories) &&
        Objects.equals(this.applicantName, CIPKYC.applicantName) &&
        Objects.equals(this.emailAddress, CIPKYC.emailAddress) &&
        Objects.equals(this.nationality, CIPKYC.nationality) &&
        Objects.equals(this.dateOfBirth, CIPKYC.dateOfBirth) &&
        Objects.equals(this.address, CIPKYC.address) &&
        Objects.equals(this.postalCode, CIPKYC.postalCode) &&
        Objects.equals(this.countryOfResidency, CIPKYC.countryOfResidency) &&
        Objects.equals(this.kycCompletedAt, CIPKYC.kycCompletedAt) &&
        Objects.equals(this.ipAddress, CIPKYC.ipAddress) &&
        Objects.equals(this.checkInitiatedAt, CIPKYC.checkInitiatedAt) &&
        Objects.equals(this.checkCompletedAt, CIPKYC.checkCompletedAt) &&
        Objects.equals(this.approvalStatus, CIPKYC.approvalStatus) &&
        Objects.equals(this.approvedBy, CIPKYC.approvedBy) &&
        Objects.equals(this.approvedAt, CIPKYC.approvedAt) &&
        Objects.equals(this.approvedReason, CIPKYC.approvedReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, riskScore, riskLevel, riskCategories, applicantName, emailAddress, nationality, dateOfBirth, address, postalCode, countryOfResidency, kycCompletedAt, ipAddress, checkInitiatedAt, checkCompletedAt, approvalStatus, approvedBy, approvedAt, approvedReason);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CIPKYC {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    riskScore: ").append(toIndentedString(riskScore)).append("\n");
    sb.append("    riskLevel: ").append(toIndentedString(riskLevel)).append("\n");
    sb.append("    riskCategories: ").append(toIndentedString(riskCategories)).append("\n");
    sb.append("    applicantName: ").append(toIndentedString(applicantName)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    nationality: ").append(toIndentedString(nationality)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    countryOfResidency: ").append(toIndentedString(countryOfResidency)).append("\n");
    sb.append("    kycCompletedAt: ").append(toIndentedString(kycCompletedAt)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    checkInitiatedAt: ").append(toIndentedString(checkInitiatedAt)).append("\n");
    sb.append("    checkCompletedAt: ").append(toIndentedString(checkCompletedAt)).append("\n");
    sb.append("    approvalStatus: ").append(toIndentedString(approvalStatus)).append("\n");
    sb.append("    approvedBy: ").append(toIndentedString(approvedBy)).append("\n");
    sb.append("    approvedAt: ").append(toIndentedString(approvedAt)).append("\n");
    sb.append("    approvedReason: ").append(toIndentedString(approvedReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("risk_score");
    openapiFields.add("risk_level");
    openapiFields.add("risk_categories");
    openapiFields.add("applicant_name");
    openapiFields.add("email_address");
    openapiFields.add("nationality");
    openapiFields.add("date_of_birth");
    openapiFields.add("address");
    openapiFields.add("postal_code");
    openapiFields.add("country_of_residency");
    openapiFields.add("kyc_completed_at");
    openapiFields.add("ip_address");
    openapiFields.add("check_initiated_at");
    openapiFields.add("check_completed_at");
    openapiFields.add("approval_status");
    openapiFields.add("approved_by");
    openapiFields.add("approved_at");
    openapiFields.add("approved_reason");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CIPKYC.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CIPKYC is not found in the empty JSON string", CIPKYC.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CIPKYC.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CIPKYC` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CIPKYC.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("risk_score") != null && !jsonObj.get("risk_score").isJsonNull()) && !jsonObj.get("risk_score").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `risk_score` to be a primitive type in the JSON string but got `%s`", jsonObj.get("risk_score").toString()));
      }
      if ((jsonObj.get("risk_level") != null && !jsonObj.get("risk_level").isJsonNull()) && !jsonObj.get("risk_level").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `risk_level` to be a primitive type in the JSON string but got `%s`", jsonObj.get("risk_level").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("risk_categories") != null && !jsonObj.get("risk_categories").isJsonNull() && !jsonObj.get("risk_categories").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `risk_categories` to be an array in the JSON string but got `%s`", jsonObj.get("risk_categories").toString()));
      }
      if ((jsonObj.get("applicant_name") != null && !jsonObj.get("applicant_name").isJsonNull()) && !jsonObj.get("applicant_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `applicant_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("applicant_name").toString()));
      }
      if ((jsonObj.get("email_address") != null && !jsonObj.get("email_address").isJsonNull()) && !jsonObj.get("email_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `email_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("email_address").toString()));
      }
      if ((jsonObj.get("nationality") != null && !jsonObj.get("nationality").isJsonNull()) && !jsonObj.get("nationality").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `nationality` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nationality").toString()));
      }
      if ((jsonObj.get("address") != null && !jsonObj.get("address").isJsonNull()) && !jsonObj.get("address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("address").toString()));
      }
      if ((jsonObj.get("postal_code") != null && !jsonObj.get("postal_code").isJsonNull()) && !jsonObj.get("postal_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `postal_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("postal_code").toString()));
      }
      if ((jsonObj.get("country_of_residency") != null && !jsonObj.get("country_of_residency").isJsonNull()) && !jsonObj.get("country_of_residency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country_of_residency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country_of_residency").toString()));
      }
      if ((jsonObj.get("ip_address") != null && !jsonObj.get("ip_address").isJsonNull()) && !jsonObj.get("ip_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ip_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ip_address").toString()));
      }
      if ((jsonObj.get("approval_status") != null && !jsonObj.get("approval_status").isJsonNull()) && !jsonObj.get("approval_status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `approval_status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("approval_status").toString()));
      }
      if ((jsonObj.get("approved_by") != null && !jsonObj.get("approved_by").isJsonNull()) && !jsonObj.get("approved_by").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `approved_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get("approved_by").toString()));
      }
      if ((jsonObj.get("approved_reason") != null && !jsonObj.get("approved_reason").isJsonNull()) && !jsonObj.get("approved_reason").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `approved_reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("approved_reason").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CIPKYC.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CIPKYC' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CIPKYC> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CIPKYC.class));

       return (TypeAdapter<T>) new TypeAdapter<CIPKYC>() {
           @Override
           public void write(JsonWriter out, CIPKYC value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CIPKYC read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CIPKYC given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CIPKYC
  * @throws IOException if the JSON string is invalid with respect to CIPKYC
  */
  public static CIPKYC fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CIPKYC.class);
  }

 /**
  * Convert an instance of CIPKYC to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

