/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPDocument;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPIdentity;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPKYC;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPPhoto;
import net.jacobpeterson.alpaca.openapi.broker.model.CIPWatchlist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Customer Identification Program (CIP) information for an account applicant.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CIPInfo {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private UUID accountId;

  public static final String SERIALIZED_NAME_PROVIDER_NAME = "provider_name";
  @SerializedName(SERIALIZED_NAME_PROVIDER_NAME)
  private List<String> providerName;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_KYC = "kyc";
  @SerializedName(SERIALIZED_NAME_KYC)
  private CIPKYC kyc;

  public static final String SERIALIZED_NAME_DOCUMENT = "document";
  @SerializedName(SERIALIZED_NAME_DOCUMENT)
  private CIPDocument document;

  public static final String SERIALIZED_NAME_PHOTO = "photo";
  @SerializedName(SERIALIZED_NAME_PHOTO)
  private CIPPhoto photo;

  public static final String SERIALIZED_NAME_IDENTITY = "identity";
  @SerializedName(SERIALIZED_NAME_IDENTITY)
  private CIPIdentity identity;

  public static final String SERIALIZED_NAME_WATCHLIST = "watchlist";
  @SerializedName(SERIALIZED_NAME_WATCHLIST)
  private CIPWatchlist watchlist;

  public CIPInfo() {
  }

  public CIPInfo id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * ID of this CIPInfo
   * @return id
  **/
  @javax.annotation.Nullable
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public CIPInfo accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * UUID of the Account instance this CIPInfo is for
   * @return accountId
  **/
  @javax.annotation.Nullable
  public UUID getAccountId() {
    return accountId;
  }

  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }


  public CIPInfo providerName(List<String> providerName) {
    this.providerName = providerName;
    return this;
  }

  public CIPInfo addProviderNameItem(String providerNameItem) {
    if (this.providerName == null) {
      this.providerName = new ArrayList<>();
    }
    this.providerName.add(providerNameItem);
    return this;
  }

   /**
   * List of KYC providers this information came from
   * @return providerName
  **/
  @javax.annotation.Nullable
  public List<String> getProviderName() {
    return providerName;
  }

  public void setProviderName(List<String> providerName) {
    this.providerName = providerName;
  }


  public CIPInfo createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Get createdAt
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public CIPInfo updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Get updatedAt
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  public CIPInfo kyc(CIPKYC kyc) {
    this.kyc = kyc;
    return this;
  }

   /**
   * Get kyc
   * @return kyc
  **/
  @javax.annotation.Nullable
  public CIPKYC getKyc() {
    return kyc;
  }

  public void setKyc(CIPKYC kyc) {
    this.kyc = kyc;
  }


  public CIPInfo document(CIPDocument document) {
    this.document = document;
    return this;
  }

   /**
   * Get document
   * @return document
  **/
  @javax.annotation.Nullable
  public CIPDocument getDocument() {
    return document;
  }

  public void setDocument(CIPDocument document) {
    this.document = document;
  }


  public CIPInfo photo(CIPPhoto photo) {
    this.photo = photo;
    return this;
  }

   /**
   * Get photo
   * @return photo
  **/
  @javax.annotation.Nullable
  public CIPPhoto getPhoto() {
    return photo;
  }

  public void setPhoto(CIPPhoto photo) {
    this.photo = photo;
  }


  public CIPInfo identity(CIPIdentity identity) {
    this.identity = identity;
    return this;
  }

   /**
   * Get identity
   * @return identity
  **/
  @javax.annotation.Nullable
  public CIPIdentity getIdentity() {
    return identity;
  }

  public void setIdentity(CIPIdentity identity) {
    this.identity = identity;
  }


  public CIPInfo watchlist(CIPWatchlist watchlist) {
    this.watchlist = watchlist;
    return this;
  }

   /**
   * Get watchlist
   * @return watchlist
  **/
  @javax.annotation.Nullable
  public CIPWatchlist getWatchlist() {
    return watchlist;
  }

  public void setWatchlist(CIPWatchlist watchlist) {
    this.watchlist = watchlist;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CIPInfo ciPInfo = (CIPInfo) o;
    return Objects.equals(this.id, ciPInfo.id) &&
        Objects.equals(this.accountId, ciPInfo.accountId) &&
        Objects.equals(this.providerName, ciPInfo.providerName) &&
        Objects.equals(this.createdAt, ciPInfo.createdAt) &&
        Objects.equals(this.updatedAt, ciPInfo.updatedAt) &&
        Objects.equals(this.kyc, ciPInfo.kyc) &&
        Objects.equals(this.document, ciPInfo.document) &&
        Objects.equals(this.photo, ciPInfo.photo) &&
        Objects.equals(this.identity, ciPInfo.identity) &&
        Objects.equals(this.watchlist, ciPInfo.watchlist);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountId, providerName, createdAt, updatedAt, kyc, document, photo, identity, watchlist);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CIPInfo {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    providerName: ").append(toIndentedString(providerName)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    kyc: ").append(toIndentedString(kyc)).append("\n");
    sb.append("    document: ").append(toIndentedString(document)).append("\n");
    sb.append("    photo: ").append(toIndentedString(photo)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("    watchlist: ").append(toIndentedString(watchlist)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_id");
    openapiFields.add("provider_name");
    openapiFields.add("created_at");
    openapiFields.add("updated_at");
    openapiFields.add("kyc");
    openapiFields.add("document");
    openapiFields.add("photo");
    openapiFields.add("identity");
    openapiFields.add("watchlist");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CIPInfo.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CIPInfo is not found in the empty JSON string", CIPInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CIPInfo.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CIPInfo` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("id") != null && !jsonObj.get("id").isJsonNull()) && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_id") != null && !jsonObj.get("account_id").isJsonNull()) && !jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("provider_name") != null && !jsonObj.get("provider_name").isJsonNull() && !jsonObj.get("provider_name").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `provider_name` to be an array in the JSON string but got `%s`", jsonObj.get("provider_name").toString()));
      }
      // validate the optional field `kyc`
      if (jsonObj.get("kyc") != null && !jsonObj.get("kyc").isJsonNull()) {
        CIPKYC.validateJsonElement(jsonObj.get("kyc"));
      }
      // validate the optional field `document`
      if (jsonObj.get("document") != null && !jsonObj.get("document").isJsonNull()) {
        CIPDocument.validateJsonElement(jsonObj.get("document"));
      }
      // validate the optional field `photo`
      if (jsonObj.get("photo") != null && !jsonObj.get("photo").isJsonNull()) {
        CIPPhoto.validateJsonElement(jsonObj.get("photo"));
      }
      // validate the optional field `identity`
      if (jsonObj.get("identity") != null && !jsonObj.get("identity").isJsonNull()) {
        CIPIdentity.validateJsonElement(jsonObj.get("identity"));
      }
      // validate the optional field `watchlist`
      if (jsonObj.get("watchlist") != null && !jsonObj.get("watchlist").isJsonNull()) {
        CIPWatchlist.validateJsonElement(jsonObj.get("watchlist"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CIPInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CIPInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CIPInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CIPInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<CIPInfo>() {
           @Override
           public void write(JsonWriter out, CIPInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CIPInfo read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CIPInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CIPInfo
  * @throws IOException if the JSON string is invalid with respect to CIPInfo
  */
  public static CIPInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CIPInfo.class);
  }

 /**
  * Convert an instance of CIPInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

