/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents results of checking a document for CIPInfo 
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class CIPDocument {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_RESULT = "result";
  @SerializedName(SERIALIZED_NAME_RESULT)
  private String result;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private String status;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_DATE_OF_EXPIRY = "date_of_expiry";
  @SerializedName(SERIALIZED_NAME_DATE_OF_EXPIRY)
  private LocalDate dateOfExpiry;

  public static final String SERIALIZED_NAME_DOCUMENT_NUMBERS = "document_numbers";
  @SerializedName(SERIALIZED_NAME_DOCUMENT_NUMBERS)
  private List<String> documentNumbers;

  public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
  @SerializedName(SERIALIZED_NAME_DOCUMENT_TYPE)
  private String documentType;

  public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
  @SerializedName(SERIALIZED_NAME_FIRST_NAME)
  private String firstName;

  public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
  @SerializedName(SERIALIZED_NAME_LAST_NAME)
  private String lastName;

  public static final String SERIALIZED_NAME_GENDER = "gender";
  @SerializedName(SERIALIZED_NAME_GENDER)
  private String gender;

  public static final String SERIALIZED_NAME_ISSUING_COUNTRY = "issuing_country";
  @SerializedName(SERIALIZED_NAME_ISSUING_COUNTRY)
  private String issuingCountry;

  public static final String SERIALIZED_NAME_NATIONALITY = "nationality";
  @SerializedName(SERIALIZED_NAME_NATIONALITY)
  private String nationality;

  public static final String SERIALIZED_NAME_AGE_VALIDATION = "age_validation";
  @SerializedName(SERIALIZED_NAME_AGE_VALIDATION)
  private String ageValidation;

  public static final String SERIALIZED_NAME_COMPRISED_DOCUMENT = "comprised_document";
  @SerializedName(SERIALIZED_NAME_COMPRISED_DOCUMENT)
  private String comprisedDocument;

  public static final String SERIALIZED_NAME_POLICE_RECORD = "police_record";
  @SerializedName(SERIALIZED_NAME_POLICE_RECORD)
  private String policeRecord;

  public static final String SERIALIZED_NAME_DATA_COMPARISON = "data_comparison";
  @SerializedName(SERIALIZED_NAME_DATA_COMPARISON)
  private String dataComparison;

  public static final String SERIALIZED_NAME_DATA_COMPARISON_BREAKDOWN = "data_comparison_breakdown";
  @SerializedName(SERIALIZED_NAME_DATA_COMPARISON_BREAKDOWN)
  private String dataComparisonBreakdown;

  public static final String SERIALIZED_NAME_IMAGE_INTEGRITY = "image_integrity";
  @SerializedName(SERIALIZED_NAME_IMAGE_INTEGRITY)
  private String imageIntegrity;

  public static final String SERIALIZED_NAME_IMAGE_INTEGRITY_BREAKDOWN = "image_integrity_breakdown";
  @SerializedName(SERIALIZED_NAME_IMAGE_INTEGRITY_BREAKDOWN)
  private String imageIntegrityBreakdown;

  public static final String SERIALIZED_NAME_VISUAL_AUTHENTICITY = "visual_authenticity";
  @SerializedName(SERIALIZED_NAME_VISUAL_AUTHENTICITY)
  private String visualAuthenticity;

  public CIPDocument() {
  }

  public CIPDocument id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Your internal ID of check
   * @return id
  **/
  @javax.annotation.Nonnull
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public CIPDocument result(String result) {
    this.result = result;
    return this;
  }

   /**
   * \&quot;clear\&quot;  \&quot;consider\&quot;
   * @return result
  **/
  @javax.annotation.Nullable
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }


  public CIPDocument status(String status) {
    this.status = status;
    return this;
  }

   /**
   * An enum representing the status of the CIPInfo  \&quot;complete\&quot;  \&quot;withdrawn\&quot;
   * @return status
  **/
  @javax.annotation.Nullable
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }


  public CIPDocument createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Datetime for when this check was done
   * @return createdAt
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public CIPDocument dateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * Datetime for when this check was done
   * @return dateOfBirth
  **/
  @javax.annotation.Nullable
  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public CIPDocument dateOfExpiry(LocalDate dateOfExpiry) {
    this.dateOfExpiry = dateOfExpiry;
    return this;
  }

   /**
   * Datetime for when this check was done
   * @return dateOfExpiry
  **/
  @javax.annotation.Nullable
  public LocalDate getDateOfExpiry() {
    return dateOfExpiry;
  }

  public void setDateOfExpiry(LocalDate dateOfExpiry) {
    this.dateOfExpiry = dateOfExpiry;
  }


  public CIPDocument documentNumbers(List<String> documentNumbers) {
    this.documentNumbers = documentNumbers;
    return this;
  }

  public CIPDocument addDocumentNumbersItem(String documentNumbersItem) {
    if (this.documentNumbers == null) {
      this.documentNumbers = new ArrayList<>();
    }
    this.documentNumbers.add(documentNumbersItem);
    return this;
  }

   /**
   * Number of the document that was checked
   * @return documentNumbers
  **/
  @javax.annotation.Nullable
  public List<String> getDocumentNumbers() {
    return documentNumbers;
  }

  public void setDocumentNumbers(List<String> documentNumbers) {
    this.documentNumbers = documentNumbers;
  }


  public CIPDocument documentType(String documentType) {
    this.documentType = documentType;
    return this;
  }

   /**
   * Type of the document that was checked
   * @return documentType
  **/
  @javax.annotation.Nullable
  public String getDocumentType() {
    return documentType;
  }

  public void setDocumentType(String documentType) {
    this.documentType = documentType;
  }


  public CIPDocument firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * First name extracted from the document
   * @return firstName
  **/
  @javax.annotation.Nullable
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public CIPDocument lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name extracted from the document
   * @return lastName
  **/
  @javax.annotation.Nullable
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public CIPDocument gender(String gender) {
    this.gender = gender;
    return this;
  }

   /**
   * Gender info extracted from the document
   * @return gender
  **/
  @javax.annotation.Nullable
  public String getGender() {
    return gender;
  }

  public void setGender(String gender) {
    this.gender = gender;
  }


  public CIPDocument issuingCountry(String issuingCountry) {
    this.issuingCountry = issuingCountry;
    return this;
  }

   /**
   * Country for which issued the document
   * @return issuingCountry
  **/
  @javax.annotation.Nullable
  public String getIssuingCountry() {
    return issuingCountry;
  }

  public void setIssuingCountry(String issuingCountry) {
    this.issuingCountry = issuingCountry;
  }


  public CIPDocument nationality(String nationality) {
    this.nationality = nationality;
    return this;
  }

   /**
   * Nationality extracted from the document
   * @return nationality
  **/
  @javax.annotation.Nullable
  public String getNationality() {
    return nationality;
  }

  public void setNationality(String nationality) {
    this.nationality = nationality;
  }


  public CIPDocument ageValidation(String ageValidation) {
    this.ageValidation = ageValidation;
    return this;
  }

   /**
   * \&quot;clear\&quot;  \&quot;consider\&quot;
   * @return ageValidation
  **/
  @javax.annotation.Nullable
  public String getAgeValidation() {
    return ageValidation;
  }

  public void setAgeValidation(String ageValidation) {
    this.ageValidation = ageValidation;
  }


  public CIPDocument comprisedDocument(String comprisedDocument) {
    this.comprisedDocument = comprisedDocument;
    return this;
  }

   /**
   * \&quot;clear\&quot;  \&quot;consider\&quot;
   * @return comprisedDocument
  **/
  @javax.annotation.Nullable
  public String getComprisedDocument() {
    return comprisedDocument;
  }

  public void setComprisedDocument(String comprisedDocument) {
    this.comprisedDocument = comprisedDocument;
  }


  public CIPDocument policeRecord(String policeRecord) {
    this.policeRecord = policeRecord;
    return this;
  }

   /**
   * An enum representing the status of the CIPInfo  \&quot;complete\&quot;  \&quot;withdrawn\&quot;
   * @return policeRecord
  **/
  @javax.annotation.Nullable
  public String getPoliceRecord() {
    return policeRecord;
  }

  public void setPoliceRecord(String policeRecord) {
    this.policeRecord = policeRecord;
  }


  public CIPDocument dataComparison(String dataComparison) {
    this.dataComparison = dataComparison;
    return this;
  }

   /**
   * \&quot;clear\&quot;  \&quot;consider\&quot;
   * @return dataComparison
  **/
  @javax.annotation.Nullable
  public String getDataComparison() {
    return dataComparison;
  }

  public void setDataComparison(String dataComparison) {
    this.dataComparison = dataComparison;
  }


  public CIPDocument dataComparisonBreakdown(String dataComparisonBreakdown) {
    this.dataComparisonBreakdown = dataComparisonBreakdown;
    return this;
  }

   /**
   * json object representing the results of the various sub-checks           done when calculating the result on &#x60;data_comparison&#x60;. Example: {“date_of_birth”: “clear”,           “date_of_expiry”: “clear” “document_numbers”: “clear”, “document_type”: “clear”, “first_name”: “clear”,           “gender”: “clear”, “issuing_country”: “clear”, “last_name”: “clear”}
   * @return dataComparisonBreakdown
  **/
  @javax.annotation.Nullable
  public String getDataComparisonBreakdown() {
    return dataComparisonBreakdown;
  }

  public void setDataComparisonBreakdown(String dataComparisonBreakdown) {
    this.dataComparisonBreakdown = dataComparisonBreakdown;
  }


  public CIPDocument imageIntegrity(String imageIntegrity) {
    this.imageIntegrity = imageIntegrity;
    return this;
  }

   /**
   * \&quot;clear\&quot;  \&quot;consider\&quot;
   * @return imageIntegrity
  **/
  @javax.annotation.Nullable
  public String getImageIntegrity() {
    return imageIntegrity;
  }

  public void setImageIntegrity(String imageIntegrity) {
    this.imageIntegrity = imageIntegrity;
  }


  public CIPDocument imageIntegrityBreakdown(String imageIntegrityBreakdown) {
    this.imageIntegrityBreakdown = imageIntegrityBreakdown;
    return this;
  }

   /**
   * json object representing the results of the various sub-checks done           when calculating the result on &#x60;image_integrity&#x60;. Example: example: {“colour_picture”: “clear”,           “conclusive_document_quality”: “clear”, “image_quality”: “clear”, “supported_document”: “clear”}
   * @return imageIntegrityBreakdown
  **/
  @javax.annotation.Nullable
  public String getImageIntegrityBreakdown() {
    return imageIntegrityBreakdown;
  }

  public void setImageIntegrityBreakdown(String imageIntegrityBreakdown) {
    this.imageIntegrityBreakdown = imageIntegrityBreakdown;
  }


  public CIPDocument visualAuthenticity(String visualAuthenticity) {
    this.visualAuthenticity = visualAuthenticity;
    return this;
  }

   /**
   * json object representing the the various sub-checks done when determening           whether visual (non-textual) elements are correct given the document type. Example: {           “digital_tampering”: “clear”, “face_detection”: “clear”, “fonts”: “clear”, “original_document_present”:           “clear”, “picture_face_integrity”: “clear”, “security_features”: “clear”, “template”: “clear”}
   * @return visualAuthenticity
  **/
  @javax.annotation.Nullable
  public String getVisualAuthenticity() {
    return visualAuthenticity;
  }

  public void setVisualAuthenticity(String visualAuthenticity) {
    this.visualAuthenticity = visualAuthenticity;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CIPDocument ciPDocument = (CIPDocument) o;
    return Objects.equals(this.id, ciPDocument.id) &&
        Objects.equals(this.result, ciPDocument.result) &&
        Objects.equals(this.status, ciPDocument.status) &&
        Objects.equals(this.createdAt, ciPDocument.createdAt) &&
        Objects.equals(this.dateOfBirth, ciPDocument.dateOfBirth) &&
        Objects.equals(this.dateOfExpiry, ciPDocument.dateOfExpiry) &&
        Objects.equals(this.documentNumbers, ciPDocument.documentNumbers) &&
        Objects.equals(this.documentType, ciPDocument.documentType) &&
        Objects.equals(this.firstName, ciPDocument.firstName) &&
        Objects.equals(this.lastName, ciPDocument.lastName) &&
        Objects.equals(this.gender, ciPDocument.gender) &&
        Objects.equals(this.issuingCountry, ciPDocument.issuingCountry) &&
        Objects.equals(this.nationality, ciPDocument.nationality) &&
        Objects.equals(this.ageValidation, ciPDocument.ageValidation) &&
        Objects.equals(this.comprisedDocument, ciPDocument.comprisedDocument) &&
        Objects.equals(this.policeRecord, ciPDocument.policeRecord) &&
        Objects.equals(this.dataComparison, ciPDocument.dataComparison) &&
        Objects.equals(this.dataComparisonBreakdown, ciPDocument.dataComparisonBreakdown) &&
        Objects.equals(this.imageIntegrity, ciPDocument.imageIntegrity) &&
        Objects.equals(this.imageIntegrityBreakdown, ciPDocument.imageIntegrityBreakdown) &&
        Objects.equals(this.visualAuthenticity, ciPDocument.visualAuthenticity);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, result, status, createdAt, dateOfBirth, dateOfExpiry, documentNumbers, documentType, firstName, lastName, gender, issuingCountry, nationality, ageValidation, comprisedDocument, policeRecord, dataComparison, dataComparisonBreakdown, imageIntegrity, imageIntegrityBreakdown, visualAuthenticity);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CIPDocument {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    dateOfExpiry: ").append(toIndentedString(dateOfExpiry)).append("\n");
    sb.append("    documentNumbers: ").append(toIndentedString(documentNumbers)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    issuingCountry: ").append(toIndentedString(issuingCountry)).append("\n");
    sb.append("    nationality: ").append(toIndentedString(nationality)).append("\n");
    sb.append("    ageValidation: ").append(toIndentedString(ageValidation)).append("\n");
    sb.append("    comprisedDocument: ").append(toIndentedString(comprisedDocument)).append("\n");
    sb.append("    policeRecord: ").append(toIndentedString(policeRecord)).append("\n");
    sb.append("    dataComparison: ").append(toIndentedString(dataComparison)).append("\n");
    sb.append("    dataComparisonBreakdown: ").append(toIndentedString(dataComparisonBreakdown)).append("\n");
    sb.append("    imageIntegrity: ").append(toIndentedString(imageIntegrity)).append("\n");
    sb.append("    imageIntegrityBreakdown: ").append(toIndentedString(imageIntegrityBreakdown)).append("\n");
    sb.append("    visualAuthenticity: ").append(toIndentedString(visualAuthenticity)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("result");
    openapiFields.add("status");
    openapiFields.add("created_at");
    openapiFields.add("date_of_birth");
    openapiFields.add("date_of_expiry");
    openapiFields.add("document_numbers");
    openapiFields.add("document_type");
    openapiFields.add("first_name");
    openapiFields.add("last_name");
    openapiFields.add("gender");
    openapiFields.add("issuing_country");
    openapiFields.add("nationality");
    openapiFields.add("age_validation");
    openapiFields.add("comprised_document");
    openapiFields.add("police_record");
    openapiFields.add("data_comparison");
    openapiFields.add("data_comparison_breakdown");
    openapiFields.add("image_integrity");
    openapiFields.add("image_integrity_breakdown");
    openapiFields.add("visual_authenticity");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!CIPDocument.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CIPDocument is not found in the empty JSON string", CIPDocument.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!CIPDocument.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CIPDocument` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CIPDocument.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("result") != null && !jsonObj.get("result").isJsonNull()) && !jsonObj.get("result").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `result` to be a primitive type in the JSON string but got `%s`", jsonObj.get("result").toString()));
      }
      if ((jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("document_numbers") != null && !jsonObj.get("document_numbers").isJsonNull() && !jsonObj.get("document_numbers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `document_numbers` to be an array in the JSON string but got `%s`", jsonObj.get("document_numbers").toString()));
      }
      if ((jsonObj.get("document_type") != null && !jsonObj.get("document_type").isJsonNull()) && !jsonObj.get("document_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `document_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("document_type").toString()));
      }
      if ((jsonObj.get("first_name") != null && !jsonObj.get("first_name").isJsonNull()) && !jsonObj.get("first_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `first_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("first_name").toString()));
      }
      if ((jsonObj.get("last_name") != null && !jsonObj.get("last_name").isJsonNull()) && !jsonObj.get("last_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_name").toString()));
      }
      if ((jsonObj.get("gender") != null && !jsonObj.get("gender").isJsonNull()) && !jsonObj.get("gender").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `gender` to be a primitive type in the JSON string but got `%s`", jsonObj.get("gender").toString()));
      }
      if ((jsonObj.get("issuing_country") != null && !jsonObj.get("issuing_country").isJsonNull()) && !jsonObj.get("issuing_country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `issuing_country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuing_country").toString()));
      }
      if ((jsonObj.get("nationality") != null && !jsonObj.get("nationality").isJsonNull()) && !jsonObj.get("nationality").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `nationality` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nationality").toString()));
      }
      if ((jsonObj.get("age_validation") != null && !jsonObj.get("age_validation").isJsonNull()) && !jsonObj.get("age_validation").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `age_validation` to be a primitive type in the JSON string but got `%s`", jsonObj.get("age_validation").toString()));
      }
      if ((jsonObj.get("comprised_document") != null && !jsonObj.get("comprised_document").isJsonNull()) && !jsonObj.get("comprised_document").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `comprised_document` to be a primitive type in the JSON string but got `%s`", jsonObj.get("comprised_document").toString()));
      }
      if ((jsonObj.get("police_record") != null && !jsonObj.get("police_record").isJsonNull()) && !jsonObj.get("police_record").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `police_record` to be a primitive type in the JSON string but got `%s`", jsonObj.get("police_record").toString()));
      }
      if ((jsonObj.get("data_comparison") != null && !jsonObj.get("data_comparison").isJsonNull()) && !jsonObj.get("data_comparison").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `data_comparison` to be a primitive type in the JSON string but got `%s`", jsonObj.get("data_comparison").toString()));
      }
      if ((jsonObj.get("data_comparison_breakdown") != null && !jsonObj.get("data_comparison_breakdown").isJsonNull()) && !jsonObj.get("data_comparison_breakdown").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `data_comparison_breakdown` to be a primitive type in the JSON string but got `%s`", jsonObj.get("data_comparison_breakdown").toString()));
      }
      if ((jsonObj.get("image_integrity") != null && !jsonObj.get("image_integrity").isJsonNull()) && !jsonObj.get("image_integrity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_integrity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_integrity").toString()));
      }
      if ((jsonObj.get("image_integrity_breakdown") != null && !jsonObj.get("image_integrity_breakdown").isJsonNull()) && !jsonObj.get("image_integrity_breakdown").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_integrity_breakdown` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_integrity_breakdown").toString()));
      }
      if ((jsonObj.get("visual_authenticity") != null && !jsonObj.get("visual_authenticity").isJsonNull()) && !jsonObj.get("visual_authenticity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `visual_authenticity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("visual_authenticity").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CIPDocument.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CIPDocument' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CIPDocument> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CIPDocument.class));

       return (TypeAdapter<T>) new TypeAdapter<CIPDocument>() {
           @Override
           public void write(JsonWriter out, CIPDocument value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CIPDocument read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CIPDocument given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CIPDocument
  * @throws IOException if the JSON string is invalid with respect to CIPDocument
  */
  public static CIPDocument fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CIPDocument.class);
  }

 /**
  * Convert an instance of CIPDocument to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

