/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.JournalStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * A Journal object with an extra attribute error_message in the case when a specific account fails to receive a journal.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class BatchJournalResponse {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private String entryType;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private String fromAccount;

  public static final String SERIALIZED_NAME_TO_ACCOUNT = "to_account";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT)
  private String toAccount;

  public static final String SERIALIZED_NAME_SETTLE_DATE = "settle_date";
  @SerializedName(SERIALIZED_NAME_SETTLE_DATE)
  private String settleDate;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private JournalStatus status;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private String qty;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private String price;

  public static final String SERIALIZED_NAME_SYSTEM_DATE = "system_date";
  @SerializedName(SERIALIZED_NAME_SYSTEM_DATE)
  private String systemDate;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
  @SerializedName(SERIALIZED_NAME_NET_AMOUNT)
  private BigDecimal netAmount;

  public static final String SERIALIZED_NAME_TRANSMITTER_NAME = "transmitter_name";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_NAME)
  private String transmitterName;

  public static final String SERIALIZED_NAME_TRANSMITTER_ACCOUNT_NUMBER = "transmitter_account_number";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_ACCOUNT_NUMBER)
  private String transmitterAccountNumber;

  public static final String SERIALIZED_NAME_TRANSMITTER_ADDRESS = "transmitter_address";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_ADDRESS)
  private String transmitterAddress;

  public static final String SERIALIZED_NAME_TRANSMITTER_FINANCIAL_INSTITUTION = "transmitter_financial_institution";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_FINANCIAL_INSTITUTION)
  private String transmitterFinancialInstitution;

  public static final String SERIALIZED_NAME_TRANSMITTER_TIMESTAMP = "transmitter_timestamp";
  @SerializedName(SERIALIZED_NAME_TRANSMITTER_TIMESTAMP)
  private OffsetDateTime transmitterTimestamp;

  public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
  @SerializedName(SERIALIZED_NAME_ERROR_MESSAGE)
  private String errorMessage;

  public BatchJournalResponse() {
  }

  public BatchJournalResponse id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The journal ID
   * @return id
  **/
  @javax.annotation.Nonnull
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public BatchJournalResponse entryType(String entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * JNLS
   * @return entryType
  **/
  @javax.annotation.Nonnull
  public String getEntryType() {
    return entryType;
  }

  public void setEntryType(String entryType) {
    this.entryType = entryType;
  }


  public BatchJournalResponse fromAccount(String fromAccount) {
    this.fromAccount = fromAccount;
    return this;
  }

   /**
   * The account ID that initiates the journal - account_status must equal to ACTIVE or CLOSE
   * @return fromAccount
  **/
  @javax.annotation.Nonnull
  public String getFromAccount() {
    return fromAccount;
  }

  public void setFromAccount(String fromAccount) {
    this.fromAccount = fromAccount;
  }


  public BatchJournalResponse toAccount(String toAccount) {
    this.toAccount = toAccount;
    return this;
  }

   /**
   * The account ID that received the journal - account_status must equal to ACTIVE
   * @return toAccount
  **/
  @javax.annotation.Nonnull
  public String getToAccount() {
    return toAccount;
  }

  public void setToAccount(String toAccount) {
    this.toAccount = toAccount;
  }


  public BatchJournalResponse settleDate(String settleDate) {
    this.settleDate = settleDate;
    return this;
  }

   /**
   * Date string in “%Y-%m-%d” format
   * @return settleDate
  **/
  @javax.annotation.Nonnull
  public String getSettleDate() {
    return settleDate;
  }

  public void setSettleDate(String settleDate) {
    this.settleDate = settleDate;
  }


  public BatchJournalResponse status(JournalStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  public JournalStatus getStatus() {
    return status;
  }

  public void setStatus(JournalStatus status) {
    this.status = status;
  }


  public BatchJournalResponse symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol of the security journaled
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public BatchJournalResponse qty(String qty) {
    this.qty = qty;
    return this;
  }

   /**
   * The quantity of the securities journaled
   * @return qty
  **/
  @javax.annotation.Nullable
  public String getQty() {
    return qty;
  }

  public void setQty(String qty) {
    this.qty = qty;
  }


  public BatchJournalResponse price(String price) {
    this.price = price;
    return this;
  }

   /**
   * The price of the security journaled
   * @return price
  **/
  @javax.annotation.Nullable
  public String getPrice() {
    return price;
  }

  public void setPrice(String price) {
    this.price = price;
  }


  public BatchJournalResponse systemDate(String systemDate) {
    this.systemDate = systemDate;
    return this;
  }

   /**
   * Date string in “%Y-%m-%d” format
   * @return systemDate
  **/
  @javax.annotation.Nullable
  public String getSystemDate() {
    return systemDate;
  }

  public void setSystemDate(String systemDate) {
    this.systemDate = systemDate;
  }


  public BatchJournalResponse description(String description) {
    this.description = description;
    return this;
  }

   /**
   * ID the amount goes to. Only valid for JNLC journals. Null for JNLS.
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public BatchJournalResponse currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Currency denomination of the journal. USD by default.
   * @return currency
  **/
  @javax.annotation.Nullable
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public BatchJournalResponse netAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.
   * @return netAmount
  **/
  @javax.annotation.Nonnull
  public BigDecimal getNetAmount() {
    return netAmount;
  }

  public void setNetAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
  }


  public BatchJournalResponse transmitterName(String transmitterName) {
    this.transmitterName = transmitterName;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS. Max 255 characters.
   * @return transmitterName
  **/
  @javax.annotation.Nullable
  public String getTransmitterName() {
    return transmitterName;
  }

  public void setTransmitterName(String transmitterName) {
    this.transmitterName = transmitterName;
  }


  public BatchJournalResponse transmitterAccountNumber(String transmitterAccountNumber) {
    this.transmitterAccountNumber = transmitterAccountNumber;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.max 255 characters
   * @return transmitterAccountNumber
  **/
  @javax.annotation.Nullable
  public String getTransmitterAccountNumber() {
    return transmitterAccountNumber;
  }

  public void setTransmitterAccountNumber(String transmitterAccountNumber) {
    this.transmitterAccountNumber = transmitterAccountNumber;
  }


  public BatchJournalResponse transmitterAddress(String transmitterAddress) {
    this.transmitterAddress = transmitterAddress;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.max 255 characters
   * @return transmitterAddress
  **/
  @javax.annotation.Nullable
  public String getTransmitterAddress() {
    return transmitterAddress;
  }

  public void setTransmitterAddress(String transmitterAddress) {
    this.transmitterAddress = transmitterAddress;
  }


  public BatchJournalResponse transmitterFinancialInstitution(String transmitterFinancialInstitution) {
    this.transmitterFinancialInstitution = transmitterFinancialInstitution;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.max 255 characters
   * @return transmitterFinancialInstitution
  **/
  @javax.annotation.Nullable
  public String getTransmitterFinancialInstitution() {
    return transmitterFinancialInstitution;
  }

  public void setTransmitterFinancialInstitution(String transmitterFinancialInstitution) {
    this.transmitterFinancialInstitution = transmitterFinancialInstitution;
  }


  public BatchJournalResponse transmitterTimestamp(OffsetDateTime transmitterTimestamp) {
    this.transmitterTimestamp = transmitterTimestamp;
    return this;
  }

   /**
   * Only valid for JNLC journals. Null for JNLS.
   * @return transmitterTimestamp
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getTransmitterTimestamp() {
    return transmitterTimestamp;
  }

  public void setTransmitterTimestamp(OffsetDateTime transmitterTimestamp) {
    this.transmitterTimestamp = transmitterTimestamp;
  }


  public BatchJournalResponse errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

   /**
   * Description of why this journal transaction failed
   * @return errorMessage
  **/
  @javax.annotation.Nonnull
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchJournalResponse batchJournalResponse = (BatchJournalResponse) o;
    return Objects.equals(this.id, batchJournalResponse.id) &&
        Objects.equals(this.entryType, batchJournalResponse.entryType) &&
        Objects.equals(this.fromAccount, batchJournalResponse.fromAccount) &&
        Objects.equals(this.toAccount, batchJournalResponse.toAccount) &&
        Objects.equals(this.settleDate, batchJournalResponse.settleDate) &&
        Objects.equals(this.status, batchJournalResponse.status) &&
        Objects.equals(this.symbol, batchJournalResponse.symbol) &&
        Objects.equals(this.qty, batchJournalResponse.qty) &&
        Objects.equals(this.price, batchJournalResponse.price) &&
        Objects.equals(this.systemDate, batchJournalResponse.systemDate) &&
        Objects.equals(this.description, batchJournalResponse.description) &&
        Objects.equals(this.currency, batchJournalResponse.currency) &&
        Objects.equals(this.netAmount, batchJournalResponse.netAmount) &&
        Objects.equals(this.transmitterName, batchJournalResponse.transmitterName) &&
        Objects.equals(this.transmitterAccountNumber, batchJournalResponse.transmitterAccountNumber) &&
        Objects.equals(this.transmitterAddress, batchJournalResponse.transmitterAddress) &&
        Objects.equals(this.transmitterFinancialInstitution, batchJournalResponse.transmitterFinancialInstitution) &&
        Objects.equals(this.transmitterTimestamp, batchJournalResponse.transmitterTimestamp) &&
        Objects.equals(this.errorMessage, batchJournalResponse.errorMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, entryType, fromAccount, toAccount, settleDate, status, symbol, qty, price, systemDate, description, currency, netAmount, transmitterName, transmitterAccountNumber, transmitterAddress, transmitterFinancialInstitution, transmitterTimestamp, errorMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchJournalResponse {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    toAccount: ").append(toIndentedString(toAccount)).append("\n");
    sb.append("    settleDate: ").append(toIndentedString(settleDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    systemDate: ").append(toIndentedString(systemDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    transmitterName: ").append(toIndentedString(transmitterName)).append("\n");
    sb.append("    transmitterAccountNumber: ").append(toIndentedString(transmitterAccountNumber)).append("\n");
    sb.append("    transmitterAddress: ").append(toIndentedString(transmitterAddress)).append("\n");
    sb.append("    transmitterFinancialInstitution: ").append(toIndentedString(transmitterFinancialInstitution)).append("\n");
    sb.append("    transmitterTimestamp: ").append(toIndentedString(transmitterTimestamp)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("entry_type");
    openapiFields.add("from_account");
    openapiFields.add("to_account");
    openapiFields.add("settle_date");
    openapiFields.add("status");
    openapiFields.add("symbol");
    openapiFields.add("qty");
    openapiFields.add("price");
    openapiFields.add("system_date");
    openapiFields.add("description");
    openapiFields.add("currency");
    openapiFields.add("net_amount");
    openapiFields.add("transmitter_name");
    openapiFields.add("transmitter_account_number");
    openapiFields.add("transmitter_address");
    openapiFields.add("transmitter_financial_institution");
    openapiFields.add("transmitter_timestamp");
    openapiFields.add("error_message");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("entry_type");
    openapiRequiredFields.add("from_account");
    openapiRequiredFields.add("to_account");
    openapiRequiredFields.add("settle_date");
    openapiRequiredFields.add("net_amount");
    openapiRequiredFields.add("error_message");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!BatchJournalResponse.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BatchJournalResponse is not found in the empty JSON string", BatchJournalResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!BatchJournalResponse.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BatchJournalResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BatchJournalResponse.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("entry_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `entry_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entry_type").toString()));
      }
      if (!jsonObj.get("from_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from_account").toString()));
      }
      if (!jsonObj.get("to_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to_account").toString()));
      }
      if (!jsonObj.get("settle_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `settle_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("settle_date").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        JournalStatus.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      if ((jsonObj.get("price") != null && !jsonObj.get("price").isJsonNull()) && !jsonObj.get("price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price").toString()));
      }
      if ((jsonObj.get("system_date") != null && !jsonObj.get("system_date").isJsonNull()) && !jsonObj.get("system_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `system_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("system_date").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonNull()) && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (!jsonObj.get("net_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_amount").toString()));
      }
      if ((jsonObj.get("transmitter_name") != null && !jsonObj.get("transmitter_name").isJsonNull()) && !jsonObj.get("transmitter_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_name").toString()));
      }
      if ((jsonObj.get("transmitter_account_number") != null && !jsonObj.get("transmitter_account_number").isJsonNull()) && !jsonObj.get("transmitter_account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_account_number").toString()));
      }
      if ((jsonObj.get("transmitter_address") != null && !jsonObj.get("transmitter_address").isJsonNull()) && !jsonObj.get("transmitter_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_address").toString()));
      }
      if ((jsonObj.get("transmitter_financial_institution") != null && !jsonObj.get("transmitter_financial_institution").isJsonNull()) && !jsonObj.get("transmitter_financial_institution").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `transmitter_financial_institution` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transmitter_financial_institution").toString()));
      }
      if (!jsonObj.get("error_message").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `error_message` to be a primitive type in the JSON string but got `%s`", jsonObj.get("error_message").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BatchJournalResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BatchJournalResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BatchJournalResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BatchJournalResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<BatchJournalResponse>() {
           @Override
           public void write(JsonWriter out, BatchJournalResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BatchJournalResponse read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BatchJournalResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BatchJournalResponse
  * @throws IOException if the JSON string is invalid with respect to BatchJournalResponse
  */
  public static BatchJournalResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BatchJournalResponse.class);
  }

 /**
  * Convert an instance of BatchJournalResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

