/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.BatchJournalRequestEntriesInner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Journals API allows you to move cash or securities from one account to another.  This model represents the fields you can specify when creating a request of many Journals out of one account to many others at once.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class BatchJournalRequest {
  /**
   * Only supports &#x60;JNLC&#x60; for now
   */
  @JsonAdapter(EntryTypeEnum.Adapter.class)
  public enum EntryTypeEnum {
    JNLC("JNLC");

    private String value;

    EntryTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EntryTypeEnum fromValue(String value) {
      for (EntryTypeEnum b : EntryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<EntryTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EntryTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EntryTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EntryTypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      EntryTypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_ENTRY_TYPE = "entry_type";
  @SerializedName(SERIALIZED_NAME_ENTRY_TYPE)
  private EntryTypeEnum entryType;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "from_account";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private UUID fromAccount;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ENTRIES = "entries";
  @SerializedName(SERIALIZED_NAME_ENTRIES)
  private List<BatchJournalRequestEntriesInner> entries = new ArrayList<>();

  public BatchJournalRequest() {
  }

  public BatchJournalRequest entryType(EntryTypeEnum entryType) {
    this.entryType = entryType;
    return this;
  }

   /**
   * Only supports &#x60;JNLC&#x60; for now
   * @return entryType
  **/
  @javax.annotation.Nonnull
  public EntryTypeEnum getEntryType() {
    return entryType;
  }

  public void setEntryType(EntryTypeEnum entryType) {
    this.entryType = entryType;
  }


  public BatchJournalRequest fromAccount(UUID fromAccount) {
    this.fromAccount = fromAccount;
    return this;
  }

   /**
   * The account id that is the originator of the funds being moved. Most likely is your Sweep Firm Account
   * @return fromAccount
  **/
  @javax.annotation.Nonnull
  public UUID getFromAccount() {
    return fromAccount;
  }

  public void setFromAccount(UUID fromAccount) {
    this.fromAccount = fromAccount;
  }


  public BatchJournalRequest description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Journal description, gets returned in the response
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public BatchJournalRequest entries(List<BatchJournalRequestEntriesInner> entries) {
    this.entries = entries;
    return this;
  }

  public BatchJournalRequest addEntriesItem(BatchJournalRequestEntriesInner entriesItem) {
    if (this.entries == null) {
      this.entries = new ArrayList<>();
    }
    this.entries.add(entriesItem);
    return this;
  }

   /**
   * An array of objects describing to what accounts you want to move funds into and how much to move into for each account
   * @return entries
  **/
  @javax.annotation.Nonnull
  public List<BatchJournalRequestEntriesInner> getEntries() {
    return entries;
  }

  public void setEntries(List<BatchJournalRequestEntriesInner> entries) {
    this.entries = entries;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchJournalRequest batchJournalRequest = (BatchJournalRequest) o;
    return Objects.equals(this.entryType, batchJournalRequest.entryType) &&
        Objects.equals(this.fromAccount, batchJournalRequest.fromAccount) &&
        Objects.equals(this.description, batchJournalRequest.description) &&
        Objects.equals(this.entries, batchJournalRequest.entries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entryType, fromAccount, description, entries);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchJournalRequest {\n");
    sb.append("    entryType: ").append(toIndentedString(entryType)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    entries: ").append(toIndentedString(entries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("entry_type");
    openapiFields.add("from_account");
    openapiFields.add("description");
    openapiFields.add("entries");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("entry_type");
    openapiRequiredFields.add("from_account");
    openapiRequiredFields.add("entries");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!BatchJournalRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in BatchJournalRequest is not found in the empty JSON string", BatchJournalRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!BatchJournalRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BatchJournalRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : BatchJournalRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("entry_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `entry_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entry_type").toString()));
      }
      // validate the required field `entry_type`
      EntryTypeEnum.validateJsonElement(jsonObj.get("entry_type"));
      if (!jsonObj.get("from_account").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from_account` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from_account").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // ensure the json data is an array
      if (!jsonObj.get("entries").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `entries` to be an array in the JSON string but got `%s`", jsonObj.get("entries").toString()));
      }

      JsonArray jsonArrayentries = jsonObj.getAsJsonArray("entries");
      // validate the required field `entries` (array)
      for (int i = 0; i < jsonArrayentries.size(); i++) {
        BatchJournalRequestEntriesInner.validateJsonElement(jsonArrayentries.get(i));
      };
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BatchJournalRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BatchJournalRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BatchJournalRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BatchJournalRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<BatchJournalRequest>() {
           @Override
           public void write(JsonWriter out, BatchJournalRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BatchJournalRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BatchJournalRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BatchJournalRequest
  * @throws IOException if the JSON string is invalid with respect to BatchJournalRequest
  */
  public static BatchJournalRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BatchJournalRequest.class);
  }

 /**
  * Convert an instance of BatchJournalRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

