/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * This represents the category to which the asset belongs to. It serves to identify the nature of the financial instrument, with options including \&quot;us_equity\&quot; for U.S. equities, \&quot;us_option\&quot; for U.S. options, and \&quot;crypto\&quot; for cryptocurrencies.
 */
@JsonAdapter(AssetClass.Adapter.class)
public enum AssetClass {
  
  US_EQUITY("us_equity"),
  
  US_OPTION("us_option"),
  
  CRYPTO("crypto");

  private String value;

  AssetClass(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AssetClass fromValue(String value) {
    for (AssetClass b : AssetClass.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AssetClass> {
    @Override
    public void write(final JsonWriter jsonWriter, final AssetClass enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public AssetClass read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return AssetClass.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    AssetClass.fromValue(value);
  }
}

