/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Assets are sorted by asset class, exchange and symbol. Some assets are not tradable with Alpaca. These assets will be marked with the flag tradable&#x3D;false
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Asset {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_PROPERTY_CLASS = "class";
  @SerializedName(SERIALIZED_NAME_PROPERTY_CLASS)
  private AssetClass propertyClass;

  public static final String SERIALIZED_NAME_EXCHANGE = "exchange";
  @SerializedName(SERIALIZED_NAME_EXCHANGE)
  private Exchange exchange;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * active or inactive
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("active"),
    
    INACTIVE("inactive");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TRADABLE = "tradable";
  @SerializedName(SERIALIZED_NAME_TRADABLE)
  private Boolean tradable;

  public static final String SERIALIZED_NAME_MARGINABLE = "marginable";
  @SerializedName(SERIALIZED_NAME_MARGINABLE)
  private Boolean marginable;

  public static final String SERIALIZED_NAME_SHORTABLE = "shortable";
  @SerializedName(SERIALIZED_NAME_SHORTABLE)
  private Boolean shortable;

  public static final String SERIALIZED_NAME_EASY_TO_BORROW = "easy_to_borrow";
  @SerializedName(SERIALIZED_NAME_EASY_TO_BORROW)
  private Boolean easyToBorrow;

  public static final String SERIALIZED_NAME_FRACTIONABLE = "fractionable";
  @SerializedName(SERIALIZED_NAME_FRACTIONABLE)
  private Boolean fractionable;

  public static final String SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE = "last_close_pct_change";
  @SerializedName(SERIALIZED_NAME_LAST_CLOSE_PCT_CHANGE)
  private BigDecimal lastClosePctChange;

  public static final String SERIALIZED_NAME_LAST_PRICE = "last_price";
  @SerializedName(SERIALIZED_NAME_LAST_PRICE)
  private BigDecimal lastPrice;

  public static final String SERIALIZED_NAME_LAST_CLOSE = "last_close";
  @SerializedName(SERIALIZED_NAME_LAST_CLOSE)
  private BigDecimal lastClose;

  public static final String SERIALIZED_NAME_MIN_ORDER_SIZE = "min_order_size";
  @SerializedName(SERIALIZED_NAME_MIN_ORDER_SIZE)
  private String minOrderSize;

  public static final String SERIALIZED_NAME_MIN_TRADE_INCREMENT = "min_trade_increment";
  @SerializedName(SERIALIZED_NAME_MIN_TRADE_INCREMENT)
  private String minTradeIncrement;

  public static final String SERIALIZED_NAME_PRICE_INCREMENT = "price_increment";
  @SerializedName(SERIALIZED_NAME_PRICE_INCREMENT)
  private String priceIncrement;

  public static final String SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT = "maintenance_margin_requirement";
  @SerializedName(SERIALIZED_NAME_MAINTENANCE_MARGIN_REQUIREMENT)
  private BigDecimal maintenanceMarginRequirement;

  /**
   * Gets or Sets attributes
   */
  @JsonAdapter(AttributesEnum.Adapter.class)
  public enum AttributesEnum {
    PTP_NO_EXCEPTION("ptp_no_exception"),
    
    PTP_WITH_EXCEPTION("ptp_with_exception"),
    
    IPO("ipo"),
    
    OPTIONS_ENABLED("options_enabled");

    private String value;

    AttributesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AttributesEnum fromValue(String value) {
      for (AttributesEnum b : AttributesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<AttributesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AttributesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AttributesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AttributesEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      AttributesEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
  @SerializedName(SERIALIZED_NAME_ATTRIBUTES)
  private List<AttributesEnum> attributes;

  public Asset() {
  }

  public Asset id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Asset ID
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public Asset propertyClass(AssetClass propertyClass) {
    this.propertyClass = propertyClass;
    return this;
  }

   /**
   * Get propertyClass
   * @return propertyClass
  **/
  @javax.annotation.Nonnull
  public AssetClass getPropertyClass() {
    return propertyClass;
  }

  public void setPropertyClass(AssetClass propertyClass) {
    this.propertyClass = propertyClass;
  }


  public Asset exchange(Exchange exchange) {
    this.exchange = exchange;
    return this;
  }

   /**
   * Get exchange
   * @return exchange
  **/
  @javax.annotation.Nullable
  public Exchange getExchange() {
    return exchange;
  }

  public void setExchange(Exchange exchange) {
    this.exchange = exchange;
  }


  public Asset symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * The symbol of the asset
   * @return symbol
  **/
  @javax.annotation.Nonnull
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public Asset name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The official name of the asset
   * @return name
  **/
  @javax.annotation.Nullable
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public Asset status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * active or inactive
   * @return status
  **/
  @javax.annotation.Nullable
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Asset tradable(Boolean tradable) {
    this.tradable = tradable;
    return this;
  }

   /**
   * Asset is tradable on Alpaca or not
   * @return tradable
  **/
  @javax.annotation.Nullable
  public Boolean getTradable() {
    return tradable;
  }

  public void setTradable(Boolean tradable) {
    this.tradable = tradable;
  }


  public Asset marginable(Boolean marginable) {
    this.marginable = marginable;
    return this;
  }

   /**
   * Asset is marginable or not
   * @return marginable
  **/
  @javax.annotation.Nullable
  public Boolean getMarginable() {
    return marginable;
  }

  public void setMarginable(Boolean marginable) {
    this.marginable = marginable;
  }


  public Asset shortable(Boolean shortable) {
    this.shortable = shortable;
    return this;
  }

   /**
   * Asset is shortable or not
   * @return shortable
  **/
  @javax.annotation.Nullable
  public Boolean getShortable() {
    return shortable;
  }

  public void setShortable(Boolean shortable) {
    this.shortable = shortable;
  }


  public Asset easyToBorrow(Boolean easyToBorrow) {
    this.easyToBorrow = easyToBorrow;
    return this;
  }

   /**
   * Asset is easy-to-borrow or not (filtering for easy_to_borrow &#x3D; True is the best way to check whether the name is currently available to short at Alpaca).
   * @return easyToBorrow
  **/
  @javax.annotation.Nullable
  public Boolean getEasyToBorrow() {
    return easyToBorrow;
  }

  public void setEasyToBorrow(Boolean easyToBorrow) {
    this.easyToBorrow = easyToBorrow;
  }


  public Asset fractionable(Boolean fractionable) {
    this.fractionable = fractionable;
    return this;
  }

   /**
   * Asset is fractionable or not
   * @return fractionable
  **/
  @javax.annotation.Nullable
  public Boolean getFractionable() {
    return fractionable;
  }

  public void setFractionable(Boolean fractionable) {
    this.fractionable = fractionable;
  }


  public Asset lastClosePctChange(BigDecimal lastClosePctChange) {
    this.lastClosePctChange = lastClosePctChange;
    return this;
  }

   /**
   * Percent change for the trading day as of last market closure. NOTE: This field is currently in this spec however it may not be present in the production environment at time of publishing. It will be coming in a future update at which point this spec should be updated.
   * @return lastClosePctChange
  **/
  @javax.annotation.Nullable
  public BigDecimal getLastClosePctChange() {
    return lastClosePctChange;
  }

  public void setLastClosePctChange(BigDecimal lastClosePctChange) {
    this.lastClosePctChange = lastClosePctChange;
  }


  public Asset lastPrice(BigDecimal lastPrice) {
    this.lastPrice = lastPrice;
    return this;
  }

   /**
   * Most recent available price for this asset on the market. NOTE: This field is currently in this spec however it may not be present in the production environment at time of publishing. It will be coming in a future update at which point this spec should be updated.
   * @return lastPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getLastPrice() {
    return lastPrice;
  }

  public void setLastPrice(BigDecimal lastPrice) {
    this.lastPrice = lastPrice;
  }


  public Asset lastClose(BigDecimal lastClose) {
    this.lastClose = lastClose;
    return this;
  }

   /**
   * Last price of the asset upon market closure on the most recent trading day. NOTE: This field is currently in this spec however it may not be present in the production environment at time of publishing. It will be coming in a future update at which point this spec should be updated.
   * @return lastClose
  **/
  @javax.annotation.Nullable
  public BigDecimal getLastClose() {
    return lastClose;
  }

  public void setLastClose(BigDecimal lastClose) {
    this.lastClose = lastClose;
  }


  public Asset minOrderSize(String minOrderSize) {
    this.minOrderSize = minOrderSize;
    return this;
  }

   /**
   * Minimum order size.  Field available for crypto only.
   * @return minOrderSize
  **/
  @javax.annotation.Nullable
  public String getMinOrderSize() {
    return minOrderSize;
  }

  public void setMinOrderSize(String minOrderSize) {
    this.minOrderSize = minOrderSize;
  }


  public Asset minTradeIncrement(String minTradeIncrement) {
    this.minTradeIncrement = minTradeIncrement;
    return this;
  }

   /**
   * Amount a trade quantity can be incremented by. Field available for crypto only.
   * @return minTradeIncrement
  **/
  @javax.annotation.Nullable
  public String getMinTradeIncrement() {
    return minTradeIncrement;
  }

  public void setMinTradeIncrement(String minTradeIncrement) {
    this.minTradeIncrement = minTradeIncrement;
  }


  public Asset priceIncrement(String priceIncrement) {
    this.priceIncrement = priceIncrement;
    return this;
  }

   /**
   * Amount the price can be incremented by. Field available for crypto only.
   * @return priceIncrement
  **/
  @javax.annotation.Nullable
  public String getPriceIncrement() {
    return priceIncrement;
  }

  public void setPriceIncrement(String priceIncrement) {
    this.priceIncrement = priceIncrement;
  }


  public Asset maintenanceMarginRequirement(BigDecimal maintenanceMarginRequirement) {
    this.maintenanceMarginRequirement = maintenanceMarginRequirement;
    return this;
  }

   /**
   * Shows the % margin requirement for the asset (equities only).
   * @return maintenanceMarginRequirement
  **/
  @javax.annotation.Nullable
  public BigDecimal getMaintenanceMarginRequirement() {
    return maintenanceMarginRequirement;
  }

  public void setMaintenanceMarginRequirement(BigDecimal maintenanceMarginRequirement) {
    this.maintenanceMarginRequirement = maintenanceMarginRequirement;
  }


  public Asset attributes(List<AttributesEnum> attributes) {
    this.attributes = attributes;
    return this;
  }

  public Asset addAttributesItem(AttributesEnum attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * One of &#x60;ptp_no_exception&#x60;, &#x60;ptp_with_exception&#x60;, &#x60;ipo&#x60;, or &#x60;options_enabled&#x60;. We will include unique characteristics of the asset here.
   * @return attributes
  **/
  @javax.annotation.Nullable
  public List<AttributesEnum> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<AttributesEnum> attributes) {
    this.attributes = attributes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Asset asset = (Asset) o;
    return Objects.equals(this.id, asset.id) &&
        Objects.equals(this.propertyClass, asset.propertyClass) &&
        Objects.equals(this.exchange, asset.exchange) &&
        Objects.equals(this.symbol, asset.symbol) &&
        Objects.equals(this.name, asset.name) &&
        Objects.equals(this.status, asset.status) &&
        Objects.equals(this.tradable, asset.tradable) &&
        Objects.equals(this.marginable, asset.marginable) &&
        Objects.equals(this.shortable, asset.shortable) &&
        Objects.equals(this.easyToBorrow, asset.easyToBorrow) &&
        Objects.equals(this.fractionable, asset.fractionable) &&
        Objects.equals(this.lastClosePctChange, asset.lastClosePctChange) &&
        Objects.equals(this.lastPrice, asset.lastPrice) &&
        Objects.equals(this.lastClose, asset.lastClose) &&
        Objects.equals(this.minOrderSize, asset.minOrderSize) &&
        Objects.equals(this.minTradeIncrement, asset.minTradeIncrement) &&
        Objects.equals(this.priceIncrement, asset.priceIncrement) &&
        Objects.equals(this.maintenanceMarginRequirement, asset.maintenanceMarginRequirement) &&
        Objects.equals(this.attributes, asset.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, propertyClass, exchange, symbol, name, status, tradable, marginable, shortable, easyToBorrow, fractionable, lastClosePctChange, lastPrice, lastClose, minOrderSize, minTradeIncrement, priceIncrement, maintenanceMarginRequirement, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Asset {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    propertyClass: ").append(toIndentedString(propertyClass)).append("\n");
    sb.append("    exchange: ").append(toIndentedString(exchange)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tradable: ").append(toIndentedString(tradable)).append("\n");
    sb.append("    marginable: ").append(toIndentedString(marginable)).append("\n");
    sb.append("    shortable: ").append(toIndentedString(shortable)).append("\n");
    sb.append("    easyToBorrow: ").append(toIndentedString(easyToBorrow)).append("\n");
    sb.append("    fractionable: ").append(toIndentedString(fractionable)).append("\n");
    sb.append("    lastClosePctChange: ").append(toIndentedString(lastClosePctChange)).append("\n");
    sb.append("    lastPrice: ").append(toIndentedString(lastPrice)).append("\n");
    sb.append("    lastClose: ").append(toIndentedString(lastClose)).append("\n");
    sb.append("    minOrderSize: ").append(toIndentedString(minOrderSize)).append("\n");
    sb.append("    minTradeIncrement: ").append(toIndentedString(minTradeIncrement)).append("\n");
    sb.append("    priceIncrement: ").append(toIndentedString(priceIncrement)).append("\n");
    sb.append("    maintenanceMarginRequirement: ").append(toIndentedString(maintenanceMarginRequirement)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("class");
    openapiFields.add("exchange");
    openapiFields.add("symbol");
    openapiFields.add("name");
    openapiFields.add("status");
    openapiFields.add("tradable");
    openapiFields.add("marginable");
    openapiFields.add("shortable");
    openapiFields.add("easy_to_borrow");
    openapiFields.add("fractionable");
    openapiFields.add("last_close_pct_change");
    openapiFields.add("last_price");
    openapiFields.add("last_close");
    openapiFields.add("min_order_size");
    openapiFields.add("min_trade_increment");
    openapiFields.add("price_increment");
    openapiFields.add("maintenance_margin_requirement");
    openapiFields.add("attributes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("class");
    openapiRequiredFields.add("symbol");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Asset.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Asset is not found in the empty JSON string", Asset.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Asset.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Asset` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Asset.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the required field `class`
      AssetClass.validateJsonElement(jsonObj.get("class"));
      // validate the optional field `exchange`
      if (jsonObj.get("exchange") != null && !jsonObj.get("exchange").isJsonNull()) {
        Exchange.validateJsonElement(jsonObj.get("exchange"));
      }
      if (!jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        StatusEnum.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("last_close_pct_change") != null && !jsonObj.get("last_close_pct_change").isJsonNull()) && !jsonObj.get("last_close_pct_change").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_close_pct_change` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_close_pct_change").toString()));
      }
      if ((jsonObj.get("last_price") != null && !jsonObj.get("last_price").isJsonNull()) && !jsonObj.get("last_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_price").toString()));
      }
      if ((jsonObj.get("last_close") != null && !jsonObj.get("last_close").isJsonNull()) && !jsonObj.get("last_close").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_close` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_close").toString()));
      }
      if ((jsonObj.get("min_order_size") != null && !jsonObj.get("min_order_size").isJsonNull()) && !jsonObj.get("min_order_size").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `min_order_size` to be a primitive type in the JSON string but got `%s`", jsonObj.get("min_order_size").toString()));
      }
      if ((jsonObj.get("min_trade_increment") != null && !jsonObj.get("min_trade_increment").isJsonNull()) && !jsonObj.get("min_trade_increment").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `min_trade_increment` to be a primitive type in the JSON string but got `%s`", jsonObj.get("min_trade_increment").toString()));
      }
      if ((jsonObj.get("price_increment") != null && !jsonObj.get("price_increment").isJsonNull()) && !jsonObj.get("price_increment").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price_increment` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price_increment").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("attributes") != null && !jsonObj.get("attributes").isJsonNull() && !jsonObj.get("attributes").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get("attributes").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Asset.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Asset' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Asset> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Asset.class));

       return (TypeAdapter<T>) new TypeAdapter<Asset>() {
           @Override
           public void write(JsonWriter out, Asset value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Asset read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Asset given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Asset
  * @throws IOException if the JSON string is invalid with respect to Asset
  */
  public static Asset fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Asset.class);
  }

 /**
  * Convert an instance of Asset to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

