/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Announcements have both a type and a subtype to categorize them. This model represents the higher level abstract \&quot;types\&quot; of Announcement. Please see the AnnouncementCASubType model for finer grain descriptions of the subtypes  Possible values are: - dividend   can have &#x60;cash&#x60; and &#x60;stock&#x60; subtypes - merger   has &#x60;merger_update&#x60; and &#x60;merger_completion&#x60; sub types - split   has &#x60;stock_split&#x60;, &#x60;until_split&#x60;, &#x60;reverse_split&#x60;, and &#x60;recapitalization&#x60; sub types - spinoff   currently has only the &#x60;spinoff&#x60; subtype and thus is just this higher level category for now. A disbursement of a newly tradable security when the intiating_symbol creates the target_symbol.
 */
@JsonAdapter(AnnouncementCAType.Adapter.class)
public enum AnnouncementCAType {
  
  DIVIDEND("dividend"),
  
  MERGER("merger"),
  
  SPLIT("split"),
  
  SPINOFF("spinoff");

  private String value;

  AnnouncementCAType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AnnouncementCAType fromValue(String value) {
    for (AnnouncementCAType b : AnnouncementCAType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AnnouncementCAType> {
    @Override
    public void write(final JsonWriter jsonWriter, final AnnouncementCAType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public AnnouncementCAType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return AnnouncementCAType.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    AnnouncementCAType.fromValue(value);
  }
}

