/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Announcements have both a type and a subtype to categorize them. This model represents the lowever level abstract \&quot;sub types\&quot; of Announcement. Please see the AnnouncementCAType model for higher level descriptions of the possible types  Possible values are:  - from the &#x60;dividend&#x60; type:   - **cash**      A cash payment based on the number of shares the account holds on the record date.   - **stock**      A stock payment based on the number of shares the account holds on the record date.  - from the &#x60;merger&#x60; type:   - **merger_update**      An update to the terms of an upcoming merger. This can happen any number of times before the merger is completed and can be tracked by using the id parameter.    - **merger_completion**      A final update in the terms of the merger in which the intiating_symbol will acquire the target_symbol. Any previous terms updates for this announcement will have the same id value.  - from the &#x60;split&#x60; type:   - **stock_split**      An increase in the number of shares outstanding with a decrease in the dollar value of each share. The new_rate and old_rate parameters will be returned in order to derive the ratio of the split   - **until_split**      An increase in the number of shares outstanding with a decrease in the dollar value of each share. The new_rate and old_rate parameters will be returned in order to derive the ratio of the split.   - **reverse_split**      A decrease in the number of shares outstanding with an increase in the dollar value of each share. The new_rate and old_rate parameters will be returned in order to derive the ratio of the spli   - **recapitalization**      A stock recapitalization, typically used by a company to adjust debt and equity ratios.  - from the &#x60;spinoff&#x60; type:   - **spinoff**      A disbursement of a newly tradable security when the intiating_symbol creates the target_symbol.
 */
@JsonAdapter(AnnouncementCASubType.Adapter.class)
public enum AnnouncementCASubType {
  
  CASH("cash"),
  
  STOCK("stock"),
  
  MERGER_UPDATE("merger_update"),
  
  MERGER_COMPLETION("merger_completion"),
  
  STOCK_SPLIT("stock_split"),
  
  UNTIL_SPLIT("until_split"),
  
  REVERSE_SPLIT("reverse_split"),
  
  RECAPITALIZATION("recapitalization"),
  
  SPINOFF("spinoff");

  private String value;

  AnnouncementCASubType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AnnouncementCASubType fromValue(String value) {
    for (AnnouncementCASubType b : AnnouncementCASubType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AnnouncementCASubType> {
    @Override
    public void write(final JsonWriter jsonWriter, final AnnouncementCASubType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public AnnouncementCASubType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return AnnouncementCASubType.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    AnnouncementCASubType.fromValue(value);
  }
}

