/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.AnnouncementCASubType;
import net.jacobpeterson.alpaca.openapi.broker.model.AnnouncementCAType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * The announcements endpoint contains public information on previous and upcoming dividends, mergers, spinoffs, and stock splits.  Announcement data is made available through the API as soon as it is ingested by Alpaca, which is typically the following trading day after the declaration date. This provides insight into future account stock position and cash balance changes that will take effect on an announcement’s payable date. Additionally, viewing previous announcement details can improve bookkeeping and reconciling previous account cash and position changes.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Announcement {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_CORPORATE_ACTION_ID = "corporate_action_id";
  @SerializedName(SERIALIZED_NAME_CORPORATE_ACTION_ID)
  private String corporateActionId;

  public static final String SERIALIZED_NAME_CA_TYPE = "ca_type";
  @SerializedName(SERIALIZED_NAME_CA_TYPE)
  private AnnouncementCAType caType;

  public static final String SERIALIZED_NAME_CA_SUB_TYPE = "ca_sub_type";
  @SerializedName(SERIALIZED_NAME_CA_SUB_TYPE)
  private AnnouncementCASubType caSubType;

  public static final String SERIALIZED_NAME_INITIATING_SYMBOL = "initiating_symbol";
  @SerializedName(SERIALIZED_NAME_INITIATING_SYMBOL)
  private String initiatingSymbol;

  public static final String SERIALIZED_NAME_INITIATING_ORIGINAL_CUSIP = "initiating_original_cusip";
  @SerializedName(SERIALIZED_NAME_INITIATING_ORIGINAL_CUSIP)
  private String initiatingOriginalCusip;

  public static final String SERIALIZED_NAME_TARGET_SYMBOL = "target_symbol";
  @SerializedName(SERIALIZED_NAME_TARGET_SYMBOL)
  private String targetSymbol;

  public static final String SERIALIZED_NAME_TARGET_ORIGINAL_CUSIP = "target_original_cusip";
  @SerializedName(SERIALIZED_NAME_TARGET_ORIGINAL_CUSIP)
  private String targetOriginalCusip;

  public static final String SERIALIZED_NAME_DECLARATION_DATE = "declaration_date";
  @SerializedName(SERIALIZED_NAME_DECLARATION_DATE)
  private String declarationDate;

  public static final String SERIALIZED_NAME_EX_DATE = "ex_date";
  @SerializedName(SERIALIZED_NAME_EX_DATE)
  private String exDate;

  public static final String SERIALIZED_NAME_RECORD_DATE = "record_date";
  @SerializedName(SERIALIZED_NAME_RECORD_DATE)
  private String recordDate;

  public static final String SERIALIZED_NAME_PAYABLE_DATE = "payable_date";
  @SerializedName(SERIALIZED_NAME_PAYABLE_DATE)
  private String payableDate;

  public static final String SERIALIZED_NAME_CASH = "cash";
  @SerializedName(SERIALIZED_NAME_CASH)
  private String cash;

  public static final String SERIALIZED_NAME_OLD_RATE = "old_rate";
  @SerializedName(SERIALIZED_NAME_OLD_RATE)
  private String oldRate;

  public static final String SERIALIZED_NAME_NEW_RATE = "new_rate";
  @SerializedName(SERIALIZED_NAME_NEW_RATE)
  private String newRate;

  public Announcement() {
  }

  public Announcement id(String id) {
    this.id = id;
    return this;
  }

   /**
   * ID that is specific to a single announcement.
   * @return id
  **/
  @javax.annotation.Nonnull
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public Announcement corporateActionId(String corporateActionId) {
    this.corporateActionId = corporateActionId;
    return this;
  }

   /**
   * ID that remains consistent across all announcements for the same corporate action. Unlike ‘id’, this can be used to connect multiple announcements to see how the terms have changed throughout the lifecycle of the corporate action event.
   * @return corporateActionId
  **/
  @javax.annotation.Nonnull
  public String getCorporateActionId() {
    return corporateActionId;
  }

  public void setCorporateActionId(String corporateActionId) {
    this.corporateActionId = corporateActionId;
  }


  public Announcement caType(AnnouncementCAType caType) {
    this.caType = caType;
    return this;
  }

   /**
   * Get caType
   * @return caType
  **/
  @javax.annotation.Nonnull
  public AnnouncementCAType getCaType() {
    return caType;
  }

  public void setCaType(AnnouncementCAType caType) {
    this.caType = caType;
  }


  public Announcement caSubType(AnnouncementCASubType caSubType) {
    this.caSubType = caSubType;
    return this;
  }

   /**
   * Get caSubType
   * @return caSubType
  **/
  @javax.annotation.Nonnull
  public AnnouncementCASubType getCaSubType() {
    return caSubType;
  }

  public void setCaSubType(AnnouncementCASubType caSubType) {
    this.caSubType = caSubType;
  }


  public Announcement initiatingSymbol(String initiatingSymbol) {
    this.initiatingSymbol = initiatingSymbol;
    return this;
  }

   /**
   * Symbol of the company initiating the announcement.
   * @return initiatingSymbol
  **/
  @javax.annotation.Nonnull
  public String getInitiatingSymbol() {
    return initiatingSymbol;
  }

  public void setInitiatingSymbol(String initiatingSymbol) {
    this.initiatingSymbol = initiatingSymbol;
  }


  public Announcement initiatingOriginalCusip(String initiatingOriginalCusip) {
    this.initiatingOriginalCusip = initiatingOriginalCusip;
    return this;
  }

   /**
   * CUSIP of the company initiating the announcement.
   * @return initiatingOriginalCusip
  **/
  @javax.annotation.Nonnull
  public String getInitiatingOriginalCusip() {
    return initiatingOriginalCusip;
  }

  public void setInitiatingOriginalCusip(String initiatingOriginalCusip) {
    this.initiatingOriginalCusip = initiatingOriginalCusip;
  }


  public Announcement targetSymbol(String targetSymbol) {
    this.targetSymbol = targetSymbol;
    return this;
  }

   /**
   * Symbol of the child company involved in the announcement.
   * @return targetSymbol
  **/
  @javax.annotation.Nullable
  public String getTargetSymbol() {
    return targetSymbol;
  }

  public void setTargetSymbol(String targetSymbol) {
    this.targetSymbol = targetSymbol;
  }


  public Announcement targetOriginalCusip(String targetOriginalCusip) {
    this.targetOriginalCusip = targetOriginalCusip;
    return this;
  }

   /**
   * CUSIP of the child company involved in the announcement.
   * @return targetOriginalCusip
  **/
  @javax.annotation.Nullable
  public String getTargetOriginalCusip() {
    return targetOriginalCusip;
  }

  public void setTargetOriginalCusip(String targetOriginalCusip) {
    this.targetOriginalCusip = targetOriginalCusip;
  }


  public Announcement declarationDate(String declarationDate) {
    this.declarationDate = declarationDate;
    return this;
  }

   /**
   * Date the corporate action or subsequent terms update was announced.
   * @return declarationDate
  **/
  @javax.annotation.Nonnull
  public String getDeclarationDate() {
    return declarationDate;
  }

  public void setDeclarationDate(String declarationDate) {
    this.declarationDate = declarationDate;
  }


  public Announcement exDate(String exDate) {
    this.exDate = exDate;
    return this;
  }

   /**
   * The first date that purchasing a security will not result in a corporate action entitlement.
   * @return exDate
  **/
  @javax.annotation.Nullable
  public String getExDate() {
    return exDate;
  }

  public void setExDate(String exDate) {
    this.exDate = exDate;
  }


  public Announcement recordDate(String recordDate) {
    this.recordDate = recordDate;
    return this;
  }

   /**
   * The date an account must hold a settled position in the security in order to receive the corporate action entitlement.
   * @return recordDate
  **/
  @javax.annotation.Nullable
  public String getRecordDate() {
    return recordDate;
  }

  public void setRecordDate(String recordDate) {
    this.recordDate = recordDate;
  }


  public Announcement payableDate(String payableDate) {
    this.payableDate = payableDate;
    return this;
  }

   /**
   * The date the announcement will take effect. On this date, account stock and cash balances are expected to be processed accordingly.
   * @return payableDate
  **/
  @javax.annotation.Nonnull
  public String getPayableDate() {
    return payableDate;
  }

  public void setPayableDate(String payableDate) {
    this.payableDate = payableDate;
  }


  public Announcement cash(String cash) {
    this.cash = cash;
    return this;
  }

   /**
   * The amount of cash to be paid per share held by an account on the record date.
   * @return cash
  **/
  @javax.annotation.Nullable
  public String getCash() {
    return cash;
  }

  public void setCash(String cash) {
    this.cash = cash;
  }


  public Announcement oldRate(String oldRate) {
    this.oldRate = oldRate;
    return this;
  }

   /**
   * The denominator to determine any quantity change ratios in positions.
   * @return oldRate
  **/
  @javax.annotation.Nullable
  public String getOldRate() {
    return oldRate;
  }

  public void setOldRate(String oldRate) {
    this.oldRate = oldRate;
  }


  public Announcement newRate(String newRate) {
    this.newRate = newRate;
    return this;
  }

   /**
   * The numerator to determine any quantity change ratios in positions.
   * @return newRate
  **/
  @javax.annotation.Nullable
  public String getNewRate() {
    return newRate;
  }

  public void setNewRate(String newRate) {
    this.newRate = newRate;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Announcement announcement = (Announcement) o;
    return Objects.equals(this.id, announcement.id) &&
        Objects.equals(this.corporateActionId, announcement.corporateActionId) &&
        Objects.equals(this.caType, announcement.caType) &&
        Objects.equals(this.caSubType, announcement.caSubType) &&
        Objects.equals(this.initiatingSymbol, announcement.initiatingSymbol) &&
        Objects.equals(this.initiatingOriginalCusip, announcement.initiatingOriginalCusip) &&
        Objects.equals(this.targetSymbol, announcement.targetSymbol) &&
        Objects.equals(this.targetOriginalCusip, announcement.targetOriginalCusip) &&
        Objects.equals(this.declarationDate, announcement.declarationDate) &&
        Objects.equals(this.exDate, announcement.exDate) &&
        Objects.equals(this.recordDate, announcement.recordDate) &&
        Objects.equals(this.payableDate, announcement.payableDate) &&
        Objects.equals(this.cash, announcement.cash) &&
        Objects.equals(this.oldRate, announcement.oldRate) &&
        Objects.equals(this.newRate, announcement.newRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, corporateActionId, caType, caSubType, initiatingSymbol, initiatingOriginalCusip, targetSymbol, targetOriginalCusip, declarationDate, exDate, recordDate, payableDate, cash, oldRate, newRate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Announcement {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    corporateActionId: ").append(toIndentedString(corporateActionId)).append("\n");
    sb.append("    caType: ").append(toIndentedString(caType)).append("\n");
    sb.append("    caSubType: ").append(toIndentedString(caSubType)).append("\n");
    sb.append("    initiatingSymbol: ").append(toIndentedString(initiatingSymbol)).append("\n");
    sb.append("    initiatingOriginalCusip: ").append(toIndentedString(initiatingOriginalCusip)).append("\n");
    sb.append("    targetSymbol: ").append(toIndentedString(targetSymbol)).append("\n");
    sb.append("    targetOriginalCusip: ").append(toIndentedString(targetOriginalCusip)).append("\n");
    sb.append("    declarationDate: ").append(toIndentedString(declarationDate)).append("\n");
    sb.append("    exDate: ").append(toIndentedString(exDate)).append("\n");
    sb.append("    recordDate: ").append(toIndentedString(recordDate)).append("\n");
    sb.append("    payableDate: ").append(toIndentedString(payableDate)).append("\n");
    sb.append("    cash: ").append(toIndentedString(cash)).append("\n");
    sb.append("    oldRate: ").append(toIndentedString(oldRate)).append("\n");
    sb.append("    newRate: ").append(toIndentedString(newRate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("corporate_action_id");
    openapiFields.add("ca_type");
    openapiFields.add("ca_sub_type");
    openapiFields.add("initiating_symbol");
    openapiFields.add("initiating_original_cusip");
    openapiFields.add("target_symbol");
    openapiFields.add("target_original_cusip");
    openapiFields.add("declaration_date");
    openapiFields.add("ex_date");
    openapiFields.add("record_date");
    openapiFields.add("payable_date");
    openapiFields.add("cash");
    openapiFields.add("old_rate");
    openapiFields.add("new_rate");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("corporate_action_id");
    openapiRequiredFields.add("ca_type");
    openapiRequiredFields.add("ca_sub_type");
    openapiRequiredFields.add("initiating_symbol");
    openapiRequiredFields.add("initiating_original_cusip");
    openapiRequiredFields.add("target_symbol");
    openapiRequiredFields.add("target_original_cusip");
    openapiRequiredFields.add("declaration_date");
    openapiRequiredFields.add("ex_date");
    openapiRequiredFields.add("record_date");
    openapiRequiredFields.add("payable_date");
    openapiRequiredFields.add("cash");
    openapiRequiredFields.add("old_rate");
    openapiRequiredFields.add("new_rate");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Announcement.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Announcement is not found in the empty JSON string", Announcement.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Announcement.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Announcement` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Announcement.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("corporate_action_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `corporate_action_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("corporate_action_id").toString()));
      }
      // validate the required field `ca_type`
      AnnouncementCAType.validateJsonElement(jsonObj.get("ca_type"));
      // validate the required field `ca_sub_type`
      AnnouncementCASubType.validateJsonElement(jsonObj.get("ca_sub_type"));
      if (!jsonObj.get("initiating_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `initiating_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("initiating_symbol").toString()));
      }
      if (!jsonObj.get("initiating_original_cusip").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `initiating_original_cusip` to be a primitive type in the JSON string but got `%s`", jsonObj.get("initiating_original_cusip").toString()));
      }
      if ((jsonObj.get("target_symbol") != null && !jsonObj.get("target_symbol").isJsonNull()) && !jsonObj.get("target_symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `target_symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("target_symbol").toString()));
      }
      if ((jsonObj.get("target_original_cusip") != null && !jsonObj.get("target_original_cusip").isJsonNull()) && !jsonObj.get("target_original_cusip").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `target_original_cusip` to be a primitive type in the JSON string but got `%s`", jsonObj.get("target_original_cusip").toString()));
      }
      if (!jsonObj.get("declaration_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `declaration_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("declaration_date").toString()));
      }
      if ((jsonObj.get("ex_date") != null && !jsonObj.get("ex_date").isJsonNull()) && !jsonObj.get("ex_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ex_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ex_date").toString()));
      }
      if ((jsonObj.get("record_date") != null && !jsonObj.get("record_date").isJsonNull()) && !jsonObj.get("record_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `record_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("record_date").toString()));
      }
      if (!jsonObj.get("payable_date").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `payable_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("payable_date").toString()));
      }
      if ((jsonObj.get("cash") != null && !jsonObj.get("cash").isJsonNull()) && !jsonObj.get("cash").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cash` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cash").toString()));
      }
      if ((jsonObj.get("old_rate") != null && !jsonObj.get("old_rate").isJsonNull()) && !jsonObj.get("old_rate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `old_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("old_rate").toString()));
      }
      if ((jsonObj.get("new_rate") != null && !jsonObj.get("new_rate").isJsonNull()) && !jsonObj.get("new_rate").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `new_rate` to be a primitive type in the JSON string but got `%s`", jsonObj.get("new_rate").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Announcement.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Announcement' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Announcement> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Announcement.class));

       return (TypeAdapter<T>) new TypeAdapter<Announcement>() {
           @Override
           public void write(JsonWriter out, Announcement value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Announcement read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Announcement given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Announcement
  * @throws IOException if the JSON string is invalid with respect to Announcement
  */
  public static Announcement fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Announcement.class);
  }

 /**
  * Convert an instance of Announcement to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

