/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.AgreementType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Agreement
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Agreement {
  public static final String SERIALIZED_NAME_AGREEMENT = "agreement";
  @SerializedName(SERIALIZED_NAME_AGREEMENT)
  private AgreementType agreement;

  public static final String SERIALIZED_NAME_SIGNED_AT = "signed_at";
  @SerializedName(SERIALIZED_NAME_SIGNED_AT)
  private OffsetDateTime signedAt;

  public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
  @SerializedName(SERIALIZED_NAME_IP_ADDRESS)
  private String ipAddress;

  public static final String SERIALIZED_NAME_REVISION = "revision";
  @SerializedName(SERIALIZED_NAME_REVISION)
  private String revision;

  public Agreement() {
  }

  public Agreement agreement(AgreementType agreement) {
    this.agreement = agreement;
    return this;
  }

   /**
   * Get agreement
   * @return agreement
  **/
  @javax.annotation.Nonnull
  public AgreementType getAgreement() {
    return agreement;
  }

  public void setAgreement(AgreementType agreement) {
    this.agreement = agreement;
  }


  public Agreement signedAt(OffsetDateTime signedAt) {
    this.signedAt = signedAt;
    return this;
  }

   /**
   * The timestamp the agreement was signed.
   * @return signedAt
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getSignedAt() {
    return signedAt;
  }

  public void setSignedAt(OffsetDateTime signedAt) {
    this.signedAt = signedAt;
  }


  public Agreement ipAddress(String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * The ip_address the signed agreements were sent from by the user.
   * @return ipAddress
  **/
  @javax.annotation.Nonnull
  public String getIpAddress() {
    return ipAddress;
  }

  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public Agreement revision(String revision) {
    this.revision = revision;
    return this;
  }

   /**
   * The revision date if agreement is a revision.
   * @return revision
  **/
  @javax.annotation.Nullable
  public String getRevision() {
    return revision;
  }

  public void setRevision(String revision) {
    this.revision = revision;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Agreement agreement = (Agreement) o;
    return Objects.equals(this.agreement, agreement.agreement) &&
        Objects.equals(this.signedAt, agreement.signedAt) &&
        Objects.equals(this.ipAddress, agreement.ipAddress) &&
        Objects.equals(this.revision, agreement.revision);
  }

  @Override
  public int hashCode() {
    return Objects.hash(agreement, signedAt, ipAddress, revision);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Agreement {\n");
    sb.append("    agreement: ").append(toIndentedString(agreement)).append("\n");
    sb.append("    signedAt: ").append(toIndentedString(signedAt)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    revision: ").append(toIndentedString(revision)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("agreement");
    openapiFields.add("signed_at");
    openapiFields.add("ip_address");
    openapiFields.add("revision");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("agreement");
    openapiRequiredFields.add("signed_at");
    openapiRequiredFields.add("ip_address");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Agreement.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Agreement is not found in the empty JSON string", Agreement.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Agreement.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Agreement` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Agreement.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the required field `agreement`
      AgreementType.validateJsonElement(jsonObj.get("agreement"));
      if (!jsonObj.get("ip_address").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ip_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ip_address").toString()));
      }
      if ((jsonObj.get("revision") != null && !jsonObj.get("revision").isJsonNull()) && !jsonObj.get("revision").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `revision` to be a primitive type in the JSON string but got `%s`", jsonObj.get("revision").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Agreement.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Agreement' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Agreement> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Agreement.class));

       return (TypeAdapter<T>) new TypeAdapter<Agreement>() {
           @Override
           public void write(JsonWriter out, Agreement value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Agreement read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Agreement given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Agreement
  * @throws IOException if the JSON string is invalid with respect to Agreement
  */
  public static Agreement fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Agreement.class);
  }

 /**
  * Convert an instance of Agreement to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

