/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * AggregatePositionResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AggregatePositionResponse {
  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_CUSIP = "cusip";
  @SerializedName(SERIALIZED_NAME_CUSIP)
  private BigDecimal cusip;

  public static final String SERIALIZED_NAME_LONG_QTY = "long_qty";
  @SerializedName(SERIALIZED_NAME_LONG_QTY)
  private BigDecimal longQty;

  public static final String SERIALIZED_NAME_SHORT_QTY = "short_qty";
  @SerializedName(SERIALIZED_NAME_SHORT_QTY)
  private BigDecimal shortQty;

  public static final String SERIALIZED_NAME_LONG_MARKET_VALUE = "long_market_value";
  @SerializedName(SERIALIZED_NAME_LONG_MARKET_VALUE)
  private BigDecimal longMarketValue;

  public static final String SERIALIZED_NAME_SHORT_MARKET_VALUE = "short_market_value";
  @SerializedName(SERIALIZED_NAME_SHORT_MARKET_VALUE)
  private BigDecimal shortMarketValue;

  public static final String SERIALIZED_NAME_NUM_ACCOUNTS = "num_accounts";
  @SerializedName(SERIALIZED_NAME_NUM_ACCOUNTS)
  private Integer numAccounts;

  public static final String SERIALIZED_NAME_ASSET_TYPE = "asset_type";
  @SerializedName(SERIALIZED_NAME_ASSET_TYPE)
  private AssetClass assetType;

  public static final String SERIALIZED_NAME_CLOSING_PRICE = "closing_price";
  @SerializedName(SERIALIZED_NAME_CLOSING_PRICE)
  private BigDecimal closingPrice;

  public AggregatePositionResponse() {
  }

  public AggregatePositionResponse symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Symbol of asset
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public AggregatePositionResponse cusip(BigDecimal cusip) {
    this.cusip = cusip;
    return this;
  }

   /**
   * Cusip (9 digits, can start with 0’s)
   * @return cusip
  **/
  @javax.annotation.Nullable
  public BigDecimal getCusip() {
    return cusip;
  }

  public void setCusip(BigDecimal cusip) {
    this.cusip = cusip;
  }


  public AggregatePositionResponse longQty(BigDecimal longQty) {
    this.longQty = longQty;
    return this;
  }

   /**
   * Aggregate number of shares that the partner is long
   * @return longQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getLongQty() {
    return longQty;
  }

  public void setLongQty(BigDecimal longQty) {
    this.longQty = longQty;
  }


  public AggregatePositionResponse shortQty(BigDecimal shortQty) {
    this.shortQty = shortQty;
    return this;
  }

   /**
   * Aggregate number of shares that the partner is short
   * @return shortQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getShortQty() {
    return shortQty;
  }

  public void setShortQty(BigDecimal shortQty) {
    this.shortQty = shortQty;
  }


  public AggregatePositionResponse longMarketValue(BigDecimal longMarketValue) {
    this.longMarketValue = longMarketValue;
    return this;
  }

   /**
   * Aggregate notional dollar amount of the partner’s long positions
   * @return longMarketValue
  **/
  @javax.annotation.Nullable
  public BigDecimal getLongMarketValue() {
    return longMarketValue;
  }

  public void setLongMarketValue(BigDecimal longMarketValue) {
    this.longMarketValue = longMarketValue;
  }


  public AggregatePositionResponse shortMarketValue(BigDecimal shortMarketValue) {
    this.shortMarketValue = shortMarketValue;
    return this;
  }

   /**
   * Aggregate notional dollar amount of the partner’s short positions
   * @return shortMarketValue
  **/
  @javax.annotation.Nullable
  public BigDecimal getShortMarketValue() {
    return shortMarketValue;
  }

  public void setShortMarketValue(BigDecimal shortMarketValue) {
    this.shortMarketValue = shortMarketValue;
  }


  public AggregatePositionResponse numAccounts(Integer numAccounts) {
    this.numAccounts = numAccounts;
    return this;
  }

   /**
   * Number of accounts that have a position in this asset (either long or short)
   * @return numAccounts
  **/
  @javax.annotation.Nullable
  public Integer getNumAccounts() {
    return numAccounts;
  }

  public void setNumAccounts(Integer numAccounts) {
    this.numAccounts = numAccounts;
  }


  public AggregatePositionResponse assetType(AssetClass assetType) {
    this.assetType = assetType;
    return this;
  }

   /**
   * Get assetType
   * @return assetType
  **/
  @javax.annotation.Nullable
  public AssetClass getAssetType() {
    return assetType;
  }

  public void setAssetType(AssetClass assetType) {
    this.assetType = assetType;
  }


  public AggregatePositionResponse closingPrice(BigDecimal closingPrice) {
    this.closingPrice = closingPrice;
    return this;
  }

   /**
   * EOD asset price per share at session close
   * @return closingPrice
  **/
  @javax.annotation.Nullable
  public BigDecimal getClosingPrice() {
    return closingPrice;
  }

  public void setClosingPrice(BigDecimal closingPrice) {
    this.closingPrice = closingPrice;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AggregatePositionResponse aggregatePositionResponse = (AggregatePositionResponse) o;
    return Objects.equals(this.symbol, aggregatePositionResponse.symbol) &&
        Objects.equals(this.cusip, aggregatePositionResponse.cusip) &&
        Objects.equals(this.longQty, aggregatePositionResponse.longQty) &&
        Objects.equals(this.shortQty, aggregatePositionResponse.shortQty) &&
        Objects.equals(this.longMarketValue, aggregatePositionResponse.longMarketValue) &&
        Objects.equals(this.shortMarketValue, aggregatePositionResponse.shortMarketValue) &&
        Objects.equals(this.numAccounts, aggregatePositionResponse.numAccounts) &&
        Objects.equals(this.assetType, aggregatePositionResponse.assetType) &&
        Objects.equals(this.closingPrice, aggregatePositionResponse.closingPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(symbol, cusip, longQty, shortQty, longMarketValue, shortMarketValue, numAccounts, assetType, closingPrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AggregatePositionResponse {\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    cusip: ").append(toIndentedString(cusip)).append("\n");
    sb.append("    longQty: ").append(toIndentedString(longQty)).append("\n");
    sb.append("    shortQty: ").append(toIndentedString(shortQty)).append("\n");
    sb.append("    longMarketValue: ").append(toIndentedString(longMarketValue)).append("\n");
    sb.append("    shortMarketValue: ").append(toIndentedString(shortMarketValue)).append("\n");
    sb.append("    numAccounts: ").append(toIndentedString(numAccounts)).append("\n");
    sb.append("    assetType: ").append(toIndentedString(assetType)).append("\n");
    sb.append("    closingPrice: ").append(toIndentedString(closingPrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("symbol");
    openapiFields.add("cusip");
    openapiFields.add("long_qty");
    openapiFields.add("short_qty");
    openapiFields.add("long_market_value");
    openapiFields.add("short_market_value");
    openapiFields.add("num_accounts");
    openapiFields.add("asset_type");
    openapiFields.add("closing_price");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AggregatePositionResponse.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AggregatePositionResponse is not found in the empty JSON string", AggregatePositionResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AggregatePositionResponse.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AggregatePositionResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("cusip") != null && !jsonObj.get("cusip").isJsonNull()) && !jsonObj.get("cusip").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cusip` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cusip").toString()));
      }
      if ((jsonObj.get("long_qty") != null && !jsonObj.get("long_qty").isJsonNull()) && !jsonObj.get("long_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `long_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("long_qty").toString()));
      }
      if ((jsonObj.get("short_qty") != null && !jsonObj.get("short_qty").isJsonNull()) && !jsonObj.get("short_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `short_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("short_qty").toString()));
      }
      if ((jsonObj.get("long_market_value") != null && !jsonObj.get("long_market_value").isJsonNull()) && !jsonObj.get("long_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `long_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("long_market_value").toString()));
      }
      if ((jsonObj.get("short_market_value") != null && !jsonObj.get("short_market_value").isJsonNull()) && !jsonObj.get("short_market_value").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `short_market_value` to be a primitive type in the JSON string but got `%s`", jsonObj.get("short_market_value").toString()));
      }
      // validate the optional field `asset_type`
      if (jsonObj.get("asset_type") != null && !jsonObj.get("asset_type").isJsonNull()) {
        AssetClass.validateJsonElement(jsonObj.get("asset_type"));
      }
      if ((jsonObj.get("closing_price") != null && !jsonObj.get("closing_price").isJsonNull()) && !jsonObj.get("closing_price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `closing_price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("closing_price").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AggregatePositionResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AggregatePositionResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AggregatePositionResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AggregatePositionResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<AggregatePositionResponse>() {
           @Override
           public void write(JsonWriter out, AggregatePositionResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AggregatePositionResponse read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AggregatePositionResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AggregatePositionResponse
  * @throws IOException if the JSON string is invalid with respect to AggregatePositionResponse
  */
  public static AggregatePositionResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AggregatePositionResponse.class);
  }

 /**
  * Convert an instance of AggregatePositionResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

