/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.RestrictToLiquidationReasons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * These configurations show account properties that are overriden either by Alpaca Broker Operations or an automated process.  These values cannot be modified by the Broker Partners.   For the **events** interface we are only broadcasting changes to admin configurations. In case nothing changed for a flag that will not be included in unrelated update events.  Depending on the type of the Admin Configurations the sent event will behave differently. For bool flags we are only sending the new value.  For example the following payload means, that the disable_shorting flag was set to true from false:  &#x60;&#x60;&#x60; {   \&quot;disable_shorting\&quot;: false } &#x60;&#x60;&#x60;  For other data types, we are embeding the old and new values into the payload. For example changing the max_margin_multiplier from 4 to 1 will yield this payload:  &#x60;&#x60;&#x60; {   \&quot;max_margin_multiplier\&quot;: {     \&quot;old\&quot;: 4,     \&quot;new\&quot;: 1,   } } &#x60;&#x60;&#x60;  Introducing an override value from the default will yield a null value as old. For example restricting the max_margin_multipler to 1 from default will yield the following payload:  &#x60;&#x60;&#x60; {   \&quot;max_margin_multiplier\&quot;: {     \&quot;old\&quot;: null,     \&quot;new\&quot;: 1,   } } &#x60;&#x60;&#x60;
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AdminConfigurations {
  public static final String SERIALIZED_NAME_RESTRICT_TO_LIQUIDATION_REASONS = "restrict_to_liquidation_reasons";
  @SerializedName(SERIALIZED_NAME_RESTRICT_TO_LIQUIDATION_REASONS)
  private RestrictToLiquidationReasons restrictToLiquidationReasons;

  public static final String SERIALIZED_NAME_OUTGOING_TRANSFERS_BLOCKED = "outgoing_transfers_blocked";
  @SerializedName(SERIALIZED_NAME_OUTGOING_TRANSFERS_BLOCKED)
  private Boolean outgoingTransfersBlocked;

  public static final String SERIALIZED_NAME_INCOMING_TRANSFERS_BLOCKED = "incoming_transfers_blocked";
  @SerializedName(SERIALIZED_NAME_INCOMING_TRANSFERS_BLOCKED)
  private Boolean incomingTransfersBlocked;

  public static final String SERIALIZED_NAME_DISABLE_SHORTING = "disable_shorting";
  @SerializedName(SERIALIZED_NAME_DISABLE_SHORTING)
  private Boolean disableShorting;

  public static final String SERIALIZED_NAME_DISABLE_FRACTIONAL = "disable_fractional";
  @SerializedName(SERIALIZED_NAME_DISABLE_FRACTIONAL)
  private Boolean disableFractional;

  public static final String SERIALIZED_NAME_DISABLE_CRYPTO = "disable_crypto";
  @SerializedName(SERIALIZED_NAME_DISABLE_CRYPTO)
  private Boolean disableCrypto;

  public static final String SERIALIZED_NAME_DISABLE_DAY_TRADING = "disable_day_trading";
  @SerializedName(SERIALIZED_NAME_DISABLE_DAY_TRADING)
  private Boolean disableDayTrading;

  public static final String SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER = "max_margin_multiplier";
  @SerializedName(SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER)
  private Integer maxMarginMultiplier;

  public static final String SERIALIZED_NAME_ACCT_DAILY_TRANSFER_LIMIT = "acct_daily_transfer_limit";
  @SerializedName(SERIALIZED_NAME_ACCT_DAILY_TRANSFER_LIMIT)
  private BigDecimal acctDailyTransferLimit;

  public AdminConfigurations() {
  }

  public AdminConfigurations restrictToLiquidationReasons(RestrictToLiquidationReasons restrictToLiquidationReasons) {
    this.restrictToLiquidationReasons = restrictToLiquidationReasons;
    return this;
  }

   /**
   * Get restrictToLiquidationReasons
   * @return restrictToLiquidationReasons
  **/
  @javax.annotation.Nullable
  public RestrictToLiquidationReasons getRestrictToLiquidationReasons() {
    return restrictToLiquidationReasons;
  }

  public void setRestrictToLiquidationReasons(RestrictToLiquidationReasons restrictToLiquidationReasons) {
    this.restrictToLiquidationReasons = restrictToLiquidationReasons;
  }


  public AdminConfigurations outgoingTransfersBlocked(Boolean outgoingTransfersBlocked) {
    this.outgoingTransfersBlocked = outgoingTransfersBlocked;
    return this;
  }

   /**
   * Wire-out transfers blocked for the account if false
   * @return outgoingTransfersBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getOutgoingTransfersBlocked() {
    return outgoingTransfersBlocked;
  }

  public void setOutgoingTransfersBlocked(Boolean outgoingTransfersBlocked) {
    this.outgoingTransfersBlocked = outgoingTransfersBlocked;
  }


  public AdminConfigurations incomingTransfersBlocked(Boolean incomingTransfersBlocked) {
    this.incomingTransfersBlocked = incomingTransfersBlocked;
    return this;
  }

   /**
   * Deposits are blocked for the account if false
   * @return incomingTransfersBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getIncomingTransfersBlocked() {
    return incomingTransfersBlocked;
  }

  public void setIncomingTransfersBlocked(Boolean incomingTransfersBlocked) {
    this.incomingTransfersBlocked = incomingTransfersBlocked;
  }


  public AdminConfigurations disableShorting(Boolean disableShorting) {
    this.disableShorting = disableShorting;
    return this;
  }

   /**
   * If true the account is not allowed to create short position orders
   * @return disableShorting
  **/
  @javax.annotation.Nullable
  public Boolean getDisableShorting() {
    return disableShorting;
  }

  public void setDisableShorting(Boolean disableShorting) {
    this.disableShorting = disableShorting;
  }


  public AdminConfigurations disableFractional(Boolean disableFractional) {
    this.disableFractional = disableFractional;
    return this;
  }

   /**
   * If true, the account cannot create orders for fractional share positions
   * @return disableFractional
  **/
  @javax.annotation.Nullable
  public Boolean getDisableFractional() {
    return disableFractional;
  }

  public void setDisableFractional(Boolean disableFractional) {
    this.disableFractional = disableFractional;
  }


  public AdminConfigurations disableCrypto(Boolean disableCrypto) {
    this.disableCrypto = disableCrypto;
    return this;
  }

   /**
   * If true, the account is not allowed to trade cryptos
   * @return disableCrypto
  **/
  @javax.annotation.Nullable
  public Boolean getDisableCrypto() {
    return disableCrypto;
  }

  public void setDisableCrypto(Boolean disableCrypto) {
    this.disableCrypto = disableCrypto;
  }


  public AdminConfigurations disableDayTrading(Boolean disableDayTrading) {
    this.disableDayTrading = disableDayTrading;
    return this;
  }

   /**
   * If true, the account is not allowed to day trade (e.g. buy and sell the same security on the same day)
   * @return disableDayTrading
  **/
  @javax.annotation.Nullable
  public Boolean getDisableDayTrading() {
    return disableDayTrading;
  }

  public void setDisableDayTrading(Boolean disableDayTrading) {
    this.disableDayTrading = disableDayTrading;
  }


  public AdminConfigurations maxMarginMultiplier(Integer maxMarginMultiplier) {
    this.maxMarginMultiplier = maxMarginMultiplier;
    return this;
  }

   /**
   * Max margin multipler is set by admin to this value
   * @return maxMarginMultiplier
  **/
  @javax.annotation.Nullable
  public Integer getMaxMarginMultiplier() {
    return maxMarginMultiplier;
  }

  public void setMaxMarginMultiplier(Integer maxMarginMultiplier) {
    this.maxMarginMultiplier = maxMarginMultiplier;
  }


  public AdminConfigurations acctDailyTransferLimit(BigDecimal acctDailyTransferLimit) {
    this.acctDailyTransferLimit = acctDailyTransferLimit;
    return this;
  }

   /**
   * Override the correspondent level daily transfer limits
   * @return acctDailyTransferLimit
  **/
  @javax.annotation.Nullable
  public BigDecimal getAcctDailyTransferLimit() {
    return acctDailyTransferLimit;
  }

  public void setAcctDailyTransferLimit(BigDecimal acctDailyTransferLimit) {
    this.acctDailyTransferLimit = acctDailyTransferLimit;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminConfigurations adminConfigurations = (AdminConfigurations) o;
    return Objects.equals(this.restrictToLiquidationReasons, adminConfigurations.restrictToLiquidationReasons) &&
        Objects.equals(this.outgoingTransfersBlocked, adminConfigurations.outgoingTransfersBlocked) &&
        Objects.equals(this.incomingTransfersBlocked, adminConfigurations.incomingTransfersBlocked) &&
        Objects.equals(this.disableShorting, adminConfigurations.disableShorting) &&
        Objects.equals(this.disableFractional, adminConfigurations.disableFractional) &&
        Objects.equals(this.disableCrypto, adminConfigurations.disableCrypto) &&
        Objects.equals(this.disableDayTrading, adminConfigurations.disableDayTrading) &&
        Objects.equals(this.maxMarginMultiplier, adminConfigurations.maxMarginMultiplier) &&
        Objects.equals(this.acctDailyTransferLimit, adminConfigurations.acctDailyTransferLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(restrictToLiquidationReasons, outgoingTransfersBlocked, incomingTransfersBlocked, disableShorting, disableFractional, disableCrypto, disableDayTrading, maxMarginMultiplier, acctDailyTransferLimit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminConfigurations {\n");
    sb.append("    restrictToLiquidationReasons: ").append(toIndentedString(restrictToLiquidationReasons)).append("\n");
    sb.append("    outgoingTransfersBlocked: ").append(toIndentedString(outgoingTransfersBlocked)).append("\n");
    sb.append("    incomingTransfersBlocked: ").append(toIndentedString(incomingTransfersBlocked)).append("\n");
    sb.append("    disableShorting: ").append(toIndentedString(disableShorting)).append("\n");
    sb.append("    disableFractional: ").append(toIndentedString(disableFractional)).append("\n");
    sb.append("    disableCrypto: ").append(toIndentedString(disableCrypto)).append("\n");
    sb.append("    disableDayTrading: ").append(toIndentedString(disableDayTrading)).append("\n");
    sb.append("    maxMarginMultiplier: ").append(toIndentedString(maxMarginMultiplier)).append("\n");
    sb.append("    acctDailyTransferLimit: ").append(toIndentedString(acctDailyTransferLimit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("restrict_to_liquidation_reasons");
    openapiFields.add("outgoing_transfers_blocked");
    openapiFields.add("incoming_transfers_blocked");
    openapiFields.add("disable_shorting");
    openapiFields.add("disable_fractional");
    openapiFields.add("disable_crypto");
    openapiFields.add("disable_day_trading");
    openapiFields.add("max_margin_multiplier");
    openapiFields.add("acct_daily_transfer_limit");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AdminConfigurations.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AdminConfigurations is not found in the empty JSON string", AdminConfigurations.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AdminConfigurations.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AdminConfigurations` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `restrict_to_liquidation_reasons`
      if (jsonObj.get("restrict_to_liquidation_reasons") != null && !jsonObj.get("restrict_to_liquidation_reasons").isJsonNull()) {
        RestrictToLiquidationReasons.validateJsonElement(jsonObj.get("restrict_to_liquidation_reasons"));
      }
      if ((jsonObj.get("acct_daily_transfer_limit") != null && !jsonObj.get("acct_daily_transfer_limit").isJsonNull()) && !jsonObj.get("acct_daily_transfer_limit").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `acct_daily_transfer_limit` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acct_daily_transfer_limit").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AdminConfigurations.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AdminConfigurations' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AdminConfigurations> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AdminConfigurations.class));

       return (TypeAdapter<T>) new TypeAdapter<AdminConfigurations>() {
           @Override
           public void write(JsonWriter out, AdminConfigurations value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AdminConfigurations read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AdminConfigurations given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AdminConfigurations
  * @throws IOException if the JSON string is invalid with respect to AdminConfigurations
  */
  public static AdminConfigurations fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AdminConfigurations.class);
  }

 /**
  * Convert an instance of AdminConfigurations to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

