/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionBelongsTo;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionCategory;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionContextTransactionCancelContext;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionCreatedBy;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionType;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminActionVisibility;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents structure of a TransactionCancel type AdminAction
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AdminActionTransactionCancel {
  public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
  @SerializedName(SERIALIZED_NAME_EVENT_ID)
  private String eventId;

  public static final String SERIALIZED_NAME_REPLACES_EVENT_ID = "replaces_event_id";
  @SerializedName(SERIALIZED_NAME_REPLACES_EVENT_ID)
  private String replacesEventId;

  public static final String SERIALIZED_NAME_AT = "at";
  @SerializedName(SERIALIZED_NAME_AT)
  private OffsetDateTime at;

  public static final String SERIALIZED_NAME_BELONGS_TO = "belongs_to";
  @SerializedName(SERIALIZED_NAME_BELONGS_TO)
  private AdminActionBelongsTo belongsTo;

  public static final String SERIALIZED_NAME_CREATED_BY = "created_by";
  @SerializedName(SERIALIZED_NAME_CREATED_BY)
  private AdminActionCreatedBy createdBy;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private AdminActionType type;

  public static final String SERIALIZED_NAME_CATEGORY = "category";
  @SerializedName(SERIALIZED_NAME_CATEGORY)
  private AdminActionCategory category;

  public static final String SERIALIZED_NAME_VISIBILITY = "visibility";
  @SerializedName(SERIALIZED_NAME_VISIBILITY)
  private AdminActionVisibility visibility;

  public static final String SERIALIZED_NAME_NOTE = "note";
  @SerializedName(SERIALIZED_NAME_NOTE)
  private String note;

  public static final String SERIALIZED_NAME_CORRESPONDENT = "correspondent";
  @SerializedName(SERIALIZED_NAME_CORRESPONDENT)
  private String correspondent;

  public static final String SERIALIZED_NAME_CONTEXT = "context";
  @SerializedName(SERIALIZED_NAME_CONTEXT)
  private AdminActionContextTransactionCancelContext context;

  public AdminActionTransactionCancel() {
  }

  public AdminActionTransactionCancel eventId(String eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * Lexically sortable, monotonically increasing character array
   * @return eventId
  **/
  @javax.annotation.Nonnull
  public String getEventId() {
    return eventId;
  }

  public void setEventId(String eventId) {
    this.eventId = eventId;
  }


  public AdminActionTransactionCancel replacesEventId(String replacesEventId) {
    this.replacesEventId = replacesEventId;
    return this;
  }

   /**
   * Id of the replaced event (optional)
   * @return replacesEventId
  **/
  @javax.annotation.Nullable
  public String getReplacesEventId() {
    return replacesEventId;
  }

  public void setReplacesEventId(String replacesEventId) {
    this.replacesEventId = replacesEventId;
  }


  public AdminActionTransactionCancel at(OffsetDateTime at) {
    this.at = at;
    return this;
  }

   /**
   * Timestamp of event
   * @return at
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getAt() {
    return at;
  }

  public void setAt(OffsetDateTime at) {
    this.at = at;
  }


  public AdminActionTransactionCancel belongsTo(AdminActionBelongsTo belongsTo) {
    this.belongsTo = belongsTo;
    return this;
  }

   /**
   * Get belongsTo
   * @return belongsTo
  **/
  @javax.annotation.Nonnull
  public AdminActionBelongsTo getBelongsTo() {
    return belongsTo;
  }

  public void setBelongsTo(AdminActionBelongsTo belongsTo) {
    this.belongsTo = belongsTo;
  }


  public AdminActionTransactionCancel createdBy(AdminActionCreatedBy createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * Get createdBy
   * @return createdBy
  **/
  @javax.annotation.Nonnull
  public AdminActionCreatedBy getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(AdminActionCreatedBy createdBy) {
    this.createdBy = createdBy;
  }


  public AdminActionTransactionCancel type(AdminActionType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nonnull
  public AdminActionType getType() {
    return type;
  }

  public void setType(AdminActionType type) {
    this.type = type;
  }


  public AdminActionTransactionCancel category(AdminActionCategory category) {
    this.category = category;
    return this;
  }

   /**
   * Get category
   * @return category
  **/
  @javax.annotation.Nonnull
  public AdminActionCategory getCategory() {
    return category;
  }

  public void setCategory(AdminActionCategory category) {
    this.category = category;
  }


  public AdminActionTransactionCancel visibility(AdminActionVisibility visibility) {
    this.visibility = visibility;
    return this;
  }

   /**
   * Get visibility
   * @return visibility
  **/
  @javax.annotation.Nonnull
  public AdminActionVisibility getVisibility() {
    return visibility;
  }

  public void setVisibility(AdminActionVisibility visibility) {
    this.visibility = visibility;
  }


  public AdminActionTransactionCancel note(String note) {
    this.note = note;
    return this;
  }

   /**
   * Free text form description of the admin action
   * @return note
  **/
  @javax.annotation.Nonnull
  public String getNote() {
    return note;
  }

  public void setNote(String note) {
    this.note = note;
  }


  public AdminActionTransactionCancel correspondent(String correspondent) {
    this.correspondent = correspondent;
    return this;
  }

   /**
   * Related correspondent
   * @return correspondent
  **/
  @javax.annotation.Nonnull
  public String getCorrespondent() {
    return correspondent;
  }

  public void setCorrespondent(String correspondent) {
    this.correspondent = correspondent;
  }


  public AdminActionTransactionCancel context(AdminActionContextTransactionCancelContext context) {
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @javax.annotation.Nonnull
  public AdminActionContextTransactionCancelContext getContext() {
    return context;
  }

  public void setContext(AdminActionContextTransactionCancelContext context) {
    this.context = context;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminActionTransactionCancel adminActionTransactionCancel = (AdminActionTransactionCancel) o;
    return Objects.equals(this.eventId, adminActionTransactionCancel.eventId) &&
        Objects.equals(this.replacesEventId, adminActionTransactionCancel.replacesEventId) &&
        Objects.equals(this.at, adminActionTransactionCancel.at) &&
        Objects.equals(this.belongsTo, adminActionTransactionCancel.belongsTo) &&
        Objects.equals(this.createdBy, adminActionTransactionCancel.createdBy) &&
        Objects.equals(this.type, adminActionTransactionCancel.type) &&
        Objects.equals(this.category, adminActionTransactionCancel.category) &&
        Objects.equals(this.visibility, adminActionTransactionCancel.visibility) &&
        Objects.equals(this.note, adminActionTransactionCancel.note) &&
        Objects.equals(this.correspondent, adminActionTransactionCancel.correspondent) &&
        Objects.equals(this.context, adminActionTransactionCancel.context);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventId, replacesEventId, at, belongsTo, createdBy, type, category, visibility, note, correspondent, context);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminActionTransactionCancel {\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    replacesEventId: ").append(toIndentedString(replacesEventId)).append("\n");
    sb.append("    at: ").append(toIndentedString(at)).append("\n");
    sb.append("    belongsTo: ").append(toIndentedString(belongsTo)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    correspondent: ").append(toIndentedString(correspondent)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("event_id");
    openapiFields.add("replaces_event_id");
    openapiFields.add("at");
    openapiFields.add("belongs_to");
    openapiFields.add("created_by");
    openapiFields.add("type");
    openapiFields.add("category");
    openapiFields.add("visibility");
    openapiFields.add("note");
    openapiFields.add("correspondent");
    openapiFields.add("context");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("event_id");
    openapiRequiredFields.add("at");
    openapiRequiredFields.add("belongs_to");
    openapiRequiredFields.add("created_by");
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("category");
    openapiRequiredFields.add("visibility");
    openapiRequiredFields.add("note");
    openapiRequiredFields.add("correspondent");
    openapiRequiredFields.add("context");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AdminActionTransactionCancel.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AdminActionTransactionCancel is not found in the empty JSON string", AdminActionTransactionCancel.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AdminActionTransactionCancel.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AdminActionTransactionCancel` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AdminActionTransactionCancel.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("event_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `event_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("event_id").toString()));
      }
      if ((jsonObj.get("replaces_event_id") != null && !jsonObj.get("replaces_event_id").isJsonNull()) && !jsonObj.get("replaces_event_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `replaces_event_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("replaces_event_id").toString()));
      }
      // validate the required field `belongs_to`
      AdminActionBelongsTo.validateJsonElement(jsonObj.get("belongs_to"));
      // validate the required field `created_by`
      AdminActionCreatedBy.validateJsonElement(jsonObj.get("created_by"));
      // validate the required field `type`
      AdminActionType.validateJsonElement(jsonObj.get("type"));
      // validate the required field `category`
      AdminActionCategory.validateJsonElement(jsonObj.get("category"));
      // validate the required field `visibility`
      AdminActionVisibility.validateJsonElement(jsonObj.get("visibility"));
      if (!jsonObj.get("note").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `note` to be a primitive type in the JSON string but got `%s`", jsonObj.get("note").toString()));
      }
      if (!jsonObj.get("correspondent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `correspondent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("correspondent").toString()));
      }
      // validate the required field `context`
      AdminActionContextTransactionCancelContext.validateJsonElement(jsonObj.get("context"));
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AdminActionTransactionCancel.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AdminActionTransactionCancel' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AdminActionTransactionCancel> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AdminActionTransactionCancel.class));

       return (TypeAdapter<T>) new TypeAdapter<AdminActionTransactionCancel>() {
           @Override
           public void write(JsonWriter out, AdminActionTransactionCancel value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AdminActionTransactionCancel read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AdminActionTransactionCancel given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AdminActionTransactionCancel
  * @throws IOException if the JSON string is invalid with respect to AdminActionTransactionCancel
  */
  public static AdminActionTransactionCancel fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AdminActionTransactionCancel.class);
  }

 /**
  * Convert an instance of AdminActionTransactionCancel to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

