/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Represents the various kinds of activity.  TradeActivity&#39;s will always have the type &#x60;FILL&#x60;  - **FILL**   Order Fills (Partial/Full) - **ACATC**   ACATS IN/OUT (Cash) - **ACATS**   ACATS IN/OUT (Securities) - **CIL**   Cash in Lieu of Stock - **CSD**   Cash Disbursement (+) - **CSW**   Cash Withdrawable - **DIV**   Dividend - **DIVCGL**   Dividend (Capital Gain Long Term) - **DIVCGS**   Dividend (Capital Gain Short Term) - **DIVNRA**   Dividend Adjusted (NRA Withheld) - **DIVROC**   Dividend Return of Capital - **DIVTXEX**   Dividend (Tax Exempt) - **FEE**   REG and TAF Fees - **INT**   Interest (Credit/Margin) - **JNLC**   Journal Entry (Cash) - **JNLS**   Journal Entry (Stock) - **OPASN**    Option Assignment - **OPEXC**   Option Exercise - **OPEXP**   Option Expiration - **OPTRD**   Option Trade - **MA**   Merger/Acquisition - **PTC**   Pass Thru Change - **REORG**   Reorg CA - **SPIN**   Stock Spinoff - **SPLIT**   Stock Split
 */
@JsonAdapter(ActivityType.Adapter.class)
public enum ActivityType {
  
  FILL("FILL"),
  
  ACATC("ACATC"),
  
  ACATS("ACATS"),
  
  CIL("CIL"),
  
  CSD("CSD"),
  
  CSW("CSW"),
  
  DIV("DIV"),
  
  DIVCGL("DIVCGL"),
  
  DIVCGS("DIVCGS"),
  
  DIVNRA("DIVNRA"),
  
  DIVROC("DIVROC"),
  
  DIVTXEX("DIVTXEX"),
  
  FEE("FEE"),
  
  INT("INT"),
  
  JNLC("JNLC"),
  
  JNLS("JNLS"),
  
  MA("MA"),
  
  OPASN("OPASN"),
  
  OPEXC("OPEXC"),
  
  OPEXP("OPEXP"),
  
  OPTRD("OPTRD"),
  
  PTC("PTC"),
  
  REORG("REORG"),
  
  SPIN("SPIN"),
  
  SPLIT("SPLIT");

  private String value;

  ActivityType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static ActivityType fromValue(String value) {
    for (ActivityType b : ActivityType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<ActivityType> {
    @Override
    public void write(final JsonWriter jsonWriter, final ActivityType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public ActivityType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return ActivityType.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    ActivityType.fromValue(value);
  }
}

