/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.NonTradeActivity;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeActivity;



import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class ActivityItem extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ActivityItem.class.getName());

    public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
        @SuppressWarnings("unchecked")
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ActivityItem.class.isAssignableFrom(type.getRawType())) {
                return null; // this class only serializes 'ActivityItem' and its subtypes
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TradeActivity> adapterTradeActivity = gson.getDelegateAdapter(this, TypeToken.get(TradeActivity.class));
            final TypeAdapter<NonTradeActivity> adapterNonTradeActivity = gson.getDelegateAdapter(this, TypeToken.get(NonTradeActivity.class));

            return (TypeAdapter<T>) new TypeAdapter<ActivityItem>() {
                @Override
                public void write(JsonWriter out, ActivityItem value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }

                    // check if the actual instance is of the type `TradeActivity`
                    if (value.getActualInstance() instanceof TradeActivity) {
                      JsonElement element = adapterTradeActivity.toJsonTree((TradeActivity)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    // check if the actual instance is of the type `NonTradeActivity`
                    if (value.getActualInstance() instanceof NonTradeActivity) {
                      JsonElement element = adapterNonTradeActivity.toJsonTree((NonTradeActivity)value.getActualInstance());
                      elementAdapter.write(out, element);
                      return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match anyOf schemae: NonTradeActivity, TradeActivity");
                }

                @Override
                public ActivityItem read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = elementAdapter.read(in);

                    ArrayList<String> errorMessages = new ArrayList<>();
                    TypeAdapter actualAdapter = elementAdapter;

                    // deserialize TradeActivity
                    try {
                      // validate the JSON object to see if any exception is thrown
                      TradeActivity.validateJsonElement(jsonElement);
                      actualAdapter = adapterTradeActivity;
                      ActivityItem ret = new ActivityItem();
                      ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                      return ret;
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for TradeActivity failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'TradeActivity'", e);
                    }
                    // deserialize NonTradeActivity
                    try {
                      // validate the JSON object to see if any exception is thrown
                      NonTradeActivity.validateJsonElement(jsonElement);
                      actualAdapter = adapterNonTradeActivity;
                      ActivityItem ret = new ActivityItem();
                      ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                      return ret;
                    } catch (Exception e) {
                      // deserialization failed, continue
                      errorMessages.add(String.format("Deserialization for NonTradeActivity failed with `%s`.", e.getMessage()));
                      log.log(Level.FINER, "Input data does not match schema 'NonTradeActivity'", e);
                    }

                    throw new IOException(String.format("Failed deserialization for ActivityItem: no class matches result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }

    // store a list of schema names defined in anyOf
    public static final Map<String, Class<?>> schemas = new HashMap<String, Class<?>>();

    public ActivityItem() {
        super("anyOf", Boolean.FALSE);
    }

    public ActivityItem(NonTradeActivity o) {
        super("anyOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public ActivityItem(TradeActivity o) {
        super("anyOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("TradeActivity", TradeActivity.class);
        schemas.put("NonTradeActivity", NonTradeActivity.class);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return ActivityItem.schemas;
    }

    /**
     * Set the instance that matches the anyOf child schema, check
     * the instance parameter is valid against the anyOf child schemas:
     * NonTradeActivity, TradeActivity
     *
     * It could be an instance of the 'anyOf' schemas.
     */
    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof TradeActivity) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof NonTradeActivity) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be NonTradeActivity, TradeActivity");
    }

    /**
     * Get the actual instance, which can be the following:
     * NonTradeActivity, TradeActivity
     *
     * @return The actual instance (NonTradeActivity, TradeActivity)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `TradeActivity`. If the actual instance is not `TradeActivity`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `TradeActivity`
     * @throws ClassCastException if the instance is not `TradeActivity`
     */
    public TradeActivity getTradeActivity() throws ClassCastException {
        return (TradeActivity)super.getActualInstance();
    }
    /**
     * Get the actual instance of `NonTradeActivity`. If the actual instance is not `NonTradeActivity`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `NonTradeActivity`
     * @throws ClassCastException if the instance is not `NonTradeActivity`
     */
    public NonTradeActivity getNonTradeActivity() throws ClassCastException {
        return (NonTradeActivity)super.getActualInstance();
    }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    // validate anyOf schemas one by one
    ArrayList<String> errorMessages = new ArrayList<>();
    // validate the json string with TradeActivity
    try {
      TradeActivity.validateJsonElement(jsonElement);
      return;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for TradeActivity failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    // validate the json string with NonTradeActivity
    try {
      NonTradeActivity.validateJsonElement(jsonElement);
      return;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for NonTradeActivity failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    throw new IOException(String.format("The JSON string is invalid for ActivityItem with anyOf schemas: NonTradeActivity, TradeActivity. no class match the result, expected at least 1. Detailed failure message for anyOf schemas: %s. JSON: %s", errorMessages, jsonElement.toString()));
    
  }

 /**
  * Create an instance of ActivityItem given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ActivityItem
  * @throws IOException if the JSON string is invalid with respect to ActivityItem
  */
  public static ActivityItem fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ActivityItem.class);
  }

 /**
  * Convert an instance of ActivityItem to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

