/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.ActivityType;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderSide;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderStatus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Base for activity types
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Activity {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private UUID accountId;

  public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activity_type";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_TYPE)
  private ActivityType activityType;

  public static final String SERIALIZED_NAME_TRANSACTION_TIME = "transaction_time";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TIME)
  private OffsetDateTime transactionTime;

  /**
   * Valid only for trading activity types. Null for non-trading activites.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    FILL("fill"),
    
    PARTIAL_FILL("partial_fill");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      TypeEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private BigDecimal price;

  public static final String SERIALIZED_NAME_QTY = "qty";
  @SerializedName(SERIALIZED_NAME_QTY)
  private BigDecimal qty;

  public static final String SERIALIZED_NAME_SIDE = "side";
  @SerializedName(SERIALIZED_NAME_SIDE)
  private OrderSide side;

  public static final String SERIALIZED_NAME_SYMBOL = "symbol";
  @SerializedName(SERIALIZED_NAME_SYMBOL)
  private String symbol;

  public static final String SERIALIZED_NAME_LEAVES_QTY = "leaves_qty";
  @SerializedName(SERIALIZED_NAME_LEAVES_QTY)
  private BigDecimal leavesQty;

  public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
  @SerializedName(SERIALIZED_NAME_ORDER_ID)
  private UUID orderId;

  public static final String SERIALIZED_NAME_CUM_QTY = "cum_qty";
  @SerializedName(SERIALIZED_NAME_CUM_QTY)
  private BigDecimal cumQty;

  public static final String SERIALIZED_NAME_ORDER_STATUS = "order_status";
  @SerializedName(SERIALIZED_NAME_ORDER_STATUS)
  private OrderStatus orderStatus;

  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_NET_AMOUNT = "net_amount";
  @SerializedName(SERIALIZED_NAME_NET_AMOUNT)
  private BigDecimal netAmount;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  /**
   * Valid only for non-trading activity types. Null for trading activites.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    EXECUTED("executed"),
    
    CORRECT("correct"),
    
    CANCELED("canceled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      StatusEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_PER_SHARE_AMOUNT = "per_share_amount";
  @SerializedName(SERIALIZED_NAME_PER_SHARE_AMOUNT)
  private BigDecimal perShareAmount;

  public Activity() {
  }

  public Activity id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }


  public Activity accountId(UUID accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Get accountId
   * @return accountId
  **/
  @javax.annotation.Nullable
  public UUID getAccountId() {
    return accountId;
  }

  public void setAccountId(UUID accountId) {
    this.accountId = accountId;
  }


  public Activity activityType(ActivityType activityType) {
    this.activityType = activityType;
    return this;
  }

   /**
   * Get activityType
   * @return activityType
  **/
  @javax.annotation.Nonnull
  public ActivityType getActivityType() {
    return activityType;
  }

  public void setActivityType(ActivityType activityType) {
    this.activityType = activityType;
  }


  public Activity transactionTime(OffsetDateTime transactionTime) {
    this.transactionTime = transactionTime;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return transactionTime
  **/
  @javax.annotation.Nullable
  public OffsetDateTime getTransactionTime() {
    return transactionTime;
  }

  public void setTransactionTime(OffsetDateTime transactionTime) {
    this.transactionTime = transactionTime;
  }


  public Activity type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return type
  **/
  @javax.annotation.Nullable
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Activity price(BigDecimal price) {
    this.price = price;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return price
  **/
  @javax.annotation.Nullable
  public BigDecimal getPrice() {
    return price;
  }

  public void setPrice(BigDecimal price) {
    this.price = price;
  }


  public Activity qty(BigDecimal qty) {
    this.qty = qty;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return qty
  **/
  @javax.annotation.Nullable
  public BigDecimal getQty() {
    return qty;
  }

  public void setQty(BigDecimal qty) {
    this.qty = qty;
  }


  public Activity side(OrderSide side) {
    this.side = side;
    return this;
  }

   /**
   * Get side
   * @return side
  **/
  @javax.annotation.Nullable
  public OrderSide getSide() {
    return side;
  }

  public void setSide(OrderSide side) {
    this.side = side;
  }


  public Activity symbol(String symbol) {
    this.symbol = symbol;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return symbol
  **/
  @javax.annotation.Nullable
  public String getSymbol() {
    return symbol;
  }

  public void setSymbol(String symbol) {
    this.symbol = symbol;
  }


  public Activity leavesQty(BigDecimal leavesQty) {
    this.leavesQty = leavesQty;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return leavesQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getLeavesQty() {
    return leavesQty;
  }

  public void setLeavesQty(BigDecimal leavesQty) {
    this.leavesQty = leavesQty;
  }


  public Activity orderId(UUID orderId) {
    this.orderId = orderId;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return orderId
  **/
  @javax.annotation.Nullable
  public UUID getOrderId() {
    return orderId;
  }

  public void setOrderId(UUID orderId) {
    this.orderId = orderId;
  }


  public Activity cumQty(BigDecimal cumQty) {
    this.cumQty = cumQty;
    return this;
  }

   /**
   * Valid only for trading activity types. Null for non-trading activites.
   * @return cumQty
  **/
  @javax.annotation.Nullable
  public BigDecimal getCumQty() {
    return cumQty;
  }

  public void setCumQty(BigDecimal cumQty) {
    this.cumQty = cumQty;
  }


  public Activity orderStatus(OrderStatus orderStatus) {
    this.orderStatus = orderStatus;
    return this;
  }

   /**
   * Get orderStatus
   * @return orderStatus
  **/
  @javax.annotation.Nullable
  public OrderStatus getOrderStatus() {
    return orderStatus;
  }

  public void setOrderStatus(OrderStatus orderStatus) {
    this.orderStatus = orderStatus;
  }


  public Activity date(LocalDate date) {
    this.date = date;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return date
  **/
  @javax.annotation.Nullable
  public LocalDate getDate() {
    return date;
  }

  public void setDate(LocalDate date) {
    this.date = date;
  }


  public Activity netAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return netAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getNetAmount() {
    return netAmount;
  }

  public void setNetAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
  }


  public Activity description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return description
  **/
  @javax.annotation.Nullable
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  public Activity status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return status
  **/
  @javax.annotation.Nullable
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public Activity perShareAmount(BigDecimal perShareAmount) {
    this.perShareAmount = perShareAmount;
    return this;
  }

   /**
   * Valid only for non-trading activity types. Null for trading activites.
   * @return perShareAmount
  **/
  @javax.annotation.Nullable
  public BigDecimal getPerShareAmount() {
    return perShareAmount;
  }

  public void setPerShareAmount(BigDecimal perShareAmount) {
    this.perShareAmount = perShareAmount;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Activity activity = (Activity) o;
    return Objects.equals(this.id, activity.id) &&
        Objects.equals(this.accountId, activity.accountId) &&
        Objects.equals(this.activityType, activity.activityType) &&
        Objects.equals(this.transactionTime, activity.transactionTime) &&
        Objects.equals(this.type, activity.type) &&
        Objects.equals(this.price, activity.price) &&
        Objects.equals(this.qty, activity.qty) &&
        Objects.equals(this.side, activity.side) &&
        Objects.equals(this.symbol, activity.symbol) &&
        Objects.equals(this.leavesQty, activity.leavesQty) &&
        Objects.equals(this.orderId, activity.orderId) &&
        Objects.equals(this.cumQty, activity.cumQty) &&
        Objects.equals(this.orderStatus, activity.orderStatus) &&
        Objects.equals(this.date, activity.date) &&
        Objects.equals(this.netAmount, activity.netAmount) &&
        Objects.equals(this.description, activity.description) &&
        Objects.equals(this.status, activity.status) &&
        Objects.equals(this.perShareAmount, activity.perShareAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountId, activityType, transactionTime, type, price, qty, side, symbol, leavesQty, orderId, cumQty, orderStatus, date, netAmount, description, status, perShareAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Activity {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    transactionTime: ").append(toIndentedString(transactionTime)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    qty: ").append(toIndentedString(qty)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    symbol: ").append(toIndentedString(symbol)).append("\n");
    sb.append("    leavesQty: ").append(toIndentedString(leavesQty)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    cumQty: ").append(toIndentedString(cumQty)).append("\n");
    sb.append("    orderStatus: ").append(toIndentedString(orderStatus)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    perShareAmount: ").append(toIndentedString(perShareAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_id");
    openapiFields.add("activity_type");
    openapiFields.add("transaction_time");
    openapiFields.add("type");
    openapiFields.add("price");
    openapiFields.add("qty");
    openapiFields.add("side");
    openapiFields.add("symbol");
    openapiFields.add("leaves_qty");
    openapiFields.add("order_id");
    openapiFields.add("cum_qty");
    openapiFields.add("order_status");
    openapiFields.add("date");
    openapiFields.add("net_amount");
    openapiFields.add("description");
    openapiFields.add("status");
    openapiFields.add("per_share_amount");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("activity_type");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Activity.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Activity is not found in the empty JSON string", Activity.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Activity.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Activity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Activity.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_id") != null && !jsonObj.get("account_id").isJsonNull()) && !jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      // validate the required field `activity_type`
      ActivityType.validateJsonElement(jsonObj.get("activity_type"));
      if ((jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      // validate the optional field `type`
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonNull()) {
        TypeEnum.validateJsonElement(jsonObj.get("type"));
      }
      if ((jsonObj.get("price") != null && !jsonObj.get("price").isJsonNull()) && !jsonObj.get("price").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `price` to be a primitive type in the JSON string but got `%s`", jsonObj.get("price").toString()));
      }
      if ((jsonObj.get("qty") != null && !jsonObj.get("qty").isJsonNull()) && !jsonObj.get("qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("qty").toString()));
      }
      // validate the optional field `side`
      if (jsonObj.get("side") != null && !jsonObj.get("side").isJsonNull()) {
        OrderSide.validateJsonElement(jsonObj.get("side"));
      }
      if ((jsonObj.get("symbol") != null && !jsonObj.get("symbol").isJsonNull()) && !jsonObj.get("symbol").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get("symbol").toString()));
      }
      if ((jsonObj.get("leaves_qty") != null && !jsonObj.get("leaves_qty").isJsonNull()) && !jsonObj.get("leaves_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `leaves_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("leaves_qty").toString()));
      }
      if ((jsonObj.get("order_id") != null && !jsonObj.get("order_id").isJsonNull()) && !jsonObj.get("order_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `order_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("order_id").toString()));
      }
      if ((jsonObj.get("cum_qty") != null && !jsonObj.get("cum_qty").isJsonNull()) && !jsonObj.get("cum_qty").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cum_qty` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cum_qty").toString()));
      }
      // validate the optional field `order_status`
      if (jsonObj.get("order_status") != null && !jsonObj.get("order_status").isJsonNull()) {
        OrderStatus.validateJsonElement(jsonObj.get("order_status"));
      }
      if ((jsonObj.get("net_amount") != null && !jsonObj.get("net_amount").isJsonNull()) && !jsonObj.get("net_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `net_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("net_amount").toString()));
      }
      if ((jsonObj.get("description") != null && !jsonObj.get("description").isJsonNull()) && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if ((jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the optional field `status`
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonNull()) {
        StatusEnum.validateJsonElement(jsonObj.get("status"));
      }
      if ((jsonObj.get("per_share_amount") != null && !jsonObj.get("per_share_amount").isJsonNull()) && !jsonObj.get("per_share_amount").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `per_share_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("per_share_amount").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Activity.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Activity' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Activity> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Activity.class));

       return (TypeAdapter<T>) new TypeAdapter<Activity>() {
           @Override
           public void write(JsonWriter out, Activity value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Activity read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Activity given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Activity
  * @throws IOException if the JSON string is invalid with respect to Activity
  */
  public static Activity fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Activity.class);
  }

 /**
  * Convert an instance of Activity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

