/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.AdminConfigurations;
import net.jacobpeterson.alpaca.openapi.broker.model.KYCResult;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents a change in an Account&#39;s status, sent over the events streaming api.  For partners who utilize Alpaca’s KYC service for opening brokerage accounts an additional &#x60;kyc_results&#x60; object is represented in the account status update events.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AccountStatusEvent {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_STATUS_FROM = "status_from";
  @SerializedName(SERIALIZED_NAME_STATUS_FROM)
  private AccountStatus statusFrom;

  public static final String SERIALIZED_NAME_STATUS_TO = "status_to";
  @SerializedName(SERIALIZED_NAME_STATUS_TO)
  private AccountStatus statusTo;

  public static final String SERIALIZED_NAME_REASON = "reason";
  @SerializedName(SERIALIZED_NAME_REASON)
  private String reason;

  public static final String SERIALIZED_NAME_AT = "at";
  @SerializedName(SERIALIZED_NAME_AT)
  private String at;

  public static final String SERIALIZED_NAME_KYC_RESULT = "kyc_result";
  @SerializedName(SERIALIZED_NAME_KYC_RESULT)
  private KYCResult kycResult;

  public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
  @SerializedName(SERIALIZED_NAME_EVENT_ID)
  private Integer eventId;

  public static final String SERIALIZED_NAME_EVENT_ULID = "event_ulid";
  @SerializedName(SERIALIZED_NAME_EVENT_ULID)
  private String eventUlid;

  public static final String SERIALIZED_NAME_CRYPTO_STATUS_FROM = "crypto_status_from";
  @SerializedName(SERIALIZED_NAME_CRYPTO_STATUS_FROM)
  private String cryptoStatusFrom;

  public static final String SERIALIZED_NAME_CRYPTO_STATUS_TO = "crypto_status_to";
  @SerializedName(SERIALIZED_NAME_CRYPTO_STATUS_TO)
  private String cryptoStatusTo;

  public static final String SERIALIZED_NAME_ADMIN_CONFIGURATIONS = "admin_configurations";
  @SerializedName(SERIALIZED_NAME_ADMIN_CONFIGURATIONS)
  private AdminConfigurations adminConfigurations;

  public static final String SERIALIZED_NAME_PATTERN_DAY_TRADER = "pattern_day_trader";
  @SerializedName(SERIALIZED_NAME_PATTERN_DAY_TRADER)
  private Boolean patternDayTrader;

  public static final String SERIALIZED_NAME_ACCOUNT_BLOCKED = "account_blocked";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_BLOCKED)
  private Boolean accountBlocked;

  public static final String SERIALIZED_NAME_TRADING_BLOCKED = "trading_blocked";
  @SerializedName(SERIALIZED_NAME_TRADING_BLOCKED)
  private Boolean tradingBlocked;

  public AccountStatusEvent() {
  }

  public AccountStatusEvent accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Get accountId
   * @return accountId
  **/
  @javax.annotation.Nonnull
  public String getAccountId() {
    return accountId;
  }

  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }


  public AccountStatusEvent accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * Get accountNumber
   * @return accountNumber
  **/
  @javax.annotation.Nonnull
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public AccountStatusEvent statusFrom(AccountStatus statusFrom) {
    this.statusFrom = statusFrom;
    return this;
  }

   /**
   * Get statusFrom
   * @return statusFrom
  **/
  @javax.annotation.Nonnull
  public AccountStatus getStatusFrom() {
    return statusFrom;
  }

  public void setStatusFrom(AccountStatus statusFrom) {
    this.statusFrom = statusFrom;
  }


  public AccountStatusEvent statusTo(AccountStatus statusTo) {
    this.statusTo = statusTo;
    return this;
  }

   /**
   * Get statusTo
   * @return statusTo
  **/
  @javax.annotation.Nonnull
  public AccountStatus getStatusTo() {
    return statusTo;
  }

  public void setStatusTo(AccountStatus statusTo) {
    this.statusTo = statusTo;
  }


  public AccountStatusEvent reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Optional
   * @return reason
  **/
  @javax.annotation.Nonnull
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  public AccountStatusEvent at(String at) {
    this.at = at;
    return this;
  }

   /**
   * Timestamp of event
   * @return at
  **/
  @javax.annotation.Nonnull
  public String getAt() {
    return at;
  }

  public void setAt(String at) {
    this.at = at;
  }


  public AccountStatusEvent kycResult(KYCResult kycResult) {
    this.kycResult = kycResult;
    return this;
  }

   /**
   * Get kycResult
   * @return kycResult
  **/
  @javax.annotation.Nullable
  public KYCResult getKycResult() {
    return kycResult;
  }

  public void setKycResult(KYCResult kycResult) {
    this.kycResult = kycResult;
  }


  public AccountStatusEvent eventId(Integer eventId) {
    this.eventId = eventId;
    return this;
  }

   /**
   * monotonically increasing 64bit integer
   * @return eventId
  **/
  @javax.annotation.Nonnull
  public Integer getEventId() {
    return eventId;
  }

  public void setEventId(Integer eventId) {
    this.eventId = eventId;
  }


  public AccountStatusEvent eventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
    return this;
  }

   /**
   * lexically sortable, monotonically increasing character array
   * @return eventUlid
  **/
  @javax.annotation.Nonnull
  public String getEventUlid() {
    return eventUlid;
  }

  public void setEventUlid(String eventUlid) {
    this.eventUlid = eventUlid;
  }


  public AccountStatusEvent cryptoStatusFrom(String cryptoStatusFrom) {
    this.cryptoStatusFrom = cryptoStatusFrom;
    return this;
  }

   /**
   * Account crypto_status changed from
   * @return cryptoStatusFrom
  **/
  @javax.annotation.Nullable
  public String getCryptoStatusFrom() {
    return cryptoStatusFrom;
  }

  public void setCryptoStatusFrom(String cryptoStatusFrom) {
    this.cryptoStatusFrom = cryptoStatusFrom;
  }


  public AccountStatusEvent cryptoStatusTo(String cryptoStatusTo) {
    this.cryptoStatusTo = cryptoStatusTo;
    return this;
  }

   /**
   * Account crypto_status changed to
   * @return cryptoStatusTo
  **/
  @javax.annotation.Nullable
  public String getCryptoStatusTo() {
    return cryptoStatusTo;
  }

  public void setCryptoStatusTo(String cryptoStatusTo) {
    this.cryptoStatusTo = cryptoStatusTo;
  }


  public AccountStatusEvent adminConfigurations(AdminConfigurations adminConfigurations) {
    this.adminConfigurations = adminConfigurations;
    return this;
  }

   /**
   * Get adminConfigurations
   * @return adminConfigurations
  **/
  @javax.annotation.Nullable
  public AdminConfigurations getAdminConfigurations() {
    return adminConfigurations;
  }

  public void setAdminConfigurations(AdminConfigurations adminConfigurations) {
    this.adminConfigurations = adminConfigurations;
  }


  public AccountStatusEvent patternDayTrader(Boolean patternDayTrader) {
    this.patternDayTrader = patternDayTrader;
    return this;
  }

   /**
   * If true the pattern_day_trader flag was set for the account, if false, the flag was reset.
   * @return patternDayTrader
  **/
  @javax.annotation.Nullable
  public Boolean getPatternDayTrader() {
    return patternDayTrader;
  }

  public void setPatternDayTrader(Boolean patternDayTrader) {
    this.patternDayTrader = patternDayTrader;
  }


  public AccountStatusEvent accountBlocked(Boolean accountBlocked) {
    this.accountBlocked = accountBlocked;
    return this;
  }

   /**
   * If true the account was blocked, if false, the account got unblocked
   * @return accountBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getAccountBlocked() {
    return accountBlocked;
  }

  public void setAccountBlocked(Boolean accountBlocked) {
    this.accountBlocked = accountBlocked;
  }


  public AccountStatusEvent tradingBlocked(Boolean tradingBlocked) {
    this.tradingBlocked = tradingBlocked;
    return this;
  }

   /**
   * If true the account cannot trade going forward, if false, the ban has been lifed
   * @return tradingBlocked
  **/
  @javax.annotation.Nullable
  public Boolean getTradingBlocked() {
    return tradingBlocked;
  }

  public void setTradingBlocked(Boolean tradingBlocked) {
    this.tradingBlocked = tradingBlocked;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountStatusEvent accountStatusEvent = (AccountStatusEvent) o;
    return Objects.equals(this.accountId, accountStatusEvent.accountId) &&
        Objects.equals(this.accountNumber, accountStatusEvent.accountNumber) &&
        Objects.equals(this.statusFrom, accountStatusEvent.statusFrom) &&
        Objects.equals(this.statusTo, accountStatusEvent.statusTo) &&
        Objects.equals(this.reason, accountStatusEvent.reason) &&
        Objects.equals(this.at, accountStatusEvent.at) &&
        Objects.equals(this.kycResult, accountStatusEvent.kycResult) &&
        Objects.equals(this.eventId, accountStatusEvent.eventId) &&
        Objects.equals(this.eventUlid, accountStatusEvent.eventUlid) &&
        Objects.equals(this.cryptoStatusFrom, accountStatusEvent.cryptoStatusFrom) &&
        Objects.equals(this.cryptoStatusTo, accountStatusEvent.cryptoStatusTo) &&
        Objects.equals(this.adminConfigurations, accountStatusEvent.adminConfigurations) &&
        Objects.equals(this.patternDayTrader, accountStatusEvent.patternDayTrader) &&
        Objects.equals(this.accountBlocked, accountStatusEvent.accountBlocked) &&
        Objects.equals(this.tradingBlocked, accountStatusEvent.tradingBlocked);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountNumber, statusFrom, statusTo, reason, at, kycResult, eventId, eventUlid, cryptoStatusFrom, cryptoStatusTo, adminConfigurations, patternDayTrader, accountBlocked, tradingBlocked);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountStatusEvent {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    statusFrom: ").append(toIndentedString(statusFrom)).append("\n");
    sb.append("    statusTo: ").append(toIndentedString(statusTo)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    at: ").append(toIndentedString(at)).append("\n");
    sb.append("    kycResult: ").append(toIndentedString(kycResult)).append("\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventUlid: ").append(toIndentedString(eventUlid)).append("\n");
    sb.append("    cryptoStatusFrom: ").append(toIndentedString(cryptoStatusFrom)).append("\n");
    sb.append("    cryptoStatusTo: ").append(toIndentedString(cryptoStatusTo)).append("\n");
    sb.append("    adminConfigurations: ").append(toIndentedString(adminConfigurations)).append("\n");
    sb.append("    patternDayTrader: ").append(toIndentedString(patternDayTrader)).append("\n");
    sb.append("    accountBlocked: ").append(toIndentedString(accountBlocked)).append("\n");
    sb.append("    tradingBlocked: ").append(toIndentedString(tradingBlocked)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("account_id");
    openapiFields.add("account_number");
    openapiFields.add("status_from");
    openapiFields.add("status_to");
    openapiFields.add("reason");
    openapiFields.add("at");
    openapiFields.add("kyc_result");
    openapiFields.add("event_id");
    openapiFields.add("event_ulid");
    openapiFields.add("crypto_status_from");
    openapiFields.add("crypto_status_to");
    openapiFields.add("admin_configurations");
    openapiFields.add("pattern_day_trader");
    openapiFields.add("account_blocked");
    openapiFields.add("trading_blocked");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("account_id");
    openapiRequiredFields.add("account_number");
    openapiRequiredFields.add("status_from");
    openapiRequiredFields.add("status_to");
    openapiRequiredFields.add("reason");
    openapiRequiredFields.add("at");
    openapiRequiredFields.add("event_id");
    openapiRequiredFields.add("event_ulid");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AccountStatusEvent.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AccountStatusEvent is not found in the empty JSON string", AccountStatusEvent.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AccountStatusEvent.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountStatusEvent` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AccountStatusEvent.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("account_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_id").toString()));
      }
      if (!jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      // validate the required field `status_from`
      AccountStatus.validateJsonElement(jsonObj.get("status_from"));
      // validate the required field `status_to`
      AccountStatus.validateJsonElement(jsonObj.get("status_to"));
      if (!jsonObj.get("reason").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason").toString()));
      }
      if (!jsonObj.get("at").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `at` to be a primitive type in the JSON string but got `%s`", jsonObj.get("at").toString()));
      }
      // validate the optional field `kyc_result`
      if (jsonObj.get("kyc_result") != null && !jsonObj.get("kyc_result").isJsonNull()) {
        KYCResult.validateJsonElement(jsonObj.get("kyc_result"));
      }
      if (!jsonObj.get("event_ulid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `event_ulid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("event_ulid").toString()));
      }
      if ((jsonObj.get("crypto_status_from") != null && !jsonObj.get("crypto_status_from").isJsonNull()) && !jsonObj.get("crypto_status_from").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `crypto_status_from` to be a primitive type in the JSON string but got `%s`", jsonObj.get("crypto_status_from").toString()));
      }
      if ((jsonObj.get("crypto_status_to") != null && !jsonObj.get("crypto_status_to").isJsonNull()) && !jsonObj.get("crypto_status_to").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `crypto_status_to` to be a primitive type in the JSON string but got `%s`", jsonObj.get("crypto_status_to").toString()));
      }
      // validate the optional field `admin_configurations`
      if (jsonObj.get("admin_configurations") != null && !jsonObj.get("admin_configurations").isJsonNull()) {
        AdminConfigurations.validateJsonElement(jsonObj.get("admin_configurations"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AccountStatusEvent.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AccountStatusEvent' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AccountStatusEvent> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AccountStatusEvent.class));

       return (TypeAdapter<T>) new TypeAdapter<AccountStatusEvent>() {
           @Override
           public void write(JsonWriter out, AccountStatusEvent value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AccountStatusEvent read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AccountStatusEvent given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AccountStatusEvent
  * @throws IOException if the JSON string is invalid with respect to AccountStatusEvent
  */
  public static AccountStatusEvent fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AccountStatusEvent.class);
  }

 /**
  * Convert an instance of AccountStatusEvent to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

