/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Designates the current status of this account  Possible Values: - **INACTIVE** Account not set to trade given asset. - **ONBOARDING** An application is expected for this user, but has not been submitted yet. - **SUBMITTED** The application has been submitted and in process. - **SUBMISSION_FAILED** Used to display if failure on submission - **ACTION_REQUIRED** The application requires manual action. - **ACCOUNT_UPDATED** Used to display when Account has been modified by user - **APPROVAL_PENDING** Initial value. The application approval process is in process. - **APPROVED** The account application has been approved, and waiting to be ACTIVE - **REJECTED** The account application is rejected for some reason - **ACTIVE** The account is fully active. Trading and funding are processed under this status. - **ACCOUNT_CLOSED** The account is closed. 
 */
@JsonAdapter(AccountStatus.Adapter.class)
public enum AccountStatus {
  
  INACTIVE("INACTIVE"),
  
  ONBOARDING("ONBOARDING"),
  
  SUBMITTED("SUBMITTED"),
  
  SUBMISSION_FAILED("SUBMISSION_FAILED"),
  
  ACTION_REQUIRED("ACTION_REQUIRED"),
  
  ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
  
  APPROVAL_PENDING("APPROVAL_PENDING"),
  
  APPROVED("APPROVED"),
  
  REJECTED("REJECTED"),
  
  ACTIVE("ACTIVE"),
  
  ACCOUNT_CLOSED("ACCOUNT_CLOSED");

  private String value;

  AccountStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AccountStatus fromValue(String value) {
    for (AccountStatus b : AccountStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AccountStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final AccountStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public AccountStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return AccountStatus.fromValue(value);
    }
  }

  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
    String value = jsonElement.getAsString();
    AccountStatus.fromValue(value);
  }
}

