/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountConfigurations;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountType;
import net.jacobpeterson.alpaca.openapi.broker.model.Agreement;
import net.jacobpeterson.alpaca.openapi.broker.model.ApplicationDocument;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Contact;
import net.jacobpeterson.alpaca.openapi.broker.model.CustodialAccountMinorIdentity;
import net.jacobpeterson.alpaca.openapi.broker.model.Disclosures;
import net.jacobpeterson.alpaca.openapi.broker.model.Identity;
import net.jacobpeterson.alpaca.openapi.broker.model.KYCResult;
import net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact;
import net.jacobpeterson.alpaca.openapi.broker.model.USDBalances;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents an account with all data available. If your api response is missing some of these fields, there is a good chance you are using a route that returns &#x60;Account&#x60; instances instead of these.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AccountExtended {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private AccountStatus status;

  public static final String SERIALIZED_NAME_CRYPTO_STATUS = "crypto_status";
  @SerializedName(SERIALIZED_NAME_CRYPTO_STATUS)
  private AccountStatus cryptoStatus;

  public static final String SERIALIZED_NAME_KYC_RESULT = "kyc_result";
  @SerializedName(SERIALIZED_NAME_KYC_RESULT)
  private KYCResult kycResult;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
  @SerializedName(SERIALIZED_NAME_LAST_EQUITY)
  private BigDecimal lastEquity;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_CONTACT = "contact";
  @SerializedName(SERIALIZED_NAME_CONTACT)
  private Contact contact;

  public static final String SERIALIZED_NAME_IDENTITY = "identity";
  @SerializedName(SERIALIZED_NAME_IDENTITY)
  private Identity identity;

  public static final String SERIALIZED_NAME_DISCLOSURES = "disclosures";
  @SerializedName(SERIALIZED_NAME_DISCLOSURES)
  private Disclosures disclosures;

  public static final String SERIALIZED_NAME_AGREEMENTS = "agreements";
  @SerializedName(SERIALIZED_NAME_AGREEMENTS)
  private List<Agreement> agreements;

  public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
  @SerializedName(SERIALIZED_NAME_DOCUMENTS)
  private List<ApplicationDocument> documents;

  public static final String SERIALIZED_NAME_TRUSTED_CONTACT = "trusted_contact";
  @SerializedName(SERIALIZED_NAME_TRUSTED_CONTACT)
  private TrustedContact trustedContact;

  public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NAME)
  private String accountName;

  public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_TYPE)
  private AccountType accountType;

  public static final String SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE = "custodial_account_type";
  @SerializedName(SERIALIZED_NAME_CUSTODIAL_ACCOUNT_TYPE)
  private String custodialAccountType;

  public static final String SERIALIZED_NAME_MINOR_IDENTITY = "minor_identity";
  @SerializedName(SERIALIZED_NAME_MINOR_IDENTITY)
  private CustodialAccountMinorIdentity minorIdentity;

  public static final String SERIALIZED_NAME_TRADING_CONFIGURATIONS = "trading_configurations";
  @SerializedName(SERIALIZED_NAME_TRADING_CONFIGURATIONS)
  private AccountConfigurations tradingConfigurations;

  public static final String SERIALIZED_NAME_USD = "usd";
  @SerializedName(SERIALIZED_NAME_USD)
  private USDBalances usd;

  public static final String SERIALIZED_NAME_ENABLED_ASSETS = "enabled_assets";
  @SerializedName(SERIALIZED_NAME_ENABLED_ASSETS)
  private List<AssetClass> enabledAssets;

  public AccountExtended() {
  }

  public AccountExtended id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public AccountExtended accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * Get accountNumber
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public AccountExtended status(AccountStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nonnull
  public AccountStatus getStatus() {
    return status;
  }

  public void setStatus(AccountStatus status) {
    this.status = status;
  }


  public AccountExtended cryptoStatus(AccountStatus cryptoStatus) {
    this.cryptoStatus = cryptoStatus;
    return this;
  }

   /**
   * Get cryptoStatus
   * @return cryptoStatus
  **/
  @javax.annotation.Nullable
  public AccountStatus getCryptoStatus() {
    return cryptoStatus;
  }

  public void setCryptoStatus(AccountStatus cryptoStatus) {
    this.cryptoStatus = cryptoStatus;
  }


  public AccountExtended kycResult(KYCResult kycResult) {
    this.kycResult = kycResult;
    return this;
  }

   /**
   * Get kycResult
   * @return kycResult
  **/
  @javax.annotation.Nullable
  public KYCResult getKycResult() {
    return kycResult;
  }

  public void setKycResult(KYCResult kycResult) {
    this.kycResult = kycResult;
  }


  public AccountExtended currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * \&quot;USD\&quot; // US Dollar \&quot;JPY\&quot; // Japanese Yen \&quot;EUR\&quot; // Euro \&quot;CAD\&quot; // Canadian Dollar \&quot;GBP\&quot; // British Pound Sterling \&quot;CHF\&quot; // Swiss Franc \&quot;TRY\&quot; // Turkish Lira \&quot;AUD\&quot; // Australian Dollar \&quot;CZK\&quot; // Czech Koruna \&quot;SEK\&quot; // Swedish Krona \&quot;DKK\&quot; // Danish Krone \&quot;SGD\&quot; // Singapore Dollar \&quot;HKD\&quot; // Hong Kong Dollar \&quot;HUF\&quot; // Hungarian Forint \&quot;NZD\&quot; // New Zealand Dollar \&quot;NOK\&quot; // Norwegian Krone \&quot;PLN\&quot; // Poland Złoty
   * @return currency
  **/
  @javax.annotation.Nonnull
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public AccountExtended lastEquity(BigDecimal lastEquity) {
    this.lastEquity = lastEquity;
    return this;
  }

   /**
   * Get lastEquity
   * @return lastEquity
  **/
  @javax.annotation.Nonnull
  public BigDecimal getLastEquity() {
    return lastEquity;
  }

  public void setLastEquity(BigDecimal lastEquity) {
    this.lastEquity = lastEquity;
  }


  public AccountExtended createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Get createdAt
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public AccountExtended contact(Contact contact) {
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nullable
  public Contact getContact() {
    return contact;
  }

  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public AccountExtended identity(Identity identity) {
    this.identity = identity;
    return this;
  }

   /**
   * Get identity
   * @return identity
  **/
  @javax.annotation.Nullable
  public Identity getIdentity() {
    return identity;
  }

  public void setIdentity(Identity identity) {
    this.identity = identity;
  }


  public AccountExtended disclosures(Disclosures disclosures) {
    this.disclosures = disclosures;
    return this;
  }

   /**
   * Get disclosures
   * @return disclosures
  **/
  @javax.annotation.Nullable
  public Disclosures getDisclosures() {
    return disclosures;
  }

  public void setDisclosures(Disclosures disclosures) {
    this.disclosures = disclosures;
  }


  public AccountExtended agreements(List<Agreement> agreements) {
    this.agreements = agreements;
    return this;
  }

  public AccountExtended addAgreementsItem(Agreement agreementsItem) {
    if (this.agreements == null) {
      this.agreements = new ArrayList<>();
    }
    this.agreements.add(agreementsItem);
    return this;
  }

   /**
   * Get agreements
   * @return agreements
  **/
  @javax.annotation.Nullable
  public List<Agreement> getAgreements() {
    return agreements;
  }

  public void setAgreements(List<Agreement> agreements) {
    this.agreements = agreements;
  }


  public AccountExtended documents(List<ApplicationDocument> documents) {
    this.documents = documents;
    return this;
  }

  public AccountExtended addDocumentsItem(ApplicationDocument documentsItem) {
    if (this.documents == null) {
      this.documents = new ArrayList<>();
    }
    this.documents.add(documentsItem);
    return this;
  }

   /**
   * Get documents
   * @return documents
  **/
  @javax.annotation.Nullable
  public List<ApplicationDocument> getDocuments() {
    return documents;
  }

  public void setDocuments(List<ApplicationDocument> documents) {
    this.documents = documents;
  }


  public AccountExtended trustedContact(TrustedContact trustedContact) {
    this.trustedContact = trustedContact;
    return this;
  }

   /**
   * Get trustedContact
   * @return trustedContact
  **/
  @javax.annotation.Nullable
  public TrustedContact getTrustedContact() {
    return trustedContact;
  }

  public void setTrustedContact(TrustedContact trustedContact) {
    this.trustedContact = trustedContact;
  }


  public AccountExtended accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

   /**
   * Get accountName
   * @return accountName
  **/
  @javax.annotation.Nullable
  public String getAccountName() {
    return accountName;
  }

  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public AccountExtended accountType(AccountType accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * Get accountType
   * @return accountType
  **/
  @javax.annotation.Nonnull
  public AccountType getAccountType() {
    return accountType;
  }

  public void setAccountType(AccountType accountType) {
    this.accountType = accountType;
  }


  public AccountExtended custodialAccountType(String custodialAccountType) {
    this.custodialAccountType = custodialAccountType;
    return this;
  }

   /**
   * **UTMA** CustodianTypeUTMA  **UGMA** CustodianTypeUGMA
   * @return custodialAccountType
  **/
  @javax.annotation.Nullable
  public String getCustodialAccountType() {
    return custodialAccountType;
  }

  public void setCustodialAccountType(String custodialAccountType) {
    this.custodialAccountType = custodialAccountType;
  }


  public AccountExtended minorIdentity(CustodialAccountMinorIdentity minorIdentity) {
    this.minorIdentity = minorIdentity;
    return this;
  }

   /**
   * Get minorIdentity
   * @return minorIdentity
  **/
  @javax.annotation.Nullable
  public CustodialAccountMinorIdentity getMinorIdentity() {
    return minorIdentity;
  }

  public void setMinorIdentity(CustodialAccountMinorIdentity minorIdentity) {
    this.minorIdentity = minorIdentity;
  }


  public AccountExtended tradingConfigurations(AccountConfigurations tradingConfigurations) {
    this.tradingConfigurations = tradingConfigurations;
    return this;
  }

   /**
   * Get tradingConfigurations
   * @return tradingConfigurations
  **/
  @javax.annotation.Nullable
  public AccountConfigurations getTradingConfigurations() {
    return tradingConfigurations;
  }

  public void setTradingConfigurations(AccountConfigurations tradingConfigurations) {
    this.tradingConfigurations = tradingConfigurations;
  }


  public AccountExtended usd(USDBalances usd) {
    this.usd = usd;
    return this;
  }

   /**
   * Get usd
   * @return usd
  **/
  @javax.annotation.Nullable
  public USDBalances getUsd() {
    return usd;
  }

  public void setUsd(USDBalances usd) {
    this.usd = usd;
  }


  public AccountExtended enabledAssets(List<AssetClass> enabledAssets) {
    this.enabledAssets = enabledAssets;
    return this;
  }

  public AccountExtended addEnabledAssetsItem(AssetClass enabledAssetsItem) {
    if (this.enabledAssets == null) {
      this.enabledAssets = new ArrayList<>();
    }
    this.enabledAssets.add(enabledAssetsItem);
    return this;
  }

   /**
   * Get enabledAssets
   * @return enabledAssets
  **/
  @javax.annotation.Nullable
  public List<AssetClass> getEnabledAssets() {
    return enabledAssets;
  }

  public void setEnabledAssets(List<AssetClass> enabledAssets) {
    this.enabledAssets = enabledAssets;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountExtended accountExtended = (AccountExtended) o;
    return Objects.equals(this.id, accountExtended.id) &&
        Objects.equals(this.accountNumber, accountExtended.accountNumber) &&
        Objects.equals(this.status, accountExtended.status) &&
        Objects.equals(this.cryptoStatus, accountExtended.cryptoStatus) &&
        Objects.equals(this.kycResult, accountExtended.kycResult) &&
        Objects.equals(this.currency, accountExtended.currency) &&
        Objects.equals(this.lastEquity, accountExtended.lastEquity) &&
        Objects.equals(this.createdAt, accountExtended.createdAt) &&
        Objects.equals(this.contact, accountExtended.contact) &&
        Objects.equals(this.identity, accountExtended.identity) &&
        Objects.equals(this.disclosures, accountExtended.disclosures) &&
        Objects.equals(this.agreements, accountExtended.agreements) &&
        Objects.equals(this.documents, accountExtended.documents) &&
        Objects.equals(this.trustedContact, accountExtended.trustedContact) &&
        Objects.equals(this.accountName, accountExtended.accountName) &&
        Objects.equals(this.accountType, accountExtended.accountType) &&
        Objects.equals(this.custodialAccountType, accountExtended.custodialAccountType) &&
        Objects.equals(this.minorIdentity, accountExtended.minorIdentity) &&
        Objects.equals(this.tradingConfigurations, accountExtended.tradingConfigurations) &&
        Objects.equals(this.usd, accountExtended.usd) &&
        Objects.equals(this.enabledAssets, accountExtended.enabledAssets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountNumber, status, cryptoStatus, kycResult, currency, lastEquity, createdAt, contact, identity, disclosures, agreements, documents, trustedContact, accountName, accountType, custodialAccountType, minorIdentity, tradingConfigurations, usd, enabledAssets);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountExtended {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cryptoStatus: ").append(toIndentedString(cryptoStatus)).append("\n");
    sb.append("    kycResult: ").append(toIndentedString(kycResult)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    lastEquity: ").append(toIndentedString(lastEquity)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    agreements: ").append(toIndentedString(agreements)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("    trustedContact: ").append(toIndentedString(trustedContact)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    custodialAccountType: ").append(toIndentedString(custodialAccountType)).append("\n");
    sb.append("    minorIdentity: ").append(toIndentedString(minorIdentity)).append("\n");
    sb.append("    tradingConfigurations: ").append(toIndentedString(tradingConfigurations)).append("\n");
    sb.append("    usd: ").append(toIndentedString(usd)).append("\n");
    sb.append("    enabledAssets: ").append(toIndentedString(enabledAssets)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_number");
    openapiFields.add("status");
    openapiFields.add("crypto_status");
    openapiFields.add("kyc_result");
    openapiFields.add("currency");
    openapiFields.add("last_equity");
    openapiFields.add("created_at");
    openapiFields.add("contact");
    openapiFields.add("identity");
    openapiFields.add("disclosures");
    openapiFields.add("agreements");
    openapiFields.add("documents");
    openapiFields.add("trusted_contact");
    openapiFields.add("account_name");
    openapiFields.add("account_type");
    openapiFields.add("custodial_account_type");
    openapiFields.add("minor_identity");
    openapiFields.add("trading_configurations");
    openapiFields.add("usd");
    openapiFields.add("enabled_assets");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("account_number");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("currency");
    openapiRequiredFields.add("last_equity");
    openapiRequiredFields.add("created_at");
    openapiRequiredFields.add("account_type");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AccountExtended.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AccountExtended is not found in the empty JSON string", AccountExtended.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AccountExtended.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountExtended` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AccountExtended.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_number") != null && !jsonObj.get("account_number").isJsonNull()) && !jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      // validate the required field `status`
      AccountStatus.validateJsonElement(jsonObj.get("status"));
      // validate the optional field `crypto_status`
      if (jsonObj.get("crypto_status") != null && !jsonObj.get("crypto_status").isJsonNull()) {
        AccountStatus.validateJsonElement(jsonObj.get("crypto_status"));
      }
      // validate the optional field `kyc_result`
      if (jsonObj.get("kyc_result") != null && !jsonObj.get("kyc_result").isJsonNull()) {
        KYCResult.validateJsonElement(jsonObj.get("kyc_result"));
      }
      if (!jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (!jsonObj.get("last_equity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_equity").toString()));
      }
      // validate the optional field `contact`
      if (jsonObj.get("contact") != null && !jsonObj.get("contact").isJsonNull()) {
        Contact.validateJsonElement(jsonObj.get("contact"));
      }
      // validate the optional field `identity`
      if (jsonObj.get("identity") != null && !jsonObj.get("identity").isJsonNull()) {
        Identity.validateJsonElement(jsonObj.get("identity"));
      }
      // validate the optional field `disclosures`
      if (jsonObj.get("disclosures") != null && !jsonObj.get("disclosures").isJsonNull()) {
        Disclosures.validateJsonElement(jsonObj.get("disclosures"));
      }
      if (jsonObj.get("agreements") != null && !jsonObj.get("agreements").isJsonNull()) {
        JsonArray jsonArrayagreements = jsonObj.getAsJsonArray("agreements");
        if (jsonArrayagreements != null) {
          // ensure the json data is an array
          if (!jsonObj.get("agreements").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `agreements` to be an array in the JSON string but got `%s`", jsonObj.get("agreements").toString()));
          }

          // validate the optional field `agreements` (array)
          for (int i = 0; i < jsonArrayagreements.size(); i++) {
            Agreement.validateJsonElement(jsonArrayagreements.get(i));
          };
        }
      }
      if (jsonObj.get("documents") != null && !jsonObj.get("documents").isJsonNull()) {
        JsonArray jsonArraydocuments = jsonObj.getAsJsonArray("documents");
        if (jsonArraydocuments != null) {
          // ensure the json data is an array
          if (!jsonObj.get("documents").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get("documents").toString()));
          }

          // validate the optional field `documents` (array)
          for (int i = 0; i < jsonArraydocuments.size(); i++) {
            ApplicationDocument.validateJsonElement(jsonArraydocuments.get(i));
          };
        }
      }
      // validate the optional field `trusted_contact`
      if (jsonObj.get("trusted_contact") != null && !jsonObj.get("trusted_contact").isJsonNull()) {
        TrustedContact.validateJsonElement(jsonObj.get("trusted_contact"));
      }
      if ((jsonObj.get("account_name") != null && !jsonObj.get("account_name").isJsonNull()) && !jsonObj.get("account_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_name").toString()));
      }
      // validate the required field `account_type`
      AccountType.validateJsonElement(jsonObj.get("account_type"));
      if ((jsonObj.get("custodial_account_type") != null && !jsonObj.get("custodial_account_type").isJsonNull()) && !jsonObj.get("custodial_account_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `custodial_account_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("custodial_account_type").toString()));
      }
      // validate the optional field `minor_identity`
      if (jsonObj.get("minor_identity") != null && !jsonObj.get("minor_identity").isJsonNull()) {
        CustodialAccountMinorIdentity.validateJsonElement(jsonObj.get("minor_identity"));
      }
      // validate the optional field `trading_configurations`
      if (jsonObj.get("trading_configurations") != null && !jsonObj.get("trading_configurations").isJsonNull()) {
        AccountConfigurations.validateJsonElement(jsonObj.get("trading_configurations"));
      }
      // validate the optional field `usd`
      if (jsonObj.get("usd") != null && !jsonObj.get("usd").isJsonNull()) {
        USDBalances.validateJsonElement(jsonObj.get("usd"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("enabled_assets") != null && !jsonObj.get("enabled_assets").isJsonNull() && !jsonObj.get("enabled_assets").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `enabled_assets` to be an array in the JSON string but got `%s`", jsonObj.get("enabled_assets").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AccountExtended.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AccountExtended' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AccountExtended> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AccountExtended.class));

       return (TypeAdapter<T>) new TypeAdapter<AccountExtended>() {
           @Override
           public void write(JsonWriter out, AccountExtended value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AccountExtended read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AccountExtended given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AccountExtended
  * @throws IOException if the JSON string is invalid with respect to AccountExtended
  */
  public static AccountExtended fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AccountExtended.class);
  }

 /**
  * Convert an instance of AccountExtended to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

