/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jacobpeterson.alpaca.openapi.broker.model.Agreement;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Contact;
import net.jacobpeterson.alpaca.openapi.broker.model.Disclosures;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentUploadRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Identity;
import net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents the fields required to create a new account
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AccountCreationRequest {
  public static final String SERIALIZED_NAME_CONTACT = "contact";
  @SerializedName(SERIALIZED_NAME_CONTACT)
  private Contact contact;

  public static final String SERIALIZED_NAME_IDENTITY = "identity";
  @SerializedName(SERIALIZED_NAME_IDENTITY)
  private Identity identity;

  public static final String SERIALIZED_NAME_DISCLOSURES = "disclosures";
  @SerializedName(SERIALIZED_NAME_DISCLOSURES)
  private Disclosures disclosures;

  public static final String SERIALIZED_NAME_AGREEMENTS = "agreements";
  @SerializedName(SERIALIZED_NAME_AGREEMENTS)
  private List<Agreement> agreements = new ArrayList<>();

  public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
  @SerializedName(SERIALIZED_NAME_DOCUMENTS)
  private List<DocumentUploadRequest> documents;

  public static final String SERIALIZED_NAME_TRUSTED_CONTACT = "trusted_contact";
  @SerializedName(SERIALIZED_NAME_TRUSTED_CONTACT)
  private TrustedContact trustedContact;

  public static final String SERIALIZED_NAME_ENABLED_ASSETS = "enabled_assets";
  @SerializedName(SERIALIZED_NAME_ENABLED_ASSETS)
  private List<AssetClass> enabledAssets;

  public AccountCreationRequest() {
  }

  public AccountCreationRequest contact(Contact contact) {
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nonnull
  public Contact getContact() {
    return contact;
  }

  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public AccountCreationRequest identity(Identity identity) {
    this.identity = identity;
    return this;
  }

   /**
   * Get identity
   * @return identity
  **/
  @javax.annotation.Nonnull
  public Identity getIdentity() {
    return identity;
  }

  public void setIdentity(Identity identity) {
    this.identity = identity;
  }


  public AccountCreationRequest disclosures(Disclosures disclosures) {
    this.disclosures = disclosures;
    return this;
  }

   /**
   * Get disclosures
   * @return disclosures
  **/
  @javax.annotation.Nonnull
  public Disclosures getDisclosures() {
    return disclosures;
  }

  public void setDisclosures(Disclosures disclosures) {
    this.disclosures = disclosures;
  }


  public AccountCreationRequest agreements(List<Agreement> agreements) {
    this.agreements = agreements;
    return this;
  }

  public AccountCreationRequest addAgreementsItem(Agreement agreementsItem) {
    if (this.agreements == null) {
      this.agreements = new ArrayList<>();
    }
    this.agreements.add(agreementsItem);
    return this;
  }

   /**
   * The client has to present the Alpaca Account and Margin Agreements to the end user, and have them read full sentences.
   * @return agreements
  **/
  @javax.annotation.Nonnull
  public List<Agreement> getAgreements() {
    return agreements;
  }

  public void setAgreements(List<Agreement> agreements) {
    this.agreements = agreements;
  }


  public AccountCreationRequest documents(List<DocumentUploadRequest> documents) {
    this.documents = documents;
    return this;
  }

  public AccountCreationRequest addDocumentsItem(DocumentUploadRequest documentsItem) {
    if (this.documents == null) {
      this.documents = new ArrayList<>();
    }
    this.documents.add(documentsItem);
    return this;
  }

   /**
   * Get documents
   * @return documents
  **/
  @javax.annotation.Nullable
  public List<DocumentUploadRequest> getDocuments() {
    return documents;
  }

  public void setDocuments(List<DocumentUploadRequest> documents) {
    this.documents = documents;
  }


  public AccountCreationRequest trustedContact(TrustedContact trustedContact) {
    this.trustedContact = trustedContact;
    return this;
  }

   /**
   * Get trustedContact
   * @return trustedContact
  **/
  @javax.annotation.Nullable
  public TrustedContact getTrustedContact() {
    return trustedContact;
  }

  public void setTrustedContact(TrustedContact trustedContact) {
    this.trustedContact = trustedContact;
  }


  public AccountCreationRequest enabledAssets(List<AssetClass> enabledAssets) {
    this.enabledAssets = enabledAssets;
    return this;
  }

  public AccountCreationRequest addEnabledAssetsItem(AssetClass enabledAssetsItem) {
    if (this.enabledAssets == null) {
      this.enabledAssets = new ArrayList<>();
    }
    this.enabledAssets.add(enabledAssetsItem);
    return this;
  }

   /**
   * Will default to &#x60;us_equity&#x60;. Alpaca has the ability to update the default value upon request.
   * @return enabledAssets
  **/
  @javax.annotation.Nullable
  public List<AssetClass> getEnabledAssets() {
    return enabledAssets;
  }

  public void setEnabledAssets(List<AssetClass> enabledAssets) {
    this.enabledAssets = enabledAssets;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountCreationRequest accountCreationRequest = (AccountCreationRequest) o;
    return Objects.equals(this.contact, accountCreationRequest.contact) &&
        Objects.equals(this.identity, accountCreationRequest.identity) &&
        Objects.equals(this.disclosures, accountCreationRequest.disclosures) &&
        Objects.equals(this.agreements, accountCreationRequest.agreements) &&
        Objects.equals(this.documents, accountCreationRequest.documents) &&
        Objects.equals(this.trustedContact, accountCreationRequest.trustedContact) &&
        Objects.equals(this.enabledAssets, accountCreationRequest.enabledAssets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contact, identity, disclosures, agreements, documents, trustedContact, enabledAssets);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountCreationRequest {\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    agreements: ").append(toIndentedString(agreements)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("    trustedContact: ").append(toIndentedString(trustedContact)).append("\n");
    sb.append("    enabledAssets: ").append(toIndentedString(enabledAssets)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("contact");
    openapiFields.add("identity");
    openapiFields.add("disclosures");
    openapiFields.add("agreements");
    openapiFields.add("documents");
    openapiFields.add("trusted_contact");
    openapiFields.add("enabled_assets");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("contact");
    openapiRequiredFields.add("identity");
    openapiRequiredFields.add("disclosures");
    openapiRequiredFields.add("agreements");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AccountCreationRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AccountCreationRequest is not found in the empty JSON string", AccountCreationRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AccountCreationRequest.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountCreationRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AccountCreationRequest.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the required field `contact`
      Contact.validateJsonElement(jsonObj.get("contact"));
      // validate the required field `identity`
      Identity.validateJsonElement(jsonObj.get("identity"));
      // validate the required field `disclosures`
      Disclosures.validateJsonElement(jsonObj.get("disclosures"));
      // ensure the json data is an array
      if (!jsonObj.get("agreements").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `agreements` to be an array in the JSON string but got `%s`", jsonObj.get("agreements").toString()));
      }

      JsonArray jsonArrayagreements = jsonObj.getAsJsonArray("agreements");
      // validate the required field `agreements` (array)
      for (int i = 0; i < jsonArrayagreements.size(); i++) {
        Agreement.validateJsonElement(jsonArrayagreements.get(i));
      };
      if (jsonObj.get("documents") != null && !jsonObj.get("documents").isJsonNull()) {
        JsonArray jsonArraydocuments = jsonObj.getAsJsonArray("documents");
        if (jsonArraydocuments != null) {
          // ensure the json data is an array
          if (!jsonObj.get("documents").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get("documents").toString()));
          }

          // validate the optional field `documents` (array)
          for (int i = 0; i < jsonArraydocuments.size(); i++) {
            DocumentUploadRequest.validateJsonElement(jsonArraydocuments.get(i));
          };
        }
      }
      // validate the optional field `trusted_contact`
      if (jsonObj.get("trusted_contact") != null && !jsonObj.get("trusted_contact").isJsonNull()) {
        TrustedContact.validateJsonElement(jsonObj.get("trusted_contact"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("enabled_assets") != null && !jsonObj.get("enabled_assets").isJsonNull() && !jsonObj.get("enabled_assets").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `enabled_assets` to be an array in the JSON string but got `%s`", jsonObj.get("enabled_assets").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AccountCreationRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AccountCreationRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AccountCreationRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AccountCreationRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<AccountCreationRequest>() {
           @Override
           public void write(JsonWriter out, AccountCreationRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AccountCreationRequest read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AccountCreationRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AccountCreationRequest
  * @throws IOException if the JSON string is invalid with respect to AccountCreationRequest
  */
  public static AccountCreationRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AccountCreationRequest.class);
  }

 /**
  * Convert an instance of AccountCreationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

