/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents additional configuration settings for an account
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class AccountConfigurations {
  /**
   * both, entry, or exit. Controls Day Trading Margin Call (DTMC) checks.
   */
  @JsonAdapter(DtbpCheckEnum.Adapter.class)
  public enum DtbpCheckEnum {
    BOTH("both"),
    
    ENTRY("entry"),
    
    EXIT("exit");

    private String value;

    DtbpCheckEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DtbpCheckEnum fromValue(String value) {
      for (DtbpCheckEnum b : DtbpCheckEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DtbpCheckEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DtbpCheckEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DtbpCheckEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DtbpCheckEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      DtbpCheckEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_DTBP_CHECK = "dtbp_check";
  @SerializedName(SERIALIZED_NAME_DTBP_CHECK)
  private DtbpCheckEnum dtbpCheck;

  /**
   * all or none. If none, emails for order fills are not sent.
   */
  @JsonAdapter(TradeConfirmEmailEnum.Adapter.class)
  public enum TradeConfirmEmailEnum {
    ALL("all"),
    
    NONE("none");

    private String value;

    TradeConfirmEmailEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TradeConfirmEmailEnum fromValue(String value) {
      for (TradeConfirmEmailEnum b : TradeConfirmEmailEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TradeConfirmEmailEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TradeConfirmEmailEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TradeConfirmEmailEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TradeConfirmEmailEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      TradeConfirmEmailEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_TRADE_CONFIRM_EMAIL = "trade_confirm_email";
  @SerializedName(SERIALIZED_NAME_TRADE_CONFIRM_EMAIL)
  private TradeConfirmEmailEnum tradeConfirmEmail;

  public static final String SERIALIZED_NAME_SUSPEND_TRADE = "suspend_trade";
  @SerializedName(SERIALIZED_NAME_SUSPEND_TRADE)
  private Boolean suspendTrade;

  public static final String SERIALIZED_NAME_NO_SHORTING = "no_shorting";
  @SerializedName(SERIALIZED_NAME_NO_SHORTING)
  private Boolean noShorting;

  public static final String SERIALIZED_NAME_FRACTIONAL_TRADING = "fractional_trading";
  @SerializedName(SERIALIZED_NAME_FRACTIONAL_TRADING)
  private Boolean fractionalTrading;

  public static final String SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER = "max_margin_multiplier";
  @SerializedName(SERIALIZED_NAME_MAX_MARGIN_MULTIPLIER)
  private String maxMarginMultiplier;

  /**
   * The desired maximum option trading level. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put.
   */
  @JsonAdapter(MaxOptionsTradingLevelEnum.Adapter.class)
  public enum MaxOptionsTradingLevelEnum {
    _0("0"),
    
    _1("1"),
    
    _2("2");

    private String value;

    MaxOptionsTradingLevelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static MaxOptionsTradingLevelEnum fromValue(String value) {
      for (MaxOptionsTradingLevelEnum b : MaxOptionsTradingLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<MaxOptionsTradingLevelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final MaxOptionsTradingLevelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public MaxOptionsTradingLevelEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return MaxOptionsTradingLevelEnum.fromValue(value);
      }
    }

    public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      String value = jsonElement.getAsString();
      MaxOptionsTradingLevelEnum.fromValue(value);
    }
  }

  public static final String SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL = "max_options_trading_level";
  @SerializedName(SERIALIZED_NAME_MAX_OPTIONS_TRADING_LEVEL)
  private MaxOptionsTradingLevelEnum maxOptionsTradingLevel;

  public static final String SERIALIZED_NAME_PDT_CHECK = "pdt_check";
  @SerializedName(SERIALIZED_NAME_PDT_CHECK)
  private String pdtCheck;

  public static final String SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY = "ptp_no_exception_entry";
  @SerializedName(SERIALIZED_NAME_PTP_NO_EXCEPTION_ENTRY)
  private String ptpNoExceptionEntry;

  public AccountConfigurations() {
  }

  public AccountConfigurations dtbpCheck(DtbpCheckEnum dtbpCheck) {
    this.dtbpCheck = dtbpCheck;
    return this;
  }

   /**
   * both, entry, or exit. Controls Day Trading Margin Call (DTMC) checks.
   * @return dtbpCheck
  **/
  @javax.annotation.Nonnull
  public DtbpCheckEnum getDtbpCheck() {
    return dtbpCheck;
  }

  public void setDtbpCheck(DtbpCheckEnum dtbpCheck) {
    this.dtbpCheck = dtbpCheck;
  }


  public AccountConfigurations tradeConfirmEmail(TradeConfirmEmailEnum tradeConfirmEmail) {
    this.tradeConfirmEmail = tradeConfirmEmail;
    return this;
  }

   /**
   * all or none. If none, emails for order fills are not sent.
   * @return tradeConfirmEmail
  **/
  @javax.annotation.Nonnull
  public TradeConfirmEmailEnum getTradeConfirmEmail() {
    return tradeConfirmEmail;
  }

  public void setTradeConfirmEmail(TradeConfirmEmailEnum tradeConfirmEmail) {
    this.tradeConfirmEmail = tradeConfirmEmail;
  }


  public AccountConfigurations suspendTrade(Boolean suspendTrade) {
    this.suspendTrade = suspendTrade;
    return this;
  }

   /**
   * If true, new orders are blocked.
   * @return suspendTrade
  **/
  @javax.annotation.Nonnull
  public Boolean getSuspendTrade() {
    return suspendTrade;
  }

  public void setSuspendTrade(Boolean suspendTrade) {
    this.suspendTrade = suspendTrade;
  }


  public AccountConfigurations noShorting(Boolean noShorting) {
    this.noShorting = noShorting;
    return this;
  }

   /**
   * If true, account becomes long-only mode.
   * @return noShorting
  **/
  @javax.annotation.Nonnull
  public Boolean getNoShorting() {
    return noShorting;
  }

  public void setNoShorting(Boolean noShorting) {
    this.noShorting = noShorting;
  }


  public AccountConfigurations fractionalTrading(Boolean fractionalTrading) {
    this.fractionalTrading = fractionalTrading;
    return this;
  }

   /**
   * If true, account is able to participate in fractional trading
   * @return fractionalTrading
  **/
  @javax.annotation.Nonnull
  public Boolean getFractionalTrading() {
    return fractionalTrading;
  }

  public void setFractionalTrading(Boolean fractionalTrading) {
    this.fractionalTrading = fractionalTrading;
  }


  public AccountConfigurations maxMarginMultiplier(String maxMarginMultiplier) {
    this.maxMarginMultiplier = maxMarginMultiplier;
    return this;
  }

   /**
   * Can be \&quot;1\&quot; or \&quot;2\&quot;
   * @return maxMarginMultiplier
  **/
  @javax.annotation.Nonnull
  public String getMaxMarginMultiplier() {
    return maxMarginMultiplier;
  }

  public void setMaxMarginMultiplier(String maxMarginMultiplier) {
    this.maxMarginMultiplier = maxMarginMultiplier;
  }


  public AccountConfigurations maxOptionsTradingLevel(MaxOptionsTradingLevelEnum maxOptionsTradingLevel) {
    this.maxOptionsTradingLevel = maxOptionsTradingLevel;
    return this;
  }

   /**
   * The desired maximum option trading level. 0&#x3D;disabled, 1&#x3D;Covered Call/Cash-Secured Put, 2&#x3D;Long Call/Put.
   * @return maxOptionsTradingLevel
  **/
  @javax.annotation.Nullable
  public MaxOptionsTradingLevelEnum getMaxOptionsTradingLevel() {
    return maxOptionsTradingLevel;
  }

  public void setMaxOptionsTradingLevel(MaxOptionsTradingLevelEnum maxOptionsTradingLevel) {
    this.maxOptionsTradingLevel = maxOptionsTradingLevel;
  }


  public AccountConfigurations pdtCheck(String pdtCheck) {
    this.pdtCheck = pdtCheck;
    return this;
  }

   /**
   * Get pdtCheck
   * @return pdtCheck
  **/
  @javax.annotation.Nonnull
  public String getPdtCheck() {
    return pdtCheck;
  }

  public void setPdtCheck(String pdtCheck) {
    this.pdtCheck = pdtCheck;
  }


  public AccountConfigurations ptpNoExceptionEntry(String ptpNoExceptionEntry) {
    this.ptpNoExceptionEntry = ptpNoExceptionEntry;
    return this;
  }

   /**
   * If set to true then Alpaca will accept orders for PTP symbols with no exception. Default is false.
   * @return ptpNoExceptionEntry
  **/
  @javax.annotation.Nonnull
  public String getPtpNoExceptionEntry() {
    return ptpNoExceptionEntry;
  }

  public void setPtpNoExceptionEntry(String ptpNoExceptionEntry) {
    this.ptpNoExceptionEntry = ptpNoExceptionEntry;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountConfigurations accountConfigurations = (AccountConfigurations) o;
    return Objects.equals(this.dtbpCheck, accountConfigurations.dtbpCheck) &&
        Objects.equals(this.tradeConfirmEmail, accountConfigurations.tradeConfirmEmail) &&
        Objects.equals(this.suspendTrade, accountConfigurations.suspendTrade) &&
        Objects.equals(this.noShorting, accountConfigurations.noShorting) &&
        Objects.equals(this.fractionalTrading, accountConfigurations.fractionalTrading) &&
        Objects.equals(this.maxMarginMultiplier, accountConfigurations.maxMarginMultiplier) &&
        Objects.equals(this.maxOptionsTradingLevel, accountConfigurations.maxOptionsTradingLevel) &&
        Objects.equals(this.pdtCheck, accountConfigurations.pdtCheck) &&
        Objects.equals(this.ptpNoExceptionEntry, accountConfigurations.ptpNoExceptionEntry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dtbpCheck, tradeConfirmEmail, suspendTrade, noShorting, fractionalTrading, maxMarginMultiplier, maxOptionsTradingLevel, pdtCheck, ptpNoExceptionEntry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountConfigurations {\n");
    sb.append("    dtbpCheck: ").append(toIndentedString(dtbpCheck)).append("\n");
    sb.append("    tradeConfirmEmail: ").append(toIndentedString(tradeConfirmEmail)).append("\n");
    sb.append("    suspendTrade: ").append(toIndentedString(suspendTrade)).append("\n");
    sb.append("    noShorting: ").append(toIndentedString(noShorting)).append("\n");
    sb.append("    fractionalTrading: ").append(toIndentedString(fractionalTrading)).append("\n");
    sb.append("    maxMarginMultiplier: ").append(toIndentedString(maxMarginMultiplier)).append("\n");
    sb.append("    maxOptionsTradingLevel: ").append(toIndentedString(maxOptionsTradingLevel)).append("\n");
    sb.append("    pdtCheck: ").append(toIndentedString(pdtCheck)).append("\n");
    sb.append("    ptpNoExceptionEntry: ").append(toIndentedString(ptpNoExceptionEntry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("dtbp_check");
    openapiFields.add("trade_confirm_email");
    openapiFields.add("suspend_trade");
    openapiFields.add("no_shorting");
    openapiFields.add("fractional_trading");
    openapiFields.add("max_margin_multiplier");
    openapiFields.add("max_options_trading_level");
    openapiFields.add("pdt_check");
    openapiFields.add("ptp_no_exception_entry");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("dtbp_check");
    openapiRequiredFields.add("trade_confirm_email");
    openapiRequiredFields.add("suspend_trade");
    openapiRequiredFields.add("no_shorting");
    openapiRequiredFields.add("fractional_trading");
    openapiRequiredFields.add("max_margin_multiplier");
    openapiRequiredFields.add("pdt_check");
    openapiRequiredFields.add("ptp_no_exception_entry");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!AccountConfigurations.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in AccountConfigurations is not found in the empty JSON string", AccountConfigurations.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!AccountConfigurations.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountConfigurations` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AccountConfigurations.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("dtbp_check").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `dtbp_check` to be a primitive type in the JSON string but got `%s`", jsonObj.get("dtbp_check").toString()));
      }
      // validate the required field `dtbp_check`
      DtbpCheckEnum.validateJsonElement(jsonObj.get("dtbp_check"));
      if (!jsonObj.get("trade_confirm_email").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `trade_confirm_email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("trade_confirm_email").toString()));
      }
      // validate the required field `trade_confirm_email`
      TradeConfirmEmailEnum.validateJsonElement(jsonObj.get("trade_confirm_email"));
      if (!jsonObj.get("max_margin_multiplier").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `max_margin_multiplier` to be a primitive type in the JSON string but got `%s`", jsonObj.get("max_margin_multiplier").toString()));
      }
      if ((jsonObj.get("max_options_trading_level") != null && !jsonObj.get("max_options_trading_level").isJsonNull()) && !jsonObj.get("max_options_trading_level").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `max_options_trading_level` to be a primitive type in the JSON string but got `%s`", jsonObj.get("max_options_trading_level").toString()));
      }
      // validate the optional field `max_options_trading_level`
      if (jsonObj.get("max_options_trading_level") != null && !jsonObj.get("max_options_trading_level").isJsonNull()) {
        MaxOptionsTradingLevelEnum.validateJsonElement(jsonObj.get("max_options_trading_level"));
      }
      if (!jsonObj.get("pdt_check").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pdt_check` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pdt_check").toString()));
      }
      if (!jsonObj.get("ptp_no_exception_entry").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ptp_no_exception_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ptp_no_exception_entry").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AccountConfigurations.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AccountConfigurations' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AccountConfigurations> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AccountConfigurations.class));

       return (TypeAdapter<T>) new TypeAdapter<AccountConfigurations>() {
           @Override
           public void write(JsonWriter out, AccountConfigurations value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AccountConfigurations read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AccountConfigurations given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AccountConfigurations
  * @throws IOException if the JSON string is invalid with respect to AccountConfigurations
  */
  public static AccountConfigurations fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AccountConfigurations.class);
  }

 /**
  * Convert an instance of AccountConfigurations to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

