/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountStatus;
import net.jacobpeterson.alpaca.openapi.broker.model.AccountType;
import net.jacobpeterson.alpaca.openapi.broker.model.Agreement;
import net.jacobpeterson.alpaca.openapi.broker.model.AssetClass;
import net.jacobpeterson.alpaca.openapi.broker.model.Contact;
import net.jacobpeterson.alpaca.openapi.broker.model.Disclosures;
import net.jacobpeterson.alpaca.openapi.broker.model.DocumentInner;
import net.jacobpeterson.alpaca.openapi.broker.model.Identity;
import net.jacobpeterson.alpaca.openapi.broker.model.TrustedContact;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.jacobpeterson.alpaca.openapi.broker.JSON;

/**
 * Represents high level account info. Used when returning entire account information would not be useful like the getAllAccounts operation
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T11:10:45.478835-08:00[America/Los_Angeles]")
public class Account {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private UUID id;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_TYPE)
  private AccountType accountType;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private AccountStatus status;

  public static final String SERIALIZED_NAME_CRYPTO_STATUS = "crypto_status";
  @SerializedName(SERIALIZED_NAME_CRYPTO_STATUS)
  private AccountStatus cryptoStatus;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_LAST_EQUITY = "last_equity";
  @SerializedName(SERIALIZED_NAME_LAST_EQUITY)
  private BigDecimal lastEquity;

  public static final String SERIALIZED_NAME_ENABLED_ASSETS = "enabled_assets";
  @SerializedName(SERIALIZED_NAME_ENABLED_ASSETS)
  private List<AssetClass> enabledAssets;

  public static final String SERIALIZED_NAME_CONTACT = "contact";
  @SerializedName(SERIALIZED_NAME_CONTACT)
  private Contact contact;

  public static final String SERIALIZED_NAME_IDENTITY = "identity";
  @SerializedName(SERIALIZED_NAME_IDENTITY)
  private Identity identity;

  public static final String SERIALIZED_NAME_DISCLOSURES = "disclosures";
  @SerializedName(SERIALIZED_NAME_DISCLOSURES)
  private Disclosures disclosures;

  public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
  @SerializedName(SERIALIZED_NAME_DOCUMENTS)
  private List<Set<DocumentInner>> documents;

  public static final String SERIALIZED_NAME_AGREEMENTS = "agreements";
  @SerializedName(SERIALIZED_NAME_AGREEMENTS)
  private List<Agreement> agreements;

  public static final String SERIALIZED_NAME_TRUSTED_CONTACT = "trusted_contact";
  @SerializedName(SERIALIZED_NAME_TRUSTED_CONTACT)
  private TrustedContact trustedContact;

  public Account() {
  }

  public Account id(UUID id) {
    this.id = id;
    return this;
  }

   /**
   * UUID that identifies the account for later reference
   * @return id
  **/
  @javax.annotation.Nonnull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }


  public Account accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * A human-readable account number that can be shown to the end user
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  public String getAccountNumber() {
    return accountNumber;
  }

  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public Account accountType(AccountType accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * Get accountType
   * @return accountType
  **/
  @javax.annotation.Nullable
  public AccountType getAccountType() {
    return accountType;
  }

  public void setAccountType(AccountType accountType) {
    this.accountType = accountType;
  }


  public Account status(AccountStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nonnull
  public AccountStatus getStatus() {
    return status;
  }

  public void setStatus(AccountStatus status) {
    this.status = status;
  }


  public Account cryptoStatus(AccountStatus cryptoStatus) {
    this.cryptoStatus = cryptoStatus;
    return this;
  }

   /**
   * Get cryptoStatus
   * @return cryptoStatus
  **/
  @javax.annotation.Nullable
  public AccountStatus getCryptoStatus() {
    return cryptoStatus;
  }

  public void setCryptoStatus(AccountStatus cryptoStatus) {
    this.cryptoStatus = cryptoStatus;
  }


  public Account currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * \&quot;USD\&quot; // US Dollar \&quot;JPY\&quot; // Japanese Yen \&quot;EUR\&quot; // Euro \&quot;CAD\&quot; // Canadian Dollar \&quot;GBP\&quot; // British Pound Sterling \&quot;CHF\&quot; // Swiss Franc \&quot;TRY\&quot; // Turkish Lira \&quot;AUD\&quot; // Australian Dollar \&quot;CZK\&quot; // Czech Koruna \&quot;SEK\&quot; // Swedish Krona \&quot;DKK\&quot; // Danish Krone \&quot;SGD\&quot; // Singapore Dollar \&quot;HKD\&quot; // Hong Kong Dollar \&quot;HUF\&quot; // Hungarian Forint \&quot;NZD\&quot; // New Zealand Dollar \&quot;NOK\&quot; // Norwegian Krone \&quot;PLN\&quot; // Poland Złoty
   * @return currency
  **/
  @javax.annotation.Nonnull
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Account createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Timestamp (RFC3339) of account creation.
   * @return createdAt
  **/
  @javax.annotation.Nonnull
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Account lastEquity(BigDecimal lastEquity) {
    this.lastEquity = lastEquity;
    return this;
  }

   /**
   * EOD equity calculation (cash + long market value + short market value)
   * @return lastEquity
  **/
  @javax.annotation.Nonnull
  public BigDecimal getLastEquity() {
    return lastEquity;
  }

  public void setLastEquity(BigDecimal lastEquity) {
    this.lastEquity = lastEquity;
  }


  public Account enabledAssets(List<AssetClass> enabledAssets) {
    this.enabledAssets = enabledAssets;
    return this;
  }

  public Account addEnabledAssetsItem(AssetClass enabledAssetsItem) {
    if (this.enabledAssets == null) {
      this.enabledAssets = new ArrayList<>();
    }
    this.enabledAssets.add(enabledAssetsItem);
    return this;
  }

   /**
   * Assets the user has enabled and is able to trade once status and/or crypto_status are ACTIVE
   * @return enabledAssets
  **/
  @javax.annotation.Nullable
  public List<AssetClass> getEnabledAssets() {
    return enabledAssets;
  }

  public void setEnabledAssets(List<AssetClass> enabledAssets) {
    this.enabledAssets = enabledAssets;
  }


  public Account contact(Contact contact) {
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nullable
  public Contact getContact() {
    return contact;
  }

  public void setContact(Contact contact) {
    this.contact = contact;
  }


  public Account identity(Identity identity) {
    this.identity = identity;
    return this;
  }

   /**
   * Get identity
   * @return identity
  **/
  @javax.annotation.Nullable
  public Identity getIdentity() {
    return identity;
  }

  public void setIdentity(Identity identity) {
    this.identity = identity;
  }


  public Account disclosures(Disclosures disclosures) {
    this.disclosures = disclosures;
    return this;
  }

   /**
   * Get disclosures
   * @return disclosures
  **/
  @javax.annotation.Nullable
  public Disclosures getDisclosures() {
    return disclosures;
  }

  public void setDisclosures(Disclosures disclosures) {
    this.disclosures = disclosures;
  }


  public Account documents(List<Set<DocumentInner>> documents) {
    this.documents = documents;
    return this;
  }

  public Account addDocumentsItem(Set<DocumentInner> documentsItem) {
    if (this.documents == null) {
      this.documents = new ArrayList<>();
    }
    this.documents.add(documentsItem);
    return this;
  }

   /**
   * Get documents
   * @return documents
  **/
  @javax.annotation.Nullable
  public List<Set<DocumentInner>> getDocuments() {
    return documents;
  }

  public void setDocuments(List<Set<DocumentInner>> documents) {
    this.documents = documents;
  }


  public Account agreements(List<Agreement> agreements) {
    this.agreements = agreements;
    return this;
  }

  public Account addAgreementsItem(Agreement agreementsItem) {
    if (this.agreements == null) {
      this.agreements = new ArrayList<>();
    }
    this.agreements.add(agreementsItem);
    return this;
  }

   /**
   * Get agreements
   * @return agreements
  **/
  @javax.annotation.Nullable
  public List<Agreement> getAgreements() {
    return agreements;
  }

  public void setAgreements(List<Agreement> agreements) {
    this.agreements = agreements;
  }


  public Account trustedContact(TrustedContact trustedContact) {
    this.trustedContact = trustedContact;
    return this;
  }

   /**
   * Get trustedContact
   * @return trustedContact
  **/
  @javax.annotation.Nullable
  public TrustedContact getTrustedContact() {
    return trustedContact;
  }

  public void setTrustedContact(TrustedContact trustedContact) {
    this.trustedContact = trustedContact;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.id, account.id) &&
        Objects.equals(this.accountNumber, account.accountNumber) &&
        Objects.equals(this.accountType, account.accountType) &&
        Objects.equals(this.status, account.status) &&
        Objects.equals(this.cryptoStatus, account.cryptoStatus) &&
        Objects.equals(this.currency, account.currency) &&
        Objects.equals(this.createdAt, account.createdAt) &&
        Objects.equals(this.lastEquity, account.lastEquity) &&
        Objects.equals(this.enabledAssets, account.enabledAssets) &&
        Objects.equals(this.contact, account.contact) &&
        Objects.equals(this.identity, account.identity) &&
        Objects.equals(this.disclosures, account.disclosures) &&
        Objects.equals(this.documents, account.documents) &&
        Objects.equals(this.agreements, account.agreements) &&
        Objects.equals(this.trustedContact, account.trustedContact);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, accountNumber, accountType, status, cryptoStatus, currency, createdAt, lastEquity, enabledAssets, contact, identity, disclosures, documents, agreements, trustedContact);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    cryptoStatus: ").append(toIndentedString(cryptoStatus)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    lastEquity: ").append(toIndentedString(lastEquity)).append("\n");
    sb.append("    enabledAssets: ").append(toIndentedString(enabledAssets)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    identity: ").append(toIndentedString(identity)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("    agreements: ").append(toIndentedString(agreements)).append("\n");
    sb.append("    trustedContact: ").append(toIndentedString(trustedContact)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("account_number");
    openapiFields.add("account_type");
    openapiFields.add("status");
    openapiFields.add("crypto_status");
    openapiFields.add("currency");
    openapiFields.add("created_at");
    openapiFields.add("last_equity");
    openapiFields.add("enabled_assets");
    openapiFields.add("contact");
    openapiFields.add("identity");
    openapiFields.add("disclosures");
    openapiFields.add("documents");
    openapiFields.add("agreements");
    openapiFields.add("trusted_contact");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("account_number");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("currency");
    openapiRequiredFields.add("created_at");
    openapiRequiredFields.add("last_equity");
  }

 
  public static boolean validate = false;
    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (!validate) return;
      if (jsonElement == null) {
        if (!Account.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Account is not found in the empty JSON string", Account.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Account.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Account` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Account.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if ((jsonObj.get("account_number") != null && !jsonObj.get("account_number").isJsonNull()) && !jsonObj.get("account_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `account_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("account_number").toString()));
      }
      // validate the optional field `account_type`
      if (jsonObj.get("account_type") != null && !jsonObj.get("account_type").isJsonNull()) {
        AccountType.validateJsonElement(jsonObj.get("account_type"));
      }
      // validate the required field `status`
      AccountStatus.validateJsonElement(jsonObj.get("status"));
      // validate the optional field `crypto_status`
      if (jsonObj.get("crypto_status") != null && !jsonObj.get("crypto_status").isJsonNull()) {
        AccountStatus.validateJsonElement(jsonObj.get("crypto_status"));
      }
      if (!jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (!jsonObj.get("last_equity").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_equity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_equity").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("enabled_assets") != null && !jsonObj.get("enabled_assets").isJsonNull() && !jsonObj.get("enabled_assets").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `enabled_assets` to be an array in the JSON string but got `%s`", jsonObj.get("enabled_assets").toString()));
      }
      // validate the optional field `contact`
      if (jsonObj.get("contact") != null && !jsonObj.get("contact").isJsonNull()) {
        Contact.validateJsonElement(jsonObj.get("contact"));
      }
      // validate the optional field `identity`
      if (jsonObj.get("identity") != null && !jsonObj.get("identity").isJsonNull()) {
        Identity.validateJsonElement(jsonObj.get("identity"));
      }
      // validate the optional field `disclosures`
      if (jsonObj.get("disclosures") != null && !jsonObj.get("disclosures").isJsonNull()) {
        Disclosures.validateJsonElement(jsonObj.get("disclosures"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("documents") != null && !jsonObj.get("documents").isJsonNull() && !jsonObj.get("documents").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get("documents").toString()));
      }
      if (jsonObj.get("agreements") != null && !jsonObj.get("agreements").isJsonNull()) {
        JsonArray jsonArrayagreements = jsonObj.getAsJsonArray("agreements");
        if (jsonArrayagreements != null) {
          // ensure the json data is an array
          if (!jsonObj.get("agreements").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `agreements` to be an array in the JSON string but got `%s`", jsonObj.get("agreements").toString()));
          }

          // validate the optional field `agreements` (array)
          for (int i = 0; i < jsonArrayagreements.size(); i++) {
            Agreement.validateJsonElement(jsonArrayagreements.get(i));
          };
        }
      }
      // validate the optional field `trusted_contact`
      if (jsonObj.get("trusted_contact") != null && !jsonObj.get("trusted_contact").isJsonNull()) {
        TrustedContact.validateJsonElement(jsonObj.get("trusted_contact"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Account.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Account' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Account> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Account.class));

       return (TypeAdapter<T>) new TypeAdapter<Account>() {
           @Override
           public void write(JsonWriter out, Account value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Account read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Account given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Account
  * @throws IOException if the JSON string is invalid with respect to Account
  */
  public static Account fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Account.class);
  }

 /**
  * Convert an instance of Account to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

