/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.CreateWatchlistRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.Watchlist;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WatchlistApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WatchlistApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WatchlistApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for createWatchlistForAccount
     * @param accountId Unique identifier of an account. (required)
     * @param createWatchlistRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Newly created watchlist </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createWatchlistForAccountCall(UUID accountId, CreateWatchlistRequest createWatchlistRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createWatchlistRequest;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createWatchlistForAccountValidateBeforeCall(UUID accountId, CreateWatchlistRequest createWatchlistRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createWatchlistForAccount(Async)");
        }

        return createWatchlistForAccountCall(accountId, createWatchlistRequest, _callback);

    }

    /**
     * Create a New Watchlist for an Account
     * Returns the watchlist object
     * @param accountId Unique identifier of an account. (required)
     * @param createWatchlistRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Newly created watchlist </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist createWatchlistForAccount(UUID accountId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = createWatchlistForAccountWithHttpInfo(accountId, createWatchlistRequest);
        return localVarResp.getData();
    }

    /**
     * Create a New Watchlist for an Account
     * Returns the watchlist object
     * @param accountId Unique identifier of an account. (required)
     * @param createWatchlistRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Newly created watchlist </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> createWatchlistForAccountWithHttpInfo(UUID accountId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        okhttp3.Call localVarCall = createWatchlistForAccountValidateBeforeCall(accountId, createWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a New Watchlist for an Account (asynchronously)
     * Returns the watchlist object
     * @param accountId Unique identifier of an account. (required)
     * @param createWatchlistRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Newly created watchlist </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createWatchlistForAccountAsync(UUID accountId, CreateWatchlistRequest createWatchlistRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = createWatchlistForAccountValidateBeforeCall(accountId, createWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol
     * @param accountId Account identifier. (required)
     * @param watchlistId The Watchlist ID (required)
     * @param symbol The symbol  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolCall(String accountId, String watchlistId, String symbol, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}/{symbol}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()))
            .replace("{" + "symbol" + "}", localVarApiClient.escapeString(symbol.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolValidateBeforeCall(String accountId, String watchlistId, String symbol, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(Async)");
        }

        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(Async)");
        }

        // verify the required parameter 'symbol' is set
        if (symbol == null) {
            throw new ApiException("Missing the required parameter 'symbol' when calling deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(Async)");
        }

        return deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolCall(accountId, watchlistId, symbol, _callback);

    }

    /**
     * Remove a Symbol from a Watchlist
     * Delete one entry for an asset by symbol name
     * @param accountId Account identifier. (required)
     * @param watchlistId The Watchlist ID (required)
     * @param symbol The symbol  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found </td><td>  -  </td></tr>
     </table>
     */
    public void deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbol(String accountId, String watchlistId, String symbol) throws ApiException {
        deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolWithHttpInfo(accountId, watchlistId, symbol);
    }

    /**
     * Remove a Symbol from a Watchlist
     * Delete one entry for an asset by symbol name
     * @param accountId Account identifier. (required)
     * @param watchlistId The Watchlist ID (required)
     * @param symbol The symbol  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolWithHttpInfo(String accountId, String watchlistId, String symbol) throws ApiException {
        okhttp3.Call localVarCall = deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolValidateBeforeCall(accountId, watchlistId, symbol, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Remove a Symbol from a Watchlist (asynchronously)
     * Delete one entry for an asset by symbol name
     * @param accountId Account identifier. (required)
     * @param watchlistId The Watchlist ID (required)
     * @param symbol The symbol  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolAsync(String accountId, String watchlistId, String symbol, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteDELETEV1TradingAccountsAccountIdWatchlistsWatchlistIdSymbolValidateBeforeCall(accountId, watchlistId, symbol, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteWatchlistFromAccountById
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Watchlist deleted. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteWatchlistFromAccountByIdCall(UUID accountId, UUID watchlistId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteWatchlistFromAccountByIdValidateBeforeCall(UUID accountId, UUID watchlistId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteWatchlistFromAccountById(Async)");
        }

        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling deleteWatchlistFromAccountById(Async)");
        }

        return deleteWatchlistFromAccountByIdCall(accountId, watchlistId, _callback);

    }

    /**
     * Remove a Watchlist
     * Irrevocably delete a watchlist.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Watchlist deleted. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteWatchlistFromAccountById(UUID accountId, UUID watchlistId) throws ApiException {
        deleteWatchlistFromAccountByIdWithHttpInfo(accountId, watchlistId);
    }

    /**
     * Remove a Watchlist
     * Irrevocably delete a watchlist.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Watchlist deleted. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteWatchlistFromAccountByIdWithHttpInfo(UUID accountId, UUID watchlistId) throws ApiException {
        okhttp3.Call localVarCall = deleteWatchlistFromAccountByIdValidateBeforeCall(accountId, watchlistId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Remove a Watchlist (asynchronously)
     * Irrevocably delete a watchlist.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Watchlist deleted. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteWatchlistFromAccountByIdAsync(UUID accountId, UUID watchlistId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteWatchlistFromAccountByIdValidateBeforeCall(accountId, watchlistId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllWatchlistsForAccount
     * @param accountId Unique identifier of an account. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllWatchlistsForAccountCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllWatchlistsForAccountValidateBeforeCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAllWatchlistsForAccount(Async)");
        }

        return getAllWatchlistsForAccountCall(accountId, _callback);

    }

    /**
     * Retrieve all Watchlists for an Account
     * Fetch a list of all watchlists currently in an account.
     * @param accountId Unique identifier of an account. (required)
     * @return List&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public List<Watchlist> getAllWatchlistsForAccount(UUID accountId) throws ApiException {
        ApiResponse<List<Watchlist>> localVarResp = getAllWatchlistsForAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Retrieve all Watchlists for an Account
     * Fetch a list of all watchlists currently in an account.
     * @param accountId Unique identifier of an account. (required)
     * @return ApiResponse&lt;List&lt;Watchlist&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Watchlist>> getAllWatchlistsForAccountWithHttpInfo(UUID accountId) throws ApiException {
        okhttp3.Call localVarCall = getAllWatchlistsForAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve all Watchlists for an Account (asynchronously)
     * Fetch a list of all watchlists currently in an account.
     * @param accountId Unique identifier of an account. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllWatchlistsForAccountAsync(UUID accountId, final ApiCallback<List<Watchlist>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllWatchlistsForAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<Watchlist>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getWatchlistForAccountById
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistForAccountByIdCall(UUID accountId, UUID watchlistId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getWatchlistForAccountByIdValidateBeforeCall(UUID accountId, UUID watchlistId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getWatchlistForAccountById(Async)");
        }

        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling getWatchlistForAccountById(Async)");
        }

        return getWatchlistForAccountByIdCall(accountId, watchlistId, _callback);

    }

    /**
     * Manage watchlists
     * Retrieve Watchlist by ID
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist getWatchlistForAccountById(UUID accountId, UUID watchlistId) throws ApiException {
        ApiResponse<Watchlist> localVarResp = getWatchlistForAccountByIdWithHttpInfo(accountId, watchlistId);
        return localVarResp.getData();
    }

    /**
     * Manage watchlists
     * Retrieve Watchlist by ID
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> getWatchlistForAccountByIdWithHttpInfo(UUID accountId, UUID watchlistId) throws ApiException {
        okhttp3.Call localVarCall = getWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Manage watchlists (asynchronously)
     * Retrieve Watchlist by ID
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getWatchlistForAccountByIdAsync(UUID accountId, UUID watchlistId, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = getWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1TradingAccountsAccountIdWatchlistsWatchlistId
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found, or one of the symbols is not found in the assets </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1TradingAccountsAccountIdWatchlistsWatchlistIdCall(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1TradingAccountsAccountIdWatchlistsWatchlistIdValidateBeforeCall(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling postV1TradingAccountsAccountIdWatchlistsWatchlistId(Async)");
        }

        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling postV1TradingAccountsAccountIdWatchlistsWatchlistId(Async)");
        }

        return postV1TradingAccountsAccountIdWatchlistsWatchlistIdCall(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, _callback);

    }

    /**
     * Add an Asset to a Watchlist
     * Adds an asset to an existing watchlist.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found, or one of the symbols is not found in the assets </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist postV1TradingAccountsAccountIdWatchlistsWatchlistId(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = postV1TradingAccountsAccountIdWatchlistsWatchlistIdWithHttpInfo(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest);
        return localVarResp.getData();
    }

    /**
     * Add an Asset to a Watchlist
     * Adds an asset to an existing watchlist.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found, or one of the symbols is not found in the assets </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> postV1TradingAccountsAccountIdWatchlistsWatchlistIdWithHttpInfo(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest) throws ApiException {
        okhttp3.Call localVarCall = postV1TradingAccountsAccountIdWatchlistsWatchlistIdValidateBeforeCall(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add an Asset to a Watchlist (asynchronously)
     * Adds an asset to an existing watchlist.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested watchlist is not found, or one of the symbols is not found in the assets </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1TradingAccountsAccountIdWatchlistsWatchlistIdAsync(UUID accountId, UUID watchlistId, PostV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1TradingAccountsAccountIdWatchlistsWatchlistIdValidateBeforeCall(accountId, watchlistId, postV1TradingAccountsAccountIdWatchlistsWatchlistIdRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for replaceWatchlistForAccountById
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param createWatchlistRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated watchlist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call replaceWatchlistForAccountByIdCall(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createWatchlistRequest;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/watchlists/{watchlist_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "watchlist_id" + "}", localVarApiClient.escapeString(watchlistId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call replaceWatchlistForAccountByIdValidateBeforeCall(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling replaceWatchlistForAccountById(Async)");
        }

        // verify the required parameter 'watchlistId' is set
        if (watchlistId == null) {
            throw new ApiException("Missing the required parameter 'watchlistId' when calling replaceWatchlistForAccountById(Async)");
        }

        return replaceWatchlistForAccountByIdCall(accountId, watchlistId, createWatchlistRequest, _callback);

    }

    /**
     * Update a Watchlist
     * Replace entirely the set of securities contained in the watchlist while optionally renaming it. Destructive operation.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param createWatchlistRequest  (optional)
     * @return Watchlist
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated watchlist. </td><td>  -  </td></tr>
     </table>
     */
    public Watchlist replaceWatchlistForAccountById(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        ApiResponse<Watchlist> localVarResp = replaceWatchlistForAccountByIdWithHttpInfo(accountId, watchlistId, createWatchlistRequest);
        return localVarResp.getData();
    }

    /**
     * Update a Watchlist
     * Replace entirely the set of securities contained in the watchlist while optionally renaming it. Destructive operation.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param createWatchlistRequest  (optional)
     * @return ApiResponse&lt;Watchlist&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated watchlist. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Watchlist> replaceWatchlistForAccountByIdWithHttpInfo(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest) throws ApiException {
        okhttp3.Call localVarCall = replaceWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, createWatchlistRequest, null);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a Watchlist (asynchronously)
     * Replace entirely the set of securities contained in the watchlist while optionally renaming it. Destructive operation.
     * @param accountId Unique identifier of an account (required)
     * @param watchlistId Unique identifier of a watchlist (required)
     * @param createWatchlistRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated watchlist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call replaceWatchlistForAccountByIdAsync(UUID accountId, UUID watchlistId, CreateWatchlistRequest createWatchlistRequest, final ApiCallback<Watchlist> _callback) throws ApiException {

        okhttp3.Call localVarCall = replaceWatchlistForAccountByIdValidateBeforeCall(accountId, watchlistId, createWatchlistRequest, _callback);
        Type localVarReturnType = new TypeToken<Watchlist>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
