/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.AccountConfigurations;
import net.jacobpeterson.alpaca.openapi.broker.model.CreateOrderRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Error;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1AccountsPositions200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1TradingAccountsAccountIdOrdersEstimationRequest;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import net.jacobpeterson.alpaca.openapi.broker.model.Order;
import net.jacobpeterson.alpaca.openapi.broker.model.OrderClosedResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioHistory;
import net.jacobpeterson.alpaca.openapi.broker.model.Position;
import net.jacobpeterson.alpaca.openapi.broker.model.PositionClosedResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.TradeUpdateEventV2;
import java.util.UUID;
import net.jacobpeterson.alpaca.openapi.broker.model.UpdateOrderRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TradingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TradingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TradingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for closeAllPositionsForAccount
     * @param accountId Account identifier. (required)
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body; an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate some positions </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call closeAllPositionsForAccountCall(UUID accountId, Boolean cancelOrders, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/positions"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (cancelOrders != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cancel_orders", cancelOrders));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call closeAllPositionsForAccountValidateBeforeCall(UUID accountId, Boolean cancelOrders, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling closeAllPositionsForAccount(Async)");
        }

        return closeAllPositionsForAccountCall(accountId, cancelOrders, _callback);

    }

    /**
     * Close All Positions for an Account
     * Closes (liquidates) all of the account’s open long and short positions. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param accountId Account identifier. (required)
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @return List&lt;PositionClosedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body; an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate some positions </td><td>  -  </td></tr>
     </table>
     */
    public List<PositionClosedResponse> closeAllPositionsForAccount(UUID accountId, Boolean cancelOrders) throws ApiException {
        ApiResponse<List<PositionClosedResponse>> localVarResp = closeAllPositionsForAccountWithHttpInfo(accountId, cancelOrders);
        return localVarResp.getData();
    }

    /**
     * Close All Positions for an Account
     * Closes (liquidates) all of the account’s open long and short positions. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param accountId Account identifier. (required)
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @return ApiResponse&lt;List&lt;PositionClosedResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body; an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate some positions </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<PositionClosedResponse>> closeAllPositionsForAccountWithHttpInfo(UUID accountId, Boolean cancelOrders) throws ApiException {
        okhttp3.Call localVarCall = closeAllPositionsForAccountValidateBeforeCall(accountId, cancelOrders, null);
        Type localVarReturnType = new TypeToken<List<PositionClosedResponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Close All Positions for an Account (asynchronously)
     * Closes (liquidates) all of the account’s open long and short positions. A response will be provided for each order that is attempted to be cancelled. If an order is no longer cancelable, the server will respond with status 500 and reject the request.
     * @param accountId Account identifier. (required)
     * @param cancelOrders If true is specified, cancel all open orders before liquidating all positions. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body; an array of objects that include the order id and http status code for each status request. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failed to liquidate some positions </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call closeAllPositionsForAccountAsync(UUID accountId, Boolean cancelOrders, final ApiCallback<List<PositionClosedResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = closeAllPositionsForAccountValidateBeforeCall(accountId, cancelOrders, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClosedResponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for closePositionForAccountBySymbol
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @param qty Optional the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call closePositionForAccountBySymbolCall(UUID accountId, String symbolOrAssetId, String qty, String percentage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/positions/{symbol_or_asset_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "symbol_or_asset_id" + "}", localVarApiClient.escapeString(symbolOrAssetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (qty != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("qty", qty));
        }

        if (percentage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("percentage", percentage));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call closePositionForAccountBySymbolValidateBeforeCall(UUID accountId, String symbolOrAssetId, String qty, String percentage, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling closePositionForAccountBySymbol(Async)");
        }

        // verify the required parameter 'symbolOrAssetId' is set
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling closePositionForAccountBySymbol(Async)");
        }

        return closePositionForAccountBySymbolCall(accountId, symbolOrAssetId, qty, percentage, _callback);

    }

    /**
     * Close a Position for an Account
     * Closes (liquidates) the account’s open position for the given symbol. Works for both long and short positions.
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @param qty Optional the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Order closePositionForAccountBySymbol(UUID accountId, String symbolOrAssetId, String qty, String percentage) throws ApiException {
        ApiResponse<Order> localVarResp = closePositionForAccountBySymbolWithHttpInfo(accountId, symbolOrAssetId, qty, percentage);
        return localVarResp.getData();
    }

    /**
     * Close a Position for an Account
     * Closes (liquidates) the account’s open position for the given symbol. Works for both long and short positions.
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @param qty Optional the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> closePositionForAccountBySymbolWithHttpInfo(UUID accountId, String symbolOrAssetId, String qty, String percentage) throws ApiException {
        okhttp3.Call localVarCall = closePositionForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, qty, percentage, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Close a Position for an Account (asynchronously)
     * Closes (liquidates) the account’s open position for the given symbol. Works for both long and short positions.
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @param qty Optional the number of shares to liquidate. Can accept up to 9 decimal points. Cannot work with percentage (optional)
     * @param percentage percentage of position to liquidate. Must be between 0 and 100. Would only sell fractional if position is originally fractional. Can accept up to 9 decimal points. Cannot work with qty (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call closePositionForAccountBySymbolAsync(UUID accountId, String symbolOrAssetId, String qty, String percentage, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = closePositionForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, qty, percentage, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createOrderForAccount
     * @param accountId Account identifier. (required)
     * @param createOrderRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Request is forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createOrderForAccountCall(UUID accountId, CreateOrderRequest createOrderRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createOrderRequest;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createOrderForAccountValidateBeforeCall(UUID accountId, CreateOrderRequest createOrderRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling createOrderForAccount(Async)");
        }

        // verify the required parameter 'createOrderRequest' is set
        if (createOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'createOrderRequest' when calling createOrderForAccount(Async)");
        }

        return createOrderForAccountCall(accountId, createOrderRequest, _callback);

    }

    /**
     * Create an Order for an Account
     * Creating an order for your end customer. Each trading request must pass in the account_id in the URL.  Note that when submitting crypto orders, Market, Limit and Stop Limit orders are supported while the supported time_in_force values are gtc, and ioc. We accept fractional orders as well with either notional or qty provided. Note that submitting an options order is only available for partners who have been enabled for Options BETA.
     * @param accountId Account identifier. (required)
     * @param createOrderRequest  (required)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Request is forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    public Order createOrderForAccount(UUID accountId, CreateOrderRequest createOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = createOrderForAccountWithHttpInfo(accountId, createOrderRequest);
        return localVarResp.getData();
    }

    /**
     * Create an Order for an Account
     * Creating an order for your end customer. Each trading request must pass in the account_id in the URL.  Note that when submitting crypto orders, Market, Limit and Stop Limit orders are supported while the supported time_in_force values are gtc, and ioc. We accept fractional orders as well with either notional or qty provided. Note that submitting an options order is only available for partners who have been enabled for Options BETA.
     * @param accountId Account identifier. (required)
     * @param createOrderRequest  (required)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Request is forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> createOrderForAccountWithHttpInfo(UUID accountId, CreateOrderRequest createOrderRequest) throws ApiException {
        okhttp3.Call localVarCall = createOrderForAccountValidateBeforeCall(accountId, createOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an Order for an Account (asynchronously)
     * Creating an order for your end customer. Each trading request must pass in the account_id in the URL.  Note that when submitting crypto orders, Market, Limit and Stop Limit orders are supported while the supported time_in_force values are gtc, and ioc. We accept fractional orders as well with either notional or qty provided. Note that submitting an options order is only available for partners who have been enabled for Options BETA.
     * @param accountId Account identifier. (required)
     * @param createOrderRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Request is forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Some parameters are not valid </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call createOrderForAccountAsync(UUID accountId, CreateOrderRequest createOrderRequest, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = createOrderForAccountValidateBeforeCall(accountId, createOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAllOrdersForAccount
     * @param accountId Account identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body, which is an array of objects that include the order id, http status code and an order object for each cancellation request. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteAllOrdersForAccountCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllOrdersForAccountValidateBeforeCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteAllOrdersForAccount(Async)");
        }

        return deleteAllOrdersForAccountCall(accountId, _callback);

    }

    /**
     * Cancel all Open Orders For an Account
     * Attempts to cancel all open orders. A response will be provided for each order that is attempted to be cancelled.
     * @param accountId Account identifier. (required)
     * @return List&lt;OrderClosedResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body, which is an array of objects that include the order id, http status code and an order object for each cancellation request. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public List<OrderClosedResponse> deleteAllOrdersForAccount(UUID accountId) throws ApiException {
        ApiResponse<List<OrderClosedResponse>> localVarResp = deleteAllOrdersForAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * Cancel all Open Orders For an Account
     * Attempts to cancel all open orders. A response will be provided for each order that is attempted to be cancelled.
     * @param accountId Account identifier. (required)
     * @return ApiResponse&lt;List&lt;OrderClosedResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body, which is an array of objects that include the order id, http status code and an order object for each cancellation request. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<OrderClosedResponse>> deleteAllOrdersForAccountWithHttpInfo(UUID accountId) throws ApiException {
        okhttp3.Call localVarCall = deleteAllOrdersForAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<OrderClosedResponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel all Open Orders For an Account (asynchronously)
     * Attempts to cancel all open orders. A response will be provided for each order that is attempted to be cancelled.
     * @param accountId Account identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 207 </td><td> HTTP 207 Multi-Status with body, which is an array of objects that include the order id, http status code and an order object for each cancellation request. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteAllOrdersForAccountAsync(UUID accountId, final ApiCallback<List<OrderClosedResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllOrdersForAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<OrderClosedResponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteOrderForAccount
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteOrderForAccountCall(UUID accountId, String orderId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/{order_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "order_id" + "}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteOrderForAccountValidateBeforeCall(UUID accountId, String orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteOrderForAccount(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling deleteOrderForAccount(Async)");
        }

        return deleteOrderForAccountCall(accountId, orderId, _callback);

    }

    /**
     * Cancel an Open Order
     * Attempts to cancel an open order. If the order is no longer cancelable (for example if the status is \&quot;filled\&quot;), the server will respond with status 422, and reject the request.  Upon acceptance of the cancel request, it returns status 204.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteOrderForAccount(UUID accountId, String orderId) throws ApiException {
        deleteOrderForAccountWithHttpInfo(accountId, orderId);
    }

    /**
     * Cancel an Open Order
     * Attempts to cancel an open order. If the order is no longer cancelable (for example if the status is \&quot;filled\&quot;), the server will respond with status 422, and reject the request.  Upon acceptance of the cancel request, it returns status 204.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteOrderForAccountWithHttpInfo(UUID accountId, String orderId) throws ApiException {
        okhttp3.Call localVarCall = deleteOrderForAccountValidateBeforeCall(accountId, orderId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Cancel an Open Order (asynchronously)
     * Attempts to cancel an open order. If the order is no longer cancelable (for example if the status is \&quot;filled\&quot;), the server will respond with status 422, and reject the request.  Upon acceptance of the cancel request, it returns status 204.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Success (No Content) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteOrderForAccountAsync(UUID accountId, String orderId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteOrderForAccountValidateBeforeCall(accountId, orderId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllOrdersForAccount
     * @param accountId Account identifier. (required)
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by. (optional)
     * @param qtyAbove  (optional)
     * @param qtyBelow  (optional)
     * @param subtag  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Retrieves a list of orders for the account, filtered by the supplied query parameters. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllOrdersForAccountCall(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (direction != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("direction", direction));
        }

        if (nested != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nested", nested));
        }

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (qtyAbove != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("qty_above", qtyAbove));
        }

        if (qtyBelow != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("qty_below", qtyBelow));
        }

        if (subtag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subtag", subtag));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllOrdersForAccountValidateBeforeCall(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAllOrdersForAccount(Async)");
        }

        return getAllOrdersForAccountCall(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag, _callback);

    }

    /**
     * Retrieve a List of Orders
     * Retrieves a list of orders for the account, filtered by the supplied query parameters.  Endpoint defaults to open orders if no parameters are provided.
     * @param accountId Account identifier. (required)
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by. (optional)
     * @param qtyAbove  (optional)
     * @param qtyBelow  (optional)
     * @param subtag  (optional)
     * @return List&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Retrieves a list of orders for the account, filtered by the supplied query parameters. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public List<Order> getAllOrdersForAccount(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag) throws ApiException {
        ApiResponse<List<Order>> localVarResp = getAllOrdersForAccountWithHttpInfo(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag);
        return localVarResp.getData();
    }

    /**
     * Retrieve a List of Orders
     * Retrieves a list of orders for the account, filtered by the supplied query parameters.  Endpoint defaults to open orders if no parameters are provided.
     * @param accountId Account identifier. (required)
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by. (optional)
     * @param qtyAbove  (optional)
     * @param qtyBelow  (optional)
     * @param subtag  (optional)
     * @return ApiResponse&lt;List&lt;Order&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Retrieves a list of orders for the account, filtered by the supplied query parameters. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Order>> getAllOrdersForAccountWithHttpInfo(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag) throws ApiException {
        okhttp3.Call localVarCall = getAllOrdersForAccountValidateBeforeCall(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a List of Orders (asynchronously)
     * Retrieves a list of orders for the account, filtered by the supplied query parameters.  Endpoint defaults to open orders if no parameters are provided.
     * @param accountId Account identifier. (required)
     * @param status Order status to be queried. open, closed or all. Defaults to open. (optional)
     * @param limit The maximum number of orders in response. Defaults to 50 and max is 500. (optional)
     * @param after The response will include only ones submitted after this timestamp (exclusive.) (optional)
     * @param until The response will include only ones submitted until this timestamp (exclusive.) (optional)
     * @param direction The chronological order of response based on the submission time. asc or desc. Defaults to desc. (optional)
     * @param nested If true, the result will roll up multi-leg orders under the legs field of primary order. (optional)
     * @param symbols A comma-separated list of symbols to filter by. (optional)
     * @param qtyAbove  (optional)
     * @param qtyBelow  (optional)
     * @param subtag  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Retrieves a list of orders for the account, filtered by the supplied query parameters. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getAllOrdersForAccountAsync(UUID accountId, String status, Integer limit, OffsetDateTime after, OffsetDateTime until, String direction, Boolean nested, String symbols, String qtyAbove, String qtyBelow, String subtag, final ApiCallback<List<Order>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllOrdersForAccountValidateBeforeCall(accountId, status, limit, after, until, direction, nested, symbols, qtyAbove, qtyBelow, subtag, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOrderForAccount
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Order object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOrderForAccountCall(UUID accountId, String orderId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/{order_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "order_id" + "}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOrderForAccountValidateBeforeCall(UUID accountId, String orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getOrderForAccount(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrderForAccount(Async)");
        }

        return getOrderForAccountCall(accountId, orderId, _callback);

    }

    /**
     * Retrieve an Order by its ID
     * Retrieves a single order for the given order_id.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Order object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public Order getOrderForAccount(UUID accountId, String orderId) throws ApiException {
        ApiResponse<Order> localVarResp = getOrderForAccountWithHttpInfo(accountId, orderId);
        return localVarResp.getData();
    }

    /**
     * Retrieve an Order by its ID
     * Retrieves a single order for the given order_id.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Order object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> getOrderForAccountWithHttpInfo(UUID accountId, String orderId) throws ApiException {
        okhttp3.Call localVarCall = getOrderForAccountValidateBeforeCall(accountId, orderId, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve an Order by its ID (asynchronously)
     * Retrieves a single order for the given order_id.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Order object </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getOrderForAccountAsync(UUID accountId, String orderId, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOrderForAccountValidateBeforeCall(accountId, orderId, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPositionsForAccount
     * @param accountId Account identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getPositionsForAccountCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/positions"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPositionsForAccountValidateBeforeCall(UUID accountId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getPositionsForAccount(Async)");
        }

        return getPositionsForAccountCall(accountId, _callback);

    }

    /**
     * List Open Positions for an Account
     * List open positions for an account
     * @param accountId Account identifier. (required)
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> getPositionsForAccount(UUID accountId) throws ApiException {
        ApiResponse<List<Position>> localVarResp = getPositionsForAccountWithHttpInfo(accountId);
        return localVarResp.getData();
    }

    /**
     * List Open Positions for an Account
     * List open positions for an account
     * @param accountId Account identifier. (required)
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Position>> getPositionsForAccountWithHttpInfo(UUID accountId) throws ApiException {
        okhttp3.Call localVarCall = getPositionsForAccountValidateBeforeCall(accountId, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Open Positions for an Account (asynchronously)
     * List open positions for an account
     * @param accountId Account identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getPositionsForAccountAsync(UUID accountId, final ApiCallback<List<Position>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPositionsForAccountValidateBeforeCall(accountId, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPositionsForAccountBySymbol
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Position object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account doesn&#39;t have a position for this symbol or asset_id  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getPositionsForAccountBySymbolCall(UUID accountId, String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/positions/{symbol_or_asset_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "symbol_or_asset_id" + "}", localVarApiClient.escapeString(symbolOrAssetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPositionsForAccountBySymbolValidateBeforeCall(UUID accountId, String symbolOrAssetId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getPositionsForAccountBySymbol(Async)");
        }

        // verify the required parameter 'symbolOrAssetId' is set
        if (symbolOrAssetId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrAssetId' when calling getPositionsForAccountBySymbol(Async)");
        }

        return getPositionsForAccountBySymbolCall(accountId, symbolOrAssetId, _callback);

    }

    /**
     * Get an Open Position for account by Symbol or AssetId
     * Retrieves the account’s open position for the given symbol or asset_id.
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @return Position
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Position object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account doesn&#39;t have a position for this symbol or asset_id  </td><td>  -  </td></tr>
     </table>
     */
    public Position getPositionsForAccountBySymbol(UUID accountId, String symbolOrAssetId) throws ApiException {
        ApiResponse<Position> localVarResp = getPositionsForAccountBySymbolWithHttpInfo(accountId, symbolOrAssetId);
        return localVarResp.getData();
    }

    /**
     * Get an Open Position for account by Symbol or AssetId
     * Retrieves the account’s open position for the given symbol or asset_id.
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @return ApiResponse&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Position object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account doesn&#39;t have a position for this symbol or asset_id  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Position> getPositionsForAccountBySymbolWithHttpInfo(UUID accountId, String symbolOrAssetId) throws ApiException {
        okhttp3.Call localVarCall = getPositionsForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an Open Position for account by Symbol or AssetId (asynchronously)
     * Retrieves the account’s open position for the given symbol or asset_id.
     * @param accountId Account identifier. (required)
     * @param symbolOrAssetId The symbol or asset_id  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The requested Position object </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Account doesn&#39;t have a position for this symbol or asset_id  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getPositionsForAccountBySymbolAsync(UUID accountId, String symbolOrAssetId, final ApiCallback<Position> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPositionsForAccountBySymbolValidateBeforeCall(accountId, symbolOrAssetId, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1AccountsPositions
     * @param page The number of the page of the results to be fetched. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains two fields:  asof: the timestamp for which the positions are returned. It is always the last market close  positions: an account-id to position list map, contains the requested page’s accounts The positions map is empty for the last page.  Note: when fetching bulk positions, which can take multiple minutes depending on the number of accounts managed have, a market close can happen, and after that a new set of results might be returned. To make sure results are consistent, please always check that the as_of field didn’t change during the whole fetching process. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsPositionsCall(Integer page, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/accounts/positions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1AccountsPositionsValidateBeforeCall(Integer page, final ApiCallback _callback) throws ApiException {
        return getV1AccountsPositionsCall(page, _callback);

    }

    /**
     * Bulk Fetch All Accounts Positions
     * Retrieves a list of the account’s open positions.
     * @param page The number of the page of the results to be fetched. (optional)
     * @return GetV1AccountsPositions200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains two fields:  asof: the timestamp for which the positions are returned. It is always the last market close  positions: an account-id to position list map, contains the requested page’s accounts The positions map is empty for the last page.  Note: when fetching bulk positions, which can take multiple minutes depending on the number of accounts managed have, a market close can happen, and after that a new set of results might be returned. To make sure results are consistent, please always check that the as_of field didn’t change during the whole fetching process. </td><td>  -  </td></tr>
     </table>
     */
    public GetV1AccountsPositions200Response getV1AccountsPositions(Integer page) throws ApiException {
        ApiResponse<GetV1AccountsPositions200Response> localVarResp = getV1AccountsPositionsWithHttpInfo(page);
        return localVarResp.getData();
    }

    /**
     * Bulk Fetch All Accounts Positions
     * Retrieves a list of the account’s open positions.
     * @param page The number of the page of the results to be fetched. (optional)
     * @return ApiResponse&lt;GetV1AccountsPositions200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains two fields:  asof: the timestamp for which the positions are returned. It is always the last market close  positions: an account-id to position list map, contains the requested page’s accounts The positions map is empty for the last page.  Note: when fetching bulk positions, which can take multiple minutes depending on the number of accounts managed have, a market close can happen, and after that a new set of results might be returned. To make sure results are consistent, please always check that the as_of field didn’t change during the whole fetching process. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetV1AccountsPositions200Response> getV1AccountsPositionsWithHttpInfo(Integer page) throws ApiException {
        okhttp3.Call localVarCall = getV1AccountsPositionsValidateBeforeCall(page, null);
        Type localVarReturnType = new TypeToken<GetV1AccountsPositions200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Bulk Fetch All Accounts Positions (asynchronously)
     * Retrieves a list of the account’s open positions.
     * @param page The number of the page of the results to be fetched. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response contains two fields:  asof: the timestamp for which the positions are returned. It is always the last market close  positions: an account-id to position list map, contains the requested page’s accounts The positions map is empty for the last page.  Note: when fetching bulk positions, which can take multiple minutes depending on the number of accounts managed have, a market close can happen, and after that a new set of results might be returned. To make sure results are consistent, please always check that the as_of field didn’t change during the whole fetching process. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1AccountsPositionsAsync(Integer page, final ApiCallback<GetV1AccountsPositions200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1AccountsPositionsValidateBeforeCall(page, _callback);
        Type localVarReturnType = new TypeToken<GetV1AccountsPositions200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1TradingAccountsAccountIdAccountPortfolioHistory
     * @param accountId  (required)
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous** **(v2 only)**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset **(v2 only)** &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @param forceEngineVersion &#x60;force_engine_version&#x60; can be used to override which version of Portfolio History is used on a per-request basis.  Using this flag the transition to V2 engine can be governed by the broker partner.  **default value**: the engine version defaults to the engine version set by Alpaca for the correspondent.   All Portfolio History responses contain the &#x60;X-Portfolio-History-Engine-Version&#x60; header which will indicate what engine version was used to serve the request. This can be either &#x60;v1&#x60; or &#x60;v2&#x60;.  This flag is only provided for the duration of &#x60;v1&#x60; to &#x60;v2&#x60; migration, afterwards it will be accepted, but won&#39;t have any effect on the query.  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TradingAccountsAccountIdAccountPortfolioHistoryCall(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/account/portfolio/history"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (period != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("period", period));
        }

        if (timeframe != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("timeframe", timeframe));
        }

        if (intradayReporting != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("intraday_reporting", intradayReporting));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (pnlReset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pnl_reset", pnlReset));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (dateEnd != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date_end", dateEnd));
        }

        if (extendedHours != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("extended_hours", extendedHours));
        }

        if (forceEngineVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force_engine_version", forceEngineVersion));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1TradingAccountsAccountIdAccountPortfolioHistoryValidateBeforeCall(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1TradingAccountsAccountIdAccountPortfolioHistory(Async)");
        }

        return getV1TradingAccountsAccountIdAccountPortfolioHistoryCall(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion, _callback);

    }

    /**
     * Get Account Portfolio History
     * Returns timeseries data about equity and profit/loss (P/L) of the account in requested timespan.
     * @param accountId  (required)
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous** **(v2 only)**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset **(v2 only)** &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @param forceEngineVersion &#x60;force_engine_version&#x60; can be used to override which version of Portfolio History is used on a per-request basis.  Using this flag the transition to V2 engine can be governed by the broker partner.  **default value**: the engine version defaults to the engine version set by Alpaca for the correspondent.   All Portfolio History responses contain the &#x60;X-Portfolio-History-Engine-Version&#x60; header which will indicate what engine version was used to serve the request. This can be either &#x60;v1&#x60; or &#x60;v2&#x60;.  This flag is only provided for the duration of &#x60;v1&#x60; to &#x60;v2&#x60; migration, afterwards it will be accepted, but won&#39;t have any effect on the query.  (optional)
     * @return PortfolioHistory
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    public PortfolioHistory getV1TradingAccountsAccountIdAccountPortfolioHistory(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion) throws ApiException {
        ApiResponse<PortfolioHistory> localVarResp = getV1TradingAccountsAccountIdAccountPortfolioHistoryWithHttpInfo(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion);
        return localVarResp.getData();
    }

    /**
     * Get Account Portfolio History
     * Returns timeseries data about equity and profit/loss (P/L) of the account in requested timespan.
     * @param accountId  (required)
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous** **(v2 only)**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset **(v2 only)** &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @param forceEngineVersion &#x60;force_engine_version&#x60; can be used to override which version of Portfolio History is used on a per-request basis.  Using this flag the transition to V2 engine can be governed by the broker partner.  **default value**: the engine version defaults to the engine version set by Alpaca for the correspondent.   All Portfolio History responses contain the &#x60;X-Portfolio-History-Engine-Version&#x60; header which will indicate what engine version was used to serve the request. This can be either &#x60;v1&#x60; or &#x60;v2&#x60;.  This flag is only provided for the duration of &#x60;v1&#x60; to &#x60;v2&#x60; migration, afterwards it will be accepted, but won&#39;t have any effect on the query.  (optional)
     * @return ApiResponse&lt;PortfolioHistory&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<PortfolioHistory> getV1TradingAccountsAccountIdAccountPortfolioHistoryWithHttpInfo(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion) throws ApiException {
        okhttp3.Call localVarCall = getV1TradingAccountsAccountIdAccountPortfolioHistoryValidateBeforeCall(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion, null);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Account Portfolio History (asynchronously)
     * Returns timeseries data about equity and profit/loss (P/L) of the account in requested timespan.
     * @param accountId  (required)
     * @param period The duration of the data in &#x60;number&#x60; + &#x60;unit&#x60; format, such as 1D, where &#x60;unit&#x60; can be D for day, W for week, M for month and A for year. Defaults to 1M.  Only two of &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; can be specified at the same time.  For intraday timeframes (\\&lt;1D) only 30 days or less can be queried, for 1D resolutions there is no such limit, data is available since the creation of the account.  (optional)
     * @param timeframe The resolution of time window. 1Min, 5Min, 15Min, 1H, or 1D. If omitted, 1Min for less than 7 days period, 15Min for less than 30 days, or otherwise 1D.  For queries with longer than 30 days of &#x60;period&#x60;, the system only accepts 1D as &#x60;timeframe&#x60;.  (optional)
     * @param intradayReporting This is effective only for &#x60;timeframe&#x60; less than 1D. 1D resolutions always return the pices only on the end of trading days.  Allowed values are: - **market_hours**    Only timestamps for the core requity trading hours are returned (usually 9:30am to 4:00pm, trading days only)  - **extended_hours**    Returns timestamps for the whole session including extended hours (usually 4:00am to 8:00pm, trading days only)  - **continuous** **(v2 only)**    Returns price data points 24/7 (for off-session times too). To calculate the equity values we are using the following prices:    Between 4:00am and 10:00pm on trading days the valuation will be calculated based on the last trade (extended hours and normal hours respectively).     After 10:00pm, until the next session open the equities will be valued at their official closing price on the primary exchange.  (optional, default to market_hours)
     * @param start The timestamp the data is returned starting from in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T03:30:00-04:00&#x60;, then the first data point returned will be &#x60;2023-10-19T04:00:00-04:00&#x60; due to the session opening at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the &#x60;period&#x60; will be used to calculate the starting time.  (optional)
     * @param pnlReset **(v2 only)** &#x60;pnl_reset&#x60; defines how we are calculating the baseline values for Profit And Loss (pnl) for queries with &#x60;timeframe&#x60; less than 1D.  The default behavior is that we reset the pnl value to the previous day&#39;s closing equity for each **trading** day.  In case of crypto (given it&#39;s continous nature), this might not be desired: specifying \&quot;no_reset\&quot; disables this behavior and all pnl values returned will be relative to the closing equity of the previous trading day.  (optional, default to per_day)
     * @param end The timestamp the data is returned up to in RFC3339 format (including timezone specification).  For &#x60;timeframes&#x60; less than 1D, the actual start will be determined based on the value of the &#x60;intraday_reporting&#x60; query parameter:  For example if the &#x60;intraday_reporting&#x60; is &#x60;extended_hours&#x60;, and the timestamp specified is &#x60;2023-10-19T21:33:00-04:00&#x60;, then the last data point returned will be &#x60;2023-10-19T20:00:00-04:00&#x60; due to the session closing at that time.  &#x60;start&#x60;, &#x60;end&#x60; (or &#x60;date_end&#x60;) and &#x60;period&#x60; cannot be specified at the same time.  If unset, the current time is considered the &#x60;end&#x60;&#39;s default value.  (optional)
     * @param dateEnd **deprecated**: please use the end query parameter instead for **better control of the time zone**.  The date the data is returned up to, in “YYYY-MM-DD” format. Defaults to the current market date (rolls over at the market open if  &#x60;extended_hours&#x60; is false, otherwise at 7am ET)  In continous mode, the returned data is starting from midnight the given day in ET.  (optional)
     * @param extendedHours **deprecated**: Users are strongly advised to **rely on the &#x60;intraday_reporting&#x60; query parameter** for better control  of the reporting range.  If true, include extended hours in the result. This is effective only for timeframe less than 1D.  (optional)
     * @param forceEngineVersion &#x60;force_engine_version&#x60; can be used to override which version of Portfolio History is used on a per-request basis.  Using this flag the transition to V2 engine can be governed by the broker partner.  **default value**: the engine version defaults to the engine version set by Alpaca for the correspondent.   All Portfolio History responses contain the &#x60;X-Portfolio-History-Engine-Version&#x60; header which will indicate what engine version was used to serve the request. This can be either &#x60;v1&#x60; or &#x60;v2&#x60;.  This flag is only provided for the duration of &#x60;v1&#x60; to &#x60;v2&#x60; migration, afterwards it will be accepted, but won&#39;t have any effect on the query.  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TradingAccountsAccountIdAccountPortfolioHistoryAsync(String accountId, String period, String timeframe, String intradayReporting, OffsetDateTime start, String pnlReset, OffsetDateTime end, LocalDate dateEnd, String extendedHours, String forceEngineVersion, final ApiCallback<PortfolioHistory> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1TradingAccountsAccountIdAccountPortfolioHistoryValidateBeforeCall(accountId, period, timeframe, intradayReporting, start, pnlReset, end, dateEnd, extendedHours, forceEngineVersion, _callback);
        Type localVarReturnType = new TypeToken<PortfolioHistory>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1TradingAccountsAccountIdOrdersEstimation
     * @param accountId  (required)
     * @param getV1TradingAccountsAccountIdOrdersEstimationRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TradingAccountsAccountIdOrdersEstimationCall(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = getV1TradingAccountsAccountIdOrdersEstimationRequest;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/estimation"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1TradingAccountsAccountIdOrdersEstimationValidateBeforeCall(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getV1TradingAccountsAccountIdOrdersEstimation(Async)");
        }

        return getV1TradingAccountsAccountIdOrdersEstimationCall(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest, _callback);

    }

    /**
     * Estimate an Order
     * Order estimation endpoint will display, based on user’s account balance, the estimated quantity and price they will receive for their notional order.  For LCT - customer’s order will include the Alpaca swap_fee, while correspondent side swap_fee is configurable in the API call. Utilising this API does not result in a real order and after the calculation - the user’s buying power reverts to the previous state.  Responses and Errors are the same as with the Orders API  Please note that the estimation is based on the market condition at the time of submission and a live order will differ. The output should be considered indicative.  **Note:** This does not support Crypto or non-market orders at this time.
     * @param accountId  (required)
     * @param getV1TradingAccountsAccountIdOrdersEstimationRequest  (optional)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Order getV1TradingAccountsAccountIdOrdersEstimation(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest) throws ApiException {
        ApiResponse<Order> localVarResp = getV1TradingAccountsAccountIdOrdersEstimationWithHttpInfo(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest);
        return localVarResp.getData();
    }

    /**
     * Estimate an Order
     * Order estimation endpoint will display, based on user’s account balance, the estimated quantity and price they will receive for their notional order.  For LCT - customer’s order will include the Alpaca swap_fee, while correspondent side swap_fee is configurable in the API call. Utilising this API does not result in a real order and after the calculation - the user’s buying power reverts to the previous state.  Responses and Errors are the same as with the Orders API  Please note that the estimation is based on the market condition at the time of submission and a live order will differ. The output should be considered indicative.  **Note:** This does not support Crypto or non-market orders at this time.
     * @param accountId  (required)
     * @param getV1TradingAccountsAccountIdOrdersEstimationRequest  (optional)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> getV1TradingAccountsAccountIdOrdersEstimationWithHttpInfo(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest) throws ApiException {
        okhttp3.Call localVarCall = getV1TradingAccountsAccountIdOrdersEstimationValidateBeforeCall(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Estimate an Order (asynchronously)
     * Order estimation endpoint will display, based on user’s account balance, the estimated quantity and price they will receive for their notional order.  For LCT - customer’s order will include the Alpaca swap_fee, while correspondent side swap_fee is configurable in the API call. Utilising this API does not result in a real order and after the calculation - the user’s buying power reverts to the previous state.  Responses and Errors are the same as with the Orders API  Please note that the estimation is based on the market condition at the time of submission and a live order will differ. The output should be considered indicative.  **Note:** This does not support Crypto or non-market orders at this time.
     * @param accountId  (required)
     * @param getV1TradingAccountsAccountIdOrdersEstimationRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1TradingAccountsAccountIdOrdersEstimationAsync(String accountId, GetV1TradingAccountsAccountIdOrdersEstimationRequest getV1TradingAccountsAccountIdOrdersEstimationRequest, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1TradingAccountsAccountIdOrdersEstimationValidateBeforeCall(accountId, getV1TradingAccountsAccountIdOrdersEstimationRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for optionExercise
     * @param accountId Account identifier. (required)
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call optionExerciseCall(UUID accountId, UUID symbolOrContractId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/positions/{symbol_or_contract_id}/exercise"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "symbol_or_contract_id" + "}", localVarApiClient.escapeString(symbolOrContractId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call optionExerciseValidateBeforeCall(UUID accountId, UUID symbolOrContractId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling optionExercise(Async)");
        }

        // verify the required parameter 'symbolOrContractId' is set
        if (symbolOrContractId == null) {
            throw new ApiException("Missing the required parameter 'symbolOrContractId' when calling optionExercise(Async)");
        }

        return optionExerciseCall(accountId, symbolOrContractId, _callback);

    }

    /**
     * Exercise an Options Position (BETA)
     * This endpoint enables users to exercise a held option contract, converting it into the underlying asset based on the specified terms. All available held shares of this option contract will be exercised.  By default, Alpaca will automatically exercise in-the-money (ITM) contracts at expiry. Exercise requests will be processed immediately once received. Exercise requests submitted outside market hours will be rejected. To cancel an exercise request or to submit a Do-not-exercise (DNE) instruction, please contact our support team.
     * @param accountId Account identifier. (required)
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
     </table>
     */
    public void optionExercise(UUID accountId, UUID symbolOrContractId) throws ApiException {
        optionExerciseWithHttpInfo(accountId, symbolOrContractId);
    }

    /**
     * Exercise an Options Position (BETA)
     * This endpoint enables users to exercise a held option contract, converting it into the underlying asset based on the specified terms. All available held shares of this option contract will be exercised.  By default, Alpaca will automatically exercise in-the-money (ITM) contracts at expiry. Exercise requests will be processed immediately once received. Exercise requests submitted outside market hours will be rejected. To cancel an exercise request or to submit a Do-not-exercise (DNE) instruction, please contact our support team.
     * @param accountId Account identifier. (required)
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> optionExerciseWithHttpInfo(UUID accountId, UUID symbolOrContractId) throws ApiException {
        okhttp3.Call localVarCall = optionExerciseValidateBeforeCall(accountId, symbolOrContractId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Exercise an Options Position (BETA) (asynchronously)
     * This endpoint enables users to exercise a held option contract, converting it into the underlying asset based on the specified terms. All available held shares of this option contract will be exercised.  By default, Alpaca will automatically exercise in-the-money (ITM) contracts at expiry. Exercise requests will be processed immediately once received. Exercise requests submitted outside market hours will be rejected. To cancel an exercise request or to submit a Do-not-exercise (DNE) instruction, please contact our support team.
     * @param accountId Account identifier. (required)
     * @param symbolOrContractId Option contract symbol or ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful Response  Exercise instruction successfully submitted. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden  Available position quantity is not sufficient. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call optionExerciseAsync(UUID accountId, UUID symbolOrContractId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = optionExerciseValidateBeforeCall(accountId, symbolOrContractId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for patchPATCHV1TradingAccountsAccountIdAccountConfigurations
     * @param accountId  (required)
     * @param accountConfigurations  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Response will contain the account configuration settings for the account. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchPATCHV1TradingAccountsAccountIdAccountConfigurationsCall(String accountId, AccountConfigurations accountConfigurations, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = accountConfigurations;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/account/configurations"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchPATCHV1TradingAccountsAccountIdAccountConfigurationsValidateBeforeCall(String accountId, AccountConfigurations accountConfigurations, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling patchPATCHV1TradingAccountsAccountIdAccountConfigurations(Async)");
        }

        return patchPATCHV1TradingAccountsAccountIdAccountConfigurationsCall(accountId, accountConfigurations, _callback);

    }

    /**
     * Update Trading Configurations for an Account
     * You can also set the margin settings for your users’ account by passing a PATCH request. By default any account with funds under $2,000 is set a margin multiplier of 1.0, and accounts with over $2,000 are set to 2.0.
     * @param accountId  (required)
     * @param accountConfigurations  (optional)
     * @return AccountConfigurations
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Response will contain the account configuration settings for the account. </td><td>  -  </td></tr>
     </table>
     */
    public AccountConfigurations patchPATCHV1TradingAccountsAccountIdAccountConfigurations(String accountId, AccountConfigurations accountConfigurations) throws ApiException {
        ApiResponse<AccountConfigurations> localVarResp = patchPATCHV1TradingAccountsAccountIdAccountConfigurationsWithHttpInfo(accountId, accountConfigurations);
        return localVarResp.getData();
    }

    /**
     * Update Trading Configurations for an Account
     * You can also set the margin settings for your users’ account by passing a PATCH request. By default any account with funds under $2,000 is set a margin multiplier of 1.0, and accounts with over $2,000 are set to 2.0.
     * @param accountId  (required)
     * @param accountConfigurations  (optional)
     * @return ApiResponse&lt;AccountConfigurations&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Response will contain the account configuration settings for the account. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<AccountConfigurations> patchPATCHV1TradingAccountsAccountIdAccountConfigurationsWithHttpInfo(String accountId, AccountConfigurations accountConfigurations) throws ApiException {
        okhttp3.Call localVarCall = patchPATCHV1TradingAccountsAccountIdAccountConfigurationsValidateBeforeCall(accountId, accountConfigurations, null);
        Type localVarReturnType = new TypeToken<AccountConfigurations>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Trading Configurations for an Account (asynchronously)
     * You can also set the margin settings for your users’ account by passing a PATCH request. By default any account with funds under $2,000 is set a margin multiplier of 1.0, and accounts with over $2,000 are set to 2.0.
     * @param accountId  (required)
     * @param accountConfigurations  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Response will contain the account configuration settings for the account. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchPATCHV1TradingAccountsAccountIdAccountConfigurationsAsync(String accountId, AccountConfigurations accountConfigurations, final ApiCallback<AccountConfigurations> _callback) throws ApiException {

        okhttp3.Call localVarCall = patchPATCHV1TradingAccountsAccountIdAccountConfigurationsValidateBeforeCall(accountId, accountConfigurations, _callback);
        Type localVarReturnType = new TypeToken<AccountConfigurations>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for replaceOrderForAccount
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param updateOrderRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A new Order object with a new order_id </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Buying power or shares are not sufficient </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call replaceOrderForAccountCall(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateOrderRequest;

        // create path and map variables
        String localVarPath = "/v1/trading/accounts/{account_id}/orders/{order_id}"
            .replace("{" + "account_id" + "}", localVarApiClient.escapeString(accountId.toString()))
            .replace("{" + "order_id" + "}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call replaceOrderForAccountValidateBeforeCall(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling replaceOrderForAccount(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling replaceOrderForAccount(Async)");
        }

        // verify the required parameter 'updateOrderRequest' is set
        if (updateOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'updateOrderRequest' when calling replaceOrderForAccount(Async)");
        }

        return replaceOrderForAccountCall(accountId, orderId, updateOrderRequest, _callback);

    }

    /**
     * Replace an Order
     * Replaces a single order with updated parameters. Each parameter overrides the corresponding attribute of the existing order. The other attributes remain the same as the existing order.  A success return code from a replaced order does NOT guarantee the existing open order has been replaced. If the existing open order is filled before the replacing (new) order reaches the execution venue, the replacing (new) order is rejected, and these events are sent in the trade_updates stream channel found [here in the market data api](https://alpaca.markets/docs/api-references/market-data-api/#order-updates).  While an order is being replaced, the account&#39;s buying power is reduced by the larger of the two orders that have been placed (the old order being replaced, and the newly placed order to replace it). If you are replacing a buy entry order with a higher limit price than the original order, the buying power is calculated based on the newly placed order. If you are replacing it with a lower limit price, the buying power is calculated based on the old order.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param updateOrderRequest  (required)
     * @return Order
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A new Order object with a new order_id </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Buying power or shares are not sufficient </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public Order replaceOrderForAccount(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest) throws ApiException {
        ApiResponse<Order> localVarResp = replaceOrderForAccountWithHttpInfo(accountId, orderId, updateOrderRequest);
        return localVarResp.getData();
    }

    /**
     * Replace an Order
     * Replaces a single order with updated parameters. Each parameter overrides the corresponding attribute of the existing order. The other attributes remain the same as the existing order.  A success return code from a replaced order does NOT guarantee the existing open order has been replaced. If the existing open order is filled before the replacing (new) order reaches the execution venue, the replacing (new) order is rejected, and these events are sent in the trade_updates stream channel found [here in the market data api](https://alpaca.markets/docs/api-references/market-data-api/#order-updates).  While an order is being replaced, the account&#39;s buying power is reduced by the larger of the two orders that have been placed (the old order being replaced, and the newly placed order to replace it). If you are replacing a buy entry order with a higher limit price than the original order, the buying power is calculated based on the newly placed order. If you are replacing it with a lower limit price, the buying power is calculated based on the old order.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param updateOrderRequest  (required)
     * @return ApiResponse&lt;Order&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A new Order object with a new order_id </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Buying power or shares are not sufficient </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Order> replaceOrderForAccountWithHttpInfo(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest) throws ApiException {
        okhttp3.Call localVarCall = replaceOrderForAccountValidateBeforeCall(accountId, orderId, updateOrderRequest, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Replace an Order (asynchronously)
     * Replaces a single order with updated parameters. Each parameter overrides the corresponding attribute of the existing order. The other attributes remain the same as the existing order.  A success return code from a replaced order does NOT guarantee the existing open order has been replaced. If the existing open order is filled before the replacing (new) order reaches the execution venue, the replacing (new) order is rejected, and these events are sent in the trade_updates stream channel found [here in the market data api](https://alpaca.markets/docs/api-references/market-data-api/#order-updates).  While an order is being replaced, the account&#39;s buying power is reduced by the larger of the two orders that have been placed (the old order being replaced, and the newly placed order to replace it). If you are replacing a buy entry order with a higher limit price than the original order, the buying power is calculated based on the newly placed order. If you are replacing it with a lower limit price, the buying power is calculated based on the old order.
     * @param accountId Account identifier. (required)
     * @param orderId Order identifier. (required)
     * @param updateOrderRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A new Order object with a new order_id </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Malformed input. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Buying power or shares are not sufficient </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call replaceOrderForAccountAsync(UUID accountId, String orderId, UpdateOrderRequest updateOrderRequest, final ApiCallback<Order> _callback) throws ApiException {

        okhttp3.Call localVarCall = replaceOrderForAccountValidateBeforeCall(accountId, orderId, updateOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for subscribeToTradeV2SSE
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call subscribeToTradeV2SSECall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2beta1/events/trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (sinceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since_id", sinceId));
        }

        if (untilId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until_id", untilId));
        }

        final String[] localVarAccepts = {
            "text/event-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call subscribeToTradeV2SSEValidateBeforeCall(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback _callback) throws ApiException {
        return subscribeToTradeV2SSECall(since, until, sinceId, untilId, _callback);

    }

    /**
     * Subscribe to Trade Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Legacy trade events API**  The legacy trade events API is available for compatibility reasons at:  &#x60;GET /v1/events/trades&#x60;  Broker partners are recommended to upgrade to the /v2beta1/events/trades endpoint, which provides faster event delivery times.  The legacy trade events api works the same way as the new one with the exception of the event_id which is an integer except of an ULID. This results in the request’s since_id and until_id are also being integers. This integer is monotonically increasing over time for events.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected.   - timestamp: The time at which the rejection occurred. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @return List&lt;TradeUpdateEventV2&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    public List<TradeUpdateEventV2> subscribeToTradeV2SSE(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        ApiResponse<List<TradeUpdateEventV2>> localVarResp = subscribeToTradeV2SSEWithHttpInfo(since, until, sinceId, untilId);
        return localVarResp.getData();
    }

    /**
     * Subscribe to Trade Events (SSE)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Legacy trade events API**  The legacy trade events API is available for compatibility reasons at:  &#x60;GET /v1/events/trades&#x60;  Broker partners are recommended to upgrade to the /v2beta1/events/trades endpoint, which provides faster event delivery times.  The legacy trade events api works the same way as the new one with the exception of the event_id which is an integer except of an ULID. This results in the request’s since_id and until_id are also being integers. This integer is monotonically increasing over time for events.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected.   - timestamp: The time at which the rejection occurred. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @return ApiResponse&lt;List&lt;TradeUpdateEventV2&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<TradeUpdateEventV2>> subscribeToTradeV2SSEWithHttpInfo(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId) throws ApiException {
        okhttp3.Call localVarCall = subscribeToTradeV2SSEValidateBeforeCall(since, until, sinceId, untilId, null);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEventV2>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Subscribe to Trade Events (SSE) (asynchronously)
     * The Events API provides event push as well as historical queries via SSE (server sent events).  You can listen to events related to trade updates. Most market trades sent during market hours are filled instantly; you can listen to limit order updates through this endpoint.  Historical events are streamed immediately if queried, and updates are pushed as events occur.  Query Params Rules: - &#x60;since&#x60; required if &#x60;until&#x60; specified - &#x60;since_id&#x60; required if &#x60;until_id&#x60; specified - &#x60;since&#x60; and &#x60;since_id&#x60; can’t be used at the same time Behavior: - if &#x60;since&#x60; or &#x60;since_id&#x60; not specified this will not return any historic data - if &#x60;until&#x60; or &#x60;until_id&#x60; reached stream will end (status 200)  ---  Note for people using the clients generated from this OAS spec. Currently OAS-3 doesn&#39;t have full support for representing SSE style responses from an API, so if you are using a generated client and don&#39;t specify a &#x60;since&#x60; and &#x60;until&#x60; there is a good chance the generated clients will hang waiting for the response to end.  If you require the streaming capabilities we recommend not using the generated clients for this specific usecase until the OAS-3 standards come to a consensus on how to represent this correcting in OAS-3.  ---  **Legacy trade events API**  The legacy trade events API is available for compatibility reasons at:  &#x60;GET /v1/events/trades&#x60;  Broker partners are recommended to upgrade to the /v2beta1/events/trades endpoint, which provides faster event delivery times.  The legacy trade events api works the same way as the new one with the exception of the event_id which is an integer except of an ULID. This results in the request’s since_id and until_id are also being integers. This integer is monotonically increasing over time for events.  ---  **Common events**  These are the events that are the expected results of actions you may have taken by sending API requests.  The meaning of the timestamp field changes for each type; the meanings have been specified here for which types the timestamp field will be present.  - &#x60;accepted&#x60; Sent when an order recieved and accepted by Alpaca - &#x60;pending_new&#x60; Sent when the order has been received by Alpaca and routed to the exchanges, but has not yet been accepted for execution. - &#x60;new&#x60; Sent when an order has been routed to exchanges for execution. - &#x60;fill&#x60; Sent when your order has been completely filled.   - timestamp: The time at which the order was filled. - &#x60;partial_fill&#x60; Sent when a number of shares less than the total remaining quantity on your order has been filled.   - timestamp: The time at which the shares were filled. - &#x60;canceled&#x60; Sent when your requested cancellation of an order is processed.   - timestamp: The time at which the order was canceled. - &#x60;expired&#x60; Sent when an order has reached the end of its lifespan, as determined by the order&#39;s time in force value.   - timestamp: The time at which the order expired. - &#x60;done_for_day&#x60; Sent when the order is done executing for the day, and will not receive further updates until the next trading day. - &#x60;replaced&#x60; Sent when your requested replacement of an order is processed.   - timestamp: The time at which the order was replaced.  **Rarer events**  These are events that may rarely be sent due to unexpected circumstances on the exchanges. It is unlikely you will need to design your code around them, but you may still wish to account for the possibility that they will occur.  - &#x60;rejected&#x60; Sent when your order has been rejected.   - timestamp: The time at which the rejection occurred. - &#x60;held&#x60; For multi-leg orders, the secondary orders (stop loss, take profit) will enter this state while waiting to be triggered. - &#x60;stopped&#x60; Sent when your order has been stopped, and a trade is guaranteed for the order, usually at a stated price or better, but has not yet occurred. - &#x60;pending_cancel&#x60; Sent when the order is awaiting cancellation. Most cancellations will occur without the order entering this state. - &#x60;pending_replace&#x60; Sent when the order is awaiting replacement. - &#x60;calculated&#x60; Sent when the order has been completed for the day - it is either filled or done_for_day - but remaining settlement calculations are still pending. - &#x60;suspended&#x60; Sent when the order has been suspended and is not eligible for trading. - &#x60;order_replace_rejected&#x60; Sent when the order replace has been rejected. - &#x60;order_cancel_rejected&#x60; Sent when the order cancel has been rejected.
     * @param since Format: YYYY-MM-DD (optional)
     * @param until Format: YYYY-MM-DD (optional)
     * @param sinceId  (optional)
     * @param untilId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Connected. Events will now start streaming as long as you keep the connection open. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call subscribeToTradeV2SSEAsync(OffsetDateTime since, OffsetDateTime until, String sinceId, String untilId, final ApiCallback<List<TradeUpdateEventV2>> _callback) throws ApiException {

        okhttp3.Call localVarCall = subscribeToTradeV2SSEValidateBeforeCall(since, until, sinceId, untilId, _callback);
        Type localVarReturnType = new TypeToken<List<TradeUpdateEventV2>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
