/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.AggregatePositionResponse;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1ReportingEodPositions200Response;
import net.jacobpeterson.alpaca.openapi.broker.model.GetV1ReportingEodPositionsRequest;
import java.time.LocalDate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReportingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReportingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for getV1ReportingEodAggregatePositions
     * @param date “YYYY-MM-DD” format (required)
     * @param symbols Comma-separated symbols. If populated, then only the specified symbols will be returned. If null, then all symbols will be included in the response. (optional)
     * @param firmAccounts Defaults to True which includes firm accounts. Passing False will exclude all firm accounts. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of objects, each object pertains to the date specified in the request and a unique asset. See parameters below. Notes: Returns an empty array for non-trading days, assets with no positions are omitted. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1ReportingEodAggregatePositionsCall(LocalDate date, String symbols, String firmAccounts, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/reporting/eod/aggregate_positions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (date != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("date", date));
        }

        if (symbols != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbols", symbols));
        }

        if (firmAccounts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firm_accounts", firmAccounts));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1ReportingEodAggregatePositionsValidateBeforeCall(LocalDate date, String symbols, String firmAccounts, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'date' is set
        if (date == null) {
            throw new ApiException("Missing the required parameter 'date' when calling getV1ReportingEodAggregatePositions(Async)");
        }

        return getV1ReportingEodAggregatePositionsCall(date, symbols, firmAccounts, _callback);

    }

    /**
     * Retrieve Aggregate Positions
     * This API endpoint provides reporting data to partners for aggregate common stock and crypto positions across their account base. Partners can view historical snapshots of their holding across their entire account base. Please note that this API utilizes an 8:00 pm (EST) cutoff which aligns with the end of the Securities extended hours trading session as well as Alpaca’s 24 hour Crypto trading window. Additionally, the endpoint supports indexing to help the partner efficiently filter by key information including date and symbol while being able to include or remove firm accounts.
     * @param date “YYYY-MM-DD” format (required)
     * @param symbols Comma-separated symbols. If populated, then only the specified symbols will be returned. If null, then all symbols will be included in the response. (optional)
     * @param firmAccounts Defaults to True which includes firm accounts. Passing False will exclude all firm accounts. (optional)
     * @return List&lt;AggregatePositionResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of objects, each object pertains to the date specified in the request and a unique asset. See parameters below. Notes: Returns an empty array for non-trading days, assets with no positions are omitted. </td><td>  -  </td></tr>
     </table>
     */
    public List<AggregatePositionResponse> getV1ReportingEodAggregatePositions(LocalDate date, String symbols, String firmAccounts) throws ApiException {
        ApiResponse<List<AggregatePositionResponse>> localVarResp = getV1ReportingEodAggregatePositionsWithHttpInfo(date, symbols, firmAccounts);
        return localVarResp.getData();
    }

    /**
     * Retrieve Aggregate Positions
     * This API endpoint provides reporting data to partners for aggregate common stock and crypto positions across their account base. Partners can view historical snapshots of their holding across their entire account base. Please note that this API utilizes an 8:00 pm (EST) cutoff which aligns with the end of the Securities extended hours trading session as well as Alpaca’s 24 hour Crypto trading window. Additionally, the endpoint supports indexing to help the partner efficiently filter by key information including date and symbol while being able to include or remove firm accounts.
     * @param date “YYYY-MM-DD” format (required)
     * @param symbols Comma-separated symbols. If populated, then only the specified symbols will be returned. If null, then all symbols will be included in the response. (optional)
     * @param firmAccounts Defaults to True which includes firm accounts. Passing False will exclude all firm accounts. (optional)
     * @return ApiResponse&lt;List&lt;AggregatePositionResponse&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of objects, each object pertains to the date specified in the request and a unique asset. See parameters below. Notes: Returns an empty array for non-trading days, assets with no positions are omitted. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<AggregatePositionResponse>> getV1ReportingEodAggregatePositionsWithHttpInfo(LocalDate date, String symbols, String firmAccounts) throws ApiException {
        okhttp3.Call localVarCall = getV1ReportingEodAggregatePositionsValidateBeforeCall(date, symbols, firmAccounts, null);
        Type localVarReturnType = new TypeToken<List<AggregatePositionResponse>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve Aggregate Positions (asynchronously)
     * This API endpoint provides reporting data to partners for aggregate common stock and crypto positions across their account base. Partners can view historical snapshots of their holding across their entire account base. Please note that this API utilizes an 8:00 pm (EST) cutoff which aligns with the end of the Securities extended hours trading session as well as Alpaca’s 24 hour Crypto trading window. Additionally, the endpoint supports indexing to help the partner efficiently filter by key information including date and symbol while being able to include or remove firm accounts.
     * @param date “YYYY-MM-DD” format (required)
     * @param symbols Comma-separated symbols. If populated, then only the specified symbols will be returned. If null, then all symbols will be included in the response. (optional)
     * @param firmAccounts Defaults to True which includes firm accounts. Passing False will exclude all firm accounts. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of objects, each object pertains to the date specified in the request and a unique asset. See parameters below. Notes: Returns an empty array for non-trading days, assets with no positions are omitted. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1ReportingEodAggregatePositionsAsync(LocalDate date, String symbols, String firmAccounts, final ApiCallback<List<AggregatePositionResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1ReportingEodAggregatePositionsValidateBeforeCall(date, symbols, firmAccounts, _callback);
        Type localVarReturnType = new TypeToken<List<AggregatePositionResponse>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1ReportingEodPositions
     * @param getV1ReportingEodPositionsRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response containing the end-of-day positions for the specified accounts. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> This can be returned if the asof param does not match the latest snap available at Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1ReportingEodPositionsCall(GetV1ReportingEodPositionsRequest getV1ReportingEodPositionsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = getV1ReportingEodPositionsRequest;

        // create path and map variables
        String localVarPath = "/v1/reporting/eod/positions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1ReportingEodPositionsValidateBeforeCall(GetV1ReportingEodPositionsRequest getV1ReportingEodPositionsRequest, final ApiCallback _callback) throws ApiException {
        return getV1ReportingEodPositionsCall(getV1ReportingEodPositionsRequest, _callback);

    }

    /**
     * Retrieve EOD Positions
     * This API retrieves a comprehensive list of end-of-day positions for all accounts. End-of-day (EOD) positions are typically accessible after 4:00 am Eastern Time (ET) on the following day, providing a comprehensive view of the day&#39;s closing positions across all accounts.
     * @param getV1ReportingEodPositionsRequest  (optional)
     * @return GetV1ReportingEodPositions200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response containing the end-of-day positions for the specified accounts. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> This can be returned if the asof param does not match the latest snap available at Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    public GetV1ReportingEodPositions200Response getV1ReportingEodPositions(GetV1ReportingEodPositionsRequest getV1ReportingEodPositionsRequest) throws ApiException {
        ApiResponse<GetV1ReportingEodPositions200Response> localVarResp = getV1ReportingEodPositionsWithHttpInfo(getV1ReportingEodPositionsRequest);
        return localVarResp.getData();
    }

    /**
     * Retrieve EOD Positions
     * This API retrieves a comprehensive list of end-of-day positions for all accounts. End-of-day (EOD) positions are typically accessible after 4:00 am Eastern Time (ET) on the following day, providing a comprehensive view of the day&#39;s closing positions across all accounts.
     * @param getV1ReportingEodPositionsRequest  (optional)
     * @return ApiResponse&lt;GetV1ReportingEodPositions200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response containing the end-of-day positions for the specified accounts. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> This can be returned if the asof param does not match the latest snap available at Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<GetV1ReportingEodPositions200Response> getV1ReportingEodPositionsWithHttpInfo(GetV1ReportingEodPositionsRequest getV1ReportingEodPositionsRequest) throws ApiException {
        okhttp3.Call localVarCall = getV1ReportingEodPositionsValidateBeforeCall(getV1ReportingEodPositionsRequest, null);
        Type localVarReturnType = new TypeToken<GetV1ReportingEodPositions200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve EOD Positions (asynchronously)
     * This API retrieves a comprehensive list of end-of-day positions for all accounts. End-of-day (EOD) positions are typically accessible after 4:00 am Eastern Time (ET) on the following day, providing a comprehensive view of the day&#39;s closing positions across all accounts.
     * @param getV1ReportingEodPositionsRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful response containing the end-of-day positions for the specified accounts. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> This can be returned if the asof param does not match the latest snap available at Alpaca. </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1ReportingEodPositionsAsync(GetV1ReportingEodPositionsRequest getV1ReportingEodPositionsRequest, final ApiCallback<GetV1ReportingEodPositions200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1ReportingEodPositionsValidateBeforeCall(getV1ReportingEodPositionsRequest, _callback);
        Type localVarReturnType = new TypeToken<GetV1ReportingEodPositions200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
