/*
 * Broker API
 * Open brokerage accounts, enable stock, options and crypto trading. Manage the ongoing user experience and brokerage customer lifecycle with the Alpaca Broker API
 *
 * The version of the OpenAPI document: 1.1.1
 * Contact: support@alpaca.markets
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.jacobpeterson.alpaca.openapi.broker.api;

import net.jacobpeterson.alpaca.openapi.broker.ApiCallback;
import net.jacobpeterson.alpaca.openapi.broker.ApiClient;
import net.jacobpeterson.alpaca.openapi.broker.ApiException;
import net.jacobpeterson.alpaca.openapi.broker.ApiResponse;
import net.jacobpeterson.alpaca.openapi.broker.Configuration;
import net.jacobpeterson.alpaca.openapi.broker.Pair;
import net.jacobpeterson.alpaca.openapi.broker.ProgressRequestBody;
import net.jacobpeterson.alpaca.openapi.broker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import net.jacobpeterson.alpaca.openapi.broker.model.PatchV1RebalancingPortfoliosPortfolioIdRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.Portfolio;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioRun;
import net.jacobpeterson.alpaca.openapi.broker.model.PortfolioSubscription;
import net.jacobpeterson.alpaca.openapi.broker.model.PostV1RebalancingPortfoliosRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.PostV1RebalancingRunsRequest;
import net.jacobpeterson.alpaca.openapi.broker.model.PostV1RebalancingSubscriptionsRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebalancingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RebalancingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RebalancingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }


    /**
     * Build call for deleteV1RebalancingPortfoliosPortfolioId
     * @param portfolioId The Portfolio ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteV1RebalancingPortfoliosPortfolioIdCall(String portfolioId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/portfolios/{portfolio_id}"
            .replace("{" + "portfolio_id" + "}", localVarApiClient.escapeString(portfolioId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(String portfolioId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'portfolioId' is set
        if (portfolioId == null) {
            throw new ApiException("Missing the required parameter 'portfolioId' when calling deleteV1RebalancingPortfoliosPortfolioId(Async)");
        }

        return deleteV1RebalancingPortfoliosPortfolioIdCall(portfolioId, _callback);

    }

    /**
     * Inactivate Portfolio By ID
     * Sets a portfolio to “inactive”, so it can be filtered out of the list request. Only permitted if there are no active subscriptions to this portfolio and this portfolio is not a listed in the weights of any active portfolios.  Inactive portfolios cannot be linked in new subscriptions or added as weights to new portfolios.
     * @param portfolioId The Portfolio ID (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity  </td><td>  -  </td></tr>
     </table>
     */
    public void deleteV1RebalancingPortfoliosPortfolioId(String portfolioId) throws ApiException {
        deleteV1RebalancingPortfoliosPortfolioIdWithHttpInfo(portfolioId);
    }

    /**
     * Inactivate Portfolio By ID
     * Sets a portfolio to “inactive”, so it can be filtered out of the list request. Only permitted if there are no active subscriptions to this portfolio and this portfolio is not a listed in the weights of any active portfolios.  Inactive portfolios cannot be linked in new subscriptions or added as weights to new portfolios.
     * @param portfolioId The Portfolio ID (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity  </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteV1RebalancingPortfoliosPortfolioIdWithHttpInfo(String portfolioId) throws ApiException {
        okhttp3.Call localVarCall = deleteV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(portfolioId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Inactivate Portfolio By ID (asynchronously)
     * Sets a portfolio to “inactive”, so it can be filtered out of the list request. Only permitted if there are no active subscriptions to this portfolio and this portfolio is not a listed in the weights of any active portfolios.  Inactive portfolios cannot be linked in new subscriptions or added as weights to new portfolios.
     * @param portfolioId The Portfolio ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity  </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteV1RebalancingPortfoliosPortfolioIdAsync(String portfolioId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(portfolioId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteV1RebalancingRunsRunId
     * @param runId the id of the portfolio run (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteV1RebalancingRunsRunIdCall(String runId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/runs/{run_id}"
            .replace("{" + "run_id" + "}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteV1RebalancingRunsRunIdValidateBeforeCall(String runId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling deleteV1RebalancingRunsRunId(Async)");
        }

        return deleteV1RebalancingRunsRunIdCall(runId, _callback);

    }

    /**
     * Cancel Run by ID
     * Cancels a run. Only runs within certain statuses (QUEUED, CANCELED, SELLS_IN_PROGRESS, BUYS_IN_PROGRESS) are cancelable. If this endpoint is called after orders have been submitted, we’ll attempt to cancel the orders.
     * @param runId the id of the portfolio run (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteV1RebalancingRunsRunId(String runId) throws ApiException {
        deleteV1RebalancingRunsRunIdWithHttpInfo(runId);
    }

    /**
     * Cancel Run by ID
     * Cancels a run. Only runs within certain statuses (QUEUED, CANCELED, SELLS_IN_PROGRESS, BUYS_IN_PROGRESS) are cancelable. If this endpoint is called after orders have been submitted, we’ll attempt to cancel the orders.
     * @param runId the id of the portfolio run (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteV1RebalancingRunsRunIdWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = deleteV1RebalancingRunsRunIdValidateBeforeCall(runId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Cancel Run by ID (asynchronously)
     * Cancels a run. Only runs within certain statuses (QUEUED, CANCELED, SELLS_IN_PROGRESS, BUYS_IN_PROGRESS) are cancelable. If this endpoint is called after orders have been submitted, we’ll attempt to cancel the orders.
     * @param runId the id of the portfolio run (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteV1RebalancingRunsRunIdAsync(String runId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteV1RebalancingRunsRunIdValidateBeforeCall(runId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteV1RebalancingSubscriptionsSubscriptionId
     * @param subscriptionId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteV1RebalancingSubscriptionsSubscriptionIdCall(String subscriptionId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/subscriptions/{subscription_id}"
            .replace("{" + "subscription_id" + "}", localVarApiClient.escapeString(subscriptionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteV1RebalancingSubscriptionsSubscriptionIdValidateBeforeCall(String subscriptionId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'subscriptionId' is set
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling deleteV1RebalancingSubscriptionsSubscriptionId(Async)");
        }

        return deleteV1RebalancingSubscriptionsSubscriptionIdCall(subscriptionId, _callback);

    }

    /**
     * Unsubscribe Account (Delete Subscription)
     * Deletes the subscription which stops the rebalancing of an account.
     * @param subscriptionId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    public void deleteV1RebalancingSubscriptionsSubscriptionId(String subscriptionId) throws ApiException {
        deleteV1RebalancingSubscriptionsSubscriptionIdWithHttpInfo(subscriptionId);
    }

    /**
     * Unsubscribe Account (Delete Subscription)
     * Deletes the subscription which stops the rebalancing of an account.
     * @param subscriptionId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> deleteV1RebalancingSubscriptionsSubscriptionIdWithHttpInfo(String subscriptionId) throws ApiException {
        okhttp3.Call localVarCall = deleteV1RebalancingSubscriptionsSubscriptionIdValidateBeforeCall(subscriptionId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Unsubscribe Account (Delete Subscription) (asynchronously)
     * Deletes the subscription which stops the rebalancing of an account.
     * @param subscriptionId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call deleteV1RebalancingSubscriptionsSubscriptionIdAsync(String subscriptionId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteV1RebalancingSubscriptionsSubscriptionIdValidateBeforeCall(subscriptionId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1RebalancingPortfolios
     * @param name Name of portfolio (optional)
     * @param description Description of portfolio (optional)
     * @param symbol Symbol included in portfolio (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param status Portfolio Status (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Portfolios </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingPortfoliosCall(String name, String description, String symbol, String portfolioId, String status, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/portfolios";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (description != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("description", description));
        }

        if (symbol != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("symbol", symbol));
        }

        if (portfolioId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("portfolio_id", portfolioId));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1RebalancingPortfoliosValidateBeforeCall(String name, String description, String symbol, String portfolioId, String status, final ApiCallback _callback) throws ApiException {
        return getV1RebalancingPortfoliosCall(name, description, symbol, portfolioId, status, _callback);

    }

    /**
     * List Portfolios
     * Lists portfolios.  When more than one query parameter is passed, only portfolios meeting all provided values will be returned (logical AND between parameter values).
     * @param name Name of portfolio (optional)
     * @param description Description of portfolio (optional)
     * @param symbol Symbol included in portfolio (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param status Portfolio Status (optional)
     * @return List&lt;Portfolio&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Portfolios </td><td>  -  </td></tr>
     </table>
     */
    public List<Portfolio> getV1RebalancingPortfolios(String name, String description, String symbol, String portfolioId, String status) throws ApiException {
        ApiResponse<List<Portfolio>> localVarResp = getV1RebalancingPortfoliosWithHttpInfo(name, description, symbol, portfolioId, status);
        return localVarResp.getData();
    }

    /**
     * List Portfolios
     * Lists portfolios.  When more than one query parameter is passed, only portfolios meeting all provided values will be returned (logical AND between parameter values).
     * @param name Name of portfolio (optional)
     * @param description Description of portfolio (optional)
     * @param symbol Symbol included in portfolio (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param status Portfolio Status (optional)
     * @return ApiResponse&lt;List&lt;Portfolio&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Portfolios </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<Portfolio>> getV1RebalancingPortfoliosWithHttpInfo(String name, String description, String symbol, String portfolioId, String status) throws ApiException {
        okhttp3.Call localVarCall = getV1RebalancingPortfoliosValidateBeforeCall(name, description, symbol, portfolioId, status, null);
        Type localVarReturnType = new TypeToken<List<Portfolio>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Portfolios (asynchronously)
     * Lists portfolios.  When more than one query parameter is passed, only portfolios meeting all provided values will be returned (logical AND between parameter values).
     * @param name Name of portfolio (optional)
     * @param description Description of portfolio (optional)
     * @param symbol Symbol included in portfolio (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param status Portfolio Status (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Portfolios </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingPortfoliosAsync(String name, String description, String symbol, String portfolioId, String status, final ApiCallback<List<Portfolio>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1RebalancingPortfoliosValidateBeforeCall(name, description, symbol, portfolioId, status, _callback);
        Type localVarReturnType = new TypeToken<List<Portfolio>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1RebalancingPortfoliosPortfolioId
     * @param portfolioId The Portfolio ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingPortfoliosPortfolioIdCall(String portfolioId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/portfolios/{portfolio_id}"
            .replace("{" + "portfolio_id" + "}", localVarApiClient.escapeString(portfolioId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(String portfolioId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'portfolioId' is set
        if (portfolioId == null) {
            throw new ApiException("Missing the required parameter 'portfolioId' when calling getV1RebalancingPortfoliosPortfolioId(Async)");
        }

        return getV1RebalancingPortfoliosPortfolioIdCall(portfolioId, _callback);

    }

    /**
     * Get Portfolio by ID
     * Get a portfolio by its ID.
     * @param portfolioId The Portfolio ID (required)
     * @return Portfolio
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Portfolio getV1RebalancingPortfoliosPortfolioId(String portfolioId) throws ApiException {
        ApiResponse<Portfolio> localVarResp = getV1RebalancingPortfoliosPortfolioIdWithHttpInfo(portfolioId);
        return localVarResp.getData();
    }

    /**
     * Get Portfolio by ID
     * Get a portfolio by its ID.
     * @param portfolioId The Portfolio ID (required)
     * @return ApiResponse&lt;Portfolio&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Portfolio> getV1RebalancingPortfoliosPortfolioIdWithHttpInfo(String portfolioId) throws ApiException {
        okhttp3.Call localVarCall = getV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(portfolioId, null);
        Type localVarReturnType = new TypeToken<Portfolio>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Portfolio by ID (asynchronously)
     * Get a portfolio by its ID.
     * @param portfolioId The Portfolio ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingPortfoliosPortfolioIdAsync(String portfolioId, final ApiCallback<Portfolio> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(portfolioId, _callback);
        Type localVarReturnType = new TypeToken<Portfolio>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1RebalancingRuns
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param type Type of portfolio run (full_rebalance, invest_cash) (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The runs which match the query </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingRunsCall(String accountId, String type, String pageToken, String limit, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/runs";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accountId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("account_id", accountId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1RebalancingRunsValidateBeforeCall(String accountId, String type, String pageToken, String limit, final ApiCallback _callback) throws ApiException {
        return getV1RebalancingRunsCall(accountId, type, pageToken, limit, _callback);

    }

    /**
     * List All Runs
     * Lists runs.
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param type Type of portfolio run (full_rebalance, invest_cash) (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @return List&lt;PortfolioRun&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The runs which match the query </td><td>  -  </td></tr>
     </table>
     */
    public List<PortfolioRun> getV1RebalancingRuns(String accountId, String type, String pageToken, String limit) throws ApiException {
        ApiResponse<List<PortfolioRun>> localVarResp = getV1RebalancingRunsWithHttpInfo(accountId, type, pageToken, limit);
        return localVarResp.getData();
    }

    /**
     * List All Runs
     * Lists runs.
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param type Type of portfolio run (full_rebalance, invest_cash) (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @return ApiResponse&lt;List&lt;PortfolioRun&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The runs which match the query </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<List<PortfolioRun>> getV1RebalancingRunsWithHttpInfo(String accountId, String type, String pageToken, String limit) throws ApiException {
        okhttp3.Call localVarCall = getV1RebalancingRunsValidateBeforeCall(accountId, type, pageToken, limit, null);
        Type localVarReturnType = new TypeToken<List<PortfolioRun>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List All Runs (asynchronously)
     * Lists runs.
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param type Type of portfolio run (full_rebalance, invest_cash) (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The runs which match the query </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingRunsAsync(String accountId, String type, String pageToken, String limit, final ApiCallback<List<PortfolioRun>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1RebalancingRunsValidateBeforeCall(accountId, type, pageToken, limit, _callback);
        Type localVarReturnType = new TypeToken<List<PortfolioRun>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1RebalancingRunsRunId
     * @param runId the id of the portfolio run (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The run object </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingRunsRunIdCall(String runId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/runs/{run_id}"
            .replace("{" + "run_id" + "}", localVarApiClient.escapeString(runId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1RebalancingRunsRunIdValidateBeforeCall(String runId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'runId' is set
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getV1RebalancingRunsRunId(Async)");
        }

        return getV1RebalancingRunsRunIdCall(runId, _callback);

    }

    /**
     * Get Run by ID
     * Get a run by its ID.
     * @param runId the id of the portfolio run (required)
     * @return PortfolioRun
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The run object </td><td>  -  </td></tr>
     </table>
     */
    public PortfolioRun getV1RebalancingRunsRunId(String runId) throws ApiException {
        ApiResponse<PortfolioRun> localVarResp = getV1RebalancingRunsRunIdWithHttpInfo(runId);
        return localVarResp.getData();
    }

    /**
     * Get Run by ID
     * Get a run by its ID.
     * @param runId the id of the portfolio run (required)
     * @return ApiResponse&lt;PortfolioRun&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The run object </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<PortfolioRun> getV1RebalancingRunsRunIdWithHttpInfo(String runId) throws ApiException {
        okhttp3.Call localVarCall = getV1RebalancingRunsRunIdValidateBeforeCall(runId, null);
        Type localVarReturnType = new TypeToken<PortfolioRun>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Run by ID (asynchronously)
     * Get a run by its ID.
     * @param runId the id of the portfolio run (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The run object </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingRunsRunIdAsync(String runId, final ApiCallback<PortfolioRun> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1RebalancingRunsRunIdValidateBeforeCall(runId, _callback);
        Type localVarReturnType = new TypeToken<PortfolioRun>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1RebalancingSubscriptions
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingSubscriptionsCall(String accountId, String portfolioId, String pageToken, String limit, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/subscriptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accountId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("account_id", accountId));
        }

        if (portfolioId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("portfolio_id", portfolioId));
        }

        if (pageToken != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page_token", pageToken));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1RebalancingSubscriptionsValidateBeforeCall(String accountId, String portfolioId, String pageToken, String limit, final ApiCallback _callback) throws ApiException {
        return getV1RebalancingSubscriptionsCall(accountId, portfolioId, pageToken, limit, _callback);

    }

    /**
     * List All Subscriptions
     * Lists subscriptions
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @return PortfolioSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PortfolioSubscription getV1RebalancingSubscriptions(String accountId, String portfolioId, String pageToken, String limit) throws ApiException {
        ApiResponse<PortfolioSubscription> localVarResp = getV1RebalancingSubscriptionsWithHttpInfo(accountId, portfolioId, pageToken, limit);
        return localVarResp.getData();
    }

    /**
     * List All Subscriptions
     * Lists subscriptions
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @return ApiResponse&lt;PortfolioSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<PortfolioSubscription> getV1RebalancingSubscriptionsWithHttpInfo(String accountId, String portfolioId, String pageToken, String limit) throws ApiException {
        okhttp3.Call localVarCall = getV1RebalancingSubscriptionsValidateBeforeCall(accountId, portfolioId, pageToken, limit, null);
        Type localVarReturnType = new TypeToken<PortfolioSubscription>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List All Subscriptions (asynchronously)
     * Lists subscriptions
     * @param accountId Any subscriptions for this account_id will be returned (optional)
     * @param portfolioId Portfolio ID (optional)
     * @param pageToken Pagination token (optional)
     * @param limit Max number of subscriptions to return per page (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingSubscriptionsAsync(String accountId, String portfolioId, String pageToken, String limit, final ApiCallback<PortfolioSubscription> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1RebalancingSubscriptionsValidateBeforeCall(accountId, portfolioId, pageToken, limit, _callback);
        Type localVarReturnType = new TypeToken<PortfolioSubscription>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getV1RebalancingSubscriptionsSubscriptionId
     * @param subscriptionId  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The portfolio subscription </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingSubscriptionsSubscriptionIdCall(String subscriptionId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/subscriptions/{subscription_id}"
            .replace("{" + "subscription_id" + "}", localVarApiClient.escapeString(subscriptionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getV1RebalancingSubscriptionsSubscriptionIdValidateBeforeCall(String subscriptionId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'subscriptionId' is set
        if (subscriptionId == null) {
            throw new ApiException("Missing the required parameter 'subscriptionId' when calling getV1RebalancingSubscriptionsSubscriptionId(Async)");
        }

        return getV1RebalancingSubscriptionsSubscriptionIdCall(subscriptionId, _callback);

    }

    /**
     * Get Subscription by ID
     * Get a subscription by its ID.
     * @param subscriptionId  (required)
     * @return PortfolioSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The portfolio subscription </td><td>  -  </td></tr>
     </table>
     */
    public PortfolioSubscription getV1RebalancingSubscriptionsSubscriptionId(String subscriptionId) throws ApiException {
        ApiResponse<PortfolioSubscription> localVarResp = getV1RebalancingSubscriptionsSubscriptionIdWithHttpInfo(subscriptionId);
        return localVarResp.getData();
    }

    /**
     * Get Subscription by ID
     * Get a subscription by its ID.
     * @param subscriptionId  (required)
     * @return ApiResponse&lt;PortfolioSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The portfolio subscription </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<PortfolioSubscription> getV1RebalancingSubscriptionsSubscriptionIdWithHttpInfo(String subscriptionId) throws ApiException {
        okhttp3.Call localVarCall = getV1RebalancingSubscriptionsSubscriptionIdValidateBeforeCall(subscriptionId, null);
        Type localVarReturnType = new TypeToken<PortfolioSubscription>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Subscription by ID (asynchronously)
     * Get a subscription by its ID.
     * @param subscriptionId  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The portfolio subscription </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call getV1RebalancingSubscriptionsSubscriptionIdAsync(String subscriptionId, final ApiCallback<PortfolioSubscription> _callback) throws ApiException {

        okhttp3.Call localVarCall = getV1RebalancingSubscriptionsSubscriptionIdValidateBeforeCall(subscriptionId, _callback);
        Type localVarReturnType = new TypeToken<PortfolioSubscription>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for patchV1RebalancingPortfoliosPortfolioId
     * @param portfolioId The Portfolio ID (required)
     * @param patchV1RebalancingPortfoliosPortfolioIdRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The updated portfolio </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchV1RebalancingPortfoliosPortfolioIdCall(String portfolioId, PatchV1RebalancingPortfoliosPortfolioIdRequest patchV1RebalancingPortfoliosPortfolioIdRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = patchV1RebalancingPortfoliosPortfolioIdRequest;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/portfolios/{portfolio_id}"
            .replace("{" + "portfolio_id" + "}", localVarApiClient.escapeString(portfolioId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call patchV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(String portfolioId, PatchV1RebalancingPortfoliosPortfolioIdRequest patchV1RebalancingPortfoliosPortfolioIdRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'portfolioId' is set
        if (portfolioId == null) {
            throw new ApiException("Missing the required parameter 'portfolioId' when calling patchV1RebalancingPortfoliosPortfolioId(Async)");
        }

        return patchV1RebalancingPortfoliosPortfolioIdCall(portfolioId, patchV1RebalancingPortfoliosPortfolioIdRequest, _callback);

    }

    /**
     * Update Portfolio by ID
     * Updates a portfolio. If weights or conditions are changed, all subscribed accounts will be evaluated for rebalancing at the next opportunity (normal market hours). If a cooldown is active on the portfolio, the rebalancing will occur after the cooldown expired.
     * @param portfolioId The Portfolio ID (required)
     * @param patchV1RebalancingPortfoliosPortfolioIdRequest  (optional)
     * @return Portfolio
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The updated portfolio </td><td>  -  </td></tr>
     </table>
     */
    public Portfolio patchV1RebalancingPortfoliosPortfolioId(String portfolioId, PatchV1RebalancingPortfoliosPortfolioIdRequest patchV1RebalancingPortfoliosPortfolioIdRequest) throws ApiException {
        ApiResponse<Portfolio> localVarResp = patchV1RebalancingPortfoliosPortfolioIdWithHttpInfo(portfolioId, patchV1RebalancingPortfoliosPortfolioIdRequest);
        return localVarResp.getData();
    }

    /**
     * Update Portfolio by ID
     * Updates a portfolio. If weights or conditions are changed, all subscribed accounts will be evaluated for rebalancing at the next opportunity (normal market hours). If a cooldown is active on the portfolio, the rebalancing will occur after the cooldown expired.
     * @param portfolioId The Portfolio ID (required)
     * @param patchV1RebalancingPortfoliosPortfolioIdRequest  (optional)
     * @return ApiResponse&lt;Portfolio&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The updated portfolio </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Portfolio> patchV1RebalancingPortfoliosPortfolioIdWithHttpInfo(String portfolioId, PatchV1RebalancingPortfoliosPortfolioIdRequest patchV1RebalancingPortfoliosPortfolioIdRequest) throws ApiException {
        okhttp3.Call localVarCall = patchV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(portfolioId, patchV1RebalancingPortfoliosPortfolioIdRequest, null);
        Type localVarReturnType = new TypeToken<Portfolio>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Portfolio by ID (asynchronously)
     * Updates a portfolio. If weights or conditions are changed, all subscribed accounts will be evaluated for rebalancing at the next opportunity (normal market hours). If a cooldown is active on the portfolio, the rebalancing will occur after the cooldown expired.
     * @param portfolioId The Portfolio ID (required)
     * @param patchV1RebalancingPortfoliosPortfolioIdRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The updated portfolio </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call patchV1RebalancingPortfoliosPortfolioIdAsync(String portfolioId, PatchV1RebalancingPortfoliosPortfolioIdRequest patchV1RebalancingPortfoliosPortfolioIdRequest, final ApiCallback<Portfolio> _callback) throws ApiException {

        okhttp3.Call localVarCall = patchV1RebalancingPortfoliosPortfolioIdValidateBeforeCall(portfolioId, patchV1RebalancingPortfoliosPortfolioIdRequest, _callback);
        Type localVarReturnType = new TypeToken<Portfolio>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1RebalancingPortfolios
     * @param postV1RebalancingPortfoliosRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1RebalancingPortfoliosCall(PostV1RebalancingPortfoliosRequest postV1RebalancingPortfoliosRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = postV1RebalancingPortfoliosRequest;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/portfolios";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1RebalancingPortfoliosValidateBeforeCall(PostV1RebalancingPortfoliosRequest postV1RebalancingPortfoliosRequest, final ApiCallback _callback) throws ApiException {
        return postV1RebalancingPortfoliosCall(postV1RebalancingPortfoliosRequest, _callback);

    }

    /**
     * Create Portfolio
     * Creates a portfolio allocation containing securities and/or cash. Having no rebalancing conditions is allowed but the rebalance event would need to be triggered manually. Portfolios created with API may have multiple rebalance_conditions, but only one of type calendar.
     * @param postV1RebalancingPortfoliosRequest  (optional)
     * @return Portfolio
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public Portfolio postV1RebalancingPortfolios(PostV1RebalancingPortfoliosRequest postV1RebalancingPortfoliosRequest) throws ApiException {
        ApiResponse<Portfolio> localVarResp = postV1RebalancingPortfoliosWithHttpInfo(postV1RebalancingPortfoliosRequest);
        return localVarResp.getData();
    }

    /**
     * Create Portfolio
     * Creates a portfolio allocation containing securities and/or cash. Having no rebalancing conditions is allowed but the rebalance event would need to be triggered manually. Portfolios created with API may have multiple rebalance_conditions, but only one of type calendar.
     * @param postV1RebalancingPortfoliosRequest  (optional)
     * @return ApiResponse&lt;Portfolio&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Portfolio> postV1RebalancingPortfoliosWithHttpInfo(PostV1RebalancingPortfoliosRequest postV1RebalancingPortfoliosRequest) throws ApiException {
        okhttp3.Call localVarCall = postV1RebalancingPortfoliosValidateBeforeCall(postV1RebalancingPortfoliosRequest, null);
        Type localVarReturnType = new TypeToken<Portfolio>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create Portfolio (asynchronously)
     * Creates a portfolio allocation containing securities and/or cash. Having no rebalancing conditions is allowed but the rebalance event would need to be triggered manually. Portfolios created with API may have multiple rebalance_conditions, but only one of type calendar.
     * @param postV1RebalancingPortfoliosRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1RebalancingPortfoliosAsync(PostV1RebalancingPortfoliosRequest postV1RebalancingPortfoliosRequest, final ApiCallback<Portfolio> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1RebalancingPortfoliosValidateBeforeCall(postV1RebalancingPortfoliosRequest, _callback);
        Type localVarReturnType = new TypeToken<Portfolio>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1RebalancingRuns
     * @param postV1RebalancingRunsRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1RebalancingRunsCall(PostV1RebalancingRunsRequest postV1RebalancingRunsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = postV1RebalancingRunsRequest;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/runs";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1RebalancingRunsValidateBeforeCall(PostV1RebalancingRunsRequest postV1RebalancingRunsRequest, final ApiCallback _callback) throws ApiException {
        return postV1RebalancingRunsCall(postV1RebalancingRunsRequest, _callback);

    }

    /**
     * Create Run (Manual rebalancing event)
     * Manually creates a run.  The determination of a run’s orders and the execution of a run take place during normal market hours  Runs can be initiated either by the system (when the system evaluates the rebalance conditions specified at the portfolio level) or by API call (manual run creation using POST /v1/rebalancing/runs). Runs can be initiated manually outside of the normal market hours but will remain in the QUEUED status until normal market hours  Only 1 run in a non-terminal status is allowed at any time.  Manually executing a run is currently only allowed for accounts who do not have an active subscription.
     * @param postV1RebalancingRunsRequest  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public void postV1RebalancingRuns(PostV1RebalancingRunsRequest postV1RebalancingRunsRequest) throws ApiException {
        postV1RebalancingRunsWithHttpInfo(postV1RebalancingRunsRequest);
    }

    /**
     * Create Run (Manual rebalancing event)
     * Manually creates a run.  The determination of a run’s orders and the execution of a run take place during normal market hours  Runs can be initiated either by the system (when the system evaluates the rebalance conditions specified at the portfolio level) or by API call (manual run creation using POST /v1/rebalancing/runs). Runs can be initiated manually outside of the normal market hours but will remain in the QUEUED status until normal market hours  Only 1 run in a non-terminal status is allowed at any time.  Manually executing a run is currently only allowed for accounts who do not have an active subscription.
     * @param postV1RebalancingRunsRequest  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<Void> postV1RebalancingRunsWithHttpInfo(PostV1RebalancingRunsRequest postV1RebalancingRunsRequest) throws ApiException {
        okhttp3.Call localVarCall = postV1RebalancingRunsValidateBeforeCall(postV1RebalancingRunsRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create Run (Manual rebalancing event) (asynchronously)
     * Manually creates a run.  The determination of a run’s orders and the execution of a run take place during normal market hours  Runs can be initiated either by the system (when the system evaluates the rebalance conditions specified at the portfolio level) or by API call (manual run creation using POST /v1/rebalancing/runs). Runs can be initiated manually outside of the normal market hours but will remain in the QUEUED status until normal market hours  Only 1 run in a non-terminal status is allowed at any time.  Manually executing a run is currently only allowed for accounts who do not have an active subscription.
     * @param postV1RebalancingRunsRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1RebalancingRunsAsync(PostV1RebalancingRunsRequest postV1RebalancingRunsRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1RebalancingRunsValidateBeforeCall(postV1RebalancingRunsRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for postV1RebalancingSubscriptions
     * @param postV1RebalancingSubscriptionsRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1RebalancingSubscriptionsCall(PostV1RebalancingSubscriptionsRequest postV1RebalancingSubscriptionsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = postV1RebalancingSubscriptionsRequest;

        // create path and map variables
        String localVarPath = "/v1/rebalancing/subscriptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postV1RebalancingSubscriptionsValidateBeforeCall(PostV1RebalancingSubscriptionsRequest postV1RebalancingSubscriptionsRequest, final ApiCallback _callback) throws ApiException {
        return postV1RebalancingSubscriptionsCall(postV1RebalancingSubscriptionsRequest, _callback);

    }

    /**
     * Create Subscription
     * Creates a subscription between an account and a portfolio.
     * @param postV1RebalancingSubscriptionsRequest  (optional)
     * @return PortfolioSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public PortfolioSubscription postV1RebalancingSubscriptions(PostV1RebalancingSubscriptionsRequest postV1RebalancingSubscriptionsRequest) throws ApiException {
        ApiResponse<PortfolioSubscription> localVarResp = postV1RebalancingSubscriptionsWithHttpInfo(postV1RebalancingSubscriptionsRequest);
        return localVarResp.getData();
    }

    /**
     * Create Subscription
     * Creates a subscription between an account and a portfolio.
     * @param postV1RebalancingSubscriptionsRequest  (optional)
     * @return ApiResponse&lt;PortfolioSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected ApiResponse<PortfolioSubscription> postV1RebalancingSubscriptionsWithHttpInfo(PostV1RebalancingSubscriptionsRequest postV1RebalancingSubscriptionsRequest) throws ApiException {
        okhttp3.Call localVarCall = postV1RebalancingSubscriptionsValidateBeforeCall(postV1RebalancingSubscriptionsRequest, null);
        Type localVarReturnType = new TypeToken<PortfolioSubscription>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create Subscription (asynchronously)
     * Creates a subscription between an account and a portfolio.
     * @param postV1RebalancingSubscriptionsRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    protected okhttp3.Call postV1RebalancingSubscriptionsAsync(PostV1RebalancingSubscriptionsRequest postV1RebalancingSubscriptionsRequest, final ApiCallback<PortfolioSubscription> _callback) throws ApiException {

        okhttp3.Call localVarCall = postV1RebalancingSubscriptionsValidateBeforeCall(postV1RebalancingSubscriptionsRequest, _callback);
        Type localVarReturnType = new TypeToken<PortfolioSubscription>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
